/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.recurringdeposit;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.SavingsAccountTransactionEnumValueSerialiser;
import org.apache.fineract.infrastructure.core.exception.AbstractPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionEnumData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecurringDepositTransactionImportHandler
implements ImportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RecurringDepositTransactionImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @Autowired
    public RecurringDepositTransactionImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        List savingsTransactions = this.readExcelFile(workbook, locale, dateFormat);
        return this.importEntity(workbook, savingsTransactions, dateFormat);
    }

    public List<SavingsAccountTransactionData> readExcelFile(Workbook workbook, String locale, String dateFormat) {
        ArrayList<SavingsAccountTransactionData> savingsTransactions = new ArrayList<SavingsAccountTransactionData>();
        Sheet savingsTransactionSheet = workbook.getSheet("SavingsTransaction");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)savingsTransactionSheet, (int)6);
        Long savingsAccountId = null;
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = savingsTransactionSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)14)) continue;
            savingsTransactions.add(this.readSavingsTransaction(workbook, row, savingsAccountId, locale, dateFormat));
        }
        return savingsTransactions;
    }

    private SavingsAccountTransactionData readSavingsTransaction(Workbook workbook, Row row, Long savingsAccountId, String locale, String dateFormat) {
        Long internalSavingsAccountId = ImportHandlerUtils.readAsLong((int)2, (Row)row);
        if (internalSavingsAccountId != null) {
            savingsAccountId = internalSavingsAccountId;
        }
        String transactionType = ImportHandlerUtils.readAsString((int)5, (Row)row);
        SavingsAccountTransactionEnumData savingsAccountTransactionEnumData = new SavingsAccountTransactionEnumData(null, null, transactionType);
        BigDecimal amount = null;
        if (ImportHandlerUtils.readAsDouble((int)6, (Row)row) != null) {
            amount = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)6, (Row)row));
        }
        LocalDate transactionDate = ImportHandlerUtils.readAsDate((int)7, (Row)row);
        String paymentType = ImportHandlerUtils.readAsString((int)8, (Row)row);
        Long paymentTypeId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Extras"), (String)paymentType);
        String accountNumber = ImportHandlerUtils.readAsString((int)9, (Row)row);
        String checkNumber = ImportHandlerUtils.readAsString((int)10, (Row)row);
        String routingCode = ImportHandlerUtils.readAsString((int)11, (Row)row);
        String receiptNumber = ImportHandlerUtils.readAsString((int)12, (Row)row);
        String bankNumber = ImportHandlerUtils.readAsString((int)13, (Row)row);
        return SavingsAccountTransactionData.importInstance((BigDecimal)amount, (LocalDate)transactionDate, (Long)paymentTypeId, (String)accountNumber, (String)checkNumber, (String)routingCode, (String)receiptNumber, (String)bankNumber, (Long)savingsAccountId, (SavingsAccountTransactionEnumData)savingsAccountTransactionEnumData, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
    }

    public Count importEntity(Workbook workbook, List<SavingsAccountTransactionData> savingsTransactions, String dateFormat) {
        Sheet savingsTransactionSheet = workbook.getSheet("SavingsTransaction");
        int successCount = 0;
        int errorCount = 0;
        String errorMessage = "";
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        gsonBuilder.registerTypeAdapter(SavingsAccountTransactionEnumData.class, (Object)new SavingsAccountTransactionEnumValueSerialiser());
        for (SavingsAccountTransactionData transaction : savingsTransactions) {
            try {
                JsonObject savingsTransactionJsonob = gsonBuilder.create().toJsonTree((Object)transaction).getAsJsonObject();
                savingsTransactionJsonob.remove("transactionType");
                savingsTransactionJsonob.remove("reversed");
                savingsTransactionJsonob.remove("interestedPostedAsOn");
                String payload = savingsTransactionJsonob.toString();
                CommandWrapper commandRequest = null;
                if (transaction.getTransactionType().getValue().equals("Withdrawal")) {
                    commandRequest = new CommandWrapperBuilder().recurringAccountWithdrawal(transaction.getSavingsAccountId()).withJson(payload).build();
                } else if (transaction.getTransactionType().getValue().equals("Deposit")) {
                    commandRequest = new CommandWrapperBuilder().recurringAccountDeposit(transaction.getSavingsAccountId()).withJson(payload).build();
                }
                this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                ++successCount;
                Cell statusCell = savingsTransactionSheet.getRow(transaction.getRowIndex().intValue()).createCell(14);
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
            }
            catch (AbstractPlatformDomainRuleException e) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)e);
                errorMessage = e.getDefaultUserMessage();
                ImportHandlerUtils.writeErrorMessage((Sheet)savingsTransactionSheet, (Integer)transaction.getRowIndex(), (String)errorMessage, (int)14);
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                ImportHandlerUtils.writeErrorMessage((Sheet)savingsTransactionSheet, (Integer)transaction.getRowIndex(), (String)errorMessage, (int)14);
            }
        }
        savingsTransactionSheet.setColumnWidth(14, 4000);
        ImportHandlerUtils.writeString((int)14, (Row)savingsTransactionSheet.getRow(14), (String)"Status");
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }
}

