/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.recurringdeposit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ClientSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ExtrasSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class RecurringDepositTransactionWorkbookPopulator
extends AbstractWorkbookPopulator {
    private final OfficeSheetPopulator officeSheetPopulator;
    private final ClientSheetPopulator clientSheetPopulator;
    private final ExtrasSheetPopulator extrasSheetPopulator;
    private final List<SavingsAccountData> savingsAccounts;

    public RecurringDepositTransactionWorkbookPopulator(OfficeSheetPopulator officeSheetPopulator, ClientSheetPopulator clientSheetPopulator, ExtrasSheetPopulator extrasSheetPopulator, List<SavingsAccountData> savingsAccounts) {
        this.officeSheetPopulator = officeSheetPopulator;
        this.clientSheetPopulator = clientSheetPopulator;
        this.extrasSheetPopulator = extrasSheetPopulator;
        this.savingsAccounts = savingsAccounts;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet savingsTransactionSheet = workbook.createSheet("SavingsTransaction");
        this.setLayout(savingsTransactionSheet);
        this.officeSheetPopulator.populate(workbook, dateFormat);
        this.clientSheetPopulator.populate(workbook, dateFormat);
        this.extrasSheetPopulator.populate(workbook, dateFormat);
        this.populateSavingsTable(savingsTransactionSheet, dateFormat);
        this.setRules(savingsTransactionSheet, dateFormat);
        this.setDefaults(savingsTransactionSheet);
    }

    private void setDefaults(Sheet worksheet) {
        Integer rowNo = 1;
        while (rowNo < 3000) {
            Row row = worksheet.getRow(rowNo.intValue());
            if (row == null) {
                row = worksheet.createRow(rowNo.intValue());
            }
            this.writeFormula(3, row, "IF(ISERROR(VLOOKUP($C" + (rowNo + 1) + ",$Q$2:$S$" + (this.savingsAccounts.size() + 1) + ",2,FALSE)),\"\",VLOOKUP($C" + (rowNo + 1) + ",$Q$2:$S$" + (this.savingsAccounts.size() + 1) + ",2,FALSE))");
            this.writeFormula(4, row, "IF(ISERROR(VLOOKUP($C" + (rowNo + 1) + ",$Q$2:$S$" + (this.savingsAccounts.size() + 1) + ",3,FALSE)),\"\",VLOOKUP($C" + (rowNo + 1) + ",$Q$2:$S$" + (this.savingsAccounts.size() + 1) + ",3,FALSE))");
            Integer n = rowNo;
            rowNo = rowNo + 1;
        }
    }

    private void setRules(Sheet worksheet, String dateFormat) {
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 0, 0);
        CellRangeAddressList clientNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 1, 1);
        CellRangeAddressList accountNumberRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 2, 2);
        CellRangeAddressList transactionTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 5, 5);
        CellRangeAddressList paymentTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 8, 8);
        CellRangeAddressList transactionDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 7, 7);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)worksheet);
        this.setNames(worksheet);
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint clientNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Client_\",$A1))");
        DataValidationConstraint accountNumberConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Account_\",SUBSTITUTE(SUBSTITUTE(SUBSTITUTE($B1,\" \",\"_\"),\"(\",\"_\"),\")\",\"_\")))");
        DataValidationConstraint transactionTypeConstraint = validationHelper.createExplicitListConstraint(new String[]{"Withdrawal", "Deposit"});
        DataValidationConstraint paymentTypeConstraint = validationHelper.createFormulaListConstraint("PaymentTypes");
        DataValidationConstraint transactionDateConstraint = validationHelper.createDateConstraint(0, "=VLOOKUP($C1,$Q$2:$T$" + (this.savingsAccounts.size() + 1) + ",4,FALSE)", "=TODAY()", dateFormat);
        DataValidation officeValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation clientValidation = validationHelper.createValidation(clientNameConstraint, clientNameRange);
        DataValidation accountNumberValidation = validationHelper.createValidation(accountNumberConstraint, accountNumberRange);
        DataValidation transactionTypeValidation = validationHelper.createValidation(transactionTypeConstraint, transactionTypeRange);
        DataValidation paymentTypeValidation = validationHelper.createValidation(paymentTypeConstraint, paymentTypeRange);
        DataValidation transactionDateValidation = validationHelper.createValidation(transactionDateConstraint, transactionDateRange);
        worksheet.addValidationData(officeValidation);
        worksheet.addValidationData(clientValidation);
        worksheet.addValidationData(accountNumberValidation);
        worksheet.addValidationData(transactionTypeValidation);
        worksheet.addValidationData(paymentTypeValidation);
        worksheet.addValidationData(transactionDateValidation);
    }

    private void setNames(Sheet worksheet) {
        Workbook savingsTransactionWorkbook = worksheet.getWorkbook();
        List officeNames = this.officeSheetPopulator.getOfficeNames();
        Name officeGroup = savingsTransactionWorkbook.createName();
        officeGroup.setNameName("Office");
        officeGroup.setRefersToFormula("Offices!$B$2:$B$" + (officeNames.size() + 1));
        Integer i = 0;
        while (i < officeNames.size()) {
            Object officeNameToBeginEndIndexesOfClients = (Integer[])this.clientSheetPopulator.getOfficeNameToBeginEndIndexesOfClients().get(i);
            Name name = savingsTransactionWorkbook.createName();
            if (officeNameToBeginEndIndexesOfClients != null) {
                this.setSanitized(name, "Client_" + (String)officeNames.get(i));
                name.setRefersToFormula("Clients!$B$" + officeNameToBeginEndIndexesOfClients[0] + ":$B$" + officeNameToBeginEndIndexesOfClients[1]);
            }
            officeNameToBeginEndIndexesOfClients = i;
            i = i + 1;
        }
        HashMap<String, Integer[]> clientNameToBeginEndIndexes = new HashMap<String, Integer[]>();
        ArrayList<String> clientsWithActiveSavings = new ArrayList<String>();
        ArrayList<Long> clientIdsWithActiveSavings = new ArrayList<Long>();
        int startIndex = 1;
        int endIndex = 1;
        String clientName = "";
        Long clientId = null;
        for (int i2 = 0; i2 < this.savingsAccounts.size(); ++i2) {
            if (!clientName.equals(((SavingsAccountData)this.savingsAccounts.get(i2)).getClientName())) {
                endIndex = i2 + 1;
                clientNameToBeginEndIndexes.put(clientName, new Integer[]{startIndex, endIndex});
                startIndex = i2 + 2;
                clientName = ((SavingsAccountData)this.savingsAccounts.get(i2)).getClientName();
                clientId = ((SavingsAccountData)this.savingsAccounts.get(i2)).getClientId();
                clientsWithActiveSavings.add(clientName);
                clientIdsWithActiveSavings.add(clientId);
            }
            if (i2 != this.savingsAccounts.size() - 1) continue;
            endIndex = i2 + 2;
            clientNameToBeginEndIndexes.put(clientName, new Integer[]{startIndex, endIndex});
        }
        for (int j = 0; j < clientsWithActiveSavings.size(); ++j) {
            Name name = savingsTransactionWorkbook.createName();
            this.setSanitized(name, "Account_" + (String)clientsWithActiveSavings.get(j) + "_" + String.valueOf(clientIdsWithActiveSavings.get(j)) + "_");
            name.setRefersToFormula("SavingsTransaction!$Q$" + ((Integer[])clientNameToBeginEndIndexes.get(clientsWithActiveSavings.get(j)))[0] + ":$Q$" + ((Integer[])clientNameToBeginEndIndexes.get(clientsWithActiveSavings.get(j)))[1]);
        }
        Name paymentTypeGroup = savingsTransactionWorkbook.createName();
        paymentTypeGroup.setNameName("PaymentTypes");
        paymentTypeGroup.setRefersToFormula("Extras!$D$2:$D$" + (this.extrasSheetPopulator.getPaymentTypesSize() + 1));
    }

    private void populateSavingsTable(Sheet savingsTransactionSheet, String dateFormat) {
        Workbook workbook = savingsTransactionSheet.getWorkbook();
        CellStyle dateCellStyle = workbook.createCellStyle();
        short df = workbook.createDataFormat().getFormat(dateFormat);
        dateCellStyle.setDataFormat(df);
        int rowIndex = 1;
        Collections.sort(this.savingsAccounts, SavingsAccountData.ClientNameComparator);
        for (SavingsAccountData savingsAccount : this.savingsAccounts) {
            Row row = savingsTransactionSheet.createRow(rowIndex++);
            this.writeString(15, row, savingsAccount.getClientName() + "(" + savingsAccount.getClientId() + ")");
            this.writeString(16, row, savingsAccount.getAccountNo());
            this.writeString(17, row, savingsAccount.getSavingsProductName());
            if (savingsAccount.getMinRequiredOpeningBalance() != null) {
                this.writeBigDecimal(18, row, savingsAccount.getMinRequiredOpeningBalance());
            }
            this.writeDate(19, row, savingsAccount.getTimeline().getActivatedOnDate().getDayOfMonth() + "/" + savingsAccount.getTimeline().getActivatedOnDate().getMonthValue() + "/" + savingsAccount.getTimeline().getActivatedOnDate().getYear(), dateCellStyle, dateFormat);
        }
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 5000);
        worksheet.setColumnWidth(2, 3000);
        worksheet.setColumnWidth(3, 4000);
        worksheet.setColumnWidth(4, 4000);
        worksheet.setColumnWidth(5, 3300);
        worksheet.setColumnWidth(6, 4000);
        worksheet.setColumnWidth(7, 3000);
        worksheet.setColumnWidth(8, 3000);
        worksheet.setColumnWidth(9, 3000);
        worksheet.setColumnWidth(10, 3000);
        worksheet.setColumnWidth(12, 3000);
        worksheet.setColumnWidth(11, 3000);
        worksheet.setColumnWidth(13, 3000);
        worksheet.setColumnWidth(15, 5000);
        worksheet.setColumnWidth(16, 3000);
        worksheet.setColumnWidth(17, 3000);
        worksheet.setColumnWidth(18, 3700);
        worksheet.setColumnWidth(19, 3500);
        this.writeString(0, rowHeader, "Office Name*");
        this.writeString(1, rowHeader, "Client Name*");
        this.writeString(2, rowHeader, "Account No.*");
        this.writeString(3, rowHeader, "Product Name");
        this.writeString(4, rowHeader, "Opening Balance");
        this.writeString(5, rowHeader, "Transaction Type*");
        this.writeString(6, rowHeader, "Amount*");
        this.writeString(7, rowHeader, "Date*");
        this.writeString(8, rowHeader, "Type*");
        this.writeString(9, rowHeader, "Account No");
        this.writeString(10, rowHeader, "Check No");
        this.writeString(12, rowHeader, "Receipt No");
        this.writeString(11, rowHeader, "Routing Code");
        this.writeString(13, rowHeader, "Bank No");
        this.writeString(15, rowHeader, "Lookup Client");
        this.writeString(16, rowHeader, "Lookup Account");
        this.writeString(17, rowHeader, "Lookup Product");
        this.writeString(18, rowHeader, "Lookup Opening Balance");
        this.writeString(19, rowHeader, "Lookup Savings Activation Date");
    }
}

