/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaign;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessageStatusType;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.group.domain.Group;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="scheduled_email_messages_outbound")
public class EmailMessage
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne
    @JoinColumn(name="group_id", nullable=true)
    private Group group;
    @ManyToOne
    @JoinColumn(name="client_id", nullable=true)
    private Client client;
    @ManyToOne
    @JoinColumn(name="staff_id", nullable=true)
    private Staff staff;
    @ManyToOne
    @JoinColumn(name="email_campaign_id", nullable=true)
    private EmailCampaign emailCampaign;
    @Column(name="status_enum", nullable=false)
    private Integer statusType;
    @Column(name="email_address", nullable=false, length=50)
    private String emailAddress;
    @Column(name="email_subject", nullable=false, length=50)
    private String emailSubject;
    @Column(name="message", nullable=false)
    private String message;
    @Column(name="campaign_name", nullable=true)
    private String campaignName;
    @Column(name="submittedon_date", nullable=true)
    private LocalDate submittedOnDate;
    @Column(name="error_message")
    private String errorMessage;
    static final long serialVersionUID = 6822083206939247061L;

    public static EmailMessage pendingEmail(Group group, Client client, Staff staff, EmailCampaign emailCampaign, String emailSubject, String message, String emailAddress, String campaignName) {
        return new EmailMessage().setGroup(group).setClient(client).setStaff(staff).setEmailCampaign(emailCampaign).setStatusType(emailCampaign.getStatus()).setEmailSubject(emailSubject).setMessage(message).setEmailAddress(emailAddress).setCampaignName(campaignName);
    }

    public static EmailMessage instance(Group group, Client client, Staff staff, EmailCampaign emailCampaign, EmailMessageStatusType statusType, String emailSubject, String message, String sourceAddress, String emailAddress, String campaignName) {
        return new EmailMessage().setGroup(group).setClient(client).setStaff(staff).setEmailCampaign(emailCampaign).setEmailSubject(emailSubject).setMessage(message).setEmailAddress(emailAddress).setCampaignName(campaignName).setStatusType(statusType.getValue());
    }

    public Map<String, Object> update(JsonCommand command) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(1);
        if (command.isChangeInStringParameterNamed("emailMessage", this._persistence_get_message())) {
            String newValue = command.stringValueOfParameterNamed("emailMessage");
            actualChanges.put("emailMessage", newValue);
            this._persistence_set_message((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        return actualChanges;
    }

    public boolean isPending() {
        return EmailMessageStatusType.fromInt((Integer)this._persistence_get_statusType()).isPending();
    }

    public boolean isSent() {
        return EmailMessageStatusType.fromInt((Integer)this._persistence_get_statusType()).isSent();
    }

    @Generated
    public Group getGroup() {
        return this._persistence_get_group();
    }

    @Generated
    public Client getClient() {
        return this._persistence_get_client();
    }

    @Generated
    public Staff getStaff() {
        return this._persistence_get_staff();
    }

    @Generated
    public EmailCampaign getEmailCampaign() {
        return this._persistence_get_emailCampaign();
    }

    @Generated
    public Integer getStatusType() {
        return this._persistence_get_statusType();
    }

    @Generated
    public String getEmailAddress() {
        return this._persistence_get_emailAddress();
    }

    @Generated
    public String getEmailSubject() {
        return this._persistence_get_emailSubject();
    }

    @Generated
    public String getMessage() {
        return this._persistence_get_message();
    }

    @Generated
    public String getCampaignName() {
        return this._persistence_get_campaignName();
    }

    @Generated
    public LocalDate getSubmittedOnDate() {
        return this._persistence_get_submittedOnDate();
    }

    @Generated
    public String getErrorMessage() {
        return this._persistence_get_errorMessage();
    }

    @Generated
    public EmailMessage setGroup(Group group) {
        this._persistence_set_group(group);
        return this;
    }

    @Generated
    public EmailMessage setClient(Client client) {
        this._persistence_set_client(client);
        return this;
    }

    @Generated
    public EmailMessage setStaff(Staff staff) {
        this._persistence_set_staff(staff);
        return this;
    }

    @Generated
    public EmailMessage setEmailCampaign(EmailCampaign emailCampaign) {
        this._persistence_set_emailCampaign(emailCampaign);
        return this;
    }

    @Generated
    public EmailMessage setStatusType(Integer statusType) {
        this._persistence_set_statusType(statusType);
        return this;
    }

    @Generated
    public EmailMessage setEmailAddress(String emailAddress) {
        this._persistence_set_emailAddress(emailAddress);
        return this;
    }

    @Generated
    public EmailMessage setEmailSubject(String emailSubject) {
        this._persistence_set_emailSubject(emailSubject);
        return this;
    }

    @Generated
    public EmailMessage setMessage(String message) {
        this._persistence_set_message(message);
        return this;
    }

    @Generated
    public EmailMessage setCampaignName(String campaignName) {
        this._persistence_set_campaignName(campaignName);
        return this;
    }

    @Generated
    public EmailMessage setSubmittedOnDate(LocalDate submittedOnDate) {
        this._persistence_set_submittedOnDate(submittedOnDate);
        return this;
    }

    @Generated
    public EmailMessage setErrorMessage(String errorMessage) {
        this._persistence_set_errorMessage(errorMessage);
        return this;
    }

    @Generated
    public EmailMessage() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EmailMessage();
    }

    public Object _persistence_get(String string) {
        if (string == "emailAddress") {
            return this.emailAddress;
        }
        if (string == "emailCampaign") {
            return this.emailCampaign;
        }
        if (string == "statusType") {
            return this.statusType;
        }
        if (string == "errorMessage") {
            return this.errorMessage;
        }
        if (string == "client") {
            return this.client;
        }
        if (string == "staff") {
            return this.staff;
        }
        if (string == "submittedOnDate") {
            return this.submittedOnDate;
        }
        if (string == "message") {
            return this.message;
        }
        if (string == "emailSubject") {
            return this.emailSubject;
        }
        if (string == "campaignName") {
            return this.campaignName;
        }
        if (string == "group") {
            return this.group;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "emailAddress") {
            this.emailAddress = (String)object;
            return;
        }
        if (string == "emailCampaign") {
            this.emailCampaign = (EmailCampaign)object;
            return;
        }
        if (string == "statusType") {
            this.statusType = (Integer)object;
            return;
        }
        if (string == "errorMessage") {
            this.errorMessage = (String)object;
            return;
        }
        if (string == "client") {
            this.client = (Client)object;
            return;
        }
        if (string == "staff") {
            this.staff = (Staff)object;
            return;
        }
        if (string == "submittedOnDate") {
            this.submittedOnDate = (LocalDate)object;
            return;
        }
        if (string == "message") {
            this.message = (String)object;
            return;
        }
        if (string == "emailSubject") {
            this.emailSubject = (String)object;
            return;
        }
        if (string == "campaignName") {
            this.campaignName = (String)object;
            return;
        }
        if (string == "group") {
            this.group = (Group)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_emailAddress() {
        this._persistence_checkFetched("emailAddress");
        return this.emailAddress;
    }

    public void _persistence_set_emailAddress(String string) {
        this._persistence_checkFetchedForSet("emailAddress");
        this._persistence_propertyChange("emailAddress", (Object)this.emailAddress, (Object)string);
        this.emailAddress = string;
    }

    public EmailCampaign _persistence_get_emailCampaign() {
        this._persistence_checkFetched("emailCampaign");
        return this.emailCampaign;
    }

    public void _persistence_set_emailCampaign(EmailCampaign emailCampaign) {
        this._persistence_checkFetchedForSet("emailCampaign");
        this._persistence_propertyChange("emailCampaign", (Object)this.emailCampaign, (Object)emailCampaign);
        this.emailCampaign = emailCampaign;
    }

    public Integer _persistence_get_statusType() {
        this._persistence_checkFetched("statusType");
        return this.statusType;
    }

    public void _persistence_set_statusType(Integer n) {
        this._persistence_checkFetchedForSet("statusType");
        this._persistence_propertyChange("statusType", (Object)this.statusType, (Object)n);
        this.statusType = n;
    }

    public String _persistence_get_errorMessage() {
        this._persistence_checkFetched("errorMessage");
        return this.errorMessage;
    }

    public void _persistence_set_errorMessage(String string) {
        this._persistence_checkFetchedForSet("errorMessage");
        this._persistence_propertyChange("errorMessage", (Object)this.errorMessage, (Object)string);
        this.errorMessage = string;
    }

    public Client _persistence_get_client() {
        this._persistence_checkFetched("client");
        return this.client;
    }

    public void _persistence_set_client(Client client) {
        this._persistence_checkFetchedForSet("client");
        this._persistence_propertyChange("client", (Object)this.client, (Object)client);
        this.client = client;
    }

    public Staff _persistence_get_staff() {
        this._persistence_checkFetched("staff");
        return this.staff;
    }

    public void _persistence_set_staff(Staff staff) {
        this._persistence_checkFetchedForSet("staff");
        this._persistence_propertyChange("staff", (Object)this.staff, (Object)staff);
        this.staff = staff;
    }

    public LocalDate _persistence_get_submittedOnDate() {
        this._persistence_checkFetched("submittedOnDate");
        return this.submittedOnDate;
    }

    public void _persistence_set_submittedOnDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("submittedOnDate");
        this._persistence_propertyChange("submittedOnDate", (Object)this.submittedOnDate, (Object)localDate);
        this.submittedOnDate = localDate;
    }

    public String _persistence_get_message() {
        this._persistence_checkFetched("message");
        return this.message;
    }

    public void _persistence_set_message(String string) {
        this._persistence_checkFetchedForSet("message");
        this._persistence_propertyChange("message", (Object)this.message, (Object)string);
        this.message = string;
    }

    public String _persistence_get_emailSubject() {
        this._persistence_checkFetched("emailSubject");
        return this.emailSubject;
    }

    public void _persistence_set_emailSubject(String string) {
        this._persistence_checkFetchedForSet("emailSubject");
        this._persistence_propertyChange("emailSubject", (Object)this.emailSubject, (Object)string);
        this.emailSubject = string;
    }

    public String _persistence_get_campaignName() {
        this._persistence_checkFetched("campaignName");
        return this.campaignName;
    }

    public void _persistence_set_campaignName(String string) {
        this._persistence_checkFetchedForSet("campaignName");
        this._persistence_propertyChange("campaignName", (Object)this.campaignName, (Object)string);
        this.campaignName = string;
    }

    public Group _persistence_get_group() {
        this._persistence_checkFetched("group");
        return this.group;
    }

    public void _persistence_set_group(Group group) {
        this._persistence_checkFetchedForSet("group");
        this._persistence_propertyChange("group", (Object)this.group, (Object)group);
        this.group = group;
    }
}

