/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.jobs.sendmessagetosmsgateway;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.fineract.infrastructure.campaigns.helper.SmsConfigUtils;
import org.apache.fineract.infrastructure.campaigns.jobs.sendmessagetosmsgateway.SendMessageToSmsGatewayTasklet;
import org.apache.fineract.infrastructure.campaigns.sms.exception.ConnectionFailureException;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.gcm.service.NotificationSenderService;
import org.apache.fineract.infrastructure.sms.data.SmsMessageApiQueueResourceData;
import org.apache.fineract.infrastructure.sms.domain.SmsMessage;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageRepository;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageStatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.client.RestTemplate;

public class SendMessageToSmsGatewayTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SendMessageToSmsGatewayTasklet.class);
    private final SmsMessageRepository smsMessageRepository;
    private final NotificationSenderService notificationSenderService;
    private final SmsConfigUtils smsConfigUtils;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final RestTemplate restTemplate = new RestTemplate();

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Page pendingMessages;
        int totalRecords;
        int pageLimit = 200;
        int page = 0;
        do {
            PageRequest pageRequest = PageRequest.of((int)0, (int)pageLimit);
            pendingMessages = this.smsMessageRepository.findByStatusType(SmsMessageStatusType.PENDING.getValue(), (Pageable)pageRequest);
            ArrayList<SmsMessage> toSaveMessages = new ArrayList<SmsMessage>();
            ArrayList<SmsMessage> toSendNotificationMessages = new ArrayList<SmsMessage>();
            try {
                if (CollectionUtils.isEmpty((Collection)pendingMessages.getContent())) continue;
                String tenantIdentifier = ThreadLocalContextUtil.getTenant().getTenantIdentifier();
                Iterator pendingMessageIterator = pendingMessages.iterator();
                ArrayList<SmsMessageApiQueueResourceData> apiQueueResourceDataCollection = new ArrayList<SmsMessageApiQueueResourceData>();
                while (pendingMessageIterator.hasNext()) {
                    SmsMessage smsData = (SmsMessage)pendingMessageIterator.next();
                    if (smsData.isNotification()) {
                        smsData.setStatusType(SmsMessageStatusType.WAITING_FOR_DELIVERY_REPORT.getValue());
                        toSendNotificationMessages.add(smsData);
                        continue;
                    }
                    SmsMessageApiQueueResourceData apiQueueResourceData = SmsMessageApiQueueResourceData.instance((Long)((Long)smsData.getId()), (String)tenantIdentifier, null, null, (String)smsData.getMobileNo(), (String)smsData.getMessage(), (Long)smsData.getSmsCampaign().getProviderId());
                    apiQueueResourceDataCollection.add(apiQueueResourceData);
                    smsData.setStatusType(SmsMessageStatusType.WAITING_FOR_DELIVERY_REPORT.getValue());
                    toSaveMessages.add(smsData);
                }
                if (!toSaveMessages.isEmpty()) {
                    this.smsMessageRepository.saveAll(toSaveMessages);
                    this.smsMessageRepository.flush();
                    this.taskExecutor.execute((Runnable)new SmsTask(this, ThreadLocalContextUtil.getTenant(), apiQueueResourceDataCollection));
                }
                if (toSendNotificationMessages.isEmpty()) continue;
                this.notificationSenderService.sendNotification(toSendNotificationMessages);
            }
            catch (Exception e) {
                throw new ConnectionFailureException("sms", e);
            }
        } while (++page < (totalRecords = pendingMessages.getTotalPages()));
        return RepeatStatus.FINISHED;
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    private void connectAndSendToIntermediateServer(Collection<SmsMessageApiQueueResourceData> apiQueueResourceDatas) {
        HttpEntity entity;
        Map hostConfig = this.smsConfigUtils.getMessageGateWayRequestURI("sms", SmsMessageApiQueueResourceData.toJsonString(apiQueueResourceDatas));
        URI uri = (URI)hostConfig.get("uri");
        ResponseEntity responseOne = this.restTemplate.exchange(uri, HttpMethod.POST, entity = (HttpEntity)hostConfig.get("entity"), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (!responseOne.getStatusCode().equals(HttpStatus.ACCEPTED)) {
            log.debug("{}", (Object)responseOne.getStatusCode().value());
            throw new ConnectionFailureException("sms");
        }
    }

    @Generated
    public SendMessageToSmsGatewayTasklet(SmsMessageRepository smsMessageRepository, NotificationSenderService notificationSenderService, SmsConfigUtils smsConfigUtils, ThreadPoolTaskExecutor taskExecutor) {
        this.smsMessageRepository = smsMessageRepository;
        this.notificationSenderService = notificationSenderService;
        this.smsConfigUtils = smsConfigUtils;
        this.taskExecutor = taskExecutor;
    }
}

