/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.sms.service;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.fineract.infrastructure.campaigns.constants.CampaignType;
import org.apache.fineract.infrastructure.campaigns.helper.SmsConfigUtils;
import org.apache.fineract.infrastructure.campaigns.sms.constants.SmsCampaignEnumerations;
import org.apache.fineract.infrastructure.campaigns.sms.constants.SmsCampaignTriggerType;
import org.apache.fineract.infrastructure.campaigns.sms.data.SmsProviderData;
import org.apache.fineract.infrastructure.campaigns.sms.service.SmsCampaignDropdownReadPlatformService;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.portfolio.calendar.domain.CalendarWeekDaysType;
import org.apache.fineract.portfolio.calendar.service.CalendarEnumerations;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
public class SmsCampaignDropdownReadPlatformServiceImpl
implements SmsCampaignDropdownReadPlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(SmsCampaignDropdownReadPlatformServiceImpl.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final SmsConfigUtils smsConfigUtils;

    @Autowired
    public SmsCampaignDropdownReadPlatformServiceImpl(SmsConfigUtils smsConfigUtils) {
        this.smsConfigUtils = smsConfigUtils;
    }

    public Collection<EnumOptionData> retrieveCampaignTriggerTypes() {
        List<EnumOptionData> triggerTypeCodeValues = Arrays.asList(SmsCampaignEnumerations.smscampaignTriggerType((SmsCampaignTriggerType)SmsCampaignTriggerType.DIRECT), SmsCampaignEnumerations.smscampaignTriggerType((SmsCampaignTriggerType)SmsCampaignTriggerType.SCHEDULE), SmsCampaignEnumerations.smscampaignTriggerType((SmsCampaignTriggerType)SmsCampaignTriggerType.TRIGGERED));
        return triggerTypeCodeValues;
    }

    public Collection<SmsProviderData> retrieveSmsProviders() {
        Map hostConfig = this.smsConfigUtils.getMessageGateWayRequestURI("smsbridges", null);
        URI uri = (URI)hostConfig.get("uri");
        HttpEntity entity = (HttpEntity)hostConfig.get("entity");
        ResponseEntity responseOne = null;
        try {
            responseOne = this.restTemplate.exchange(uri, HttpMethod.GET, entity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (ResourceAccessException ex) {
            LOG.debug("Mobile service provider {} not available", (Object)uri, (Object)ex);
        }
        if (responseOne == null || !responseOne.getStatusCode().equals(HttpStatus.OK)) {
            throw new PlatformDataIntegrityException("error.msg.mobile.service.provider.not.available", "Mobile service provider not available.", new Object[0]);
        }
        Collection smsProviderOptions = (Collection)responseOne.getBody();
        return smsProviderOptions;
    }

    public Collection<EnumOptionData> retrieveCampaignTypes() {
        List<EnumOptionData> campaignTypeCodeValues = Arrays.asList(SmsCampaignEnumerations.smscampaignType((CampaignType)CampaignType.SMS));
        return campaignTypeCodeValues;
    }

    public Collection<EnumOptionData> retrieveMonths() {
        List monthsList = SmsCampaignEnumerations.calendarMonthType();
        return monthsList;
    }

    public Collection<EnumOptionData> retrieveWeeks() {
        List weeksList = CalendarEnumerations.calendarWeekDaysType((CalendarWeekDaysType[])CalendarWeekDaysType.values());
        return weeksList;
    }

    public Collection<EnumOptionData> retrivePeriodFrequencyTypes() {
        List periodFrequencyTypes = SmsCampaignEnumerations.calendarPeriodFrequencyTypes((PeriodFrequencyType[])PeriodFrequencyType.values());
        return periodFrequencyTypes;
    }
}

