/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.configuration.api.GlobalConfigurationApiResourceSwagger;
import org.apache.fineract.infrastructure.configuration.data.GlobalConfigurationData;
import org.apache.fineract.infrastructure.configuration.data.GlobalConfigurationPropertyData;
import org.apache.fineract.infrastructure.configuration.service.ConfigurationReadPlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/configurations")
@Component
@Tag(name="Global Configuration", description="Global configuration related to set of supported enable/disable configurations:\n\nmaker-checker - defaults to false - if true turns on maker-checker functionality\nreschedule-future-repayments - defaults to false - if true reschedules repayemnts which falls on a non-working day to configured repayment rescheduling rule\nallow-transactions-on-non-workingday - defaults to false - if true allows transactions on non-working days\nreschedule-repayments-on-holidays - defaults to false - if true reschedules repayemnts which falls on a non-working day to defined reschedule date\nallow-transactions-on-holiday - defaults to false - if true allows transactions on holidays\nsavings-interest-posting-current-period-end - Set it at the database level before any savings interest is posted. When set as false(default), interest will be posted on the first date of next period. If set as true, interest will be posted on last date of current period. There is no difference in the interest amount posted.\nfinancial-year-beginning-month - Set it at the database level before any savings interest is posted. Allowed values 1 - 12 (January - December). Interest posting periods are evaluated based on this configuration.\nmeetings-mandatory-for-jlg-loans - if set to true, enforces all JLG loans to follow a meeting schedule belonging to either the parent group or Center.")
public class GlobalConfigurationApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("globalConfiguration"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "CONFIGURATION";
    private final PlatformSecurityContext context;
    private final ConfigurationReadPlatformService readPlatformService;
    private final DefaultToApiJsonSerializer<GlobalConfigurationData> toApiJsonSerializer;
    private final DefaultToApiJsonSerializer<GlobalConfigurationPropertyData> propertyDataJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Global Configuration | Retrieve Global Configuration for surveys", description="Returns the list global enable/disable configurations.\n\nExample Requests:\n\nconfigurations\n\n\nReturns the list global enable/disable survey configurations.\n\nExample Requests:\n\nconfigurations/survey")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of example \\n response \\nsurveys response   \\ngiven below", content={@Content(schema=@Schema(implementation=GlobalConfigurationApiResourceSwagger.GetGlobalConfigurationsResponse.class))})})
    public String retrieveConfiguration(@Context UriInfo uriInfo, @DefaultValue(value="false") @QueryParam(value="survey") @Parameter(description="survey") boolean survey) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        GlobalConfigurationData configurationData = this.readPlatformService.retrieveGlobalConfiguration(survey);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)configurationData, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{configId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Global Configuration", description="Returns a global enable/disable configurations.\n\nExample Requests:\n\nconfigurations/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GlobalConfigurationApiResourceSwagger.GetGlobalConfigurationsResponse.class))})})
    public String retrieveOne(@PathParam(value="configId") @Parameter(description="configId") Long configId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        GlobalConfigurationPropertyData configurationData = this.readPlatformService.retrieveGlobalConfiguration(configId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.propertyDataJsonSerializer.serialize(settings, (Object)configurationData, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="name/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Global Configuration", description="Returns a global enable/disable configuration.\n\nExample Requests:\n\nconfigurations/name/enable-address")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GlobalConfigurationPropertyData.class))})})
    public String retrieveOneByName(@PathParam(value="name") @Parameter(description="name") String name, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        GlobalConfigurationPropertyData configurationData = this.readPlatformService.retrieveGlobalConfiguration(name);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.propertyDataJsonSerializer.serialize(settings, (Object)configurationData, RESPONSE_DATA_PARAMETERS);
    }

    @PUT
    @Path(value="{configId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Global Configuration", description="Updates an enable/disable global configuration item.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=GlobalConfigurationApiResourceSwagger.PutGlobalConfigurationsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GlobalConfigurationApiResourceSwagger.PutGlobalConfigurationsResponse.class))})})
    public String updateConfiguration(@PathParam(value="configId") @Parameter(description="configId") Long configId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateGlobalConfiguration(configId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="/name/{configName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Global Configuration by name", description="Updates an enable/disable global configuration item by name")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=GlobalConfigurationApiResourceSwagger.PutGlobalConfigurationsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GlobalConfigurationApiResourceSwagger.PutGlobalConfigurationsResponse.class))})})
    public String updateConfigurationByName(@PathParam(value="configName") @Parameter(description="configName") String configName, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        GlobalConfigurationPropertyData configurationData = this.readPlatformService.retrieveGlobalConfiguration(configName);
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateGlobalConfiguration(configurationData.getId()).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public GlobalConfigurationApiResource(PlatformSecurityContext context, ConfigurationReadPlatformService readPlatformService, DefaultToApiJsonSerializer<GlobalConfigurationData> toApiJsonSerializer, DefaultToApiJsonSerializer<GlobalConfigurationPropertyData> propertyDataJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.propertyDataJsonSerializer = propertyDataJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

