/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.config.jpa;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.fineract.infrastructure.core.auditing.JpaAuditingHandlerRegistrar;
import org.apache.fineract.infrastructure.core.config.jpa.EntityManagerFactoryCustomizer;
import org.apache.fineract.infrastructure.core.domain.AuditorAwareImpl;
import org.apache.fineract.infrastructure.core.persistence.DatabaseSelectingPersistenceUnitPostProcessor;
import org.apache.fineract.infrastructure.core.service.database.DatabaseTypeResolver;
import org.apache.fineract.infrastructure.core.service.database.RoutingDataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.orm.jpa.EntityManagerFactoryBuilderCustomizer;
import org.springframework.boot.autoconfigure.orm.jpa.JpaBaseConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.AuditorAware;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@EnableJpaAuditing
@EnableJpaRepositories(basePackages={"org.apache.fineract.**.domain", "org.apache.fineract.**.repository"})
@EnableConfigurationProperties(value={JpaProperties.class})
@Import(value={JpaAuditingHandlerRegistrar.class})
public class JPAConfig
extends JpaBaseConfiguration {
    private final DatabaseTypeResolver databaseTypeResolver;
    private final Collection<EntityManagerFactoryCustomizer> emFactoryCustomizers;

    public JPAConfig(RoutingDataSource dataSource, JpaProperties properties, ObjectProvider<JtaTransactionManager> jtaTransactionManager, DatabaseTypeResolver databaseTypeResolver, Collection<EntityManagerFactoryCustomizer> customizers) {
        super((DataSource)dataSource, properties, jtaTransactionManager);
        this.databaseTypeResolver = databaseTypeResolver;
        this.emFactoryCustomizers = customizers;
    }

    @Bean
    @Primary
    @DependsOn(value={"tenantDatabaseUpgradeService"})
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(EntityManagerFactoryBuilder factoryBuilder, PersistenceManagedTypes persistenceManagedTypes) {
        Map vendorProperties = this.getVendorProperties();
        String[] packagesToScan = this.getPackagesToScan();
        return factoryBuilder.dataSource(this.getDataSource()).properties(vendorProperties).persistenceUnit("jpa-pu").packages(packagesToScan).jta(false).build();
    }

    protected Map<String, Object> getVendorProperties() {
        HashMap<String, Object> vendorProperties = new HashMap<String, Object>();
        vendorProperties.put("eclipselink.weaving", "static");
        vendorProperties.put("eclipselink.persistence-context.close-on-commit", "true");
        vendorProperties.put("eclipselink.cache.shared.default", "false");
        this.emFactoryCustomizers.forEach(c -> vendorProperties.putAll(c.additionalVendorProperties()));
        return vendorProperties;
    }

    protected String[] getPackagesToScan() {
        HashSet<String> packagesToScan = new HashSet<String>();
        packagesToScan.add("org.apache.fineract");
        this.emFactoryCustomizers.forEach(c -> packagesToScan.addAll(c.additionalPackagesToScan()));
        return (String[])packagesToScan.toArray(String[]::new);
    }

    public EntityManagerFactoryBuilder entityManagerFactoryBuilder(JpaVendorAdapter jpaVendorAdapter, ObjectProvider<PersistenceUnitManager> persistenceUnitManager, ObjectProvider<EntityManagerFactoryBuilderCustomizer> customizers) {
        EntityManagerFactoryBuilder builder = super.entityManagerFactoryBuilder(jpaVendorAdapter, persistenceUnitManager, customizers);
        builder.setPersistenceUnitPostProcessors(this.getPersistenceUnitPostProcessors());
        return builder;
    }

    private PersistenceUnitPostProcessor[] getPersistenceUnitPostProcessors() {
        HashSet<DatabaseSelectingPersistenceUnitPostProcessor> processors = new HashSet<DatabaseSelectingPersistenceUnitPostProcessor>();
        processors.add(new DatabaseSelectingPersistenceUnitPostProcessor(this.databaseTypeResolver));
        this.emFactoryCustomizers.forEach(c -> processors.addAll(c.additionalPersistenceUnitPostProcessors()));
        return (PersistenceUnitPostProcessor[])processors.toArray(PersistenceUnitPostProcessor[]::new);
    }

    protected AbstractJpaVendorAdapter createJpaVendorAdapter() {
        return new EclipseLinkJpaVendorAdapter();
    }

    @Bean
    public AuditorAware<Long> auditorAware() {
        return new AuditorAwareImpl();
    }

    @Bean
    public TransactionTemplate txTemplate(PlatformTransactionManager transactionManager) {
        TransactionTemplate tt = new TransactionTemplate();
        tt.setTransactionManager(transactionManager);
        return tt;
    }
}

