/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.jersey;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.fineract.infrastructure.core.jersey.JerseyJacksonObjectArgumentHandler;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonInputMessage;
import org.springframework.stereotype.Component;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Component
public class JerseyJacksonObjectArgumentHandler<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private final MappingJackson2HttpMessageConverter converter;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, jakarta.ws.rs.core.MediaType mediaType) {
        return true;
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, jakarta.ws.rs.core.MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        if (String.class == genericType) {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)entityStream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
            String json = writer.toString();
            return type.cast(json);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.putAll(httpHeaders);
        return (T)this.converter.read(genericType, type, (HttpInputMessage)new MappingJacksonInputMessage(entityStream, headers));
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, jakarta.ws.rs.core.MediaType mediaType) {
        return true;
    }

    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, jakarta.ws.rs.core.MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (String.class == genericType) {
            IOUtils.write((String)((String)t), (OutputStream)entityStream, (Charset)StandardCharsets.UTF_8);
        } else {
            HttpHeaders headers = new HttpHeaders();
            httpHeaders.forEach((header, rawValues) -> {
                List<String> values = rawValues.stream().map(Object::toString).toList();
                headers.put(header, values);
            });
            this.converter.write(t, genericType, MediaType.APPLICATION_JSON, (HttpOutputMessage)new SimpleHttpOutputMessage(entityStream, headers));
        }
    }

    @Generated
    public JerseyJacksonObjectArgumentHandler(MappingJackson2HttpMessageConverter converter) {
        this.converter = converter;
    }
}

