/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.service.migration;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.service.migration.ExtendedSpringLiquibase;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.core.io.ResourceLoader;

public class ExtendedSpringLiquibaseBuilder {
    private final Set<String> contexts = new HashSet();
    private final Map<String, String> changeLogParameters = new HashMap();
    private final boolean clearCheckSums;
    private final String liquibaseSchema;
    private final String liquibaseTableSpace;
    private final String databaseChangeLogTable;
    private final String databaseChangeLogLockTable;
    private final boolean shouldRun;
    private final String labelFilter;
    private final File rollbackFile;
    private final boolean testRollbackOnUpdate;
    private final String tag;
    private String changeLog;
    private ResourceLoader resourceLoader;
    private String defaultSchema;
    private boolean dropFirst;
    private DataSource dataSource;

    public ExtendedSpringLiquibaseBuilder(LiquibaseProperties liquibaseProperties) {
        this.defaultSchema = liquibaseProperties.getDefaultSchema();
        this.dropFirst = liquibaseProperties.isDropFirst();
        if (liquibaseProperties.getParameters() != null) {
            this.changeLogParameters.putAll(liquibaseProperties.getParameters());
        }
        this.changeLog = liquibaseProperties.getChangeLog();
        if (StringUtils.isNotBlank((CharSequence)liquibaseProperties.getContexts())) {
            this.contexts.add(liquibaseProperties.getContexts());
        }
        this.clearCheckSums = liquibaseProperties.isClearChecksums();
        this.liquibaseSchema = liquibaseProperties.getLiquibaseSchema();
        this.liquibaseTableSpace = liquibaseProperties.getLiquibaseTablespace();
        this.databaseChangeLogTable = liquibaseProperties.getDatabaseChangeLogTable();
        this.databaseChangeLogLockTable = liquibaseProperties.getDatabaseChangeLogLockTable();
        this.shouldRun = liquibaseProperties.isEnabled();
        this.labelFilter = liquibaseProperties.getLabelFilter();
        this.rollbackFile = liquibaseProperties.getRollbackFile();
        this.testRollbackOnUpdate = liquibaseProperties.isTestRollbackOnUpdate();
        this.tag = liquibaseProperties.getTag();
    }

    public ExtendedSpringLiquibaseBuilder withDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public ExtendedSpringLiquibaseBuilder withContext(String context) {
        if (StringUtils.isNotBlank((CharSequence)context)) {
            this.contexts.add(context);
        }
        return this;
    }

    public ExtendedSpringLiquibaseBuilder withContexts(String ... contexts) {
        return this.withContexts(Arrays.asList(contexts));
    }

    public ExtendedSpringLiquibaseBuilder withContexts(Collection<String> contexts) {
        this.contexts.addAll(contexts);
        return this;
    }

    public ExtendedSpringLiquibaseBuilder withResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        return this;
    }

    public ExtendedSpringLiquibase build() {
        ExtendedSpringLiquibase result = new ExtendedSpringLiquibase();
        String liquibaseContexts = Joiner.on((String)",").join((Iterable)this.contexts);
        result.setContexts(liquibaseContexts);
        result.setDataSource(this.dataSource);
        result.setChangeLog(this.changeLog);
        result.setResourceLoader(this.resourceLoader);
        result.setDefaultSchema(this.defaultSchema);
        result.setDropFirst(this.dropFirst);
        result.setChangeLogParameters(this.changeLogParameters);
        result.setClearCheckSums(this.clearCheckSums);
        result.setLiquibaseSchema(this.liquibaseSchema);
        result.setLiquibaseTablespace(this.liquibaseTableSpace);
        result.setDatabaseChangeLogTable(this.databaseChangeLogTable);
        result.setDatabaseChangeLogLockTable(this.databaseChangeLogLockTable);
        result.setShouldRun(this.shouldRun);
        result.setLabelFilter(this.labelFilter);
        result.setRollbackFile(this.rollbackFile);
        result.setTestRollbackOnUpdate(this.testRollbackOnUpdate);
        result.setTag(this.tag);
        return result;
    }
}

