/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureau;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureauLoanProductMapping;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_organisation_creditbureau")
public class OrganisationCreditBureau
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private String alias;
    @OneToOne
    @JoinColumn(name="creditbureau_id", nullable=false)
    private CreditBureau creditbureau;
    @Column(name="is_active")
    private boolean isActive;
    @OneToMany(mappedBy="organisation_creditbureau", cascade={CascadeType.ALL})
    private List<CreditBureauLoanProductMapping> creditBureauLoanProductMapping = new ArrayList();
    static final long serialVersionUID = -1728873747078604600L;

    public OrganisationCreditBureau(String alias, CreditBureau creditbureau, boolean isActive, List<CreditBureauLoanProductMapping> creditBureauLoanProductMapping) {
        this.alias = alias;
        this.creditbureau = creditbureau;
        this.isActive = isActive;
        this.creditBureauLoanProductMapping = creditBureauLoanProductMapping;
    }

    public OrganisationCreditBureau() {
    }

    public static OrganisationCreditBureau fromJson(JsonCommand command, CreditBureau creditbureau) {
        String alias = command.stringValueOfParameterNamed("alias");
        boolean isActive = command.booleanPrimitiveValueOfParameterNamed("isActive");
        return new OrganisationCreditBureau(alias, creditbureau, isActive, null);
    }

    public String getAlias() {
        return this._persistence_get_alias();
    }

    public void setAlias(String alias) {
        this._persistence_set_alias(alias);
    }

    public CreditBureau getCreditBureau() {
        return this._persistence_get_creditbureau();
    }

    public void setCreditBureau(CreditBureau creditbureau) {
        this._persistence_set_creditbureau(creditbureau);
    }

    public boolean isActive() {
        return this._persistence_get_isActive();
    }

    public void setIsActive(boolean isActive) {
        this._persistence_set_isActive(isActive);
    }

    public List<CreditBureauLoanProductMapping> getCreditBureauLoanProductMapping() {
        return this._persistence_get_creditBureauLoanProductMapping();
    }

    public void setCreditBureauLoanProductMapping(List<CreditBureauLoanProductMapping> creditBureauLoanProductMapping) {
        this._persistence_set_creditBureauLoanProductMapping(creditBureauLoanProductMapping);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new OrganisationCreditBureau();
    }

    public Object _persistence_get(String string) {
        if (string == "creditBureauLoanProductMapping") {
            return this.creditBureauLoanProductMapping;
        }
        if (string == "alias") {
            return this.alias;
        }
        if (string == "isActive") {
            return this.isActive;
        }
        if (string == "creditbureau") {
            return this.creditbureau;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "creditBureauLoanProductMapping") {
            this.creditBureauLoanProductMapping = (List)object;
            return;
        }
        if (string == "alias") {
            this.alias = (String)object;
            return;
        }
        if (string == "isActive") {
            this.isActive = (Boolean)object;
            return;
        }
        if (string == "creditbureau") {
            this.creditbureau = (CreditBureau)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_creditBureauLoanProductMapping() {
        this._persistence_checkFetched("creditBureauLoanProductMapping");
        return this.creditBureauLoanProductMapping;
    }

    public void _persistence_set_creditBureauLoanProductMapping(List list) {
        this._persistence_checkFetchedForSet("creditBureauLoanProductMapping");
        this._persistence_propertyChange("creditBureauLoanProductMapping", (Object)this.creditBureauLoanProductMapping, (Object)list);
        this.creditBureauLoanProductMapping = list;
    }

    public String _persistence_get_alias() {
        this._persistence_checkFetched("alias");
        return this.alias;
    }

    public void _persistence_set_alias(String string) {
        this._persistence_checkFetchedForSet("alias");
        this._persistence_propertyChange("alias", (Object)this.alias, (Object)string);
        this.alias = string;
    }

    public boolean _persistence_get_isActive() {
        this._persistence_checkFetched("isActive");
        return this.isActive;
    }

    public void _persistence_set_isActive(boolean bl) {
        this._persistence_checkFetchedForSet("isActive");
        this._persistence_propertyChange("isActive", (Object)new Boolean(this.isActive), (Object)new Boolean(bl));
        this.isActive = bl;
    }

    public CreditBureau _persistence_get_creditbureau() {
        this._persistence_checkFetched("creditbureau");
        return this.creditbureau;
    }

    public void _persistence_set_creditbureau(CreditBureau creditBureau) {
        this._persistence_checkFetchedForSet("creditbureau");
        this._persistence_propertyChange("creditbureau", (Object)this.creditbureau, (Object)creditBureau);
        this.creditbureau = creditBureau;
    }
}

