/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.exception.PlatformServiceUnavailableException;
import org.apache.fineract.infrastructure.dataqueries.api.RunreportsApiResourceSwagger;
import org.apache.fineract.infrastructure.dataqueries.data.ReportExportType;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.report.provider.ReportingProcessServiceProvider;
import org.apache.fineract.infrastructure.report.service.ReportingProcessService;
import org.apache.fineract.infrastructure.security.exception.NoAuthorizationException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.domain.AppUser;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.springframework.stereotype.Component;

@Path(value="/v1/runreports")
@Component
@Tag(name="Run Reports", description="")
public class RunreportsApiResource {
    public static final String IS_SELF_SERVICE_USER_REPORT_PARAMETER = "isSelfServiceUserReport";
    private final PlatformSecurityContext context;
    private final ReadReportingService readExtraDataAndReportingService;
    private final ReportingProcessServiceProvider reportingProcessServiceProvider;

    @GET
    @Path(value="/availableExports/{reportName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Return all available export types for the specific report", description="Returns the list of all available export types.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ReportExportType.class)))})})
    public Response retrieveAllAvailableExports(@PathParam(value="reportName") @Parameter(description="reportName") String reportName, @Context UriInfo uriInfo, @DefaultValue(value="false") @QueryParam(value="isSelfServiceUserReport") @Parameter(description="isSelfServiceUserReport") boolean isSelfServiceUserReport) {
        MultivaluedStringMap queryParams = new MultivaluedStringMap();
        queryParams.putAll((Map)uriInfo.getQueryParameters());
        boolean parameterType = ApiParameterHelper.parameterType((MultivaluedMap)queryParams);
        String reportType = this.readExtraDataAndReportingService.getReportType(reportName, isSelfServiceUserReport, parameterType);
        ReportingProcessService reportingProcessService = this.reportingProcessServiceProvider.findReportingProcessService(reportType);
        if (reportingProcessService == null) {
            throw new PlatformServiceUnavailableException("err.msg.report.service.implementation.missing", "There is no ReportingProcessService registered in the ReportingProcessServiceProvider for this report type: " + reportType, new Object[]{reportType});
        }
        return Response.ok().entity((Object)reportingProcessService.getAvailableExportTargets()).build();
    }

    @GET
    @Path(value="{reportName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "text/csv", "application/vnd.ms-excel", "application/pdf", "text/html"})
    @Operation(summary="Running a Report", description="This resource allows you to run and receive output from pre-defined Apache Fineract reports.\n\nReports can also be used to provide data for searching and workflow functionality.\n\nThe default output is a JSON formatted \"Generic Resultset\". The Generic Resultset contains Column Heading as well as Data information. However, you can export to CSV format by simply adding \"&exportCSV=true\" to the end of your URL.\n\nIf Pentaho reports have been pre-defined, they can also be run through this resource. Pentaho reports can return HTML, PDF or CSV formats.\n\nThe Apache Fineract reference application uses a JQuery plugin called stretchy reporting which, itself, uses this reports resource to provide a pretty flexible reporting User Interface (UI).\n\n\n\nExample Requests:\n\nrunreports/Client%20Listing?R_officeId=1\n\n\nrunreports/Client%20Listing?R_officeId=1&exportCSV=true\n\n\nrunreports/OfficeIdSelectOne?R_officeId=1&parameterType=true\n\n\nrunreports/OfficeIdSelectOne?R_officeId=1&parameterType=true&exportCSV=true\n\n\nrunreports/Expected%20Payments%20By%20Date%20-%20Formatted?R_endDate=2013-04-30&R_loanOfficerId=-1&R_officeId=1&R_startDate=2013-04-16&output-type=HTML&R_officeId=1\n\n\nrunreports/Expected%20Payments%20By%20Date%20-%20Formatted?R_endDate=2013-04-30&R_loanOfficerId=-1&R_officeId=1&R_startDate=2013-04-16&output-type=XLS&R_officeId=1\n\n\nrunreports/Expected%20Payments%20By%20Date%20-%20Formatted?R_endDate=2013-04-30&R_loanOfficerId=-1&R_officeId=1&R_startDate=2013-04-16&output-type=CSV&R_officeId=1\n\n\nrunreports/Expected%20Payments%20By%20Date%20-%20Formatted?R_endDate=2013-04-30&R_loanOfficerId=-1&R_officeId=1&R_startDate=2013-04-16&output-type=PDF&R_officeId=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RunreportsApiResourceSwagger.RunReportsResponse.class))})})
    public Response runReport(@PathParam(value="reportName") @Parameter(description="reportName") String reportName, @Context UriInfo uriInfo, @DefaultValue(value="false") @QueryParam(value="isSelfServiceUserReport") @Parameter(description="isSelfServiceUserReport") boolean isSelfServiceUserReport) {
        MultivaluedStringMap queryParams = new MultivaluedStringMap();
        queryParams.putAll((Map)uriInfo.getQueryParameters());
        boolean parameterType = ApiParameterHelper.parameterType((MultivaluedMap)queryParams);
        this.checkUserPermissionForReport(reportName, parameterType);
        queryParams.putSingle((Object)IS_SELF_SERVICE_USER_REPORT_PARAMETER, (Object)Boolean.toString(isSelfServiceUserReport));
        String reportType = this.readExtraDataAndReportingService.getReportType(reportName, isSelfServiceUserReport, parameterType);
        ReportingProcessService reportingProcessService = this.reportingProcessServiceProvider.findReportingProcessService(reportType);
        if (reportingProcessService == null) {
            throw new PlatformServiceUnavailableException("err.msg.report.service.implementation.missing", "There is no ReportingProcessService registered in the ReportingProcessServiceProvider for this report type: " + reportType, new Object[]{reportType});
        }
        return reportingProcessService.processRequest(reportName, (MultivaluedMap)queryParams);
    }

    private void checkUserPermissionForReport(String reportName, boolean parameterType) {
        AppUser currentUser;
        if (!parameterType && (currentUser = this.context.authenticatedUser()).hasNotPermissionForReport(reportName)) {
            throw new NoAuthorizationException("Not authorised to run report: " + reportName);
        }
    }

    @Generated
    public RunreportsApiResource(PlatformSecurityContext context, ReadReportingService readExtraDataAndReportingService, ReportingProcessServiceProvider reportingProcessServiceProvider) {
        this.context = context;
        this.readExtraDataAndReportingService = readExtraDataAndReportingService;
        this.reportingProcessServiceProvider = reportingProcessServiceProvider;
    }
}

