/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service;

import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.core.service.database.DatabaseTypeResolver;
import org.apache.fineract.infrastructure.dataqueries.data.DatatableCheckStatusData;
import org.apache.fineract.infrastructure.dataqueries.data.DatatableChecksData;
import org.apache.fineract.infrastructure.dataqueries.data.DatatableData;
import org.apache.fineract.infrastructure.dataqueries.data.EntityDataTableChecksData;
import org.apache.fineract.infrastructure.dataqueries.data.EntityDataTableChecksTemplateData;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.domain.EntityDatatableChecks;
import org.apache.fineract.infrastructure.dataqueries.domain.EntityDatatableChecksRepository;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksReadService;
import org.apache.fineract.infrastructure.dataqueries.service.ReadWriteNonCoreDataService;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class EntityDatatableChecksReadPlatformServiceImpl
implements EntityDatatableChecksReadService {
    private final JdbcTemplate jdbcTemplate;
    protected final DatabaseTypeResolver databaseTypeResolver;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final RegisterDataTableMapper registerDataTableMapper;
    private final EntityDataTableChecksMapper entityDataTableChecksMapper;
    private final EntityDatatableChecksRepository entityDatatableChecksRepository;
    private final ReadWriteNonCoreDataService readWriteNonCoreDataService;
    private final LoanProductReadPlatformService loanProductReadPlatformService;
    private final SavingsProductReadPlatformService savingsProductReadPlatformService;
    private final PaginationHelper paginationHelper;

    @Autowired
    public EntityDatatableChecksReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, DatabaseTypeResolver databaseTypeResolver, DatabaseSpecificSQLGenerator sqlGenerator, LoanProductReadPlatformService loanProductReadPlatformService, SavingsProductReadPlatformService savingsProductReadPlatformService, EntityDatatableChecksRepository entityDatatableChecksRepository, ReadWriteNonCoreDataService readWriteNonCoreDataService, PaginationHelper paginationHelper) {
        this.jdbcTemplate = jdbcTemplate;
        this.databaseTypeResolver = databaseTypeResolver;
        this.sqlGenerator = sqlGenerator;
        this.registerDataTableMapper = new RegisterDataTableMapper(this);
        this.entityDataTableChecksMapper = new EntityDataTableChecksMapper();
        this.loanProductReadPlatformService = loanProductReadPlatformService;
        this.savingsProductReadPlatformService = savingsProductReadPlatformService;
        this.entityDatatableChecksRepository = entityDatatableChecksRepository;
        this.readWriteNonCoreDataService = readWriteNonCoreDataService;
        this.paginationHelper = paginationHelper;
    }

    public Page<EntityDataTableChecksData> retrieveAll(@NotNull SearchParameters searchParameters, Integer status, String entity, Long productId) {
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select ").append(this.sqlGenerator.calcFoundRows()).append(" ").append(this.entityDataTableChecksMapper.schema());
        if (status != null || entity != null || productId != null) {
            sqlBuilder.append(" where ");
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (status != null) {
            sqlBuilder.append(" status_enum = ? ");
            paramList.add(status);
        }
        if (entity != null) {
            sqlBuilder.append(" and t.application_table_name = ? ");
            paramList.add(entity);
        }
        if (productId != null) {
            sqlBuilder.append(" and t.product_id = ? ");
            paramList.add(productId);
        }
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), paramList.toArray(), (RowMapper)this.entityDataTableChecksMapper);
    }

    public List<DatatableData> retrieveTemplates(Integer status, String entity, Long productId) {
        List tableRequiredBeforeAction = null;
        if (productId != null) {
            tableRequiredBeforeAction = this.entityDatatableChecksRepository.findByEntityStatusAndProduct(entity, status, productId);
        }
        if (tableRequiredBeforeAction == null || tableRequiredBeforeAction.size() < 1) {
            tableRequiredBeforeAction = this.entityDatatableChecksRepository.findByEntityStatusAndNoProduct(entity, status);
        }
        if (tableRequiredBeforeAction != null && tableRequiredBeforeAction.size() > 0) {
            ArrayList<DatatableData> ret = new ArrayList<DatatableData>();
            for (EntityDatatableChecks t : tableRequiredBeforeAction) {
                ret.add(this.readWriteNonCoreDataService.retrieveDatatable(t.getDatatableName()));
            }
            return ret;
        }
        return null;
    }

    public EntityDataTableChecksTemplateData retrieveTemplate() {
        List dataTables = this.getDataTables();
        List entities = EntityTables.getEntityNames();
        List clientStatuses = this.getStatusList(EntityTables.CLIENT.getCheckStatuses());
        List loanStatuses = this.getStatusList(EntityTables.LOAN.getCheckStatuses());
        List groupstatuses = this.getStatusList(EntityTables.GROUP.getCheckStatuses());
        List savingsStatuses = this.getStatusList(EntityTables.SAVINGS.getCheckStatuses());
        Collection loanProductDatas = this.loanProductReadPlatformService.retrieveAllLoanProductsForLookup(true);
        Collection savingsProductDatas = this.savingsProductReadPlatformService.retrieveAllForLookup();
        return new EntityDataTableChecksTemplateData(entities, clientStatuses, groupstatuses, savingsStatuses, loanStatuses, dataTables, loanProductDatas, savingsProductDatas);
    }

    private List<DatatableCheckStatusData> getStatusList(List<StatusEnum> statuses) {
        ArrayList<DatatableCheckStatusData> ret = new ArrayList<DatatableCheckStatusData>();
        if (statuses != null) {
            for (StatusEnum status : statuses) {
                ret.add(new DatatableCheckStatusData(status.name(), status.getValue().intValue()));
            }
        }
        return ret;
    }

    private List<DatatableChecksData> getDataTables() {
        String sql = "select " + this.registerDataTableMapper.schema();
        return this.jdbcTemplate.query(sql, (RowMapper)this.registerDataTableMapper);
    }
}

