/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service.export;

import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DatatableExportUtil {
    private DatatableExportUtil() {
    }

    public static String normalizeFolderName(String folderName) {
        if (StringUtils.isBlank((CharSequence)folderName)) {
            return "";
        }
        String contentNormalizer = folderName.trim().replaceAll("[^a-zA-Z0-9!\\-_.'()$/]", "_").replaceAll("/+", "/").replaceAll("^[./]+", "");
        return contentNormalizer.endsWith("/") ? contentNormalizer.substring(0, contentNormalizer.length() - 1) : contentNormalizer;
    }

    public static String generatePlainExportFileName(int maxLength, String extension, String reportName, Map<String, String> reportParams) {
        DatatableExportUtil.exportBasicValidation((String)extension, (String)reportName);
        return DatatableExportUtil.generateReportFileName((int)maxLength, (String)"", (String)extension, (String)reportName, reportParams);
    }

    private static void exportBasicValidation(String extension, String reportName) {
        if (StringUtils.isBlank((CharSequence)extension)) {
            throw new IllegalArgumentException("The extension is required");
        }
        if (StringUtils.isBlank((CharSequence)reportName)) {
            throw new IllegalArgumentException("The report name is required");
        }
    }

    public static String generateS3DatatableExportFileName(int maxLength, String folder, String extension, String reportName, Map<String, String> reportParams) {
        DatatableExportUtil.exportBasicValidation((String)extension, (String)reportName);
        if (maxLength < 30) {
            throw new IllegalArgumentException("The maximum length must be greater than 30");
        }
        folder = DatatableExportUtil.normalizeFolderName((String)folder);
        String reportFinalName = DatatableExportUtil.generateReportFileName((int)maxLength, (String)folder, (String)extension, (String)reportName, reportParams);
        if (StringUtils.isBlank((CharSequence)folder)) {
            return reportFinalName;
        }
        return folder + "/" + reportFinalName;
    }

    @NotNull
    private static String generateReportFileName(int maxLength, String folder, String extension, String reportName, Map<String, String> reportParams) {
        Object extensionWithDot = extension.startsWith(".") ? extension : "." + extension;
        String timestamp = "_" + DateUtils.getOffsetDateTimeOfTenant().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        int reportMaximumFileName = maxLength - folder.length() - timestamp.length() - ((String)extensionWithDot).length() - 1;
        if (reportMaximumFileName < 0) {
            throw new IllegalArgumentException("The folder name is too long");
        }
        Object normalizedFileName = reportName.trim().replaceAll("[^a-zA-Z0-9!\\-_.'()$]", "_");
        if (reportParams != null) {
            normalizedFileName = (String)normalizedFileName + "(" + reportParams.entrySet().stream().map(entry -> DatatableExportUtil.extractReportParameterKey((String)((String)entry.getKey())) + "_" + (String)entry.getValue()).collect(Collectors.joining(";")) + ")";
        }
        String reportFinalName = ((String)normalizedFileName).substring(0, Math.min(((String)normalizedFileName).length(), reportMaximumFileName)) + timestamp + (String)extensionWithDot;
        return reportFinalName;
    }

    private static String extractReportParameterKey(String key) {
        return key.startsWith("${") && key.endsWith("}") ? key.substring(2, key.length() - 1) : key;
    }
}

