/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.entityaccess.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.entityaccess.FineractEntityAccessConstants;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_entity_to_entity_access")
public class FineractEntityAccess
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="entity_type", length=50)
    private String entityType;
    @Column(name="entity_id")
    private Long entityId;
    @ManyToOne
    @JoinColumn(name="access_type_code_value_id", nullable=false)
    private CodeValue accessType;
    @Column(name="second_entity_type", length=50)
    private String secondEntityType;
    @Column(name="second_entity_id")
    private Long secondEntityId;
    static final long serialVersionUID = 3562479738619654678L;

    public static FineractEntityAccess createNew(String entityType, Long entityId, CodeValue accessType, String secondEntityType, Long secondEntityId) {
        return new FineractEntityAccess().setEntityType(entityType).setEntityId(entityId).setAccessType(accessType).setSecondEntityType(secondEntityType).setSecondEntityId(secondEntityId);
    }

    public static FineractEntityAccess fromJson(CodeValue accessType, JsonCommand command) {
        String entityType = command.stringValueOfParameterNamed(FineractEntityAccessConstants.EntityAccessJSONinputParams.ENTITY_TYPE.getValue());
        Long entityId = command.longValueOfParameterNamed(FineractEntityAccessConstants.EntityAccessJSONinputParams.ENTITY_ID.getValue());
        String secondEntityType = command.stringValueOfParameterNamed(FineractEntityAccessConstants.EntityAccessJSONinputParams.SECOND_ENTITY_ID.getValue());
        Long secondEntityId = command.longValueOfParameterNamed(FineractEntityAccessConstants.EntityAccessJSONinputParams.SECOND_ENTITY_ID.getValue());
        return new FineractEntityAccess().setEntityType(entityType).setEntityId(entityId).setAccessType(accessType).setSecondEntityType(secondEntityType).setSecondEntityId(secondEntityId);
    }

    public Map<String, Object> update(JsonCommand command) {
        Object newValue;
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>();
        String paramName = null;
        paramName = FineractEntityAccessConstants.EntityAccessJSONinputParams.ENTITY_TYPE.getValue();
        if (command.isChangeInStringParameterNamed(paramName, this._persistence_get_entityType())) {
            String newValue2 = command.stringValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue2);
            this._persistence_set_entityType(newValue2);
        }
        if (command.isChangeInLongParameterNamed(paramName = FineractEntityAccessConstants.EntityAccessJSONinputParams.ENTITY_ID.getValue(), this.getEntityId())) {
            this._persistence_set_entityId(command.longValueOfParameterNamed(paramName));
            actualChanges.put(paramName, this._persistence_get_entityId());
        }
        Long existingAccessTypeId = null;
        if (this._persistence_get_accessType() != null) {
            existingAccessTypeId = (Long)this._persistence_get_accessType().getId();
        }
        if (command.isChangeInLongParameterNamed(paramName = FineractEntityAccessConstants.EntityAccessJSONinputParams.ENTITY_ACCESS_TYPE_ID.getValue(), existingAccessTypeId)) {
            newValue = command.longValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue);
        }
        if (command.isChangeInStringParameterNamed(paramName = FineractEntityAccessConstants.EntityAccessJSONinputParams.SECOND_ENTITY_TYPE.getValue(), this._persistence_get_secondEntityType())) {
            newValue = command.stringValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue);
            this._persistence_set_secondEntityType((String)newValue);
        }
        if (command.isChangeInLongParameterNamed(paramName = FineractEntityAccessConstants.EntityAccessJSONinputParams.SECOND_ENTITY_ID.getValue(), this.getSecondEntityId())) {
            this._persistence_set_secondEntityId(command.longValueOfParameterNamed(paramName));
            actualChanges.put(paramName, this._persistence_get_secondEntityId());
        }
        return actualChanges;
    }

    @Generated
    public String getEntityType() {
        return this._persistence_get_entityType();
    }

    @Generated
    public Long getEntityId() {
        return this._persistence_get_entityId();
    }

    @Generated
    public CodeValue getAccessType() {
        return this._persistence_get_accessType();
    }

    @Generated
    public String getSecondEntityType() {
        return this._persistence_get_secondEntityType();
    }

    @Generated
    public Long getSecondEntityId() {
        return this._persistence_get_secondEntityId();
    }

    @Generated
    public FineractEntityAccess setEntityType(String entityType) {
        this._persistence_set_entityType(entityType);
        return this;
    }

    @Generated
    public FineractEntityAccess setEntityId(Long entityId) {
        this._persistence_set_entityId(entityId);
        return this;
    }

    @Generated
    public FineractEntityAccess setAccessType(CodeValue accessType) {
        this._persistence_set_accessType(accessType);
        return this;
    }

    @Generated
    public FineractEntityAccess setSecondEntityType(String secondEntityType) {
        this._persistence_set_secondEntityType(secondEntityType);
        return this;
    }

    @Generated
    public FineractEntityAccess setSecondEntityId(Long secondEntityId) {
        this._persistence_set_secondEntityId(secondEntityId);
        return this;
    }

    @Generated
    public FineractEntityAccess() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new FineractEntityAccess();
    }

    public Object _persistence_get(String string) {
        if (string == "accessType") {
            return this.accessType;
        }
        if (string == "secondEntityType") {
            return this.secondEntityType;
        }
        if (string == "entityType") {
            return this.entityType;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "secondEntityId") {
            return this.secondEntityId;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "accessType") {
            this.accessType = (CodeValue)object;
            return;
        }
        if (string == "secondEntityType") {
            this.secondEntityType = (String)object;
            return;
        }
        if (string == "entityType") {
            this.entityType = (String)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (Long)object;
            return;
        }
        if (string == "secondEntityId") {
            this.secondEntityId = (Long)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public CodeValue _persistence_get_accessType() {
        this._persistence_checkFetched("accessType");
        return this.accessType;
    }

    public void _persistence_set_accessType(CodeValue codeValue) {
        this._persistence_checkFetchedForSet("accessType");
        this._persistence_propertyChange("accessType", (Object)this.accessType, (Object)codeValue);
        this.accessType = codeValue;
    }

    public String _persistence_get_secondEntityType() {
        this._persistence_checkFetched("secondEntityType");
        return this.secondEntityType;
    }

    public void _persistence_set_secondEntityType(String string) {
        this._persistence_checkFetchedForSet("secondEntityType");
        this._persistence_propertyChange("secondEntityType", (Object)this.secondEntityType, (Object)string);
        this.secondEntityType = string;
    }

    public String _persistence_get_entityType() {
        this._persistence_checkFetched("entityType");
        return this.entityType;
    }

    public void _persistence_set_entityType(String string) {
        this._persistence_checkFetchedForSet("entityType");
        this._persistence_propertyChange("entityType", (Object)this.entityType, (Object)string);
        this.entityType = string;
    }

    public Long _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(Long l) {
        this._persistence_checkFetchedForSet("entityId");
        this._persistence_propertyChange("entityId", (Object)this.entityId, (Object)l);
        this.entityId = l;
    }

    public Long _persistence_get_secondEntityId() {
        this._persistence_checkFetched("secondEntityId");
        return this.secondEntityId;
    }

    public void _persistence_set_secondEntityId(Long l) {
        this._persistence_checkFetchedForSet("secondEntityId");
        this._persistence_propertyChange("secondEntityId", (Object)this.secondEntityId, (Object)l);
        this.secondEntityId = l;
    }
}

