/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan;

import lombok.Generated;
import org.apache.avro.generic.GenericContainer;
import org.apache.fineract.avro.generator.ByteBufferSerializable;
import org.apache.fineract.avro.loan.v1.LoanProductDataV1;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.product.LoanProductBusinessEvent;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan.LoanProductDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.BusinessEventSerializer;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.springframework.stereotype.Component;

@Component
public class LoanProductBusinessEventSerializer
implements BusinessEventSerializer {
    private final LoanProductReadPlatformService service;
    private final LoanProductDataMapper mapper;

    public <T> boolean canSerialize(BusinessEvent<T> event) {
        return event instanceof LoanProductBusinessEvent;
    }

    public <T> ByteBufferSerializable toAvroDTO(BusinessEvent<T> rawEvent) {
        LoanProductBusinessEvent event = (LoanProductBusinessEvent)rawEvent;
        LoanProductData data = this.service.retrieveLoanProduct((Long)((LoanProduct)event.get()).getId());
        return this.mapper.map(data);
    }

    public Class<? extends GenericContainer> getSupportedSchema() {
        return LoanProductDataV1.class;
    }

    @Generated
    public LoanProductBusinessEventSerializer(LoanProductReadPlatformService service, LoanProductDataMapper mapper) {
        this.service = service;
        this.mapper = mapper;
    }
}

