/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.gcm.domain;

import org.apache.fineract.infrastructure.gcm.domain.DeviceRegistration;
import org.apache.fineract.infrastructure.gcm.domain.DeviceRegistrationRepository;
import org.apache.fineract.infrastructure.gcm.exception.DeviceRegistrationNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceRegistrationRepositoryWrapper {
    private final DeviceRegistrationRepository repository;

    @Autowired
    public DeviceRegistrationRepositoryWrapper(DeviceRegistrationRepository repository) {
        this.repository = repository;
    }

    public DeviceRegistration findOneWithNotFoundDetection(Long deviceRegistrationId) {
        return (DeviceRegistration)this.repository.findById((Object)deviceRegistrationId).orElseThrow(() -> new DeviceRegistrationNotFoundException(deviceRegistrationId));
    }

    public void save(DeviceRegistration deviceRegistration) {
        this.repository.save((Object)deviceRegistration);
    }

    public void delete(DeviceRegistration deviceRegistration) {
        this.repository.delete((Object)deviceRegistration);
    }

    public void saveAndFlush(DeviceRegistration deviceRegistration) {
        this.repository.saveAndFlush((Object)deviceRegistration);
    }

    public DeviceRegistration findDeviceRegistrationByClientId(Long clientId) {
        return this.repository.findDeviceRegistrationByClientId(clientId);
    }
}

