/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.hooks.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.hooks.domain.Schema;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_hook_templates")
public final class HookTemplate
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @Column(name="name", nullable=false, length=100)
    private String name;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="template", orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<Schema> fields = new HashSet();
    static final long serialVersionUID = 6281159888204276476L;

    private HookTemplate(String name) {
        this.name = StringUtils.isNotBlank((CharSequence)name) ? name.trim() : null;
    }

    public static HookTemplate fromJson(JsonCommand command) {
        String name = command.stringValueOfParameterNamed("name");
        return new HookTemplate(name);
    }

    @Generated
    public String getName() {
        return this._persistence_get_name();
    }

    @Generated
    public Set<Schema> getFields() {
        return this._persistence_get_fields();
    }

    @Generated
    public HookTemplate setName(String name) {
        this._persistence_set_name(name);
        return this;
    }

    @Generated
    public HookTemplate setFields(Set<Schema> fields) {
        this._persistence_set_fields(fields);
        return this;
    }

    @Generated
    public HookTemplate() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new HookTemplate();
    }

    public Object _persistence_get(String string) {
        if (string == "name") {
            return this.name;
        }
        if (string == "fields") {
            return this.fields;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "fields") {
            this.fields = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public Set _persistence_get_fields() {
        this._persistence_checkFetched("fields");
        return this.fields;
    }

    public void _persistence_set_fields(Set set) {
        this._persistence_checkFetchedForSet("fields");
        this.fields = set;
    }
}

