/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.increasedateby1day;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.fineract.infrastructure.businessdate.data.BusinessDateData;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDate;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateRepository;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.businessdate.service.BusinessDateWritePlatformService;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.exception.AbstractPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.jobs.service.increasedateby1day.IncreaseDateBy1DayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IncreaseDateBy1DayServiceImpl
implements IncreaseDateBy1DayService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IncreaseDateBy1DayServiceImpl.class);
    private final BusinessDateRepository businessDateRepository;
    private final BusinessDateWritePlatformService businessDateWritePlatformService;

    public void increaseDateByTypeByOneDay(BusinessDateType businessDateType) {
        HashMap changes = new HashMap();
        Optional businessDateEntity = this.businessDateRepository.findByType(businessDateType);
        LocalDate businessDate = businessDateEntity.map(BusinessDate::getDate).orElse(DateUtils.getLocalDateOfTenant());
        businessDate = businessDate.plusDays(1L);
        try {
            BusinessDateData businessDateData = BusinessDateData.instance((BusinessDateType)businessDateType, (LocalDate)businessDate);
            this.businessDateWritePlatformService.adjustDate(businessDateData, changes);
        }
        catch (PlatformApiDataValidationException e) {
            List errors = e.getErrors();
            for (ApiParameterError error : errors) {
                log.error("Increasing {} by 1 day failed due to: {}", (Object)businessDateType.getDescription(), (Object)error.getDeveloperMessage());
            }
        }
        catch (AbstractPlatformDomainRuleException e) {
            log.error("Increasing {} by 1 day failed due to: {}", (Object)businessDateType.getDescription(), (Object)e.getDefaultUserMessage());
        }
        catch (Exception e) {
            log.error("Increasing {} by 1 day failed due to: {}", (Object)businessDateType.getDescription(), (Object)e.getMessage());
        }
    }

    @Generated
    public IncreaseDateBy1DayServiceImpl(BusinessDateRepository businessDateRepository, BusinessDateWritePlatformService businessDateWritePlatformService) {
        this.businessDateRepository = businessDateRepository;
        this.businessDateWritePlatformService = businessDateWritePlatformService;
    }
}

