/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.survey.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.dataqueries.data.GenericResultsetData;
import org.apache.fineract.infrastructure.dataqueries.service.GenericDataService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.survey.api.SurveyApiResourceSwagger;
import org.apache.fineract.infrastructure.survey.data.ClientScoresOverview;
import org.apache.fineract.infrastructure.survey.data.SurveyData;
import org.apache.fineract.infrastructure.survey.data.SurveyDataTableData;
import org.apache.fineract.infrastructure.survey.service.ReadSurveyService;
import org.springframework.stereotype.Component;

@Path(value="/v1/survey")
@Component
@Tag(name="Survey", description="")
public class SurveyApiResource {
    private final DefaultToApiJsonSerializer<SurveyData> toApiJsonSerializer;
    private final DefaultToApiJsonSerializer<ClientScoresOverview> toApiJsonClientScoreOverviewSerializer;
    private final PlatformSecurityContext context;
    private final ReadSurveyService readSurveyService;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final GenericDataService genericDataService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve surveys", description="Retrieve surveys. This allows to retrieve the list of survey tables registered .")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SurveyApiResourceSwagger.GetSurveyResponse.class)))})})
    public String retrieveSurveys() {
        this.context.authenticatedUser().validateHasReadPermission("Survey");
        List surveys = this.readSurveyService.retrieveAllSurveys();
        return this.toApiJsonSerializer.serialize((Object)surveys);
    }

    @GET
    @Path(value="{surveyName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve survey", description="Lists a registered survey table details and the Apache Fineract Core application table they are registered to.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SurveyApiResourceSwagger.GetSurveyResponse.class))})})
    public String retrieveSurvey(@PathParam(value="surveyName") @Parameter(description="surveyName") String surveyName) {
        this.context.authenticatedUser().validateHasReadPermission("Survey");
        SurveyDataTableData surveys = this.readSurveyService.retrieveSurvey(surveyName);
        return this.toApiJsonSerializer.serialize((Object)surveys);
    }

    @POST
    @Path(value="{surveyName}/{apptableId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an entry in the survey table", description="Insert and entry in a survey table (full fill the survey).\n\nRefer Link for sample Body:  [ https://fineract.apache.org/legacy-docs/apiLive.htm#survey_create ] ")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SurveyApiResourceSwagger.PostSurveySurveyNameApptableIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SurveyApiResourceSwagger.PostSurveySurveyNameApptableIdResponse.class))})})
    public String createDatatableEntry(@PathParam(value="surveyName") @Parameter(description="surveyName") String datatable, @PathParam(value="apptableId") @Parameter(description="apptableId") Long apptableId, String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().fullFilSurvey(datatable, apptableId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{surveyName}/{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getClientSurveyOverview(@PathParam(value="surveyName") String surveyName, @PathParam(value="clientId") Long clientId) {
        this.context.authenticatedUser().validateHasReadPermission("Survey");
        List scores = this.readSurveyService.retrieveClientSurveyScoreOverview(clientId);
        return this.toApiJsonClientScoreOverviewSerializer.serialize((Object)scores);
    }

    @GET
    @Path(value="{surveyName}/{clientId}/{entryId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getSurveyEntry(@PathParam(value="surveyName") String surveyName, @PathParam(value="clientId") Long clientId, @PathParam(value="entryId") Long entryId) {
        this.context.authenticatedUser().validateHasReadPermission("Survey");
        GenericResultsetData results = this.readSurveyService.retrieveSurveyEntry(surveyName, clientId, entryId);
        return this.genericDataService.generateJsonFromGenericResultsetData(results);
    }

    @PUT
    @Path(value="register/{surveyName}/{apptable}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String register(@PathParam(value="surveyName") String datatable, @PathParam(value="apptable") String apptable, String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().registerSurvey(datatable, apptable).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{surveyName}/{clientId}/{fulfilledId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String deleteDatatableEntries(@PathParam(value="surveyName") String surveyName, @PathParam(value="clientId") Long clientId, @PathParam(value="fulfilledId") Long fulfilledId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteDatatableEntry(surveyName, clientId, fulfilledId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public SurveyApiResource(DefaultToApiJsonSerializer<SurveyData> toApiJsonSerializer, DefaultToApiJsonSerializer<ClientScoresOverview> toApiJsonClientScoreOverviewSerializer, PlatformSecurityContext context, ReadSurveyService readSurveyService, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, GenericDataService genericDataService) {
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.toApiJsonClientScoreOverviewSerializer = toApiJsonClientScoreOverviewSerializer;
        this.context = context;
        this.readSurveyService = readSurveyService;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.genericDataService = genericDataService;
    }
}

