/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.survey.service;

import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.dataqueries.service.ReadWriteNonCoreDataService;
import org.apache.fineract.infrastructure.survey.service.WriteSurveyService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WriteSurveyServiceImpl
implements WriteSurveyService {
    private final ReadWriteNonCoreDataService readWriteNonCoreDataService;
    private final DatabaseSpecificSQLGenerator sqlGenerator;

    @Transactional
    public CommandProcessingResult registerSurvey(JsonCommand command) {
        String dataTableName = this.readWriteNonCoreDataService.getDataTableName(command.getUrl());
        String permissionSql = this.getPermissionSql(dataTableName);
        this.readWriteNonCoreDataService.registerDatatable(command, permissionSql);
        return CommandProcessingResult.commandOnlyResult((Long)command.commandId());
    }

    private String getPermissionSql(String dataTableName) {
        String createPermission = "'CREATE_" + dataTableName + "'";
        String createPermissionChecker = "'CREATE_" + dataTableName + "_CHECKER'";
        String readPermission = "'READ_" + dataTableName + "'";
        String updatePermission = "'UPDATE_" + dataTableName + "'";
        String updatePermissionChecker = "'UPDATE_" + dataTableName + "_CHECKER'";
        String deletePermission = "'DELETE_" + dataTableName + "'";
        String deletePermissionChecker = "'DELETE_" + dataTableName + "_CHECKER'";
        List<String> escapedColumns = Stream.of("grouping", "code", "action_name", "entity_name", "can_maker_checker").map(arg_0 -> ((DatabaseSpecificSQLGenerator)this.sqlGenerator).escape(arg_0)).toList();
        String columns = String.join((CharSequence)", ", escapedColumns);
        return "insert into m_permission (" + columns + ") values ('datatable', " + createPermission + ", 'CREATE', '" + dataTableName + "', false),('datatable', " + createPermissionChecker + ", 'CREATE', '" + dataTableName + "', false),('datatable', " + readPermission + ", 'READ', '" + dataTableName + "', false),('datatable', " + updatePermission + ", 'UPDATE', '" + dataTableName + "', false),('datatable', " + updatePermissionChecker + ", 'UPDATE', '" + dataTableName + "', false),('datatable', " + deletePermission + ", 'DELETE', '" + dataTableName + "', false),('datatable', " + deletePermissionChecker + ", 'DELETE', '" + dataTableName + "', false)";
    }

    @Transactional
    public CommandProcessingResult fullFillSurvey(String dataTableName, Long appTableId, JsonCommand command) {
        return this.readWriteNonCoreDataService.createPPIEntry(dataTableName, appTableId, command);
    }

    @Generated
    public WriteSurveyServiceImpl(ReadWriteNonCoreDataService readWriteNonCoreDataService, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.readWriteNonCoreDataService = readWriteNonCoreDataService;
        this.sqlGenerator = sqlGenerator;
    }
}

