/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.api;

import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.interoperation.domain.InteropIdentifierType;
import org.apache.fineract.interoperation.domain.InteropTransferActionType;

public class InteropWrapperBuilder {
    private String actionName;
    private String entityName;
    private String href;
    private String json = "{}";

    public CommandWrapper build() {
        return new CommandWrapper(null, null, null, null, null, this.actionName, this.entityName, null, null, this.href, this.json, null, null, null, null, null, null, null, null);
    }

    public InteropWrapperBuilder withJson(String json) {
        this.json = json;
        return this;
    }

    public InteropWrapperBuilder registerAccountIdentifier(InteropIdentifierType idType, String idValue, String subIdOrType) {
        this.actionName = "CREATE";
        this.entityName = "INTERID";
        this.href = "/interoperation/parties/" + String.valueOf(idType) + "/" + idValue + "/" + (subIdOrType == null ? " " : subIdOrType);
        return this;
    }

    public InteropWrapperBuilder deleteAccountIdentifier(InteropIdentifierType idType, String idValue, String subIdOrType) {
        this.actionName = "DELETE";
        this.entityName = "INTERID";
        this.href = "/interoperation/parties/" + String.valueOf(idType) + "/" + idValue + "/" + (subIdOrType == null ? " " : subIdOrType);
        return this;
    }

    public InteropWrapperBuilder createTransactionRequest() {
        this.actionName = "CREATE";
        this.entityName = "INTERREQUEST";
        this.href = "/interoperation/requests";
        return this;
    }

    public InteropWrapperBuilder createQuotes() {
        this.actionName = "CREATE";
        this.entityName = "INTERQUOTE";
        this.href = "/interoperation/quotes";
        return this;
    }

    public InteropWrapperBuilder performTransfer(InteropTransferActionType action) {
        this.actionName = action.name();
        this.entityName = "INTERTRANSFER";
        this.href = "/interoperation/transfers";
        return this;
    }
}

