/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;

public class ExtensionData {
    public static final List<String> PARAMS = List.copyOf(Arrays.asList("key", "value"));
    @NotNull
    private final String key;
    private String value;

    public ExtensionData(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static ExtensionData validateAndParse(DataValidatorBuilder dataValidator, JsonObject element, FromJsonHelper jsonHelper) {
        if (element == null) {
            return null;
        }
        jsonHelper.checkForUnsupportedParameters(element, (Collection)PARAMS);
        String key = jsonHelper.extractStringNamed("key", (JsonElement)element);
        DataValidatorBuilder dataValidatorCopy = dataValidator.reset().parameter("key").value((Object)key).notBlank();
        String value = jsonHelper.extractStringNamed("value", (JsonElement)element);
        dataValidator.merge(dataValidatorCopy);
        return dataValidator.hasError() ? null : new ExtensionData(key, value);
    }
}

