/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.provisioning.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_provision_category", uniqueConstraints={@UniqueConstraint(columnNames={"category_name"}, name="category_name")})
public class ProvisioningCategory
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="category_name", nullable=false, unique=true)
    private String categoryName;
    @Column(name="description", nullable=true)
    private String categoryDescription;
    static final long serialVersionUID = -8896757885344557299L;

    protected ProvisioningCategory() {
    }

    private ProvisioningCategory(String categoryName, String categoryDescription) {
        this.categoryName = categoryName;
        this.categoryDescription = categoryDescription;
    }

    public static ProvisioningCategory fromJson(JsonCommand jsonCommand) {
        String categoryName = jsonCommand.stringValueOfParameterNamed("categoryname");
        String description = jsonCommand.stringValueOfParameterNamed("description");
        return new ProvisioningCategory(categoryName, description);
    }

    public Map<String, Object> update(JsonCommand command) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(2);
        String nameParamName = "categoryname";
        if (command.isChangeInStringParameterNamed("categoryname", this._persistence_get_categoryName())) {
            String newValue = command.stringValueOfParameterNamed("categoryname");
            actualChanges.put("categoryname", newValue);
            this._persistence_set_categoryName(newValue);
        }
        String descriptionParamName = "categorydescription";
        if (command.isChangeInStringParameterNamed("categorydescription", this._persistence_get_categoryDescription())) {
            String newValue = command.stringValueOfParameterNamed("categorydescription");
            actualChanges.put("categorydescription", newValue);
            this._persistence_set_categoryDescription(newValue);
        }
        return actualChanges;
    }

    public String getCategoryName() {
        return this._persistence_get_categoryName();
    }

    public String getCategoryDescription() {
        return this._persistence_get_categoryDescription();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProvisioningCategory)) {
            return false;
        }
        ProvisioningCategory pc = (ProvisioningCategory)obj;
        return pc.getCategoryName().equals(this._persistence_get_categoryName());
    }

    public int hashCode() {
        return this._persistence_get_categoryName().hashCode() ^ ((Long)this.getId()).hashCode();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ProvisioningCategory();
    }

    public Object _persistence_get(String string) {
        if (string == "categoryName") {
            return this.categoryName;
        }
        if (string == "categoryDescription") {
            return this.categoryDescription;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "categoryName") {
            this.categoryName = (String)object;
            return;
        }
        if (string == "categoryDescription") {
            this.categoryDescription = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_categoryName() {
        this._persistence_checkFetched("categoryName");
        return this.categoryName;
    }

    public void _persistence_set_categoryName(String string) {
        this._persistence_checkFetchedForSet("categoryName");
        this._persistence_propertyChange("categoryName", (Object)this.categoryName, (Object)string);
        this.categoryName = string;
    }

    public String _persistence_get_categoryDescription() {
        this._persistence_checkFetched("categoryDescription");
        return this.categoryDescription;
    }

    public void _persistence_set_categoryDescription(String string) {
        this._persistence_checkFetchedForSet("categoryDescription");
        this._persistence_propertyChange("categoryDescription", (Object)this.categoryDescription, (Object)string);
        this.categoryDescription = string;
    }
}

