/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.account.api.AccountTransfersApiConstants;
import org.apache.fineract.portfolio.account.api.AccountTransfersApiResourceSwagger;
import org.apache.fineract.portfolio.account.data.AccountTransferData;
import org.apache.fineract.portfolio.account.service.AccountTransfersReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/accounttransfers")
@Component
@Tag(name="Account Transfers", description="Ability to be able to transfer monetary funds from one account to another.\n\nNote: At present only savings account to savings account transfers are supported.")
public class AccountTransfersApiResource {
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<AccountTransferData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final AccountTransfersReadPlatformService accountTransfersReadPlatformService;
    private final SqlValidator sqlValidator;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Account Transfer Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\n\n\nField Defaults\n\nAllowed Value Lists\n\nExample Requests:\n\n\n\naccounttransfers/template?fromAccountType=2&fromOfficeId=1\n\n\n\naccounttransfers/template?fromAccountType=2&fromOfficeId=1&fromClientId=1\n\n\n\naccounttransfers/template?fromClientId=1&fromAccountType=2&fromAccountId=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountTransfersApiResourceSwagger.GetAccountTransfersTemplateResponse.class))})})
    public String template(@QueryParam(value="fromOfficeId") @Parameter(description="fromOfficeId") Long fromOfficeId, @QueryParam(value="fromClientId") @Parameter(description="fromClientId") Long fromClientId, @QueryParam(value="fromAccountId") @Parameter(description="fromAccountId") Long fromAccountId, @QueryParam(value="fromAccountType") @Parameter(description="fromAccountType") Integer fromAccountType, @QueryParam(value="toOfficeId") @Parameter(description="toOfficeId") Long toOfficeId, @QueryParam(value="toClientId") @Parameter(description="toClientId") Long toClientId, @QueryParam(value="toAccountId") @Parameter(description="toAccountId") Long toAccountId, @QueryParam(value="toAccountType") @Parameter(description="toAccountType") Integer toAccountType, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("accounttransfer");
        AccountTransferData transferData = this.accountTransfersReadPlatformService.retrieveTemplate(fromOfficeId, fromClientId, fromAccountId, fromAccountType, toOfficeId, toClientId, toAccountId, toAccountType);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)transferData, AccountTransfersApiConstants.RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create new Transfer", description="Ability to create new transfer of monetary funds from one account to another.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=AccountTransfersApiResourceSwagger.PostAccountTransfersRequest.class))})
    @ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountTransfersApiResourceSwagger.PostAccountTransfersResponse.class))})
    public String create(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createAccountTransfer().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List account transfers", description="Lists account's transfers\n\nExample Requests:\n\n\n\naccounttransfers")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountTransfersApiResourceSwagger.GetAccountTransfersResponse.class))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="externalId") @Parameter(description="externalId") String externalId, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(example="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder, @QueryParam(value="accountDetailId") @Parameter(description="accountDetailId") Long accountDetailId) {
        this.context.authenticatedUser().validateHasReadPermission("accounttransfer");
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        this.sqlValidator.validate(externalId);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).externalId(externalId).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        Page transfers = this.accountTransfersReadPlatformService.retrieveAll(searchParameters, accountDetailId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, transfers, AccountTransfersApiConstants.RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{transferId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve account transfer", description="Retrieves account transfer\n\nExample Requests :\n\n\n\naccounttransfers/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountTransfersApiResourceSwagger.GetAccountTransfersResponse.GetAccountTransfersPageItems.class))})})
    public String retrieveOne(@PathParam(value="transferId") @Parameter(description="transferId") Long transferId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("accounttransfer");
        AccountTransferData transfer = this.accountTransfersReadPlatformService.retrieveOne(transferId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)transfer, AccountTransfersApiConstants.RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="templateRefundByTransfer")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Refund of an Active Loan by Transfer Template", description="Retrieves Refund of an Active Loan by Transfer TemplateExample Requests :\n\n\n\naccounttransfers/templateRefundByTransfer?fromAccountId=2&fromAccountType=1& toAccountId=1&toAccountType=2&toClientId=1&toOfficeId=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountTransfersApiResourceSwagger.GetAccountTransfersTemplateRefundByTransferResponse.class))})})
    public String templateRefundByTransfer(@QueryParam(value="fromOfficeId") @Parameter(description="fromOfficeId") Long fromOfficeId, @QueryParam(value="fromClientId") @Parameter(description="fromClientId") Long fromClientId, @QueryParam(value="fromAccountId") @Parameter(description="fromAccountId") Long fromAccountId, @QueryParam(value="fromAccountType") @Parameter(description="fromAccountType") Integer fromAccountType, @QueryParam(value="toOfficeId") @Parameter(description="toOfficeId") Long toOfficeId, @QueryParam(value="toClientId") @Parameter(description="toClientId") Long toClientId, @QueryParam(value="toAccountId") @Parameter(description="toAccountId") Long toAccountId, @QueryParam(value="toAccountType") @Parameter(description="toAccountType") Integer toAccountType, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("accounttransfer");
        AccountTransferData transferData = this.accountTransfersReadPlatformService.retrieveRefundByTransferTemplate(fromOfficeId, fromClientId, fromAccountId, fromAccountType, toOfficeId, toClientId, toAccountId, toAccountType);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)transferData, AccountTransfersApiConstants.RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Path(value="refundByTransfer")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Refund of an Active Loan by Transfer", description="Ability to refund an active loan by transferring to a savings account.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=AccountTransfersApiResourceSwagger.PostAccountTransfersRefundByTransferRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountTransfersApiResourceSwagger.PostAccountTransfersRefundByTransferResponse.class))})})
    public String templateRefundByTransferPost(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().refundByTransfer().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public AccountTransfersApiResource(PlatformSecurityContext context, DefaultToApiJsonSerializer<AccountTransferData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, AccountTransfersReadPlatformService accountTransfersReadPlatformService, SqlValidator sqlValidator) {
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.accountTransfersReadPlatformService = accountTransfersReadPlatformService;
        this.sqlValidator = sqlValidator;
    }
}

