/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_portfolio_account_associations")
public class AccountAssociations
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne
    @JoinColumn(name="loan_account_id", nullable=true)
    private Loan loanAccount;
    @ManyToOne
    @JoinColumn(name="savings_account_id", nullable=true)
    private SavingsAccount savingsAccount;
    @ManyToOne
    @JoinColumn(name="linked_loan_account_id", nullable=true)
    private Loan linkedLoanAccount;
    @ManyToOne
    @JoinColumn(name="linked_savings_account_id", nullable=true)
    private SavingsAccount linkedSavingsAccount;
    @Column(name="association_type_enum", nullable=false)
    private Integer associationType;
    @Column(name="is_active", nullable=false)
    private boolean active = true;
    static final long serialVersionUID = 2945537436966947853L;

    protected AccountAssociations() {
    }

    private AccountAssociations(Loan loanAccount, SavingsAccount savingsAccount, Loan linkedLoanAccount, SavingsAccount linkedSavingsAccount, Integer associationType, boolean active) {
        this.loanAccount = loanAccount;
        this.savingsAccount = savingsAccount;
        this.linkedLoanAccount = linkedLoanAccount;
        this.linkedSavingsAccount = linkedSavingsAccount;
        this.associationType = associationType;
        this.active = active;
    }

    public static AccountAssociations associateSavingsAccount(Loan loan, SavingsAccount savingsAccount, Integer associationType, boolean isActive) {
        return new AccountAssociations(loan, null, null, savingsAccount, associationType, isActive);
    }

    public static AccountAssociations associateSavingsAccount(SavingsAccount savingsAccount, SavingsAccount linkedSavingsAccount, Integer associationType, boolean isActive) {
        return new AccountAssociations(null, savingsAccount, null, linkedSavingsAccount, associationType, isActive);
    }

    public SavingsAccount linkedSavingsAccount() {
        return this._persistence_get_linkedSavingsAccount();
    }

    public void updateLinkedSavingsAccount(SavingsAccount savingsAccount) {
        this._persistence_set_linkedSavingsAccount(savingsAccount);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AccountAssociations();
    }

    public Object _persistence_get(String string) {
        if (string == "loanAccount") {
            return this.loanAccount;
        }
        if (string == "linkedLoanAccount") {
            return this.linkedLoanAccount;
        }
        if (string == "savingsAccount") {
            return this.savingsAccount;
        }
        if (string == "associationType") {
            return this.associationType;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "linkedSavingsAccount") {
            return this.linkedSavingsAccount;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "loanAccount") {
            this.loanAccount = (Loan)object;
            return;
        }
        if (string == "linkedLoanAccount") {
            this.linkedLoanAccount = (Loan)object;
            return;
        }
        if (string == "savingsAccount") {
            this.savingsAccount = (SavingsAccount)object;
            return;
        }
        if (string == "associationType") {
            this.associationType = (Integer)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "linkedSavingsAccount") {
            this.linkedSavingsAccount = (SavingsAccount)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Loan _persistence_get_loanAccount() {
        this._persistence_checkFetched("loanAccount");
        return this.loanAccount;
    }

    public void _persistence_set_loanAccount(Loan loan) {
        this._persistence_checkFetchedForSet("loanAccount");
        this._persistence_propertyChange("loanAccount", (Object)this.loanAccount, (Object)loan);
        this.loanAccount = loan;
    }

    public Loan _persistence_get_linkedLoanAccount() {
        this._persistence_checkFetched("linkedLoanAccount");
        return this.linkedLoanAccount;
    }

    public void _persistence_set_linkedLoanAccount(Loan loan) {
        this._persistence_checkFetchedForSet("linkedLoanAccount");
        this._persistence_propertyChange("linkedLoanAccount", (Object)this.linkedLoanAccount, (Object)loan);
        this.linkedLoanAccount = loan;
    }

    public SavingsAccount _persistence_get_savingsAccount() {
        this._persistence_checkFetched("savingsAccount");
        return this.savingsAccount;
    }

    public void _persistence_set_savingsAccount(SavingsAccount savingsAccount) {
        this._persistence_checkFetchedForSet("savingsAccount");
        this._persistence_propertyChange("savingsAccount", (Object)this.savingsAccount, (Object)savingsAccount);
        this.savingsAccount = savingsAccount;
    }

    public Integer _persistence_get_associationType() {
        this._persistence_checkFetched("associationType");
        return this.associationType;
    }

    public void _persistence_set_associationType(Integer n) {
        this._persistence_checkFetchedForSet("associationType");
        this._persistence_propertyChange("associationType", (Object)this.associationType, (Object)n);
        this.associationType = n;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", (Object)new Boolean(this.active), (Object)new Boolean(bl));
        this.active = bl;
    }

    public SavingsAccount _persistence_get_linkedSavingsAccount() {
        this._persistence_checkFetched("linkedSavingsAccount");
        return this.linkedSavingsAccount;
    }

    public void _persistence_set_linkedSavingsAccount(SavingsAccount savingsAccount) {
        this._persistence_checkFetchedForSet("linkedSavingsAccount");
        this._persistence_propertyChange("linkedSavingsAccount", (Object)this.linkedSavingsAccount, (Object)savingsAccount);
        this.linkedSavingsAccount = savingsAccount;
    }
}

