/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.account.domain.AccountTransferStandingInstruction;
import org.apache.fineract.portfolio.account.domain.AccountTransferTransaction;
import org.apache.fineract.portfolio.account.domain.AccountTransferType;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_account_transfer_details")
public class AccountTransferDetails
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @ManyToOne
    @JoinColumn(name="from_office_id", nullable=false)
    private Office fromOffice;
    @ManyToOne
    @JoinColumn(name="from_client_id", nullable=false)
    private Client fromClient;
    @ManyToOne
    @JoinColumn(name="from_savings_account_id", nullable=true)
    private SavingsAccount fromSavingsAccount;
    @ManyToOne
    @JoinColumn(name="to_office_id", nullable=false)
    private Office toOffice;
    @ManyToOne
    @JoinColumn(name="to_client_id", nullable=false)
    private Client toClient;
    @ManyToOne
    @JoinColumn(name="to_savings_account_id", nullable=true)
    private SavingsAccount toSavingsAccount;
    @ManyToOne
    @JoinColumn(name="to_loan_account_id", nullable=true)
    private Loan toLoanAccount;
    @ManyToOne
    @JoinColumn(name="from_loan_account_id", nullable=true)
    private Loan fromLoanAccount;
    @Column(name="transfer_type")
    private Integer transferType;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="accountTransferDetails", orphanRemoval=true, fetch=FetchType.EAGER)
    private List<AccountTransferTransaction> accountTransferTransactions = new ArrayList();
    @OneToOne(mappedBy="accountTransferDetails", cascade={CascadeType.ALL}, optional=true, orphanRemoval=true, fetch=FetchType.EAGER)
    private AccountTransferStandingInstruction accountTransferStandingInstruction;
    static final long serialVersionUID = 7880092687264526346L;

    public static AccountTransferDetails savingsToSavingsTransfer(Office fromOffice, Client fromClient, SavingsAccount fromSavingsAccount, Office toOffice, Client toClient, SavingsAccount toSavingsAccount, Integer transferType) {
        return new AccountTransferDetails(fromOffice, fromClient, fromSavingsAccount, null, toOffice, toClient, toSavingsAccount, null, transferType, null);
    }

    public static AccountTransferDetails savingsToLoanTransfer(Office fromOffice, Client fromClient, SavingsAccount fromSavingsAccount, Office toOffice, Client toClient, Loan toLoanAccount, Integer transferType) {
        return new AccountTransferDetails(fromOffice, fromClient, fromSavingsAccount, null, toOffice, toClient, null, toLoanAccount, transferType, null);
    }

    public static AccountTransferDetails loanTosavingsTransfer(Office fromOffice, Client fromClient, Loan fromLoanAccount, Office toOffice, Client toClient, SavingsAccount toSavingsAccount, Integer transferType) {
        return new AccountTransferDetails(fromOffice, fromClient, null, fromLoanAccount, toOffice, toClient, toSavingsAccount, null, transferType, null);
    }

    protected AccountTransferDetails() {
    }

    private AccountTransferDetails(Office fromOffice, Client fromClient, SavingsAccount fromSavingsAccount, Loan fromLoanAccount, Office toOffice, Client toClient, SavingsAccount toSavingsAccount, Loan toLoanAccount, Integer transferType, AccountTransferStandingInstruction accountTransferStandingInstruction) {
        this.fromOffice = fromOffice;
        this.fromClient = fromClient;
        this.fromSavingsAccount = fromSavingsAccount;
        this.fromLoanAccount = fromLoanAccount;
        this.toOffice = toOffice;
        this.toClient = toClient;
        this.toSavingsAccount = toSavingsAccount;
        this.toLoanAccount = toLoanAccount;
        this.transferType = transferType;
        this.accountTransferStandingInstruction = accountTransferStandingInstruction;
    }

    public SavingsAccount toSavingsAccount() {
        return this._persistence_get_toSavingsAccount();
    }

    public SavingsAccount fromSavingsAccount() {
        return this._persistence_get_fromSavingsAccount();
    }

    public void addAccountTransferTransaction(AccountTransferTransaction accountTransferTransaction) {
        this._persistence_get_accountTransferTransactions().add(accountTransferTransaction);
    }

    public void updateAccountTransferStandingInstruction(AccountTransferStandingInstruction accountTransferStandingInstruction) {
        this._persistence_set_accountTransferStandingInstruction(accountTransferStandingInstruction);
    }

    public Loan toLoanAccount() {
        return this._persistence_get_toLoanAccount();
    }

    public Loan fromLoanAccount() {
        return this._persistence_get_fromLoanAccount();
    }

    public AccountTransferStandingInstruction accountTransferStandingInstruction() {
        return this._persistence_get_accountTransferStandingInstruction();
    }

    public AccountTransferType transferType() {
        return AccountTransferType.fromInt((Integer)this._persistence_get_transferType());
    }

    public static AccountTransferDetails loanToLoanTransfer(Office fromOffice, Client fromClient, Loan fromLoanAccount, Office toOffice, Client toClient, Loan toLoanAccount, Integer transferType) {
        return new AccountTransferDetails(fromOffice, fromClient, null, fromLoanAccount, toOffice, toClient, null, toLoanAccount, transferType, null);
    }

    public List<AccountTransferTransaction> getAccountTransferTransactions() {
        return this._persistence_get_accountTransferTransactions();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AccountTransferDetails();
    }

    public Object _persistence_get(String string) {
        if (string == "accountTransferTransactions") {
            return this.accountTransferTransactions;
        }
        if (string == "fromOffice") {
            return this.fromOffice;
        }
        if (string == "toClient") {
            return this.toClient;
        }
        if (string == "fromSavingsAccount") {
            return this.fromSavingsAccount;
        }
        if (string == "fromLoanAccount") {
            return this.fromLoanAccount;
        }
        if (string == "transferType") {
            return this.transferType;
        }
        if (string == "accountTransferStandingInstruction") {
            return this.accountTransferStandingInstruction;
        }
        if (string == "fromClient") {
            return this.fromClient;
        }
        if (string == "toSavingsAccount") {
            return this.toSavingsAccount;
        }
        if (string == "toLoanAccount") {
            return this.toLoanAccount;
        }
        if (string == "toOffice") {
            return this.toOffice;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "accountTransferTransactions") {
            this.accountTransferTransactions = (List)object;
            return;
        }
        if (string == "fromOffice") {
            this.fromOffice = (Office)object;
            return;
        }
        if (string == "toClient") {
            this.toClient = (Client)object;
            return;
        }
        if (string == "fromSavingsAccount") {
            this.fromSavingsAccount = (SavingsAccount)object;
            return;
        }
        if (string == "fromLoanAccount") {
            this.fromLoanAccount = (Loan)object;
            return;
        }
        if (string == "transferType") {
            this.transferType = (Integer)object;
            return;
        }
        if (string == "accountTransferStandingInstruction") {
            this.accountTransferStandingInstruction = (AccountTransferStandingInstruction)object;
            return;
        }
        if (string == "fromClient") {
            this.fromClient = (Client)object;
            return;
        }
        if (string == "toSavingsAccount") {
            this.toSavingsAccount = (SavingsAccount)object;
            return;
        }
        if (string == "toLoanAccount") {
            this.toLoanAccount = (Loan)object;
            return;
        }
        if (string == "toOffice") {
            this.toOffice = (Office)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_accountTransferTransactions() {
        this._persistence_checkFetched("accountTransferTransactions");
        return this.accountTransferTransactions;
    }

    public void _persistence_set_accountTransferTransactions(List list) {
        this._persistence_checkFetchedForSet("accountTransferTransactions");
        this.accountTransferTransactions = list;
    }

    public Office _persistence_get_fromOffice() {
        this._persistence_checkFetched("fromOffice");
        return this.fromOffice;
    }

    public void _persistence_set_fromOffice(Office office) {
        this._persistence_checkFetchedForSet("fromOffice");
        this.fromOffice = office;
    }

    public Client _persistence_get_toClient() {
        this._persistence_checkFetched("toClient");
        return this.toClient;
    }

    public void _persistence_set_toClient(Client client) {
        this._persistence_checkFetchedForSet("toClient");
        this.toClient = client;
    }

    public SavingsAccount _persistence_get_fromSavingsAccount() {
        this._persistence_checkFetched("fromSavingsAccount");
        return this.fromSavingsAccount;
    }

    public void _persistence_set_fromSavingsAccount(SavingsAccount savingsAccount) {
        this._persistence_checkFetchedForSet("fromSavingsAccount");
        this.fromSavingsAccount = savingsAccount;
    }

    public Loan _persistence_get_fromLoanAccount() {
        this._persistence_checkFetched("fromLoanAccount");
        return this.fromLoanAccount;
    }

    public void _persistence_set_fromLoanAccount(Loan loan) {
        this._persistence_checkFetchedForSet("fromLoanAccount");
        this.fromLoanAccount = loan;
    }

    public Integer _persistence_get_transferType() {
        this._persistence_checkFetched("transferType");
        return this.transferType;
    }

    public void _persistence_set_transferType(Integer n) {
        this._persistence_checkFetchedForSet("transferType");
        this.transferType = n;
    }

    public AccountTransferStandingInstruction _persistence_get_accountTransferStandingInstruction() {
        this._persistence_checkFetched("accountTransferStandingInstruction");
        return this.accountTransferStandingInstruction;
    }

    public void _persistence_set_accountTransferStandingInstruction(AccountTransferStandingInstruction accountTransferStandingInstruction) {
        this._persistence_checkFetchedForSet("accountTransferStandingInstruction");
        this.accountTransferStandingInstruction = accountTransferStandingInstruction;
    }

    public Client _persistence_get_fromClient() {
        this._persistence_checkFetched("fromClient");
        return this.fromClient;
    }

    public void _persistence_set_fromClient(Client client) {
        this._persistence_checkFetchedForSet("fromClient");
        this.fromClient = client;
    }

    public SavingsAccount _persistence_get_toSavingsAccount() {
        this._persistence_checkFetched("toSavingsAccount");
        return this.toSavingsAccount;
    }

    public void _persistence_set_toSavingsAccount(SavingsAccount savingsAccount) {
        this._persistence_checkFetchedForSet("toSavingsAccount");
        this.toSavingsAccount = savingsAccount;
    }

    public Loan _persistence_get_toLoanAccount() {
        this._persistence_checkFetched("toLoanAccount");
        return this.toLoanAccount;
    }

    public void _persistence_set_toLoanAccount(Loan loan) {
        this._persistence_checkFetchedForSet("toLoanAccount");
        this.toLoanAccount = loan;
    }

    public Office _persistence_get_toOffice() {
        this._persistence_checkFetched("toOffice");
        return this.toOffice;
    }

    public void _persistence_set_toOffice(Office office) {
        this._persistence_checkFetchedForSet("toOffice");
        this.toOffice = office;
    }
}

