/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.MonthDay;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetails;
import org.apache.fineract.portfolio.account.domain.AccountTransferRecurrenceType;
import org.apache.fineract.portfolio.account.domain.StandingInstructionStatus;
import org.apache.fineract.portfolio.account.domain.StandingInstructionType;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_account_transfer_standing_instructions", uniqueConstraints={@UniqueConstraint(columnNames={"name"}, name="name")})
public class AccountTransferStandingInstruction
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne
    @JoinColumn(name="account_transfer_details_id", nullable=true)
    private AccountTransferDetails accountTransferDetails;
    @Column(name="name")
    private String name;
    @Column(name="priority")
    private Integer priority;
    @Column(name="instruction_type")
    private Integer instructionType;
    @Column(name="status")
    private Integer status;
    @Column(name="amount", scale=6, precision=19, nullable=true)
    private BigDecimal amount;
    @Column(name="valid_from")
    private LocalDate validFrom;
    @Column(name="valid_till")
    private LocalDate validTill;
    @Column(name="recurrence_type")
    private Integer recurrenceType;
    @Column(name="recurrence_frequency")
    private Integer recurrenceFrequency;
    @Column(name="recurrence_interval")
    private Integer recurrenceInterval;
    @Column(name="recurrence_on_day")
    private Integer recurrenceOnDay;
    @Column(name="recurrence_on_month")
    private Integer recurrenceOnMonth;
    @Column(name="last_run_date")
    private LocalDate latsRunDate;
    static final long serialVersionUID = -4515076577701772808L;

    protected AccountTransferStandingInstruction() {
    }

    public static AccountTransferStandingInstruction create(AccountTransferDetails accountTransferDetails, String name, Integer priority, Integer instructionType, Integer status, BigDecimal amount, LocalDate validFrom, LocalDate validTill, Integer recurrenceType, Integer recurrenceFrequency, Integer recurrenceInterval, MonthDay recurrenceOnMonthDay) {
        Integer recurrenceOnDay = null;
        Integer recurrenceOnMonth = null;
        if (recurrenceOnMonthDay != null) {
            recurrenceOnDay = recurrenceOnMonthDay.getDayOfMonth();
            recurrenceOnMonth = recurrenceOnMonthDay.getMonthValue();
        }
        return new AccountTransferStandingInstruction(accountTransferDetails, name, priority, instructionType, status, amount, validFrom, validTill, recurrenceType, recurrenceFrequency, recurrenceInterval, recurrenceOnDay, recurrenceOnMonth);
    }

    private AccountTransferStandingInstruction(AccountTransferDetails accountTransferDetails, String name, Integer priority, Integer instructionType, Integer status, BigDecimal amount, LocalDate validFrom, LocalDate validTill, Integer recurrenceType, Integer recurrenceFrequency, Integer recurrenceInterval, Integer recurrenceOnDay, Integer recurrenceOnMonth) {
        this.accountTransferDetails = accountTransferDetails;
        this.name = name;
        this.priority = priority;
        this.instructionType = instructionType;
        this.status = status;
        this.amount = amount;
        this.validFrom = validFrom;
        this.validTill = validTill;
        this.recurrenceType = recurrenceType;
        this.recurrenceFrequency = recurrenceFrequency;
        this.recurrenceInterval = recurrenceInterval;
        this.recurrenceOnDay = recurrenceOnDay;
        this.recurrenceOnMonth = recurrenceOnMonth;
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("standinginstruction");
        this.validateDependencies(baseDataValidator);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public Map<String, Object> update(JsonCommand command) {
        Number newValue;
        HashMap<String, Object> actualChanges = new HashMap<String, Object>();
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("standinginstruction");
        if (StandingInstructionStatus.fromInt((Integer)this._persistence_get_status()).isDeleted()) {
            baseDataValidator.reset().parameter("status").failWithCode("can.not.modify.once.deleted", new Object[0]);
        }
        if (command.isChangeInDateParameterNamed("validFrom", this._persistence_get_validFrom())) {
            this._persistence_set_validFrom(command.localDateValueOfParameterNamed("validFrom"));
            actualChanges.put("validFrom", this._persistence_get_validFrom());
        }
        if (command.isChangeInDateParameterNamed("validTill", this._persistence_get_validTill())) {
            this._persistence_set_validTill(command.localDateValueOfParameterNamed("validTill"));
            actualChanges.put("validTill", this._persistence_get_validTill());
        }
        if (command.isChangeInBigDecimalParameterNamed("amount", this._persistence_get_amount())) {
            newValue = command.bigDecimalValueOfParameterNamed("amount");
            actualChanges.put("amount", newValue);
            this._persistence_set_amount(newValue);
        }
        if (command.isChangeInIntegerParameterNamed("status", this._persistence_get_status())) {
            newValue = command.integerValueOfParameterNamed("status");
            actualChanges.put("status", newValue);
            this._persistence_set_status((Integer)newValue);
        }
        if (command.isChangeInIntegerParameterNamed("priority", this._persistence_get_priority())) {
            newValue = command.integerValueOfParameterNamed("priority");
            actualChanges.put("priority", newValue);
            this._persistence_set_priority((Integer)newValue);
        }
        if (command.isChangeInIntegerParameterNamed("instructionType", this._persistence_get_instructionType())) {
            newValue = command.integerValueOfParameterNamed("instructionType");
            actualChanges.put("instructionType", newValue);
            this._persistence_set_instructionType((Integer)newValue);
        }
        if (command.isChangeInIntegerParameterNamed("recurrenceType", this._persistence_get_recurrenceType())) {
            newValue = command.integerValueOfParameterNamed("recurrenceType");
            actualChanges.put("recurrenceType", newValue);
            this._persistence_set_recurrenceType((Integer)newValue);
        }
        if (command.isChangeInIntegerParameterNamed("recurrenceFrequency", this._persistence_get_recurrenceFrequency())) {
            newValue = command.integerValueOfParameterNamed("recurrenceFrequency");
            actualChanges.put("recurrenceFrequency", newValue);
            this._persistence_set_recurrenceFrequency((Integer)newValue);
        }
        if (command.hasParameter("recurrenceOnMonthDay")) {
            MonthDay monthDay = command.extractMonthDayNamed("recurrenceOnMonthDay");
            String actualValueEntered = command.stringValueOfParameterNamed("recurrenceOnMonthDay");
            Integer dayOfMonthValue = monthDay.getDayOfMonth();
            if (!this._persistence_get_recurrenceOnDay().equals(dayOfMonthValue)) {
                actualChanges.put("recurrenceOnMonthDay", actualValueEntered);
                this._persistence_set_recurrenceOnDay(dayOfMonthValue);
            }
            Integer monthOfYear = monthDay.getMonthValue();
            if (!this._persistence_get_recurrenceOnMonth().equals(monthOfYear)) {
                actualChanges.put("recurrenceOnMonthDay", actualValueEntered);
                this._persistence_set_recurrenceOnMonth(monthOfYear);
            }
        }
        if (command.isChangeInIntegerParameterNamed("recurrenceInterval", this._persistence_get_recurrenceInterval())) {
            newValue = command.integerValueOfParameterNamed("recurrenceInterval");
            actualChanges.put("recurrenceInterval", newValue);
            this._persistence_set_recurrenceInterval((Integer)newValue);
        }
        this.validateDependencies(baseDataValidator);
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        return actualChanges;
    }

    private void validateDependencies(DataValidatorBuilder baseDataValidator) {
        if (this._persistence_get_validTill() != null && this._persistence_get_validFrom() != null) {
            baseDataValidator.reset().parameter("validTill").value((Object)this._persistence_get_validTill()).validateDateAfter(this._persistence_get_validFrom());
        }
        if (AccountTransferRecurrenceType.fromInt((Integer)this._persistence_get_recurrenceType()).isPeriodicRecurrence()) {
            baseDataValidator.reset().parameter("recurrenceFrequency").value((Object)this._persistence_get_recurrenceFrequency()).notNull();
            baseDataValidator.reset().parameter("recurrenceInterval").value((Object)this._persistence_get_recurrenceInterval()).notNull();
            if (this._persistence_get_recurrenceFrequency() != null) {
                PeriodFrequencyType frequencyType = PeriodFrequencyType.fromInt((Integer)this._persistence_get_recurrenceFrequency());
                if (frequencyType.isMonthly()) {
                    baseDataValidator.reset().parameter("recurrenceOnMonthDay").value((Object)this._persistence_get_recurrenceOnDay()).notNull();
                } else if (frequencyType.isYearly()) {
                    baseDataValidator.reset().parameter("recurrenceOnMonthDay").value((Object)this._persistence_get_recurrenceOnDay()).notNull();
                    baseDataValidator.reset().parameter("recurrenceOnMonthDay").value((Object)this._persistence_get_recurrenceOnMonth()).notNull();
                }
            }
        }
        if (this._persistence_get_accountTransferDetails().toSavingsAccount() != null) {
            baseDataValidator.reset().parameter("instructionType").value((Object)this._persistence_get_instructionType()).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(1));
            baseDataValidator.reset().parameter("recurrenceType").value((Object)this._persistence_get_recurrenceType()).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(1));
        }
        if (StandingInstructionType.fromInt((Integer)this._persistence_get_instructionType()).isFixedAmoutTransfer()) {
            baseDataValidator.reset().parameter("amount").value((Object)this._persistence_get_amount()).notNull();
        }
        String errorCode = null;
        if (this._persistence_get_accountTransferDetails().transferType().isAccountTransfer() && (this._persistence_get_accountTransferDetails().fromSavingsAccount() == null || this._persistence_get_accountTransferDetails().toSavingsAccount() == null)) {
            errorCode = "not.account.transfer";
        } else if (this._persistence_get_accountTransferDetails().transferType().isLoanRepayment() && (this._persistence_get_accountTransferDetails().fromSavingsAccount() == null || this._persistence_get_accountTransferDetails().toLoanAccount() == null)) {
            errorCode = "not.loan.repayment";
        }
        if (errorCode != null) {
            baseDataValidator.reset().parameter("transferType").failWithCode(errorCode, new Object[0]);
        }
    }

    public void updateLatsRunDate(LocalDate latsRunDate) {
        this._persistence_set_latsRunDate(latsRunDate);
    }

    public void updateStatus(Integer status) {
        this._persistence_set_status(status);
    }

    public void delete() {
        this._persistence_set_status(StandingInstructionStatus.DELETED.getValue());
        this._persistence_set_name(this._persistence_get_name() + "_deleted_" + String.valueOf(this.getId()));
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AccountTransferStandingInstruction();
    }

    public Object _persistence_get(String string) {
        if (string == "recurrenceOnDay") {
            return this.recurrenceOnDay;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "validTill") {
            return this.validTill;
        }
        if (string == "latsRunDate") {
            return this.latsRunDate;
        }
        if (string == "validFrom") {
            return this.validFrom;
        }
        if (string == "priority") {
            return this.priority;
        }
        if (string == "recurrenceType") {
            return this.recurrenceType;
        }
        if (string == "recurrenceInterval") {
            return this.recurrenceInterval;
        }
        if (string == "instructionType") {
            return this.instructionType;
        }
        if (string == "recurrenceFrequency") {
            return this.recurrenceFrequency;
        }
        if (string == "accountTransferDetails") {
            return this.accountTransferDetails;
        }
        if (string == "recurrenceOnMonth") {
            return this.recurrenceOnMonth;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "recurrenceOnDay") {
            this.recurrenceOnDay = (Integer)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "validTill") {
            this.validTill = (LocalDate)object;
            return;
        }
        if (string == "latsRunDate") {
            this.latsRunDate = (LocalDate)object;
            return;
        }
        if (string == "validFrom") {
            this.validFrom = (LocalDate)object;
            return;
        }
        if (string == "priority") {
            this.priority = (Integer)object;
            return;
        }
        if (string == "recurrenceType") {
            this.recurrenceType = (Integer)object;
            return;
        }
        if (string == "recurrenceInterval") {
            this.recurrenceInterval = (Integer)object;
            return;
        }
        if (string == "instructionType") {
            this.instructionType = (Integer)object;
            return;
        }
        if (string == "recurrenceFrequency") {
            this.recurrenceFrequency = (Integer)object;
            return;
        }
        if (string == "accountTransferDetails") {
            this.accountTransferDetails = (AccountTransferDetails)object;
            return;
        }
        if (string == "recurrenceOnMonth") {
            this.recurrenceOnMonth = (Integer)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "status") {
            this.status = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Integer _persistence_get_recurrenceOnDay() {
        this._persistence_checkFetched("recurrenceOnDay");
        return this.recurrenceOnDay;
    }

    public void _persistence_set_recurrenceOnDay(Integer n) {
        this._persistence_checkFetchedForSet("recurrenceOnDay");
        this._persistence_propertyChange("recurrenceOnDay", (Object)this.recurrenceOnDay, (Object)n);
        this.recurrenceOnDay = n;
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", (Object)this.amount, (Object)bigDecimal);
        this.amount = bigDecimal;
    }

    public LocalDate _persistence_get_validTill() {
        this._persistence_checkFetched("validTill");
        return this.validTill;
    }

    public void _persistence_set_validTill(LocalDate localDate) {
        this._persistence_checkFetchedForSet("validTill");
        this._persistence_propertyChange("validTill", (Object)this.validTill, (Object)localDate);
        this.validTill = localDate;
    }

    public LocalDate _persistence_get_latsRunDate() {
        this._persistence_checkFetched("latsRunDate");
        return this.latsRunDate;
    }

    public void _persistence_set_latsRunDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("latsRunDate");
        this._persistence_propertyChange("latsRunDate", (Object)this.latsRunDate, (Object)localDate);
        this.latsRunDate = localDate;
    }

    public LocalDate _persistence_get_validFrom() {
        this._persistence_checkFetched("validFrom");
        return this.validFrom;
    }

    public void _persistence_set_validFrom(LocalDate localDate) {
        this._persistence_checkFetchedForSet("validFrom");
        this._persistence_propertyChange("validFrom", (Object)this.validFrom, (Object)localDate);
        this.validFrom = localDate;
    }

    public Integer _persistence_get_priority() {
        this._persistence_checkFetched("priority");
        return this.priority;
    }

    public void _persistence_set_priority(Integer n) {
        this._persistence_checkFetchedForSet("priority");
        this._persistence_propertyChange("priority", (Object)this.priority, (Object)n);
        this.priority = n;
    }

    public Integer _persistence_get_recurrenceType() {
        this._persistence_checkFetched("recurrenceType");
        return this.recurrenceType;
    }

    public void _persistence_set_recurrenceType(Integer n) {
        this._persistence_checkFetchedForSet("recurrenceType");
        this._persistence_propertyChange("recurrenceType", (Object)this.recurrenceType, (Object)n);
        this.recurrenceType = n;
    }

    public Integer _persistence_get_recurrenceInterval() {
        this._persistence_checkFetched("recurrenceInterval");
        return this.recurrenceInterval;
    }

    public void _persistence_set_recurrenceInterval(Integer n) {
        this._persistence_checkFetchedForSet("recurrenceInterval");
        this._persistence_propertyChange("recurrenceInterval", (Object)this.recurrenceInterval, (Object)n);
        this.recurrenceInterval = n;
    }

    public Integer _persistence_get_instructionType() {
        this._persistence_checkFetched("instructionType");
        return this.instructionType;
    }

    public void _persistence_set_instructionType(Integer n) {
        this._persistence_checkFetchedForSet("instructionType");
        this._persistence_propertyChange("instructionType", (Object)this.instructionType, (Object)n);
        this.instructionType = n;
    }

    public Integer _persistence_get_recurrenceFrequency() {
        this._persistence_checkFetched("recurrenceFrequency");
        return this.recurrenceFrequency;
    }

    public void _persistence_set_recurrenceFrequency(Integer n) {
        this._persistence_checkFetchedForSet("recurrenceFrequency");
        this._persistence_propertyChange("recurrenceFrequency", (Object)this.recurrenceFrequency, (Object)n);
        this.recurrenceFrequency = n;
    }

    public AccountTransferDetails _persistence_get_accountTransferDetails() {
        this._persistence_checkFetched("accountTransferDetails");
        return this.accountTransferDetails;
    }

    public void _persistence_set_accountTransferDetails(AccountTransferDetails accountTransferDetails) {
        this._persistence_checkFetchedForSet("accountTransferDetails");
        this._persistence_propertyChange("accountTransferDetails", (Object)this.accountTransferDetails, (Object)accountTransferDetails);
        this.accountTransferDetails = accountTransferDetails;
    }

    public Integer _persistence_get_recurrenceOnMonth() {
        this._persistence_checkFetched("recurrenceOnMonth");
        return this.recurrenceOnMonth;
    }

    public void _persistence_set_recurrenceOnMonth(Integer n) {
        this._persistence_checkFetchedForSet("recurrenceOnMonth");
        this._persistence_propertyChange("recurrenceOnMonth", (Object)this.recurrenceOnMonth, (Object)n);
        this.recurrenceOnMonth = n;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", (Object)this.name, (Object)string);
        this.name = string;
    }

    public Integer _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(Integer n) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", (Object)this.status, (Object)n);
        this.status = n;
    }
}

