/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.PortfolioAccountDTO;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.account.data.StandingInstructionDTO;
import org.apache.fineract.portfolio.account.data.StandingInstructionData;
import org.apache.fineract.portfolio.account.data.StandingInstructionDuesData;
import org.apache.fineract.portfolio.account.domain.AccountTransferRecurrenceType;
import org.apache.fineract.portfolio.account.domain.AccountTransferType;
import org.apache.fineract.portfolio.account.domain.StandingInstructionPriority;
import org.apache.fineract.portfolio.account.domain.StandingInstructionStatus;
import org.apache.fineract.portfolio.account.domain.StandingInstructionType;
import org.apache.fineract.portfolio.account.exception.AccountTransferNotFoundException;
import org.apache.fineract.portfolio.account.service.AccountTransferEnumerations;
import org.apache.fineract.portfolio.account.service.PortfolioAccountReadPlatformService;
import org.apache.fineract.portfolio.account.service.StandingInstructionReadPlatformService;
import org.apache.fineract.portfolio.account.service.StandingInstructionReadPlatformServiceImpl;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.common.service.DropdownReadPlatformService;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class StandingInstructionReadPlatformServiceImpl
implements StandingInstructionReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final ColumnValidator columnValidator;
    private final ClientReadPlatformService clientReadPlatformService;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final PortfolioAccountReadPlatformService portfolioAccountReadPlatformService;
    private final DropdownReadPlatformService dropdownReadPlatformService;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final StandingInstructionMapper standingInstructionMapper;
    private final PaginationHelper paginationHelper;

    public StandingInstructionReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, ClientReadPlatformService clientReadPlatformService, OfficeReadPlatformService officeReadPlatformService, PortfolioAccountReadPlatformService portfolioAccountReadPlatformService, DropdownReadPlatformService dropdownReadPlatformService, ColumnValidator columnValidator, DatabaseSpecificSQLGenerator sqlGenerator, PaginationHelper paginationHelper) {
        this.jdbcTemplate = jdbcTemplate;
        this.clientReadPlatformService = clientReadPlatformService;
        this.officeReadPlatformService = officeReadPlatformService;
        this.portfolioAccountReadPlatformService = portfolioAccountReadPlatformService;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
        this.sqlGenerator = sqlGenerator;
        this.standingInstructionMapper = new StandingInstructionMapper();
        this.columnValidator = columnValidator;
        this.paginationHelper = paginationHelper;
    }

    public StandingInstructionData retrieveTemplate(Long fromOfficeId, Long fromClientId, Long fromAccountId, Integer fromAccountType, Long toOfficeId, Long toClientId, Long toAccountId, Integer toAccountType, Integer transferType) {
        AccountTransferType accountTransferType = AccountTransferType.INVALID;
        if (transferType != null) {
            accountTransferType = AccountTransferType.fromInt((Integer)transferType);
        }
        EnumOptionData loanAccountType = AccountTransferEnumerations.accountType((PortfolioAccountType)PortfolioAccountType.LOAN);
        EnumOptionData savingsAccountType = AccountTransferEnumerations.accountType((PortfolioAccountType)PortfolioAccountType.SAVINGS);
        Integer mostRelevantFromAccountType = fromAccountType;
        List<EnumOptionData> fromAccountTypeOptions = null;
        List<EnumOptionData> toAccountTypeOptions = null;
        if (accountTransferType.isAccountTransfer()) {
            fromAccountTypeOptions = Arrays.asList(savingsAccountType);
            toAccountTypeOptions = Arrays.asList(savingsAccountType);
        } else if (accountTransferType.isLoanRepayment()) {
            fromAccountTypeOptions = Arrays.asList(savingsAccountType);
            toAccountTypeOptions = Arrays.asList(loanAccountType);
        } else {
            fromAccountTypeOptions = Arrays.asList(savingsAccountType, loanAccountType);
            toAccountTypeOptions = Arrays.asList(loanAccountType, savingsAccountType);
        }
        Integer mostRelevantToAccountType = toAccountType;
        EnumOptionData fromAccountTypeData = AccountTransferEnumerations.accountType((Integer)mostRelevantFromAccountType);
        EnumOptionData toAccountTypeData = AccountTransferEnumerations.accountType((Integer)mostRelevantToAccountType);
        OfficeData fromOffice = null;
        ClientData fromClient = null;
        PortfolioAccountData fromAccount = null;
        OfficeData toOffice = null;
        ClientData toClient = null;
        PortfolioAccountData toAccount = null;
        Collection fromAccountOptions = null;
        Collection toAccountOptions = null;
        Long mostRelevantFromOfficeId = fromOfficeId;
        Long mostRelevantFromClientId = fromClientId;
        Long mostRelevantToOfficeId = toOfficeId;
        Long mostRelevantToClientId = toClientId;
        if (fromAccountId != null) {
            Integer accountType = mostRelevantFromAccountType == 1 ? PortfolioAccountType.LOAN.getValue() : PortfolioAccountType.SAVINGS.getValue();
            fromAccount = this.portfolioAccountReadPlatformService.retrieveOne(fromAccountId, accountType);
            mostRelevantFromClientId = fromAccount.getClientId();
        }
        if (mostRelevantFromClientId != null) {
            fromClient = this.clientReadPlatformService.retrieveOne(mostRelevantFromClientId);
            mostRelevantFromOfficeId = fromClient.getOfficeId();
            long[] loanStatus = null;
            if (mostRelevantFromAccountType == 1) {
                loanStatus = new long[]{300L, 700L};
            }
            PortfolioAccountDTO portfolioAccountDTO = new PortfolioAccountDTO(mostRelevantFromAccountType, mostRelevantFromClientId, loanStatus);
            fromAccountOptions = this.portfolioAccountReadPlatformService.retrieveAllForLookup(portfolioAccountDTO);
        }
        Collection fromOfficeOptions = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
        Collection fromClientOptions = null;
        if (mostRelevantFromOfficeId != null) {
            fromOffice = this.officeReadPlatformService.retrieveOffice(mostRelevantFromOfficeId);
            fromClientOptions = this.clientReadPlatformService.retrieveAllForLookupByOfficeId(mostRelevantFromOfficeId);
        }
        LocalDate transferDate = DateUtils.getBusinessLocalDate();
        Collection toOfficeOptions = fromOfficeOptions;
        Collection toClientOptions = null;
        if (toAccountId != null && fromAccount != null) {
            toAccount = this.portfolioAccountReadPlatformService.retrieveOne(toAccountId, mostRelevantToAccountType, fromAccount.getCurrencyCode());
            mostRelevantToClientId = toAccount.getClientId();
        }
        if (mostRelevantToClientId != null) {
            toClient = this.clientReadPlatformService.retrieveOne(mostRelevantToClientId);
            mostRelevantToOfficeId = toClient.getOfficeId();
            toClientOptions = this.clientReadPlatformService.retrieveAllForLookupByOfficeId(mostRelevantToOfficeId);
            toAccountOptions = this.retrieveToAccounts(fromAccount, mostRelevantToAccountType, mostRelevantToClientId);
        }
        if (mostRelevantToOfficeId != null) {
            toOffice = this.officeReadPlatformService.retrieveOffice(mostRelevantToOfficeId);
            toOfficeOptions = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
            toClientOptions = this.clientReadPlatformService.retrieveAllForLookupByOfficeId(mostRelevantToOfficeId);
            if (toClientOptions != null && toClientOptions.size() == 1) {
                toClient = (ClientData)new ArrayList(toClientOptions).get(0);
                toAccountOptions = this.retrieveToAccounts(fromAccount, mostRelevantToAccountType, mostRelevantToClientId);
            }
        }
        List<EnumOptionData> transferTypeOptions = Arrays.asList(AccountTransferEnumerations.transferType((AccountTransferType)AccountTransferType.ACCOUNT_TRANSFER), AccountTransferEnumerations.transferType((AccountTransferType)AccountTransferType.LOAN_REPAYMENT));
        List<EnumOptionData> statusOptions = Arrays.asList(AccountTransferEnumerations.standingInstructionStatus((StandingInstructionStatus)StandingInstructionStatus.ACTIVE), AccountTransferEnumerations.standingInstructionStatus((StandingInstructionStatus)StandingInstructionStatus.DISABLED));
        List<EnumOptionData> instructionTypeOptions = Arrays.asList(AccountTransferEnumerations.standingInstructionType((StandingInstructionType)StandingInstructionType.FIXED), AccountTransferEnumerations.standingInstructionType((StandingInstructionType)StandingInstructionType.DUES));
        List<EnumOptionData> priorityOptions = Arrays.asList(AccountTransferEnumerations.standingInstructionPriority((StandingInstructionPriority)StandingInstructionPriority.URGENT), AccountTransferEnumerations.standingInstructionPriority((StandingInstructionPriority)StandingInstructionPriority.HIGH), AccountTransferEnumerations.standingInstructionPriority((StandingInstructionPriority)StandingInstructionPriority.MEDIUM), AccountTransferEnumerations.standingInstructionPriority((StandingInstructionPriority)StandingInstructionPriority.LOW));
        List<EnumOptionData> recurrenceTypeOptions = Arrays.asList(AccountTransferEnumerations.recurrenceType((AccountTransferRecurrenceType)AccountTransferRecurrenceType.PERIODIC), AccountTransferEnumerations.recurrenceType((AccountTransferRecurrenceType)AccountTransferRecurrenceType.AS_PER_DUES));
        List recurrenceFrequencyOptions = this.dropdownReadPlatformService.retrievePeriodFrequencyTypeOptions();
        return StandingInstructionData.template((OfficeData)fromOffice, (ClientData)fromClient, (EnumOptionData)fromAccountTypeData, (PortfolioAccountData)fromAccount, (LocalDate)transferDate, (OfficeData)toOffice, (ClientData)toClient, (EnumOptionData)toAccountTypeData, (PortfolioAccountData)toAccount, (Collection)fromOfficeOptions, (Collection)fromClientOptions, fromAccountTypeOptions, (Collection)fromAccountOptions, (Collection)toOfficeOptions, (Collection)toClientOptions, toAccountTypeOptions, (Collection)toAccountOptions, transferTypeOptions, statusOptions, instructionTypeOptions, priorityOptions, recurrenceTypeOptions, (Collection)recurrenceFrequencyOptions);
    }

    private Collection<PortfolioAccountData> retrieveToAccounts(PortfolioAccountData excludeThisAccountFromOptions, Integer toAccountType, Long toClientId) {
        String currencyCode = excludeThisAccountFromOptions != null ? excludeThisAccountFromOptions.getCurrencyCode() : null;
        PortfolioAccountDTO portfolioAccountDTO = new PortfolioAccountDTO(toAccountType, toClientId, currencyCode, null, null);
        Collection accountOptions = this.portfolioAccountReadPlatformService.retrieveAllForLookup(portfolioAccountDTO);
        if (!CollectionUtils.isEmpty((Collection)accountOptions)) {
            accountOptions.remove(excludeThisAccountFromOptions);
        } else {
            accountOptions = null;
        }
        return accountOptions;
    }

    public Page<StandingInstructionData> retrieveAll(StandingInstructionDTO standingInstructionDTO) {
        SearchParameters searchParameters;
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(this.standingInstructionMapper.schema());
        if (standingInstructionDTO.transferType() != null || standingInstructionDTO.clientId() != null || standingInstructionDTO.clientName() != null) {
            sqlBuilder.append(" where ");
        }
        boolean addAndCaluse = false;
        ArrayList<Object> paramObj = new ArrayList<Object>();
        if (standingInstructionDTO.transferType() != null) {
            if (addAndCaluse) {
                sqlBuilder.append(" and ");
            }
            sqlBuilder.append(" atd.transfer_type=? ");
            paramObj.add(standingInstructionDTO.transferType());
            addAndCaluse = true;
        }
        if (standingInstructionDTO.clientId() != null) {
            if (addAndCaluse) {
                sqlBuilder.append(" and ");
            }
            sqlBuilder.append(" fromclient.id=? ");
            paramObj.add(standingInstructionDTO.clientId());
            addAndCaluse = true;
        } else if (standingInstructionDTO.clientName() != null) {
            if (addAndCaluse) {
                sqlBuilder.append(" and ");
            }
            sqlBuilder.append(" fromclient.display_name=? ");
            paramObj.add(standingInstructionDTO.clientName());
            addAndCaluse = true;
        }
        if (standingInstructionDTO.fromAccountType() != null && standingInstructionDTO.fromAccount() != null) {
            PortfolioAccountType accountType = PortfolioAccountType.fromInt((Integer)standingInstructionDTO.fromAccountType());
            if (addAndCaluse) {
                sqlBuilder.append(" and ");
            }
            if (accountType.isSavingsAccount()) {
                sqlBuilder.append(" fromsavacc.id=? ");
                paramObj.add(standingInstructionDTO.fromAccount());
            } else if (accountType.isLoanAccount()) {
                sqlBuilder.append(" fromloanacc.id=? ");
                paramObj.add(standingInstructionDTO.fromAccount());
            }
            addAndCaluse = true;
        }
        if ((searchParameters = standingInstructionDTO.searchParameters()).hasOrderBy()) {
            sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
            if (searchParameters.hasSortOrder()) {
                sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
            }
        }
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" ");
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
            } else {
                sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
            }
        }
        Object[] finalObjectArray = paramObj.toArray();
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), finalObjectArray, (RowMapper)this.standingInstructionMapper);
    }

    public Collection<StandingInstructionData> retrieveAll(Integer status) {
        StringBuilder sqlBuilder = new StringBuilder(200);
        String businessDate = this.sqlGenerator.currentBusinessDate();
        sqlBuilder.append("select ");
        sqlBuilder.append(this.standingInstructionMapper.schema());
        sqlBuilder.append(" where atsi.status=? and " + businessDate + " >= atsi.valid_from and (atsi.valid_till IS NULL or " + businessDate + " < atsi.valid_till) ").append(" and  (atsi.last_run_date <> " + businessDate + " or atsi.last_run_date IS NULL)").append(" ORDER BY atsi.priority DESC");
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)this.standingInstructionMapper, new Object[]{status});
    }

    public StandingInstructionData retrieveOne(Long instructionId) {
        try {
            String sql = "select " + this.standingInstructionMapper.schema() + " where atsi.id = ?";
            return (StandingInstructionData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.standingInstructionMapper, new Object[]{instructionId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new AccountTransferNotFoundException(instructionId, e);
        }
    }

    public StandingInstructionDuesData retriveLoanDuesData(Long loanId) {
        StandingInstructionLoanDuesMapper rm = new StandingInstructionLoanDuesMapper();
        String sql = "select " + rm.schema() + " where ml.id= ? and ls.duedate <= " + this.sqlGenerator.currentBusinessDate() + " and ls.completed_derived <> 1";
        return (StandingInstructionDuesData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{loanId});
    }
}

