/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.accounts.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.exception.ResourceNotFoundException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.accounts.api.AccountsApiResourceSwagger;
import org.apache.fineract.portfolio.accounts.data.AccountData;
import org.apache.fineract.portfolio.accounts.service.AccountReadPlatformService;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/accounts/{type}")
@Component
@Tag(name="Share Account", description="Share accounts are instances of a praticular share product created for an individual. An application process around the creation of accounts is also supported.")
public class AccountsApiResource {
    private final ApplicationContext applicationContext;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final DefaultToApiJsonSerializer<AccountData> toApiJsonSerializer;
    private final PlatformSecurityContext platformSecurityContext;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Share Account Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\n\nExample Requests:\n\naccounts/share/template?clientId=1\n\n\naccounts/share/template?clientId=1&productId=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.GetAccountsTypeTemplateResponse.class))})})
    public String template(@PathParam(value="type") @Parameter(description="type") String accountType, @QueryParam(value="clientId") @Parameter(description="clientId") Long clientId, @QueryParam(value="productId") @Parameter(description="productId") Long productId, @Context UriInfo uriInfo) {
        try {
            this.platformSecurityContext.authenticatedUser();
            String serviceName = accountType + "AccountReadPlatformService";
            AccountReadPlatformService service = (AccountReadPlatformService)this.applicationContext.getBean(serviceName);
            AccountData accountData = service.retrieveTemplate(clientId, productId);
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            return this.toApiJsonSerializer.serialize(settings, (Object)accountData, service.getResponseDataParams());
        }
        catch (BeansException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    @GET
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a share application/account", description="Retrieves a share application/account\n\nExample Requests :\n\nshareaccount/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.GetAccountsTypeAccountIdResponse.class))})})
    public String retrieveAccount(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @PathParam(value="type") @Parameter(description="type") String accountType, @Context UriInfo uriInfo) {
        try {
            String serviceName = accountType + "AccountReadPlatformService";
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            AccountReadPlatformService service = (AccountReadPlatformService)this.applicationContext.getBean(serviceName);
            AccountData data = service.retrieveOne(accountId, settings.isTemplate());
            return this.toApiJsonSerializer.serialize(settings, (Object)data, service.getResponseDataParams());
        }
        catch (BeansException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List share applications/accounts", description="Lists share applications/accounts\n\nExample Requests:\n\nshareaccount")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.GetAccountsTypeResponse.class))})})
    public String retrieveAllAccounts(@PathParam(value="type") @Parameter(description="type") String accountType, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @Context UriInfo uriInfo) {
        try {
            String serviceName = accountType + "AccountReadPlatformService";
            AccountReadPlatformService service = (AccountReadPlatformService)this.applicationContext.getBean(serviceName);
            Page data = service.retrieveAll(offset, limit);
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            return this.toApiJsonSerializer.serialize(settings, data, service.getResponseDataParams());
        }
        catch (BeansException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Submit new share application", description="Submits new share application\n\nMandatory Fields: clientId, productId, submittedDate, savingsAccountId, requestedShares, applicationDate\n\nOptional Fields: accountNo, externalId\n\nInherited from Product (if not provided): minimumActivePeriod, minimumActivePeriodFrequencyType, lockinPeriodFrequency, lockinPeriodFrequencyType")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.PostAccountsTypeRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.PostAccountsTypeResponse.class))})})
    public String createAccount(@PathParam(value="type") @Parameter(description="type") String accountType, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandWrapper = null;
        this.platformSecurityContext.authenticatedUser();
        commandWrapper = new CommandWrapperBuilder().createAccount(accountType).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.toApiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    @POST
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Approve share application | Undo approval share application | Reject share application | Activate a share account | Close a share account | Apply additional shares on a share account | Approve additional shares request on a share account | Reject additional shares request on a share account | Redeem shares on a share account", description="Approve share application:\n\nApproves share application so long as its in 'Submitted and pending approval' state.\n\nUndo approval share application:\n\nWill move 'approved' share application back to 'Submitted and pending approval' state.\n\nReject share application:\n\nRejects share application so long as its in 'Submitted and pending approval' state.\n\nActivate a share account:\n\nResults in an approved share application being converted into an 'active' share account.\n\nClose a share account:\n\nResults in an Activated share application being converted into an 'closed' share account.\n\nclosedDate is closure date of share account\n\nMandatory Fields: dateFormat,locale,closedDate\n\nApply additional shares on a share account:\n\nrequestedDate is requsted date of share purchase\n\nrequestedShares is number of shares to be purchase\n\nMandatory Fields: dateFormat,locale,requestedDate, requestedShares\n\nApprove additional shares request on a share account\n\nrequestedShares is Share purchase transaction ids\n\nMandatory Fields: requestedShares\n\nReject additional shares request on a share account:\n\nrequestedShares is Share purchase transaction ids\n\nMandatory Fields: requestedShares\n\nRedeem shares on a share account:\n\nResults redeem some/all shares from share account.\n\nrequestedDate is requsted date of shares redeem\n\nrequestedShares is number of shares to be redeemed\n\nMandatory Fields: dateFormat,locale,requestedDate,requestedShares\n\nShowing request/response for 'Reject additional shares request on a share account'\n\nFor more info visit this link - https://fineract.apache.org/legacy-docs/apiLive.htm#shareaccounts")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.PostAccountsTypeAccountIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.PostAccountsTypeAccountIdResponse.class))})})
    public String handleCommands(@PathParam(value="type") @Parameter(description="type") String accountType, @PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandWrapper = null;
        this.platformSecurityContext.authenticatedUser();
        commandWrapper = new CommandWrapperBuilder().createAccountCommand(accountType, accountId, commandParam).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.toApiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    @PUT
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Modify a share application", description="Share application can only be modified when in 'Submitted and pending approval' state. Once the application is approved, the details cannot be changed using this method. Specific api endpoints will be created to allow change of interest detail such as rate, compounding period, posting period etc")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.PutAccountsTypeAccountIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountsApiResourceSwagger.PutAccountsTypeAccountIdResponse.class))})})
    public String updateAccount(@PathParam(value="type") @Parameter(description="type") String accountType, @PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateAccount(accountType, accountId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getSharedAccountsTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="dateFormat") String dateFormat, @PathParam(value="type") @Parameter(description="type") String accountType) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.SHARE_ACCOUNTS.toString(), officeId, null, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload shared accounts template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postSharedAccountsTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat, @PathParam(value="type") @Parameter(description="type") String accountType) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.SHARE_ACCOUNTS.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @Generated
    public AccountsApiResource(ApplicationContext applicationContext, ApiRequestParameterHelper apiRequestParameterHelper, DefaultToApiJsonSerializer<AccountData> toApiJsonSerializer, PlatformSecurityContext platformSecurityContext, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, BulkImportWorkbookService bulkImportWorkbookService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService) {
        this.applicationContext = applicationContext;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.platformSecurityContext = platformSecurityContext;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
    }
}

