/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.address.domain;

import com.google.gson.JsonObject;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.client.domain.ClientAddress;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_address")
public class Address
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @OneToMany(mappedBy="address", cascade={CascadeType.ALL})
    private Set<ClientAddress> clientaddress;
    @Column(name="street")
    private String street;
    @Column(name="address_line_1")
    private String addressLine1;
    @Column(name="address_line_2")
    private String addressLine2;
    @Column(name="address_line_3")
    private String addressLine3;
    @Column(name="town_village")
    private String townVillage;
    @Column(name="city")
    private String city;
    @Column(name="county_district")
    private String countyDistrict;
    @ManyToOne
    @JoinColumn(name="state_province_id")
    private CodeValue stateProvince;
    @ManyToOne
    @JoinColumn(name="country_id")
    private CodeValue country;
    @Column(name="postal_code")
    private String postalCode;
    @Column(name="latitude")
    private BigDecimal latitude;
    @Column(name="longitude")
    private BigDecimal longitude;
    @Column(name="created_by")
    private String createdBy;
    @Column(name="created_on")
    private LocalDate createdOn;
    @Column(name="updated_by")
    private String updatedBy;
    @Column(name="updated_on")
    private LocalDate updatedOn;
    static final long serialVersionUID = 346993390415203195L;

    private Address(String street, String addressLine1, String addressLine2, String addressLine3, String townVillage, String city, String countyDistrict, CodeValue stateProvince, CodeValue country, String postalCode, BigDecimal latitude, BigDecimal longitude, String createdBy, LocalDate createdOn, String updatedBy, LocalDate updatedOn) {
        this.street = street;
        this.addressLine1 = addressLine1;
        this.addressLine2 = addressLine2;
        this.addressLine3 = addressLine3;
        this.townVillage = townVillage;
        this.city = city;
        this.countyDistrict = countyDistrict;
        this.stateProvince = stateProvince;
        this.country = country;
        this.postalCode = postalCode;
        this.latitude = latitude;
        this.longitude = longitude;
        this.createdBy = createdBy;
        this.updatedBy = updatedBy;
        if (createdOn != null) {
            this.createdOn = createdOn;
        }
        if (updatedOn != null) {
            this.updatedOn = updatedOn;
        }
    }

    public Address() {
    }

    public static Address fromJson(JsonCommand command, CodeValue stateProvince, CodeValue country) {
        String street = command.stringValueOfParameterNamed("street");
        String addressLine1 = command.stringValueOfParameterNamed("addressLine1");
        String addressLine2 = command.stringValueOfParameterNamed("addressLine2");
        String addressLine3 = command.stringValueOfParameterNamed("addressLine3");
        String townVillage = command.stringValueOfParameterNamed("townVillage");
        String city = command.stringValueOfParameterNamed("city");
        String countyDistrict = command.stringValueOfParameterNamed("countyDistrict");
        String postalCode = command.stringValueOfParameterNamed("postalCode");
        BigDecimal latitude = command.bigDecimalValueOfParameterNamed("latitude");
        BigDecimal longitude = command.bigDecimalValueOfParameterNamed("longitude");
        String createdBy = command.stringValueOfParameterNamed("createdBy");
        LocalDate createdOn = command.localDateValueOfParameterNamed("createdOn");
        String updatedBy = command.stringValueOfParameterNamed("updatedBy");
        LocalDate updatedOn = command.localDateValueOfParameterNamed("updatedOn");
        return new Address(street, addressLine1, addressLine2, addressLine3, townVillage, city, countyDistrict, stateProvince, country, postalCode, latitude, longitude, createdBy, createdOn, updatedBy, updatedOn);
    }

    public static Address fromJsonObject(JsonObject jsonObject, CodeValue state_province, CodeValue country) {
        DateTimeFormatter formatter;
        String street = "";
        String addressLine1 = "";
        String addressLine2 = "";
        String addressLine3 = "";
        String townVillage = "";
        String city = "";
        String countyDistrict = "";
        String postalCode = "";
        BigDecimal latitude = BigDecimal.ZERO;
        BigDecimal longitude = BigDecimal.ZERO;
        String createdBy = "";
        String updatedBy = "";
        LocalDate updatedOnDate = null;
        LocalDate createdOnDate = null;
        if (jsonObject.has("street")) {
            street = jsonObject.get("street").getAsString();
        }
        if (jsonObject.has("addressLine1")) {
            addressLine1 = jsonObject.get("addressLine1").getAsString();
        }
        if (jsonObject.has("addressLine2")) {
            addressLine2 = jsonObject.get("addressLine2").getAsString();
        }
        if (jsonObject.has("addressLine3")) {
            addressLine3 = jsonObject.get("addressLine3").getAsString();
        }
        if (jsonObject.has("townVillage")) {
            townVillage = jsonObject.get("townVillage").getAsString();
        }
        if (jsonObject.has("city")) {
            city = jsonObject.get("city").getAsString();
        }
        if (jsonObject.has("countyDistrict")) {
            countyDistrict = jsonObject.get("countyDistrict").getAsString();
        }
        if (jsonObject.has("postalCode")) {
            postalCode = jsonObject.get("postalCode").getAsString();
        }
        if (jsonObject.has("latitude")) {
            latitude = jsonObject.get("latitude").getAsBigDecimal();
        }
        if (jsonObject.has("longitude")) {
            longitude = jsonObject.get("longitude").getAsBigDecimal();
        }
        if (jsonObject.has("createdBy")) {
            createdBy = jsonObject.get("createdBy").getAsString();
        }
        if (jsonObject.has("createdOn")) {
            String createdOn = jsonObject.get("createdOn").getAsString();
            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            createdOnDate = LocalDate.parse(createdOn, formatter);
        }
        if (jsonObject.has("updatedBy")) {
            updatedBy = jsonObject.get("updatedBy").getAsString();
        }
        if (jsonObject.has("updatedOn")) {
            String updatedOn = jsonObject.get("updatedOn").getAsString();
            formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            updatedOnDate = LocalDate.parse(updatedOn, formatter);
        }
        return new Address(street, addressLine1, addressLine2, addressLine3, townVillage, city, countyDistrict, state_province, country, postalCode, latitude, longitude, createdBy, createdOnDate, updatedBy, updatedOnDate);
    }

    public Set<ClientAddress> getClientaddress() {
        return this._persistence_get_clientaddress();
    }

    public void setClientaddress(Set<ClientAddress> clientaddress) {
        this._persistence_set_clientaddress(clientaddress);
    }

    public String getStreet() {
        return this._persistence_get_street();
    }

    public void setStreet(String street) {
        this._persistence_set_street(street);
    }

    public String getAddressLine1() {
        return this._persistence_get_addressLine1();
    }

    public void setAddressLine1(String addressLine1) {
        this._persistence_set_addressLine1(addressLine1);
    }

    public String getAddressLine2() {
        return this._persistence_get_addressLine2();
    }

    public void setAddressLine2(String addressLine2) {
        this._persistence_set_addressLine2(addressLine2);
    }

    public String getAddressLine3() {
        return this._persistence_get_addressLine3();
    }

    public void setAddressLine3(String addressLine3) {
        this._persistence_set_addressLine3(addressLine3);
    }

    public String getTownVillage() {
        return this._persistence_get_townVillage();
    }

    public void setTownVillage(String townVillage) {
        this._persistence_set_townVillage(townVillage);
    }

    public String getCity() {
        return this._persistence_get_city();
    }

    public void setCity(String city) {
        this._persistence_set_city(city);
    }

    public String getCountyDistrict() {
        return this._persistence_get_countyDistrict();
    }

    public void setCountyDistrict(String countyDistrict) {
        this._persistence_set_countyDistrict(countyDistrict);
    }

    public CodeValue getStateProvince() {
        return this._persistence_get_stateProvince();
    }

    public void setStateProvince(CodeValue stateProvince) {
        this._persistence_set_stateProvince(stateProvince);
    }

    public CodeValue getCountry() {
        return this._persistence_get_country();
    }

    public void setCountry(CodeValue country) {
        this._persistence_set_country(country);
    }

    public String getPostalCode() {
        return this._persistence_get_postalCode();
    }

    public void setPostalCode(String postalCode) {
        this._persistence_set_postalCode(postalCode);
    }

    public BigDecimal getLatitude() {
        return this._persistence_get_latitude();
    }

    public void setLatitude(BigDecimal latitude) {
        this._persistence_set_latitude(latitude);
    }

    public BigDecimal getLongitude() {
        return this._persistence_get_longitude();
    }

    public void setLongitude(BigDecimal longitude) {
        this._persistence_set_longitude(longitude);
    }

    public String getCreatedBy() {
        return this._persistence_get_createdBy();
    }

    public void setCreatedBy(String createdBy) {
        this._persistence_set_createdBy(createdBy);
    }

    public LocalDate getCreatedOn() {
        return this._persistence_get_createdOn();
    }

    public void setCreatedOn(LocalDate createdOn) {
        this._persistence_set_createdOn(createdOn);
    }

    public String getUpdatedBy() {
        return this._persistence_get_updatedBy();
    }

    public void setUpdatedBy(String updatedBy) {
        this._persistence_set_updatedBy(updatedBy);
    }

    public LocalDate getUpdatedOn() {
        return this._persistence_get_updatedOn();
    }

    public void setUpdatedOn(LocalDate updatedOn) {
        this._persistence_set_updatedOn(updatedOn);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Address();
    }

    public Object _persistence_get(String string) {
        if (string == "country") {
            return this.country;
        }
        if (string == "clientaddress") {
            return this.clientaddress;
        }
        if (string == "updatedBy") {
            return this.updatedBy;
        }
        if (string == "city") {
            return this.city;
        }
        if (string == "countyDistrict") {
            return this.countyDistrict;
        }
        if (string == "postalCode") {
            return this.postalCode;
        }
        if (string == "latitude") {
            return this.latitude;
        }
        if (string == "townVillage") {
            return this.townVillage;
        }
        if (string == "stateProvince") {
            return this.stateProvince;
        }
        if (string == "updatedOn") {
            return this.updatedOn;
        }
        if (string == "createdOn") {
            return this.createdOn;
        }
        if (string == "createdBy") {
            return this.createdBy;
        }
        if (string == "street") {
            return this.street;
        }
        if (string == "addressLine1") {
            return this.addressLine1;
        }
        if (string == "addressLine2") {
            return this.addressLine2;
        }
        if (string == "addressLine3") {
            return this.addressLine3;
        }
        if (string == "longitude") {
            return this.longitude;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "country") {
            this.country = (CodeValue)object;
            return;
        }
        if (string == "clientaddress") {
            this.clientaddress = (Set)object;
            return;
        }
        if (string == "updatedBy") {
            this.updatedBy = (String)object;
            return;
        }
        if (string == "city") {
            this.city = (String)object;
            return;
        }
        if (string == "countyDistrict") {
            this.countyDistrict = (String)object;
            return;
        }
        if (string == "postalCode") {
            this.postalCode = (String)object;
            return;
        }
        if (string == "latitude") {
            this.latitude = (BigDecimal)object;
            return;
        }
        if (string == "townVillage") {
            this.townVillage = (String)object;
            return;
        }
        if (string == "stateProvince") {
            this.stateProvince = (CodeValue)object;
            return;
        }
        if (string == "updatedOn") {
            this.updatedOn = (LocalDate)object;
            return;
        }
        if (string == "createdOn") {
            this.createdOn = (LocalDate)object;
            return;
        }
        if (string == "createdBy") {
            this.createdBy = (String)object;
            return;
        }
        if (string == "street") {
            this.street = (String)object;
            return;
        }
        if (string == "addressLine1") {
            this.addressLine1 = (String)object;
            return;
        }
        if (string == "addressLine2") {
            this.addressLine2 = (String)object;
            return;
        }
        if (string == "addressLine3") {
            this.addressLine3 = (String)object;
            return;
        }
        if (string == "longitude") {
            this.longitude = (BigDecimal)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public CodeValue _persistence_get_country() {
        this._persistence_checkFetched("country");
        return this.country;
    }

    public void _persistence_set_country(CodeValue codeValue) {
        this._persistence_checkFetchedForSet("country");
        this._persistence_propertyChange("country", (Object)this.country, (Object)codeValue);
        this.country = codeValue;
    }

    public Set _persistence_get_clientaddress() {
        this._persistence_checkFetched("clientaddress");
        return this.clientaddress;
    }

    public void _persistence_set_clientaddress(Set set) {
        this._persistence_checkFetchedForSet("clientaddress");
        this._persistence_propertyChange("clientaddress", (Object)this.clientaddress, (Object)set);
        this.clientaddress = set;
    }

    public String _persistence_get_updatedBy() {
        this._persistence_checkFetched("updatedBy");
        return this.updatedBy;
    }

    public void _persistence_set_updatedBy(String string) {
        this._persistence_checkFetchedForSet("updatedBy");
        this._persistence_propertyChange("updatedBy", (Object)this.updatedBy, (Object)string);
        this.updatedBy = string;
    }

    public String _persistence_get_city() {
        this._persistence_checkFetched("city");
        return this.city;
    }

    public void _persistence_set_city(String string) {
        this._persistence_checkFetchedForSet("city");
        this._persistence_propertyChange("city", (Object)this.city, (Object)string);
        this.city = string;
    }

    public String _persistence_get_countyDistrict() {
        this._persistence_checkFetched("countyDistrict");
        return this.countyDistrict;
    }

    public void _persistence_set_countyDistrict(String string) {
        this._persistence_checkFetchedForSet("countyDistrict");
        this._persistence_propertyChange("countyDistrict", (Object)this.countyDistrict, (Object)string);
        this.countyDistrict = string;
    }

    public String _persistence_get_postalCode() {
        this._persistence_checkFetched("postalCode");
        return this.postalCode;
    }

    public void _persistence_set_postalCode(String string) {
        this._persistence_checkFetchedForSet("postalCode");
        this._persistence_propertyChange("postalCode", (Object)this.postalCode, (Object)string);
        this.postalCode = string;
    }

    public BigDecimal _persistence_get_latitude() {
        this._persistence_checkFetched("latitude");
        return this.latitude;
    }

    public void _persistence_set_latitude(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("latitude");
        this._persistence_propertyChange("latitude", (Object)this.latitude, (Object)bigDecimal);
        this.latitude = bigDecimal;
    }

    public String _persistence_get_townVillage() {
        this._persistence_checkFetched("townVillage");
        return this.townVillage;
    }

    public void _persistence_set_townVillage(String string) {
        this._persistence_checkFetchedForSet("townVillage");
        this._persistence_propertyChange("townVillage", (Object)this.townVillage, (Object)string);
        this.townVillage = string;
    }

    public CodeValue _persistence_get_stateProvince() {
        this._persistence_checkFetched("stateProvince");
        return this.stateProvince;
    }

    public void _persistence_set_stateProvince(CodeValue codeValue) {
        this._persistence_checkFetchedForSet("stateProvince");
        this._persistence_propertyChange("stateProvince", (Object)this.stateProvince, (Object)codeValue);
        this.stateProvince = codeValue;
    }

    public LocalDate _persistence_get_updatedOn() {
        this._persistence_checkFetched("updatedOn");
        return this.updatedOn;
    }

    public void _persistence_set_updatedOn(LocalDate localDate) {
        this._persistence_checkFetchedForSet("updatedOn");
        this._persistence_propertyChange("updatedOn", (Object)this.updatedOn, (Object)localDate);
        this.updatedOn = localDate;
    }

    public LocalDate _persistence_get_createdOn() {
        this._persistence_checkFetched("createdOn");
        return this.createdOn;
    }

    public void _persistence_set_createdOn(LocalDate localDate) {
        this._persistence_checkFetchedForSet("createdOn");
        this._persistence_propertyChange("createdOn", (Object)this.createdOn, (Object)localDate);
        this.createdOn = localDate;
    }

    public String _persistence_get_createdBy() {
        this._persistence_checkFetched("createdBy");
        return this.createdBy;
    }

    public void _persistence_set_createdBy(String string) {
        this._persistence_checkFetchedForSet("createdBy");
        this._persistence_propertyChange("createdBy", (Object)this.createdBy, (Object)string);
        this.createdBy = string;
    }

    public String _persistence_get_street() {
        this._persistence_checkFetched("street");
        return this.street;
    }

    public void _persistence_set_street(String string) {
        this._persistence_checkFetchedForSet("street");
        this._persistence_propertyChange("street", (Object)this.street, (Object)string);
        this.street = string;
    }

    public String _persistence_get_addressLine1() {
        this._persistence_checkFetched("addressLine1");
        return this.addressLine1;
    }

    public void _persistence_set_addressLine1(String string) {
        this._persistence_checkFetchedForSet("addressLine1");
        this._persistence_propertyChange("addressLine1", (Object)this.addressLine1, (Object)string);
        this.addressLine1 = string;
    }

    public String _persistence_get_addressLine2() {
        this._persistence_checkFetched("addressLine2");
        return this.addressLine2;
    }

    public void _persistence_set_addressLine2(String string) {
        this._persistence_checkFetchedForSet("addressLine2");
        this._persistence_propertyChange("addressLine2", (Object)this.addressLine2, (Object)string);
        this.addressLine2 = string;
    }

    public String _persistence_get_addressLine3() {
        this._persistence_checkFetched("addressLine3");
        return this.addressLine3;
    }

    public void _persistence_set_addressLine3(String string) {
        this._persistence_checkFetchedForSet("addressLine3");
        this._persistence_propertyChange("addressLine3", (Object)this.addressLine3, (Object)string);
        this.addressLine3 = string;
    }

    public BigDecimal _persistence_get_longitude() {
        this._persistence_checkFetched("longitude");
        return this.longitude;
    }

    public void _persistence_set_longitude(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("longitude");
        this._persistence_propertyChange("longitude", (Object)this.longitude, (Object)bigDecimal);
        this.longitude = bigDecimal;
    }
}

