/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.address.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.address.data.FieldConfigurationData;
import org.apache.fineract.portfolio.address.service.FieldConfigurationReadPlatformService;
import org.springframework.stereotype.Component;

@Component
public class AddressCommandFromApiJsonDeserializer {
    private final FromJsonHelper fromApiJsonHelper;
    private final FieldConfigurationReadPlatformService readservice;

    public void validateForUpdate(String json) {
        this.validate(json, false);
    }

    public void validateForCreate(String json, boolean fromNewClient) {
        this.validate(json, fromNewClient);
    }

    public void validate(String json, boolean fromNewClient) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("Address");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList configurationData = new ArrayList(this.readservice.retrieveFieldConfigurationList("ADDRESS"));
        List<FieldConfigurationData> configData = configurationData.stream().filter(FieldConfigurationData::isEnabled).collect(Collectors.toList());
        Set supportedParameters = configData.stream().map(FieldConfigurationData::getField).collect(Collectors.toSet());
        supportedParameters.add("locale");
        supportedParameters.add("dateFormat");
        supportedParameters.add(fromNewClient ? "addressTypeId" : "addressId");
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParameters);
        configData.forEach(fieldConfiguration -> {
            String field = fieldConfiguration.getField().equals("addressType") ? "addressTypeId" : fieldConfiguration.getField();
            String fieldValue = this.fromApiJsonHelper.extractStringNamed(field, element);
            if (fieldConfiguration.getField().equals("addressType") && fromNewClient) {
                baseDataValidator.reset().parameter(field).value((Object)fieldValue).notBlank();
            } else if (fieldConfiguration.isIs_mandatory() && fromNewClient) {
                baseDataValidator.reset().parameter(field).value((Object)fieldValue).notBlank();
            }
            if (!fieldConfiguration.getValidation_regex().isEmpty()) {
                baseDataValidator.reset().parameter(field).value((Object)fieldValue).matchesRegularExpression(fieldConfiguration.getValidation_regex());
            }
        });
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    @Generated
    public AddressCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper, FieldConfigurationReadPlatformService readservice) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.readservice = readservice;
    }
}

