/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.address.service;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.address.data.AddressData;
import org.apache.fineract.portfolio.address.service.AddressReadPlatformService;
import org.apache.fineract.portfolio.address.service.AddressReadPlatformServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class AddressReadPlatformServiceImpl
implements AddressReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final CodeValueReadPlatformService readService;

    @Autowired
    public AddressReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, CodeValueReadPlatformService readService) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.readService = readService;
    }

    public Collection<AddressData> retrieveAddressFields(long clientid) {
        this.context.authenticatedUser();
        AddFieldsMapper rm = new AddFieldsMapper();
        String sql = "select " + rm.schema() + " where client.id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientid});
    }

    public Collection<AddressData> retrieveAllClientAddress(long clientid) {
        this.context.authenticatedUser();
        AddMapper rm = new AddMapper();
        String sql = "select " + rm.schema() + " and ca.client_id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientid});
    }

    public Collection<AddressData> retrieveAddressbyType(long clientid, long typeid) {
        this.context.authenticatedUser();
        AddMapper rm = new AddMapper();
        String sql = "select " + rm.schema() + " and ca.client_id=? and ca.address_type_id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientid, typeid});
    }

    public Collection<AddressData> retrieveAddressbyTypeAndStatus(long clientid, long typeid, String status) {
        this.context.authenticatedUser();
        boolean temp = Boolean.parseBoolean(status);
        AddMapper rm = new AddMapper();
        String sql = "select " + rm.schema() + " and ca.client_id=? and ca.address_type_id=? and ca.is_active=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientid, typeid, temp});
    }

    public Collection<AddressData> retrieveAddressbyStatus(long clientid, String status) {
        this.context.authenticatedUser();
        boolean temp = Boolean.parseBoolean(status);
        AddMapper rm = new AddMapper();
        String sql = "select " + rm.schema() + " and ca.client_id=? and ca.is_active=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientid, temp});
    }

    public AddressData retrieveTemplate() {
        ArrayList countryoptions = new ArrayList(this.readService.retrieveCodeValuesByCode("COUNTRY"));
        ArrayList StateOptions = new ArrayList(this.readService.retrieveCodeValuesByCode("STATE"));
        ArrayList addressTypeOptions = new ArrayList(this.readService.retrieveCodeValuesByCode("ADDRESS_TYPE"));
        return AddressData.template(countryoptions, StateOptions, addressTypeOptions);
    }
}

