/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.calendar.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.calendar.api.CalendarsApiResource;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.exception.CalendarEntityTypeNotSupportedException;
import org.apache.fineract.portfolio.calendar.service.CalendarDropdownReadPlatformService;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformService;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.springframework.stereotype.Component;

@Path(value="/v1/{entityType}/{entityId}/calendars")
@Component
@Tag(name="Calendar", description="")
public class CalendarsApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "entityId", "entityType", "title", "description", "location", "startDate", "endDate", "duration", "type", "repeating", "recurrence", "frequency", "interval", "repeatsOnDay", "remindBy", "firstReminder", "secondReminder", "humanReadable", "createdDate", "lastUpdatedDate", "createdByUserId", "createdByUsername", "lastUpdatedByUserId", "lastUpdatedByUsername", "recurringDates", "nextTenRecurringDates", "entityTypeOptions", "calendarTypeOptions", "remindByOptions", "frequencyOptions", "repeatsOnDayOptions"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "CALENDAR";
    private final PlatformSecurityContext context;
    private final CalendarReadPlatformService readPlatformService;
    private final DefaultToApiJsonSerializer<CalendarData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final CalendarDropdownReadPlatformService dropdownReadPlatformService;

    @GET
    @Path(value="{calendarId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveCalendar(@PathParam(value="calendarId") Long calendarId, @PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Integer entityTypeId = CalendarEntityType.valueOf((String)entityType.toUpperCase()).getValue();
        CalendarData calendarData = this.readPlatformService.retrieveCalendar(calendarId, entityId, entityTypeId);
        boolean withHistory = true;
        LocalDate tillDate = null;
        Collection recurringDates = this.readPlatformService.generateRecurringDates(calendarData, true, tillDate);
        Collection nextTenRecurringDates = this.readPlatformService.generateNextTenRecurringDates(calendarData);
        LocalDate recentEligibleMeetingDate = null;
        calendarData = CalendarData.withRecurringDates((CalendarData)calendarData, (Collection)recurringDates, (Collection)nextTenRecurringDates, recentEligibleMeetingDate);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            calendarData = this.handleTemplate(calendarData);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)calendarData, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveCalendarsByEntity(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @Context UriInfo uriInfo, @DefaultValue(value="all") @QueryParam(value="calendarType") String calendarType) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        Collection calendarsData = new ArrayList();
        List calendarTypeOptions = CalendarUtils.createIntegerListFromQueryParameter((String)calendarType);
        if (!associationParameters.isEmpty() && associationParameters.contains("parentCalendars")) {
            calendarsData.addAll(this.readPlatformService.retrieveParentCalendarsByEntity(entityId, CalendarEntityType.valueOf((String)entityType.toUpperCase()).getValue(), calendarTypeOptions));
        }
        calendarsData.addAll(this.readPlatformService.retrieveCalendarsByEntity(entityId, CalendarEntityType.valueOf((String)entityType.toUpperCase()).getValue(), calendarTypeOptions));
        calendarsData = this.readPlatformService.updateWithRecurringDates(calendarsData);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, calendarsData, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveNewCalendarDetails(@Context UriInfo uriInfo, @PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        CalendarData calendarData = this.readPlatformService.retrieveNewCalendarDetails();
        calendarData = this.handleTemplate(calendarData);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)calendarData, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String createCalendar(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, String apiRequestBodyAsJson) {
        CalendarEntityType calendarEntityType = CalendarEntityType.getEntityType((String)entityType);
        if (calendarEntityType == null) {
            throw new CalendarEntityTypeNotSupportedException(entityType);
        }
        CommandWrapper resourceDetails = this.getResourceDetails(calendarEntityType, entityId);
        CommandWrapper commandRequest = new CommandWrapperBuilder().createCalendar(resourceDetails, entityType, entityId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{calendarId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String updateCalendar(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @PathParam(value="calendarId") Long calendarId, String jsonRequestBody) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateCalendar(entityType, entityId, calendarId).withJson(jsonRequestBody).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{calendarId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String deleteCalendar(@PathParam(value="entityType") String entityType, @PathParam(value="entityId") Long entityId, @PathParam(value="calendarId") Long calendarId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteCalendar(entityType, entityId, calendarId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private CalendarData handleTemplate(CalendarData calendarData) {
        List entityTypeOptions = this.dropdownReadPlatformService.retrieveCalendarEntityTypeOptions();
        List calendarTypeOptions = this.dropdownReadPlatformService.retrieveCalendarTypeOptions();
        List remindByOptions = this.dropdownReadPlatformService.retrieveCalendarRemindByOptions();
        List frequencyOptions = this.dropdownReadPlatformService.retrieveCalendarFrequencyTypeOptions();
        List repeatsOnDayOptions = this.dropdownReadPlatformService.retrieveCalendarWeekDaysTypeOptions();
        List frequencyNthDayTypeOptions = this.dropdownReadPlatformService.retrieveCalendarFrequencyNthDayTypeOptions();
        return CalendarData.withTemplateOptions((CalendarData)calendarData, (List)entityTypeOptions, (List)calendarTypeOptions, (List)remindByOptions, (List)frequencyOptions, (List)repeatsOnDayOptions, (List)frequencyNthDayTypeOptions);
    }

    private CommandWrapper getResourceDetails(CalendarEntityType type, Long entityId) {
        CommandWrapperBuilder resourceDetails = new CommandWrapperBuilder();
        switch (1.$SwitchMap$org$apache$fineract$portfolio$calendar$domain$CalendarEntityType[type.ordinal()]) {
            case 1: {
                resourceDetails.withGroupId(entityId);
                break;
            }
            case 2: {
                resourceDetails.withClientId(entityId);
                break;
            }
            case 3: {
                resourceDetails.withGroupId(entityId);
                break;
            }
            case 4: {
                resourceDetails.withLoanId(entityId);
                break;
            }
            case 5: {
                resourceDetails.withSavingsId(entityId);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
        }
        return resourceDetails.build();
    }

    @Generated
    public CalendarsApiResource(PlatformSecurityContext context, CalendarReadPlatformService readPlatformService, DefaultToApiJsonSerializer<CalendarData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, CalendarDropdownReadPlatformService dropdownReadPlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
    }
}

