/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.calendar.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarType;
import org.apache.fineract.portfolio.calendar.exception.CalendarNotFoundException;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformService;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformServiceImpl;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.meeting.data.MeetingData;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalendarReadPlatformServiceImpl
implements CalendarReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final ConfigurationDomainService configurationDomainService;

    public CalendarData retrieveCalendar(Long calendarId, Long entityId, Integer entityTypeId) {
        try {
            CalendarDataMapper rm = new CalendarDataMapper();
            String sql = rm.schema() + " and c.id = ? and ci.entity_id = ? and ci.entity_type_enum = ? ";
            return (CalendarData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{calendarId, entityId, entityTypeId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new CalendarNotFoundException(calendarId, e);
        }
    }

    public Collection<CalendarData> retrieveCalendarsByEntity(Long entityId, Integer entityTypeId, List<Integer> calendarTypeOptions) {
        CalendarDataMapper rm = new CalendarDataMapper();
        List result = null;
        Object sql = "";
        if (calendarTypeOptions == null || calendarTypeOptions.isEmpty()) {
            sql = rm.schema() + " and ci.entity_id = ? and ci.entity_type_enum = ? order by c.start_date ";
            result = this.jdbcTemplate.query((String)sql, (RowMapper)rm, new Object[]{entityId, entityTypeId});
        } else if (!calendarTypeOptions.isEmpty()) {
            String sqlCalendarTypeOptions = CalendarUtils.getSqlCalendarTypeOptionsInString(calendarTypeOptions);
            sql = rm.schema() + " and ci.entity_id = ? and ci.entity_type_enum = ? and c.calendar_type_enum in ( " + sqlCalendarTypeOptions + " ) order by c.start_date ";
            result = this.jdbcTemplate.query((String)sql, (RowMapper)rm, new Object[]{entityId, entityTypeId});
        }
        return result;
    }

    public CalendarData retrieveCollctionCalendarByEntity(Long entityId, Integer entityTypeId) {
        CalendarDataMapper rm = new CalendarDataMapper();
        String sql = rm.schema() + " and ci.entity_id = ? and ci.entity_type_enum = ? and calendar_type_enum = ? order by c.start_date ";
        List result = this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{entityId, entityTypeId, CalendarType.COLLECTION.getValue()});
        if (!result.isEmpty() && result.size() > 0) {
            return (CalendarData)result.get(0);
        }
        return null;
    }

    public Collection<CalendarData> retrieveParentCalendarsByEntity(Long entityId, Integer entityTypeId, List<Integer> calendarTypeOptions) {
        CalendarDataMapper rm = new CalendarDataMapper();
        List result = null;
        Object sql = "";
        CalendarEntityType ceType = CalendarEntityType.fromInt((int)entityTypeId);
        String parentHeirarchyCondition = CalendarReadPlatformServiceImpl.getParentHierarchyCondition((CalendarEntityType)ceType);
        if (calendarTypeOptions == null || calendarTypeOptions.isEmpty()) {
            sql = rm.schema() + " " + parentHeirarchyCondition + " and ci.entity_type_enum = ? order by c.start_date ";
            result = this.jdbcTemplate.query((String)sql, (RowMapper)rm, new Object[]{entityId, CalendarEntityType.CENTERS.getValue()});
        } else {
            String sqlCalendarTypeOptions = CalendarUtils.getSqlCalendarTypeOptionsInString(calendarTypeOptions);
            sql = rm.schema() + " " + parentHeirarchyCondition + " and ci.entity_type_enum = ? and c.calendar_type_enum in (" + sqlCalendarTypeOptions + ") order by c.start_date ";
            result = this.jdbcTemplate.query((String)sql, (RowMapper)rm, new Object[]{entityId, CalendarEntityType.CENTERS.getValue()});
        }
        return result;
    }

    public Collection<CalendarData> retrieveAllCalendars() {
        CalendarDataMapper rm = new CalendarDataMapper();
        String sql = rm.schema();
        return this.jdbcTemplate.query(sql, (RowMapper)rm);
    }

    public CalendarData retrieveNewCalendarDetails() {
        return CalendarData.sensibleDefaultsForNewCalendarCreation();
    }

    public Collection<LocalDate> generateRecurringDates(CalendarData calendarData, boolean withHistory, LocalDate tillDate) {
        LocalDate fromDate = null;
        Collection recurringDates = this.generateRecurringDate(calendarData, fromDate, tillDate, -1);
        if (withHistory) {
            Collection calendarHistorys = this.retrieveCalendarsFromHistory(calendarData.getId());
            for (CalendarData calendarHistory : calendarHistorys) {
                recurringDates.addAll(this.generateRecurringDate(calendarHistory, fromDate, tillDate, -1));
            }
        }
        return recurringDates;
    }

    public Collection<LocalDate> generateNextTenRecurringDates(CalendarData calendarData) {
        LocalDate tillDate = null;
        return this.generateRecurringDate(calendarData, DateUtils.getLocalDateOfTenant(), tillDate, 10);
    }

    private Collection<LocalDate> generateRecurringDate(CalendarData calendarData, LocalDate fromDate, LocalDate tillDate, int maxCount) {
        if (!calendarData.isRepeating()) {
            return null;
        }
        String rrule = calendarData.getRecurrence();
        LocalDate seedDate = this.getSeedDate(calendarData.getStartDate());
        LocalDate periodStartDate = this.getPeriodStartDate(seedDate, calendarData.getStartDate(), fromDate);
        LocalDate periodEndDate = this.getPeriodEndDate(calendarData.getEndDate(), tillDate);
        Integer numberOfDays = 0;
        boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
        if (isSkipRepaymentOnFirstMonthEnabled) {
            numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
        }
        Collection recurringDates = CalendarUtils.getRecurringDates((String)rrule, (LocalDate)seedDate, (LocalDate)periodStartDate, (LocalDate)periodEndDate, (int)maxCount, (boolean)isSkipRepaymentOnFirstMonthEnabled, (Integer)numberOfDays);
        return recurringDates;
    }

    public Boolean isCalendarAssociatedWithEntity(Long entityId, Long calendarId, Long entityTypeId) {
        String query = "Select COUNT(*) from m_calendar_instance ci where ci.entity_id = ? and ci.calendar_id = ? and  ci.entity_type_enum = ?";
        try {
            int calendarInstaneId = (Integer)this.jdbcTemplate.queryForObject(query, Integer.class, new Object[]{entityId, calendarId, entityTypeId});
            return calendarInstaneId > 0;
        }
        catch (EmptyResultDataAccessException e) {
            return false;
        }
    }

    private LocalDate getSeedDate(LocalDate date) {
        return date;
    }

    private LocalDate getPeriodStartDate(LocalDate seedDate, LocalDate recurrenceStartDate, LocalDate fromDate) {
        LocalDate currentDate;
        LocalDate periodStartDate = null;
        periodStartDate = fromDate != null ? fromDate : (DateUtils.isBefore((LocalDate)seedDate, (LocalDate)(currentDate = DateUtils.getLocalDateOfTenant()).minusYears(1L)) ? currentDate.minusYears(1L) : recurrenceStartDate);
        return periodStartDate;
    }

    private LocalDate getPeriodEndDate(LocalDate endDate, LocalDate tillDate) {
        LocalDate periodEndDate = endDate;
        LocalDate currentDate = DateUtils.getLocalDateOfTenant();
        if (tillDate != null) {
            if (endDate != null) {
                if (DateUtils.isAfter((LocalDate)endDate, (LocalDate)tillDate)) {
                    periodEndDate = tillDate;
                }
            } else {
                periodEndDate = tillDate;
            }
        } else if (endDate == null || DateUtils.isAfter((LocalDate)endDate, (LocalDate)currentDate.plusYears(1L))) {
            periodEndDate = currentDate.plusYears(1L);
        }
        return periodEndDate;
    }

    public LocalDate generateNextEligibleMeetingDateForCollection(CalendarData calendarData, MeetingData lastMeetingData) {
        LocalDate lastMeetingDate = lastMeetingData == null ? null : lastMeetingData.getMeetingDate();
        CalendarData applicableCalendarData = calendarData;
        LocalDate nextEligibleMeetingDate = null;
        Integer numberOfDays = 0;
        boolean isSkipRepaymentOnFirstMonthEnabled = this.configurationDomainService.isSkippingMeetingOnFirstDayOfMonthEnabled();
        if (isSkipRepaymentOnFirstMonthEnabled) {
            numberOfDays = this.configurationDomainService.retreivePeriodInNumberOfDaysForSkipMeetingDate().intValue();
        }
        if (lastMeetingDate != null && !calendarData.isBetweenStartAndEndDate(lastMeetingDate) && !calendarData.isBetweenStartAndEndDate(DateUtils.getLocalDateOfTenant())) {
            applicableCalendarData = this.retrieveApplicableCalendarFromHistory(calendarData.getId(), lastMeetingDate);
            nextEligibleMeetingDate = CalendarUtils.getRecentEligibleMeetingDate((String)applicableCalendarData.getRecurrence(), (LocalDate)lastMeetingDate, (boolean)isSkipRepaymentOnFirstMonthEnabled, (Integer)numberOfDays);
        }
        if (nextEligibleMeetingDate == null) {
            LocalDate seedDate = lastMeetingDate != null ? lastMeetingDate : calendarData.getStartDate();
            nextEligibleMeetingDate = CalendarUtils.getRecentEligibleMeetingDate((String)applicableCalendarData.getRecurrence(), (LocalDate)seedDate, (boolean)isSkipRepaymentOnFirstMonthEnabled, (Integer)numberOfDays);
        } else if (calendarData.isBetweenStartAndEndDate(nextEligibleMeetingDate)) {
            nextEligibleMeetingDate = CalendarUtils.getRecentEligibleMeetingDate((String)applicableCalendarData.getRecurrence(), (LocalDate)calendarData.getStartDate(), (boolean)isSkipRepaymentOnFirstMonthEnabled, (Integer)numberOfDays);
        }
        return nextEligibleMeetingDate;
    }

    public Collection<CalendarData> updateWithRecurringDates(Collection<CalendarData> calendarsData) {
        ArrayList<CalendarData> recuCalendarsData = new ArrayList<CalendarData>();
        boolean withHistory = true;
        LocalDate tillDate = null;
        for (CalendarData calendarData : calendarsData) {
            Collection recurringDates = this.generateRecurringDates(calendarData, true, tillDate);
            Collection nextTenRecurringDates = this.generateNextTenRecurringDates(calendarData);
            LocalDate recentEligibleMeetingDate = null;
            CalendarData updatedCalendarData = CalendarData.withRecurringDates((CalendarData)calendarData, (Collection)recurringDates, (Collection)nextTenRecurringDates, recentEligibleMeetingDate);
            recuCalendarsData.add(updatedCalendarData);
        }
        return recuCalendarsData;
    }

    public CalendarData retrieveLoanCalendar(Long loanId) {
        CalendarData calendarData;
        block0: {
            CalendarData calendar;
            Iterator iterator;
            CalendarDataMapper rm = new CalendarDataMapper();
            String sql = rm.schema() + " and ci.entity_id = ? and ci.entity_type_enum = ? order by c.start_date ";
            calendarData = null;
            List calendars = this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{loanId, CalendarEntityType.LOANS.getValue()});
            if (CollectionUtils.isEmpty((Collection)calendars) || !(iterator = calendars.iterator()).hasNext()) break block0;
            calendarData = calendar = (CalendarData)iterator.next();
        }
        return calendarData;
    }

    public static String getParentHierarchyCondition(CalendarEntityType calendarEntityType) {
        String conditionSql = "";
        switch (1.$SwitchMap$org$apache$fineract$portfolio$calendar$domain$CalendarEntityType[calendarEntityType.ordinal()]) {
            case 1: {
                conditionSql = " and ci.entity_id in (select gc.group_id from m_client c join m_group_client gc  on c.id=gc.client_id where c.id = ? ) ";
                break;
            }
            case 2: {
                conditionSql = " and ci.entity_id in (select g.parent_id from m_group g where g.id = ? ) ";
                break;
            }
            case 3: {
                conditionSql = " and ci.entity_id = ?  ";
                break;
            }
        }
        return conditionSql;
    }

    private CalendarData retrieveApplicableCalendarFromHistory(Long calendarId, LocalDate compareDate) {
        try {
            CalendarDataFromHistoryMapper rm = new CalendarDataFromHistoryMapper();
            String sql = rm.schema() + " where c.calendar_id = ? and date(?) between c.start_date and c.end_date limit 1";
            return (CalendarData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{calendarId, compareDate});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    private Collection<CalendarData> retrieveCalendarsFromHistory(Long calendarId) {
        try {
            CalendarDataFromHistoryMapper rm = new CalendarDataFromHistoryMapper();
            String sql = rm.schema() + " where c.calendar_id = ? ";
            List calendars = this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{calendarId});
            return calendars;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Generated
    public CalendarReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, ConfigurationDomainService configurationDomainService) {
        this.jdbcTemplate = jdbcTemplate;
        this.configurationDomainService = configurationDomainService;
    }
}

