/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.charge.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.MonthDay;
import java.util.Collection;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargeData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountChargeData;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountChargeData;

public final class ConvertChargeDataToSpecificChargeData {
    private ConvertChargeDataToSpecificChargeData() {
    }

    public static LoanChargeData toLoanChargeData(ChargeData chargeData) {
        BigDecimal percentage = null;
        if ((Long)chargeData.getChargeCalculationType().getId() == 2L) {
            percentage = chargeData.getAmount();
        }
        return LoanChargeData.newLoanChargeDetails((Long)chargeData.getId(), (String)chargeData.getName(), (CurrencyData)chargeData.getCurrency(), (BigDecimal)chargeData.getAmount(), (BigDecimal)percentage, (EnumOptionData)chargeData.getChargeTimeType(), (EnumOptionData)chargeData.getChargeCalculationType(), (boolean)chargeData.isPenalty(), (EnumOptionData)chargeData.getChargePaymentMode(), (BigDecimal)chargeData.getMinCap(), (BigDecimal)chargeData.getMaxCap(), (ExternalId)ExternalId.empty());
    }

    public static SavingsAccountChargeData toSavingsAccountChargeData(ChargeData chargeData) {
        Long savingsChargeId = null;
        Long savingsAccountId = null;
        BigDecimal amountPaid = BigDecimal.ZERO;
        BigDecimal amountWaived = BigDecimal.ZERO;
        BigDecimal amountWrittenOff = BigDecimal.ZERO;
        BigDecimal amountOutstanding = BigDecimal.ZERO;
        BigDecimal percentage = BigDecimal.ZERO;
        BigDecimal amountPercentageAppliedTo = BigDecimal.ZERO;
        Collection chargeOptions = null;
        LocalDate dueAsOfDate = null;
        Boolean isActive = null;
        Boolean isFreeWithdrawal = null;
        Integer freeWithdrawalChargeFrequency = null;
        Integer restartFrequency = null;
        Integer restartFrequencyEnum = null;
        LocalDate inactivationDate = null;
        return SavingsAccountChargeData.instance(savingsChargeId, (Long)chargeData.getId(), savingsAccountId, (String)chargeData.getName(), (CurrencyData)chargeData.getCurrency(), (BigDecimal)chargeData.getAmount(), (BigDecimal)amountPaid, (BigDecimal)amountWaived, (BigDecimal)amountWrittenOff, (BigDecimal)amountOutstanding, (EnumOptionData)chargeData.getChargeTimeType(), dueAsOfDate, (EnumOptionData)chargeData.getChargeCalculationType(), (BigDecimal)percentage, (BigDecimal)amountPercentageAppliedTo, chargeOptions, (boolean)chargeData.isPenalty(), (MonthDay)chargeData.getFeeOnMonthDay(), (Integer)chargeData.getFeeInterval(), isActive, isFreeWithdrawal, freeWithdrawalChargeFrequency, restartFrequency, restartFrequencyEnum, inactivationDate);
    }

    public static ShareAccountChargeData toShareAccountChargeData(ChargeData chargeData) {
        Long shareChargeId = null;
        Long shareAccountId = null;
        BigDecimal amountPaid = BigDecimal.ZERO;
        BigDecimal amountWaived = BigDecimal.ZERO;
        BigDecimal amountWrittenOff = BigDecimal.ZERO;
        BigDecimal amountOutstanding = BigDecimal.ZERO;
        BigDecimal percentage = BigDecimal.ZERO;
        BigDecimal amountPercentageAppliedTo = BigDecimal.ZERO;
        Collection chargeOptions = null;
        Boolean isActive = null;
        BigDecimal chargeAmountOrPercentage = BigDecimal.ZERO;
        return new ShareAccountChargeData(shareChargeId, chargeData.getId(), shareAccountId, chargeData.getName(), chargeData.getCurrency(), chargeData.getAmount(), amountPaid, amountWaived, amountWrittenOff, amountOutstanding, chargeData.getChargeTimeType(), chargeData.getChargeCalculationType(), percentage, amountPercentageAppliedTo, chargeOptions, isActive, chargeAmountOrPercentage);
    }
}

