/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.address.data.AddressData;
import org.apache.fineract.portfolio.address.service.AddressReadPlatformServiceImpl;
import org.apache.fineract.portfolio.client.api.ClientAddressApiResourcesSwagger;
import org.springframework.stereotype.Component;

@Path(value="/v1/client")
@Component
@Tag(name="Clients Address", description="Address module is an optional module and can be configured into the system by using GlobalConfiguration setting: enable-address. In order to activate Address module, we need to enable the configuration, enable-address by setting its value to true.")
public class ClientAddressApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("addressId", "street", "addressLine1", "addressLine2", "addressLine3", "townVillage", "city", "countyDistrict", "stateProvinceId", "countryId", "postalCode", "latitude", "longitude", "createdBy", "createdOn", "updatedBy", "updatedOn", "clientAddressId", "client_id", "address_id", "address_type_id", "isActive", "fieldConfigurationId", "entity", "table", "field", "is_enabled", "is_mandatory", "validation_regex"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "Address";
    private final PlatformSecurityContext context;
    private final AddressReadPlatformServiceImpl readPlatformService;
    private final DefaultToApiJsonSerializer<AddressData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Path(value="addresses/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getAddressesTemplate(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        AddressData template = this.readPlatformService.retrieveTemplate();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)template, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Path(value="/{clientid}/addresses")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an address for a Client", description="Mandatory Fields : \ntype and clientId")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientAddressApiResourcesSwagger.PostClientClientIdAddressesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientAddressApiResourcesSwagger.PostClientClientIdAddressesResponse.class))})})
    public String addClientAddress(@QueryParam(value="type") @Parameter(description="type") long addressTypeId, @PathParam(value="clientid") @Parameter(description="clientId") long clientid, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().addClientAddress(clientid, addressTypeId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="/{clientid}/addresses")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all addresses for a Client", description="Example Requests:\n\nclient/1/addresses\n\n\nclients/1/addresses?status=false,true&&type=1,2,3")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ClientAddressApiResourcesSwagger.GetClientClientIdAddressesResponse.class)))})})
    public String getAddresses(@QueryParam(value="status") @Parameter(description="status") String status, @QueryParam(value="type") @Parameter(description="type") long addressTypeId, @PathParam(value="clientid") @Parameter(description="clientId") long clientid, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection address = addressTypeId == 0L && status == null ? this.readPlatformService.retrieveAllClientAddress(clientid) : (addressTypeId != 0L && status == null ? this.readPlatformService.retrieveAddressbyType(clientid, addressTypeId) : (addressTypeId != 0L && status != null ? this.readPlatformService.retrieveAddressbyTypeAndStatus(clientid, addressTypeId, status) : this.readPlatformService.retrieveAddressbyStatus(clientid, status)));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, address, RESPONSE_DATA_PARAMETERS);
    }

    @PUT
    @Path(value="/{clientid}/addresses")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an address for a Client", description="All the address fields can be updated by using update client address API\n\nMandatory Fields\ntype and addressId")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientAddressApiResourcesSwagger.PutClientClientIdAddressesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientAddressApiResourcesSwagger.PutClientClientIdAddressesResponse.class))})})
    public String updateClientAddress(@PathParam(value="clientid") @Parameter(description="clientId") long clientid, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateClientAddress(clientid).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public ClientAddressApiResource(PlatformSecurityContext context, AddressReadPlatformServiceImpl readPlatformService, DefaultToApiJsonSerializer<AddressData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

