/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.client.api.ClientApiConstants;
import org.apache.fineract.portfolio.client.api.ClientChargesApiResourceSwagger;
import org.apache.fineract.portfolio.client.data.ClientChargeData;
import org.apache.fineract.portfolio.client.service.ClientChargeReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientTransactionReadPlatformService;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Path(value="/v1/clients/{clientId}/charges")
@Component
@Tag(name="Client Charges", description="It is typical for MFI's to directly associate charges with an implicit Client account. These can be either fees or penalties\n\nClient Charges are client specific instances of Charges. Refer Charges for documentation of the various properties of a charge, Only additional properties ( specific to the context of a Charge being associated with a Client account) are described here")
public class ClientChargesApiResource {
    private final PlatformSecurityContext context;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final ClientChargeReadPlatformService clientChargeReadPlatformService;
    private final ClientTransactionReadPlatformService clientTransactionReadPlatformService;
    private final DefaultToApiJsonSerializer<ClientChargeData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Client Charges", description="The list capability of client charges supports pagination.Example Requests:\nclients/1/charges\n\nclients/1/charges?offset=0&limit=5")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientChargesApiResourceSwagger.GetClientsClientIdChargesResponse.class))})})
    public String retrieveAllClientCharges(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @DefaultValue(value="all") @QueryParam(value="chargeStatus") @Parameter(description="chargeStatus") String chargeStatus, @QueryParam(value="pendingPayment") @Parameter(description="pendingPayment") Boolean pendingPayment, @Context UriInfo uriInfo, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="offset") @Parameter(description="offset") Integer offset) {
        this.context.authenticatedUser().validateHasReadPermission("CLIENTCHARGE");
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (!(this.is(chargeStatus, "all") || this.is(chargeStatus, "active") || this.is(chargeStatus, "inactive"))) {
            throw new UnrecognizedQueryParamException("chargeStatus", chargeStatus, new Object[]{"all", "active", "inactive"});
        }
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).offset(offset).build();
        Page clientCharges = this.clientChargeReadPlatformService.retrieveClientCharges(clientId, chargeStatus, pendingPayment, searchParameters);
        return this.toApiJsonSerializer.serialize(settings, clientCharges, ClientApiConstants.CLIENT_CHARGES_RESPONSE_DATA_PARAMETERS);
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveTemplate(@Context UriInfo uriInfo, @PathParam(value="clientId") @Parameter(description="clientId") Long clientId) {
        this.context.authenticatedUser().validateHasReadPermission("CLIENTCHARGE");
        Collection chargeOptions = this.chargeReadPlatformService.retrieveAllChargesApplicableToClients();
        ClientChargeData clientChargeData = ClientChargeData.template((Collection)chargeOptions);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)clientChargeData, ClientApiConstants.CLIENT_CHARGES_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{chargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Client Charge", description="Example Requests:\nclients/1/charges/1\n\n\nclients/1/charges/1?fields=name,id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientChargesApiResourceSwagger.GetClientsClientIdChargesResponse.GetClientsChargesPageItems.class))})})
    public String retrieveClientCharge(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="chargeId") @Parameter(description="chargeId") Long chargeId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("CLIENTCHARGE");
        ClientChargeData clientCharge = this.clientChargeReadPlatformService.retrieveClientCharge(clientId, chargeId);
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        if (!associationParameters.isEmpty()) {
            Collection clientTransactionDatas;
            if (associationParameters.contains("all")) {
                associationParameters.addAll(Arrays.asList("transactions"));
            }
            ApiParameterHelper.excludeAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters(), (Set)associationParameters);
            if (associationParameters.contains("transactions") && !CollectionUtils.isEmpty((Collection)(clientTransactionDatas = this.clientTransactionReadPlatformService.retrieveAllTransactions(clientId, chargeId)))) {
                clientCharge = ClientChargeData.addAssociations((ClientChargeData)clientCharge, (Collection)clientTransactionDatas);
            }
        }
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)clientCharge, ClientApiConstants.CLIENT_CHARGES_RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Add Client Charge", description=" This API associates a Client charge with an implicit Client account\nMandatory Fields : \nchargeId and dueDate  \nOptional Fields : \namount")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientChargesApiResourceSwagger.PostClientsClientIdChargesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientChargesApiResourceSwagger.PostClientsClientIdChargesResponse.class))})})
    public String applyClientCharge(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createClientCharge(clientId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{chargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Pay a Client Charge | Waive a Client Charge", description="Pay a Client Charge:\n\nMandatory Fields:transactionDate and amount \"Pay either a part of or the entire due amount for a charge.(command=paycharge)\n\nWaive a Client Charge:\n\n\nThis API provides the facility of waiving off the remaining amount on a client charge (command=waive)\n\nShowing request/response for 'Pay a Client Charge'")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientChargesApiResourceSwagger.PostClientsClientIdChargesChargeIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientChargesApiResourceSwagger.PostClientsClientIdChargesChargeIdResponse.class))})})
    public String payOrWaiveClientCharge(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="chargeId") @Parameter(description="chargeId") Long chargeId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        String json = "";
        if (this.is(commandParam, "waive")) {
            CommandWrapper commandRequest = new CommandWrapperBuilder().waiveClientCharge(clientId, chargeId).withJson(apiRequestBodyAsJson).build();
            CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            json = this.toApiJsonSerializer.serialize((Object)result);
        } else if (this.is(commandParam, "paycharge")) {
            CommandWrapper commandRequest = new CommandWrapperBuilder().payClientCharge(clientId, chargeId).withJson(apiRequestBodyAsJson).build();
            CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            json = this.toApiJsonSerializer.serialize((Object)result);
        } else if (this.is(commandParam, "inactivate")) {
            CommandWrapper commandRequest = new CommandWrapperBuilder().inactivateClientCharge(clientId, chargeId).build();
            CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            json = this.toApiJsonSerializer.serialize((Object)result);
        } else {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"waive", "paycharge", "inactivate"});
        }
        return json;
    }

    @DELETE
    @Path(value="{chargeId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Client Charge", description="Deletes a Client Charge on which no transactions have taken place (either payments or waivers). ")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientChargesApiResourceSwagger.DeleteClientsClientIdChargesChargeIdResponse.class))})})
    public String deleteClientCharge(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @PathParam(value="chargeId") @Parameter(description="chargeId") Long chargeId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteClientCharge(clientId, chargeId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public ClientChargesApiResource(PlatformSecurityContext context, ChargeReadPlatformService chargeReadPlatformService, ClientChargeReadPlatformService clientChargeReadPlatformService, ClientTransactionReadPlatformService clientTransactionReadPlatformService, DefaultToApiJsonSerializer<ClientChargeData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.clientChargeReadPlatformService = clientChargeReadPlatformService;
        this.clientTransactionReadPlatformService = clientTransactionReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

