/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.api;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.data.ClientFamilyMembersData;
import org.apache.fineract.portfolio.client.service.ClientFamilyMembersReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/clients/{clientId}/familymembers")
@Component
@Tag(name="Client Family Member", description="")
public class ClientFamilyMembersApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "clientId", "firstName", "middleName", "lastName", "qualification", "relationship", "maritalStatus", "gender", "dateOfBirth", "profession", "clientFamilyMemberId"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "FamilyMembers";
    private final PlatformSecurityContext context;
    private final ClientFamilyMembersReadPlatformService readPlatformService;
    private final ToApiJsonSerializer<ClientFamilyMembersData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Path(value="/{familyMemberId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getFamilyMember(@Context UriInfo uriInfo, @PathParam(value="familyMemberId") Long familyMemberId, @PathParam(value="clientId") @Parameter(description="clientId") Long clientId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ClientFamilyMembersData familyMembers = this.readPlatformService.getClientFamilyMember(familyMemberId.longValue());
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)familyMembers, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getFamilyMembers(@Context UriInfo uriInfo, @PathParam(value="clientId") long clientId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection familyMembers = this.readPlatformService.getClientFamilyMembers(clientId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, familyMembers, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getTemplate(@Context UriInfo uriInfo, @PathParam(value="clientId") long clientId) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ClientFamilyMembersData options = this.readPlatformService.retrieveTemplate();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)options, RESPONSE_DATA_PARAMETERS);
    }

    @PUT
    @Path(value="/{familyMemberId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String updateClientFamilyMembers(@PathParam(value="familyMemberId") long familyMemberId, String apiRequestBodyAsJson, @PathParam(value="clientId") @Parameter(description="clientId") Long clientId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateFamilyMembers(familyMemberId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String addClientFamilyMembers(@PathParam(value="clientId") long clientid, String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().addFamilyMembers(clientid).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="/{familyMemberId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String deleteClientFamilyMembers(@PathParam(value="familyMemberId") long familyMemberId, String apiRequestBodyAsJson, @PathParam(value="clientId") @Parameter(description="clientId") Long clientId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteFamilyMembers(familyMemberId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public ClientFamilyMembersApiResource(PlatformSecurityContext context, ClientFamilyMembersReadPlatformService readPlatformService, ToApiJsonSerializer<ClientFamilyMembersData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

