/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.service;

import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.data.ClientIdentifierData;
import org.apache.fineract.portfolio.client.exception.ClientIdentifierNotFoundException;
import org.apache.fineract.portfolio.client.service.ClientIdentifierReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientIdentifierReadPlatformServiceImpl;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ClientIdentifierReadPlatformServiceImpl
implements ClientIdentifierReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    public Collection<ClientIdentifierData> retrieveClientIdentifiers(Long clientId) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        ClientIdentityMapper rm = new ClientIdentityMapper();
        String sql = "select " + rm.schema();
        sql = sql + " order by ci.id";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{clientId, hierarchySearchString});
    }

    public ClientIdentifierData retrieveClientIdentifier(Long clientId, Long clientIdentifierId) {
        try {
            AppUser currentUser = this.context.authenticatedUser();
            String hierarchy = currentUser.getOffice().getHierarchy();
            String hierarchySearchString = hierarchy + "%";
            ClientIdentityMapper rm = new ClientIdentityMapper();
            String sql = "select " + rm.schema();
            sql = sql + " and ci.id = ?";
            ClientIdentifierData clientIdentifierData = (ClientIdentifierData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{clientId, hierarchySearchString, clientIdentifierId});
            return clientIdentifierData;
        }
        catch (EmptyResultDataAccessException e) {
            throw new ClientIdentifierNotFoundException(clientIdentifierId, e);
        }
    }

    @Generated
    public ClientIdentifierReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
    }
}

