/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksReadService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.address.data.AddressData;
import org.apache.fineract.portfolio.address.service.AddressReadPlatformService;
import org.apache.fineract.portfolio.client.data.ClientCollateralManagementData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.data.ClientFamilyMembersData;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientEnumerations;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.ClientStatus;
import org.apache.fineract.portfolio.client.domain.LegalForm;
import org.apache.fineract.portfolio.client.exception.ClientNotFoundException;
import org.apache.fineract.portfolio.client.mapper.ClientMapper;
import org.apache.fineract.portfolio.client.service.ClientFamilyMembersReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformServiceImpl;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagement;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagementRepositoryWrapper;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ClientReadPlatformServiceImpl
implements ClientReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final StaffReadPlatformService staffReadPlatformService;
    private final CodeValueReadPlatformService codeValueReadPlatformService;
    private final SavingsProductReadPlatformService savingsProductReadPlatformService;
    private final PaginationHelper paginationHelper;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final ClientToDataMapper clientToDataMapper = new ClientToDataMapper();
    private final ClientLookupMapper lookupMapper = new ClientLookupMapper();
    private final ClientMembersOfGroupMapper membersOfGroupMapper = new ClientMembersOfGroupMapper();
    private final ParentGroupsMapper clientGroupsMapper = new ParentGroupsMapper();
    private final AddressReadPlatformService addressReadPlatformService;
    private final ClientFamilyMembersReadPlatformService clientFamilyMembersReadPlatformService;
    private final EntityDatatableChecksReadService entityDatatableChecksReadService;
    private final ColumnValidator columnValidator;
    private final ClientCollateralManagementRepositoryWrapper clientCollateralManagementRepositoryWrapper;
    private final ConfigurationDomainService configurationDomainService;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final ClientMapper clientMapper;

    public ClientData retrieveTemplate(Long officeId, boolean staffInSelectedOfficeOnly) {
        this.context.authenticatedUser();
        Long defaultOfficeId = this.defaultToUsersOfficeIfNull(officeId);
        AddressData address = null;
        Collection offices = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
        Collection savingsProductDatas = this.savingsProductReadPlatformService.retrieveAllForLookupByType(null);
        Boolean isAddressEnabled = this.configurationDomainService.isAddressEnabled();
        if (isAddressEnabled.booleanValue()) {
            address = this.addressReadPlatformService.retrieveTemplate();
        }
        ClientFamilyMembersData familyMemberOptions = this.clientFamilyMembersReadPlatformService.retrieveTemplate();
        Collection staffOptions = null;
        boolean loanOfficersOnly = false;
        staffOptions = staffInSelectedOfficeOnly ? this.staffReadPlatformService.retrieveAllStaffForDropdown(defaultOfficeId) : this.staffReadPlatformService.retrieveAllStaffInOfficeAndItsParentOfficeHierarchy(defaultOfficeId, false);
        if (CollectionUtils.isEmpty((Collection)staffOptions)) {
            staffOptions = null;
        }
        ArrayList genderOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Gender"));
        ArrayList clientTypeOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientType"));
        ArrayList clientClassificationOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientClassification"));
        ArrayList clientNonPersonConstitutionOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Constitution"));
        ArrayList clientNonPersonMainBusinessLineOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Main Business Line"));
        List clientLegalFormOptions = ClientEnumerations.legalForm((LegalForm[])LegalForm.values());
        List datatableTemplates = this.entityDatatableChecksReadService.retrieveTemplates(StatusEnum.CREATE.getValue(), EntityTables.CLIENT.getName(), null);
        return ClientData.template((Long)defaultOfficeId, (LocalDate)LocalDate.now(DateUtils.getDateTimeZoneOfTenant()), (Collection)offices, (Collection)staffOptions, null, genderOptions, (Collection)savingsProductDatas, clientTypeOptions, clientClassificationOptions, clientNonPersonConstitutionOptions, clientNonPersonMainBusinessLineOptions, (List)clientLegalFormOptions, (ClientFamilyMembersData)familyMemberOptions, new ArrayList<AddressData>(Arrays.asList(address)), (Boolean)isAddressEnabled, (List)datatableTemplates);
    }

    public Page<ClientData> retrieveAll(SearchParameters searchParameters) {
        if (searchParameters != null && searchParameters.getStatus() != null && ClientStatus.fromString((String)searchParameters.getStatus()) == ClientStatus.INVALID) {
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            String defaultUserMessage = "The Status value '" + searchParameters.getStatus() + "' is not supported.";
            ApiParameterError error = ApiParameterError.parameterError((String)"validation.msg.client.status.value.is.not.supported", (String)defaultUserMessage, (String)"status", (Object[])new Object[]{searchParameters.getStatus()});
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        String userOfficeHierarchy = this.context.officeHierarchy();
        String underHierarchySearchString = userOfficeHierarchy + "%";
        String appUserID = String.valueOf(this.context.authenticatedUser().getId());
        ArrayList<String> paramList = new ArrayList<String>(Arrays.asList(underHierarchySearchString, underHierarchySearchString));
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(this.clientToDataMapper.schema());
        sqlBuilder.append(" where (o.hierarchy like ? or transferToOffice.hierarchy like ?) ");
        if (searchParameters != null) {
            String extraCriteria;
            if (searchParameters.getIsSelfUser().booleanValue()) {
                sqlBuilder.append(" and c.id in (select umap.client_id from m_selfservice_user_client_mapping as umap where umap.appuser_id = ? ) ");
                paramList.add(appUserID);
            }
            if (StringUtils.isNotBlank((CharSequence)(extraCriteria = this.buildSqlStringFromClientCriteria(this.clientToDataMapper.schema(), searchParameters, paramList)))) {
                sqlBuilder.append(" and (").append(extraCriteria).append(")");
            }
            if (searchParameters.hasOrderBy()) {
                sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
                if (searchParameters.hasSortOrder()) {
                    sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                    this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
                }
            }
            if (searchParameters.hasLimit()) {
                sqlBuilder.append(" ");
                if (searchParameters.hasOffset()) {
                    sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
                } else {
                    sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
                }
            }
        }
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), paramList.toArray(), (RowMapper)this.clientToDataMapper);
    }

    private String buildSqlStringFromClientCriteria(String schemaSql, SearchParameters searchParameters, List<Object> paramList) {
        Long officeId = searchParameters.getOfficeId();
        String externalId = searchParameters.getExternalId();
        String displayName = searchParameters.getName();
        String firstname = searchParameters.getFirstname();
        String lastname = searchParameters.getLastname();
        String status = searchParameters.getStatus();
        Object extraCriteria = "";
        if (officeId != null) {
            extraCriteria = (String)extraCriteria + " and c.office_id = ? ";
            paramList.add(officeId);
        }
        if (externalId != null) {
            paramList.add(externalId);
            extraCriteria = (String)extraCriteria + " and c.external_id like ? ";
        }
        if (displayName != null) {
            paramList.add("%" + displayName + "%");
            extraCriteria = (String)extraCriteria + " and c.display_name like ? ";
        }
        if (status != null) {
            ClientStatus clientStatus = ClientStatus.fromString((String)status);
            extraCriteria = (String)extraCriteria + " and c.status_enum = " + clientStatus.getValue().toString() + " ";
        }
        if (firstname != null) {
            paramList.add(firstname);
            extraCriteria = (String)extraCriteria + " and c.firstname like ? ";
        }
        if (lastname != null) {
            paramList.add(lastname);
            extraCriteria = (String)extraCriteria + " and c.lastname like ? ";
        }
        if (searchParameters.hasHierarchy()) {
            paramList.add(searchParameters.getHierarchy() + "%");
            extraCriteria = (String)extraCriteria + " and o.hierarchy like ? ";
        }
        if (searchParameters.getOrphansOnly().booleanValue()) {
            extraCriteria = (String)extraCriteria + " and c.id NOT IN (select client_id from m_group_client) ";
        }
        if (StringUtils.isNotBlank((CharSequence)extraCriteria)) {
            extraCriteria = ((String)extraCriteria).substring(4);
        }
        return extraCriteria;
    }

    public ClientData retrieveOne(Long clientId) {
        try {
            String hierarchy = this.context.officeHierarchy();
            String hierarchySearchString = hierarchy + "%";
            Client client = this.clientRepositoryWrapper.getClientByClientIdAndHierarchy(clientId, hierarchySearchString);
            ClientData clientData = this.clientMapper.map(client);
            List clientCollateralManagements = this.clientCollateralManagementRepositoryWrapper.getCollateralsPerClient(clientId);
            HashSet<ClientCollateralManagementData> clientCollateralManagementDataSet = new HashSet<ClientCollateralManagementData>();
            for (ClientCollateralManagement clientCollateralManagement : clientCollateralManagements) {
                BigDecimal total = clientCollateralManagement.getTotal();
                BigDecimal totalCollateral = clientCollateralManagement.getTotalCollateral(total);
                clientCollateralManagementDataSet.add(new ClientCollateralManagementData((Long)clientCollateralManagement.getId(), clientCollateralManagement.getCollaterals().getName(), clientCollateralManagement.getQuantity(), clientCollateralManagement.getCollaterals().getPctToBase(), clientCollateralManagement.getCollaterals().getBasePrice(), total, totalCollateral));
            }
            String clientGroupsSql = "select " + this.clientGroupsMapper.parentGroupsSchema();
            List parentGroups = this.jdbcTemplate.query(clientGroupsSql, (RowMapper)this.clientGroupsMapper, new Object[]{clientId});
            return ClientData.setParentGroups((ClientData)clientData, (Collection)parentGroups, clientCollateralManagementDataSet);
        }
        catch (EmptyResultDataAccessException e) {
            throw new ClientNotFoundException(clientId, e);
        }
    }

    public Collection<ClientData> retrieveAllForLookup(String extraCriteria) {
        String sql = "select " + this.lookupMapper.schema();
        if (StringUtils.isNotBlank((CharSequence)extraCriteria)) {
            sql = sql + " and (" + extraCriteria + ")";
            this.columnValidator.validateSqlInjection(sql, new String[]{extraCriteria});
        }
        return this.jdbcTemplate.query(sql, (RowMapper)this.lookupMapper);
    }

    public Collection<ClientData> retrieveAllForLookupByOfficeId(Long officeId) {
        String sql = "select " + this.lookupMapper.schema() + " where c.office_id = ? and c.status_enum != ?";
        return this.jdbcTemplate.query(sql, (RowMapper)this.lookupMapper, new Object[]{officeId, ClientStatus.CLOSED.getValue()});
    }

    public Collection<ClientData> retrieveClientMembersOfGroup(Long groupId) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        String sql = "select " + this.membersOfGroupMapper.schema() + " where o.hierarchy like ? and pgc.group_id = ?";
        return this.jdbcTemplate.query(sql, (RowMapper)this.membersOfGroupMapper, new Object[]{hierarchySearchString, groupId});
    }

    public Collection<ClientData> retrieveActiveClientMembersOfGroup(Long groupId) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        String sql = "select " + this.membersOfGroupMapper.schema() + " where o.hierarchy like ? and pgc.group_id = ? and c.status_enum = ? ";
        return this.jdbcTemplate.query(sql, (RowMapper)this.membersOfGroupMapper, new Object[]{hierarchySearchString, groupId, ClientStatus.ACTIVE.getValue()});
    }

    public Collection<ClientData> retrieveActiveClientMembersOfCenter(Long centerId) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        String sql = "select " + this.membersOfGroupMapper.schema() + " left join m_group g on pgc.group_id=g.id where o.hierarchy like ? and g.parent_id = ? and c.status_enum = ? group by c.id";
        return this.jdbcTemplate.query(sql, (RowMapper)this.membersOfGroupMapper, new Object[]{hierarchySearchString, centerId, ClientStatus.ACTIVE.getValue()});
    }

    public ClientData retrieveClientByIdentifier(Long identifierTypeId, String identifierKey) {
        try {
            ClientIdentifierMapper mapper = new ClientIdentifierMapper();
            String sql = "select " + mapper.clientLookupByIdentifierSchema();
            return (ClientData)this.jdbcTemplate.queryForObject(sql, (RowMapper)mapper, new Object[]{identifierTypeId, identifierKey});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    private Long defaultToUsersOfficeIfNull(Long officeId) {
        Long defaultOfficeId = officeId;
        if (defaultOfficeId == null) {
            defaultOfficeId = (Long)this.context.authenticatedUser().getOffice().getId();
        }
        return defaultOfficeId;
    }

    public ClientData retrieveAllNarrations(String clientNarrations) {
        ArrayList narrations = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode(clientNarrations));
        Collection clientTypeOptions = null;
        Collection clientClassificationOptions = null;
        Collection clientNonPersonConstitutionOptions = null;
        Collection clientNonPersonMainBusinessLineOptions = null;
        List clientLegalFormOptions = null;
        return ClientData.template(null, null, null, null, narrations, null, null, clientTypeOptions, clientClassificationOptions, clientNonPersonConstitutionOptions, clientNonPersonMainBusinessLineOptions, clientLegalFormOptions, null, null, null, null);
    }

    public LocalDate retrieveClientTransferProposalDate(Long clientId) {
        String sql = "SELECT cl.proposed_transfer_date FROM m_client cl WHERE cl.id = ? ";
        try {
            return (LocalDate)this.jdbcTemplate.queryForObject("SELECT cl.proposed_transfer_date FROM m_client cl WHERE cl.id = ? ", LocalDate.class, new Object[]{clientId});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public Collection<Long> retrieveUserClients(Long aUserID) {
        String sql = "SELECT  m.client_id FROM m_selfservice_user_client_mapping m INNER JOIN m_client c ON c.id = m.client_id WHERE m.appuser_id = ?";
        return this.jdbcTemplate.queryForList(sql, Long.class, new Object[]{aUserID});
    }

    public Long retrieveClientIdByExternalId(ExternalId externalId) {
        return this.clientRepositoryWrapper.findIdByExternalId(externalId);
    }

    @Generated
    public ClientReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, OfficeReadPlatformService officeReadPlatformService, StaffReadPlatformService staffReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService, SavingsProductReadPlatformService savingsProductReadPlatformService, PaginationHelper paginationHelper, DatabaseSpecificSQLGenerator sqlGenerator, AddressReadPlatformService addressReadPlatformService, ClientFamilyMembersReadPlatformService clientFamilyMembersReadPlatformService, EntityDatatableChecksReadService entityDatatableChecksReadService, ColumnValidator columnValidator, ClientCollateralManagementRepositoryWrapper clientCollateralManagementRepositoryWrapper, ConfigurationDomainService configurationDomainService, ClientRepositoryWrapper clientRepositoryWrapper, ClientMapper clientMapper) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
        this.officeReadPlatformService = officeReadPlatformService;
        this.staffReadPlatformService = staffReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
        this.savingsProductReadPlatformService = savingsProductReadPlatformService;
        this.paginationHelper = paginationHelper;
        this.sqlGenerator = sqlGenerator;
        this.addressReadPlatformService = addressReadPlatformService;
        this.clientFamilyMembersReadPlatformService = clientFamilyMembersReadPlatformService;
        this.entityDatatableChecksReadService = entityDatatableChecksReadService;
        this.columnValidator = columnValidator;
        this.clientCollateralManagementRepositoryWrapper = clientCollateralManagementRepositoryWrapper;
        this.configurationDomainService = configurationDomainService;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.clientMapper = clientMapper;
    }
}

