/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.portfolio.collateralmanagement.api.CollateralManagementApiResourceSwagger;
import org.apache.fineract.portfolio.collateralmanagement.api.CollateralManagementJsonInputParams;
import org.apache.fineract.portfolio.collateralmanagement.data.CollateralManagementData;
import org.apache.fineract.portfolio.collateralmanagement.service.CollateralManagementReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/collateral-management")
@Component
@Tag(name="Collateral Management", description="Collateral Management is for managing collateral operations")
public class CollateralManagementApiResource {
    private final DefaultToApiJsonSerializer<CollateralManagementData> apiJsonSerializerService;
    private final DefaultToApiJsonSerializer<CurrencyData> apiJsonSerializerServiceForCurrency;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final PlatformSecurityContext context;
    private final CollateralManagementReadPlatformService collateralManagementReadPlatformService;
    private final CurrencyReadPlatformService currencyReadPlatformService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a new collateral", description="Collateral Creation")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CollateralManagementApiResourceSwagger.PostCollateralManagementProductRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralManagementApiResourceSwagger.PostCollateralManagementProductResponse.class))})})
    public String createCollateral(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().createCollateral().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.apiJsonSerializerService.serialize((Object)commandProcessingResult);
    }

    @GET
    @Path(value="{collateralId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get Collateral", description="Fetch Collateral")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralManagementApiResourceSwagger.GetCollateralManagementsResponse.class))})})
    public String getCollateral(@PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(CollateralManagementJsonInputParams.COLLATERAL_PRODUCT_READ_PERMISSION.getValue());
        CollateralManagementData collateralManagementData = this.collateralManagementReadPlatformService.getCollateralProduct(collateralId);
        return this.apiJsonSerializerService.serialize((Object)collateralManagementData);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get All Collaterals", description="Fetch all Collateral Products")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=CollateralManagementApiResourceSwagger.GetCollateralManagementsResponse.class)))})})
    public String getAllCollaterals(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(CollateralManagementJsonInputParams.COLLATERAL_PRODUCT_READ_PERMISSION.getValue());
        List collateralManagementDataList = this.collateralManagementReadPlatformService.getAllCollateralProducts();
        return this.apiJsonSerializerService.serialize((Object)collateralManagementDataList);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get Collateral Template", description="Get Collateral Template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=CollateralManagementApiResourceSwagger.GetCollateralProductTemplate.class)))})})
    public String getCollateralTemplate(@Context UriInfo uriInfo) {
        Collection currencyDataCollection = this.currencyReadPlatformService.retrieveAllPlatformCurrencies();
        return this.apiJsonSerializerServiceForCurrency.serialize((Object)currencyDataCollection);
    }

    @PUT
    @Path(value="{collateralId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update Collateral", description="Update Collateral")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=CollateralManagementApiResourceSwagger.PutCollateralProductRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralManagementApiResourceSwagger.PutCollateralProductResponse.class))})})
    public String updateCollateral(@PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId, @Parameter(hidden=true) String jsonBody) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().updateCollateralProduct(collateralId).withJson(jsonBody).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.apiJsonSerializerService.serialize((Object)commandProcessingResult);
    }

    @DELETE
    @Path(value="{collateralId}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Delete a Collateral", description="Delete Collateral")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CollateralManagementApiResourceSwagger.DeleteCollateralProductResponse.class))})})
    public String deleteCollateral(@PathParam(value="collateralId") @Parameter(description="collateralId") Long collateralId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteCollateralProduct(collateralId).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.apiJsonSerializerService.serialize((Object)commandProcessingResult);
    }

    @Generated
    public CollateralManagementApiResource(DefaultToApiJsonSerializer<CollateralManagementData> apiJsonSerializerService, DefaultToApiJsonSerializer<CurrencyData> apiJsonSerializerServiceForCurrency, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, PlatformSecurityContext context, CollateralManagementReadPlatformService collateralManagementReadPlatformService, CurrencyReadPlatformService currencyReadPlatformService) {
        this.apiJsonSerializerService = apiJsonSerializerService;
        this.apiJsonSerializerServiceForCurrency = apiJsonSerializerServiceForCurrency;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.context = context;
        this.collateralManagementReadPlatformService = collateralManagementReadPlatformService;
        this.currencyReadPlatformService = currencyReadPlatformService;
    }
}

