/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.group.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.core.data.PaginationParameters;
import org.apache.fineract.infrastructure.core.data.PaginationParametersDataValidator;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.infrastructure.security.utils.SQLBuilder;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.fineract.portfolio.group.domain.GroupTypes;
import org.apache.fineract.portfolio.group.exception.GroupNotFoundException;
import org.apache.fineract.portfolio.group.service.AllGroupTypesDataMapper;
import org.apache.fineract.portfolio.group.service.CenterReadPlatformService;
import org.apache.fineract.portfolio.group.service.GroupReadPlatformService;
import org.apache.fineract.portfolio.group.service.GroupReadPlatformServiceImpl;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class GroupReadPlatformServiceImpl
implements GroupReadPlatformService {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String OFFICE_ID = "officeId";
    public static final String OFFICE_NAME = "officeName";
    private static final AllGroupTypesDataMapper ALL_GROUP_TYPES_DATA_MAPPER = new AllGroupTypesDataMapper();
    private static final Set<String> SUPPORTED_ORDER_BY_VALUES = new HashSet<String>(Arrays.asList("id", "name", "officeId", "officeName"));
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final StaffReadPlatformService staffReadPlatformService;
    private final CenterReadPlatformService centerReadPlatformService;
    private final CodeValueReadPlatformService codeValueReadPlatformService;
    private final PaginationHelper paginationHelper;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PaginationParametersDataValidator paginationParametersDataValidator;
    private final ColumnValidator columnValidator;
    private final ClientReadPlatformService clientReadPlatformService;

    public GroupGeneralData retrieveTemplate(Long officeId, boolean isCenterGroup, boolean staffInSelectedOfficeOnly) {
        Long defaultOfficeId = this.defaultToUsersOfficeIfNull(officeId);
        Collection centerOptions = null;
        if (isCenterGroup) {
            centerOptions = this.centerReadPlatformService.retrieveAllForDropdown(defaultOfficeId);
        }
        Collection officeOptions = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
        boolean loanOfficersOnly = false;
        Collection staffOptions = null;
        staffOptions = staffInSelectedOfficeOnly ? this.staffReadPlatformService.retrieveAllStaffForDropdown(defaultOfficeId) : this.staffReadPlatformService.retrieveAllStaffInOfficeAndItsParentOfficeHierarchy(defaultOfficeId, false);
        if (CollectionUtils.isEmpty((Collection)staffOptions)) {
            staffOptions = null;
        }
        List availableRoles = this.codeValueReadPlatformService.retrieveCodeValuesByCode("GROUPROLE");
        Long centerId = null;
        String accountNo = null;
        String centerName = null;
        Long staffId = null;
        String staffName = null;
        Collection clientOptions = null;
        return GroupGeneralData.template((Long)defaultOfficeId, centerId, accountNo, centerName, staffId, staffName, (Collection)centerOptions, (Collection)officeOptions, (Collection)staffOptions, clientOptions, (Collection)availableRoles);
    }

    private Long defaultToUsersOfficeIfNull(Long officeId) {
        Long defaultOfficeId = officeId;
        if (defaultOfficeId == null) {
            defaultOfficeId = (Long)this.context.authenticatedUser().getOffice().getId();
        }
        return defaultOfficeId;
    }

    public Page<GroupGeneralData> retrievePagedAll(SearchParameters searchParameters, PaginationParameters parameters) {
        this.paginationParametersDataValidator.validateParameterValues(parameters, SUPPORTED_ORDER_BY_VALUES, "audits");
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(ALL_GROUP_TYPES_DATA_MAPPER.schema());
        SQLBuilder extraCriteria = this.getGroupExtraCriteria(searchParameters);
        extraCriteria.addCriteria(" o.hierarchy like ", (Object)hierarchySearchString);
        sqlBuilder.append(" ").append(extraCriteria.getSQLTemplate());
        if (parameters.hasOrderBy()) {
            sqlBuilder.append(" order by ").append(searchParameters.getOrderBy()).append(' ').append(searchParameters.getSortOrder());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy(), searchParameters.getSortOrder()});
        }
        if (parameters.hasLimit()) {
            sqlBuilder.append(" limit ").append(searchParameters.getLimit());
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(" offset ").append(searchParameters.getOffset());
            }
        }
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), extraCriteria.getArguments(), (RowMapper)ALL_GROUP_TYPES_DATA_MAPPER);
    }

    public Collection<GroupGeneralData> retrieveAll(SearchParameters searchParameters, PaginationParameters parameters) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        String hierarchySearchString = hierarchy + "%";
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select ");
        sqlBuilder.append(ALL_GROUP_TYPES_DATA_MAPPER.schema());
        SQLBuilder extraCriteria = this.getGroupExtraCriteria(searchParameters);
        extraCriteria.addCriteria("o.hierarchy like ", (Object)hierarchySearchString);
        sqlBuilder.append(" ").append(extraCriteria.getSQLTemplate());
        if (searchParameters != null && searchParameters.getOrphansOnly().booleanValue()) {
            sqlBuilder.append(" and g.parent_id is NULL");
        }
        if (parameters != null) {
            if (parameters.hasOrderBy()) {
                sqlBuilder.append(parameters.orderBySql());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{parameters.orderBySql()});
            }
            if (parameters.hasLimit()) {
                sqlBuilder.append(parameters.limitSql());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{parameters.limitSql()});
            }
        }
        return this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)ALL_GROUP_TYPES_DATA_MAPPER, extraCriteria.getArguments());
    }

    private SQLBuilder getGroupExtraCriteria(SearchParameters searchCriteria) {
        String hierarchy;
        SQLBuilder extraCriteria = new SQLBuilder();
        if (searchCriteria == null) {
            return extraCriteria;
        }
        extraCriteria.addCriteria("g.level_Id = ", (Object)GroupTypes.GROUP.getId());
        extraCriteria.addNonNullCriteria(" g.office_id = ", (Object)searchCriteria.getOfficeId());
        extraCriteria.addNonNullCriteria(" g.external_id =", (Object)searchCriteria.getExternalId());
        String name = searchCriteria.getName();
        if (name != null) {
            extraCriteria.addNonNullCriteria("g.display_name like", (Object)("%" + name + "%"));
        }
        if ((hierarchy = searchCriteria.getHierarchy()) != null) {
            extraCriteria.addNonNullCriteria("o.hierarchy like ", (Object)(hierarchy + "%"));
        }
        extraCriteria.addNonNullCriteria("g.staff_id =", (Object)searchCriteria.getStaffId());
        return extraCriteria;
    }

    public GroupGeneralData retrieveOne(Long groupId) {
        try {
            AppUser currentUser = this.context.authenticatedUser();
            String hierarchy = currentUser.getOffice().getHierarchy();
            String hierarchySearchString = hierarchy + "%";
            String sql = "select " + ALL_GROUP_TYPES_DATA_MAPPER.schema() + " where g.id = ? and o.hierarchy like ?";
            return (GroupGeneralData)this.jdbcTemplate.queryForObject(sql, (RowMapper)ALL_GROUP_TYPES_DATA_MAPPER, new Object[]{groupId, hierarchySearchString});
        }
        catch (EmptyResultDataAccessException e) {
            throw new GroupNotFoundException(groupId, e);
        }
    }

    public Collection<GroupGeneralData> retrieveGroupsForLookup(Long officeId) {
        this.context.authenticatedUser();
        GroupLookupDataMapper rm = new GroupLookupDataMapper();
        String sql = "Select " + rm.schema() + " and g.office_id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{officeId});
    }

    public GroupGeneralData retrieveGroupWithClosureReasons() {
        ArrayList closureReasons = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("GroupClosureReason"));
        return GroupGeneralData.withClosureReasons(closureReasons);
    }

    public GroupGeneralData retrieveGroupAndMembersDetails(Long groupId) {
        GroupGeneralData groupAccount = this.retrieveOne(groupId);
        Collection membersOfGroup = this.clientReadPlatformService.retrieveActiveClientMembersOfGroup(groupId);
        if (!CollectionUtils.isEmpty((Collection)membersOfGroup)) {
            Collection activeClientMembers = null;
            Collection calendarsData = null;
            CalendarData collectionMeetingCalendar = null;
            Collection groupRoles = null;
            groupAccount = GroupGeneralData.withAssocations((GroupGeneralData)groupAccount, (Collection)membersOfGroup, activeClientMembers, groupRoles, calendarsData, collectionMeetingCalendar);
        }
        return groupAccount;
    }

    @Generated
    public GroupReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, OfficeReadPlatformService officeReadPlatformService, StaffReadPlatformService staffReadPlatformService, CenterReadPlatformService centerReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService, PaginationHelper paginationHelper, DatabaseSpecificSQLGenerator sqlGenerator, PaginationParametersDataValidator paginationParametersDataValidator, ColumnValidator columnValidator, ClientReadPlatformService clientReadPlatformService) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
        this.officeReadPlatformService = officeReadPlatformService;
        this.staffReadPlatformService = staffReadPlatformService;
        this.centerReadPlatformService = centerReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
        this.paginationHelper = paginationHelper;
        this.sqlGenerator = sqlGenerator;
        this.paginationParametersDataValidator = paginationParametersDataValidator;
        this.columnValidator = columnValidator;
        this.clientReadPlatformService = clientReadPlatformService;
    }
}

