/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.interestratechart.service;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.interestratechart.data.InterestRateChartSlabData;
import org.apache.fineract.portfolio.interestratechart.exception.InterestRateChartSlabNotFoundException;
import org.apache.fineract.portfolio.interestratechart.service.InterestIncentiveDropdownReadPlatformService;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartDropdownReadPlatformService;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartSlabReadPlatformService;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartSlabReadPlatformServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

public class InterestRateChartSlabReadPlatformServiceImpl
implements InterestRateChartSlabReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;
    private final InterestRateChartSlabExtractor chartSlabExtractor;
    private final InterestRateChartDropdownReadPlatformService chartDropdownReadPlatformService;
    private final InterestIncentiveDropdownReadPlatformService interestIncentiveDropdownReadPlatformService;
    private final CodeValueReadPlatformService codeValueReadPlatformService;

    public Collection<InterestRateChartSlabData> retrieveAll(Long chartId) {
        this.context.authenticatedUser();
        String sql = "select " + this.chartSlabExtractor.schema() + " where ircd.interest_rate_chart_id = ? order by ircd.id";
        return (Collection)this.jdbcTemplate.query(sql, (ResultSetExtractor)this.chartSlabExtractor, new Object[]{chartId});
    }

    public InterestRateChartSlabData retrieveOne(Long chartId, Long chartSlabId) {
        this.context.authenticatedUser();
        String sql = "select " + this.chartSlabExtractor.schema() + " where irc.id = ? order by ircd.id asc";
        Collection chartDatas = (Collection)this.jdbcTemplate.query(sql, (ResultSetExtractor)this.chartSlabExtractor, new Object[]{chartSlabId, chartId});
        if (chartDatas == null || chartDatas.isEmpty()) {
            throw new InterestRateChartSlabNotFoundException(chartSlabId, chartId);
        }
        return (InterestRateChartSlabData)chartDatas.iterator().next();
    }

    public InterestRateChartSlabData retrieveWithTemplate(InterestRateChartSlabData chartSlab) {
        ArrayList genderOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Gender"));
        ArrayList clientTypeOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientType"));
        ArrayList clientClassificationOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientClassification"));
        return InterestRateChartSlabData.withTemplate((InterestRateChartSlabData)chartSlab, (Collection)this.chartDropdownReadPlatformService.retrievePeriodTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveEntityTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveAttributeNameOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveConditionTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveIncentiveTypeOptions(), genderOptions, clientTypeOptions, clientClassificationOptions);
    }

    public InterestRateChartSlabData retrieveTemplate() {
        ArrayList genderOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Gender"));
        ArrayList clientTypeOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientType"));
        ArrayList clientClassificationOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientClassification"));
        return InterestRateChartSlabData.template((Collection)this.chartDropdownReadPlatformService.retrievePeriodTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveEntityTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveAttributeNameOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveConditionTypeOptions(), (Collection)this.interestIncentiveDropdownReadPlatformService.retrieveIncentiveTypeOptions(), genderOptions, clientTypeOptions, clientClassificationOptions);
    }

    @Generated
    public InterestRateChartSlabReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate, InterestRateChartSlabExtractor chartSlabExtractor, InterestRateChartDropdownReadPlatformService chartDropdownReadPlatformService, InterestIncentiveDropdownReadPlatformService interestIncentiveDropdownReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
        this.chartSlabExtractor = chartSlabExtractor;
        this.chartDropdownReadPlatformService = chartDropdownReadPlatformService;
        this.interestIncentiveDropdownReadPlatformService = interestIncentiveDropdownReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
    }
}

