/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.data;

import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.data.CodeValueData;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.data.StringEnumOptionData;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.dataqueries.data.DatatableData;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.accountdetails.data.LoanAccountSummaryData;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.charge.util.ConvertChargeDataToSpecificChargeData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.delinquency.data.DelinquencyRangeData;
import org.apache.fineract.portfolio.floatingrates.data.InterestRatePeriodData;
import org.apache.fineract.portfolio.fund.data.FundData;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.fineract.portfolio.loanaccount.data.CollectionData;
import org.apache.fineract.portfolio.loanaccount.data.DisbursementData;
import org.apache.fineract.portfolio.loanaccount.data.LoanApplicationTimelineData;
import org.apache.fineract.portfolio.loanaccount.data.LoanBorrowerCycleData;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargeData;
import org.apache.fineract.portfolio.loanaccount.data.LoanCollateralManagementData;
import org.apache.fineract.portfolio.loanaccount.data.LoanInterestRecalculationData;
import org.apache.fineract.portfolio.loanaccount.data.LoanStatusEnumData;
import org.apache.fineract.portfolio.loanaccount.data.LoanSummaryData;
import org.apache.fineract.portfolio.loanaccount.data.LoanTermVariationsData;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionData;
import org.apache.fineract.portfolio.loanaccount.data.PaidInAdvanceData;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.guarantor.data.GuarantorData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductBorrowerCycleVariationData;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.fineract.portfolio.loanproduct.data.TransactionProcessingStrategyData;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductValueConditionType;
import org.apache.fineract.portfolio.note.data.NoteData;
import org.apache.fineract.portfolio.rate.data.RateData;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoanAccountData {
    private Long id;
    private String accountNo;
    private ExternalId externalId = ExternalId.empty();
    private LoanStatusEnumData status;
    private EnumOptionData subStatus;
    private Long clientId;
    private String clientAccountNo;
    private String clientName;
    private ExternalId clientExternalId;
    private Long clientOfficeId;
    private GroupGeneralData group;
    private Long loanProductId;
    private String loanProductName;
    private String loanProductDescription;
    private boolean isLoanProductLinkedToFloatingRate;
    private Long fundId;
    private String fundName;
    private Long loanPurposeId;
    private String loanPurposeName;
    private Long loanOfficerId;
    private String loanOfficerName;
    private EnumOptionData loanType;
    private CurrencyData currency;
    private BigDecimal principal;
    private BigDecimal approvedPrincipal;
    private BigDecimal proposedPrincipal;
    private BigDecimal netDisbursalAmount;
    private Integer termFrequency;
    private EnumOptionData termPeriodFrequencyType;
    private Integer numberOfRepayments;
    private Integer repaymentEvery;
    private Integer fixedLength;
    private EnumOptionData repaymentFrequencyType;
    private EnumOptionData repaymentFrequencyNthDayType;
    private EnumOptionData repaymentFrequencyDayOfWeekType;
    private BigDecimal interestRatePerPeriod;
    private EnumOptionData interestRateFrequencyType;
    private BigDecimal annualInterestRate;
    private boolean isFloatingInterestRate;
    private BigDecimal interestRateDifferential;
    private EnumOptionData amortizationType;
    private EnumOptionData interestType;
    private EnumOptionData interestCalculationPeriodType;
    private Boolean allowPartialPeriodInterestCalculation;
    private BigDecimal inArrearsTolerance;
    private String transactionProcessingStrategyCode;
    private String transactionProcessingStrategyName;
    private Integer graceOnPrincipalPayment;
    private Integer recurringMoratoriumOnPrincipalPeriods;
    private Integer graceOnInterestPayment;
    private Integer graceOnInterestCharged;
    private Integer graceOnArrearsAgeing;
    private LocalDate interestChargedFromDate;
    private LocalDate expectedFirstRepaymentOnDate;
    private Boolean syncDisbursementWithMeeting;
    private Boolean disallowExpectedDisbursements;
    private LoanApplicationTimelineData timeline;
    private LoanSummaryData summary;
    private LoanScheduleData repaymentSchedule;
    private Collection<LoanTransactionData> transactions;
    private Collection<LoanChargeData> charges;
    private Collection<LoanCollateralManagementData> collateral;
    private Collection<GuarantorData> guarantors;
    private CalendarData meeting;
    private Collection<NoteData> notes;
    private Collection<DisbursementData> disbursementDetails;
    private LoanScheduleData originalSchedule;
    private Collection<LoanProductData> productOptions;
    private Collection<StaffData> loanOfficerOptions;
    private Collection<CodeValueData> loanPurposeOptions;
    private Collection<FundData> fundOptions;
    private Collection<EnumOptionData> termFrequencyTypeOptions;
    private Collection<EnumOptionData> repaymentFrequencyTypeOptions;
    private Collection<EnumOptionData> repaymentFrequencyNthDayTypeOptions;
    private Collection<EnumOptionData> repaymentFrequencyDaysOfWeekTypeOptions;
    private Collection<EnumOptionData> interestRateFrequencyTypeOptions;
    private Collection<EnumOptionData> amortizationTypeOptions;
    private Collection<EnumOptionData> interestTypeOptions;
    private Collection<EnumOptionData> interestCalculationPeriodTypeOptions;
    private Collection<TransactionProcessingStrategyData> transactionProcessingStrategyOptions;
    private Collection<ChargeData> chargeOptions;
    private Collection<CodeValueData> loanCollateralOptions;
    private Collection<CalendarData> calendarOptions;
    private List<EnumOptionData> loanScheduleTypeOptions;
    private List<EnumOptionData> loanScheduleProcessingTypeOptions;
    @Transient
    private BigDecimal feeChargesAtDisbursementCharged;
    private BigDecimal totalOverpaid;
    private Integer loanCounter;
    private Integer loanProductCounter;
    private PortfolioAccountData linkedAccount;
    private Collection<PortfolioAccountData> accountLinkingOptions;
    private Boolean multiDisburseLoan;
    private Boolean canDefineInstallmentAmount;
    private BigDecimal fixedEmiAmount;
    private BigDecimal maxOutstandingLoanBalance;
    private Boolean canDisburse;
    private Collection<LoanTermVariationsData> emiAmountVariations;
    private Collection<LoanTermVariationsData> loanTermVariations;
    private Collection<LoanAccountSummaryData> clientActiveLoanOptions;
    private Boolean canUseForTopup;
    private boolean isTopup;
    private boolean fraud;
    private Long closureLoanId;
    private String closureLoanAccountNo;
    private BigDecimal topupAmount;
    private LoanProductData product;
    private Map<Long, LoanBorrowerCycleData> memberVariations;
    private Boolean inArrears;
    private Boolean isNPA;
    private Collection<ChargeData> overdueCharges;
    private EnumOptionData daysInMonthType;
    private EnumOptionData daysInYearType;
    private boolean isInterestRecalculationEnabled;
    private LoanInterestRecalculationData interestRecalculationData;
    private Boolean createStandingInstructionAtDisbursement;
    private PaidInAdvanceData paidInAdvance;
    private Collection<InterestRatePeriodData> interestRatesPeriods;
    private Boolean isVariableInstallmentsAllowed;
    private Integer minimumGap;
    private Integer maximumGap;
    private List<DatatableData> datatables;
    private Boolean isEqualAmortization;
    private BigDecimal fixedPrincipalPercentagePerInstallment;
    private List<RateData> rates;
    private Boolean isRatesEnabled;
    private String dateFormat;
    private String locale;
    private transient Integer rowIndex;
    private LocalDate submittedOnDate;
    private Long productId;
    private Integer loanTermFrequency;
    private EnumOptionData loanTermFrequencyType;
    private LocalDate repaymentsStartingFromDate;
    private String linkAccountId;
    private Long groupId;
    private LocalDate expectedDisbursementDate;
    private LocalDate overpaidOnDate;
    private CollectionData delinquent;
    private DelinquencyRangeData delinquencyRange;
    private Boolean enableInstallmentLevelDelinquency;
    private LocalDate lastClosedBusinessDate;
    private Boolean chargedOff;
    private Boolean enableDownPayment;
    private BigDecimal disbursedAmountPercentageForDownPayment;
    private Boolean enableAutoRepaymentForDownPayment;
    private Boolean interestRecognitionOnDisbursementDate;
    private EnumOptionData loanScheduleType;
    private EnumOptionData loanScheduleProcessingType;
    private StringEnumOptionData chargeOffBehaviour;
    public static final Comparator<LoanAccountData> LOAN_ACCOUNT_DATA_COMPARATOR_BY_CLIENT_NAME = (loan1, loan2) -> {
        String clientOfLoan1 = loan1.getClientName().toUpperCase(Locale.ENGLISH);
        String clientOfLoan2 = loan2.getClientName().toUpperCase(Locale.ENGLISH);
        return clientOfLoan1.compareTo(clientOfLoan2);
    };

    public static LoanAccountData importInstanceIndividual(EnumOptionData loanTypeEnumOption, Long clientId, Long productId, Long loanOfficerId, LocalDate submittedOnDate, Long fundId, BigDecimal principal, Integer numberOfRepayments, Integer repaymentEvery, EnumOptionData repaidEveryFrequencyEnums, Integer loanTermFrequency, EnumOptionData loanTermFrequencyTypeEnum, BigDecimal nominalInterestRate, LocalDate expectedDisbursementDate, EnumOptionData amortizationEnumOption, EnumOptionData interestMethodEnum, EnumOptionData interestCalculationPeriodTypeEnum, BigDecimal inArrearsTolerance, String transactionProcessingStrategyCode, Integer graceOnPrincipalPayment, Integer graceOnInterestPayment, Integer graceOnInterestCharged, LocalDate interestChargedFromDate, LocalDate repaymentsStartingFromDate, Integer rowIndex, ExternalId externalId, Long groupId, Collection<LoanChargeData> charges, String linkAccountId, String locale, String dateFormat, List<LoanCollateralManagementData> loanCollateralManagementData, Integer fixedLength) {
        return new LoanAccountData().setLoanType(loanTypeEnumOption).setClientId(clientId).setProductId(productId).setLoanOfficerId(loanOfficerId).setSubmittedOnDate(submittedOnDate).setFundId(fundId).setPrincipal(principal).setNumberOfRepayments(numberOfRepayments).setRepaymentEvery(repaymentEvery).setRepaymentFrequencyType(repaidEveryFrequencyEnums).setLoanTermFrequency(loanTermFrequency).setLoanTermFrequencyType(loanTermFrequencyTypeEnum).setInterestRatePerPeriod(nominalInterestRate).setExpectedDisbursementDate(expectedDisbursementDate).setAmortizationType(amortizationEnumOption).setInterestType(interestMethodEnum).setInterestCalculationPeriodType(interestCalculationPeriodTypeEnum).setInArrearsTolerance(inArrearsTolerance).setTransactionProcessingStrategyCode(transactionProcessingStrategyCode).setGraceOnPrincipalPayment(graceOnPrincipalPayment).setGraceOnInterestPayment(graceOnInterestPayment).setGraceOnInterestCharged(graceOnInterestCharged).setInterestChargedFromDate(interestChargedFromDate).setRepaymentsStartingFromDate(repaymentsStartingFromDate).setRowIndex(rowIndex).setExternalId(externalId).setGroupId(groupId).setCharges(charges).setLinkAccountId(linkAccountId).setLocale(locale).setDateFormat(dateFormat).setCollateral(loanCollateralManagementData).setFixedLength(fixedLength);
    }

    public static LoanAccountData importInstanceGroup(EnumOptionData loanTypeEnumOption, Long groupIdforGroupLoan, Long productId, Long loanOfficerId, LocalDate submittedOnDate, Long fundId, BigDecimal principal, Integer numberOfRepayments, Integer repaidEvery, EnumOptionData repaidEveryFrequencyEnums, Integer loanTermFrequency, EnumOptionData loanTermFrequencyTypeEnum, BigDecimal nominalInterestRate, EnumOptionData amortizationEnumOption, EnumOptionData interestMethodEnum, EnumOptionData interestCalculationPeriodEnum, BigDecimal arrearsTolerance, String transactionProcessingStrategyCode, Integer graceOnPrincipalPayment, Integer graceOnInterestPayment, Integer graceOnInterestCharged, LocalDate interestChargedFromDate, LocalDate repaymentsStartingFromDate, Integer rowIndex, ExternalId externalId, String linkAccountId, String locale, String dateFormat, Integer fixedLength) {
        return new LoanAccountData().setLoanType(loanTypeEnumOption).setGroupId(groupIdforGroupLoan).setProductId(productId).setLoanOfficerId(loanOfficerId).setSubmittedOnDate(submittedOnDate).setFundId(fundId).setPrincipal(principal).setNumberOfRepayments(numberOfRepayments).setRepaymentEvery(repaidEvery).setRepaymentFrequencyType(repaidEveryFrequencyEnums).setLoanTermFrequency(loanTermFrequency).setLoanTermFrequencyType(loanTermFrequencyTypeEnum).setInterestRatePerPeriod(nominalInterestRate).setAmortizationTypeOptions(List.of(amortizationEnumOption)).setInterestType(interestMethodEnum).setInterestCalculationPeriodType(interestCalculationPeriodEnum).setInArrearsTolerance(arrearsTolerance).setTransactionProcessingStrategyCode(transactionProcessingStrategyCode).setGraceOnPrincipalPayment(graceOnPrincipalPayment).setGraceOnInterestPayment(graceOnInterestPayment).setGraceOnInterestCharged(graceOnInterestCharged).setInterestChargedFromDate(interestChargedFromDate).setRepaymentsStartingFromDate(repaymentsStartingFromDate).setRowIndex(rowIndex).setExternalId(externalId).setLinkAccountId(linkAccountId).setLocale(locale).setDateFormat(dateFormat).setFixedLength(fixedLength);
    }

    public LoanAccountData withClientData(ClientData clientData) {
        return this.setClientId(clientData.getId()).setClientAccountNo(clientData.getAccountNo()).setClientName(clientData.getDisplayName()).setClientOfficeId(clientData.getOfficeId()).setClientExternalId(clientData.getExternalId());
    }

    public LoanAccountData withExpectedDisbursementDate(LocalDate expectedDisbursementDate) {
        if (this.getTimeline() == null) {
            this.setTimeline(new LoanApplicationTimelineData());
        }
        this.getTimeline().setExpectedDisbursementDate(expectedDisbursementDate);
        return this.setExpectedDisbursementDate(expectedDisbursementDate);
    }

    public LoanAccountData withProductData(LoanProductData product, Integer loanCycleNumber) {
        EnumOptionData termPeriodFrequencyType = product.getRepaymentFrequencyType();
        ArrayList<LoanChargeData> charges = new ArrayList<LoanChargeData>();
        for (ChargeData charge : product.charges()) {
            if (charge.isOverdueInstallmentCharge()) continue;
            charges.add(ConvertChargeDataToSpecificChargeData.toLoanChargeData((ChargeData)charge));
        }
        BigDecimal principal = null;
        BigDecimal proposedPrincipal = null;
        BigDecimal interestRatePerPeriod = null;
        Integer numberOfRepayments = null;
        if (product.isUseBorrowerCycle() && loanCycleNumber != null && loanCycleNumber > 0) {
            Collection principalVariationsForBorrowerCycle = product.getPrincipalVariationsForBorrowerCycle();
            Collection interestForVariationsForBorrowerCycle = product.getInterestRateVariationsForBorrowerCycle();
            Collection repaymentVariationsForBorrowerCycle = product.getNumberOfRepaymentVariationsForBorrowerCycle();
            proposedPrincipal = principal = LoanAccountData.fetchLoanCycleDefaultValue((Collection)principalVariationsForBorrowerCycle, (Integer)loanCycleNumber);
            interestRatePerPeriod = LoanAccountData.fetchLoanCycleDefaultValue((Collection)interestForVariationsForBorrowerCycle, (Integer)loanCycleNumber);
            BigDecimal numberofRepaymentval = LoanAccountData.fetchLoanCycleDefaultValue((Collection)repaymentVariationsForBorrowerCycle, (Integer)loanCycleNumber);
            if (numberofRepaymentval != null) {
                numberOfRepayments = numberofRepaymentval.intValue();
            }
        }
        if (principal == null) {
            proposedPrincipal = principal = product.getPrincipal();
        }
        BigDecimal netDisbursalAmount = principal;
        if (!charges.isEmpty()) {
            for (LoanChargeData charge : charges) {
                netDisbursalAmount = netDisbursalAmount.subtract(charge.getAmount());
            }
        }
        if (interestRatePerPeriod == null) {
            interestRatePerPeriod = product.getInterestRatePerPeriod();
        }
        if (numberOfRepayments == null) {
            numberOfRepayments = product.getNumberOfRepayments();
        }
        return this.setProductId(product.getId()).setLoanProductName(product.getName()).setLoanProductDescription(product.getDescription()).setLoanProductLinkedToFloatingRate(product.isLinkedToFloatingInterestRates()).setFundId(product.getFundId()).setFundName(product.getFundName()).setCurrency(product.getCurrency()).setProposedPrincipal(proposedPrincipal).setPrincipal(principal).setApprovedPrincipal(principal).setNetDisbursalAmount(netDisbursalAmount).setInArrearsTolerance(product.getInArrearsTolerance()).setTermFrequency(Integer.valueOf(numberOfRepayments * product.getRepaymentEvery())).setTermPeriodFrequencyType(termPeriodFrequencyType).setNumberOfRepayments(numberOfRepayments).setRepaymentEvery(product.getRepaymentEvery()).setRepaymentFrequencyType(product.getRepaymentFrequencyType()).setTransactionProcessingStrategyCode(product.getTransactionProcessingStrategyCode()).setAmortizationType(product.getAmortizationType()).setInterestRatePerPeriod(interestRatePerPeriod).setInterestRateFrequencyType(product.getInterestRateFrequencyType()).setAnnualInterestRate(product.getAnnualInterestRate()).setInterestType(product.getInterestType()).setFloatingInterestRate(product.isFloatingInterestRateCalculationAllowed()).setInterestRateDifferential(product.getDefaultDifferentialLendingRate()).setInterestCalculationPeriodType(product.getInterestCalculationPeriodType()).setAllowPartialPeriodInterestCalculation(product.isAllowPartialPeriodInterestCalculation()).setGraceOnPrincipalPayment(product.getGraceOnPrincipalPayment()).setRecurringMoratoriumOnPrincipalPeriods(product.getRecurringMoratoriumOnPrincipalPeriods()).setGraceOnInterestPayment(product.getGraceOnInterestPayment()).setGraceOnInterestCharged(product.getGraceOnInterestCharged()).setCharges(charges).setMultiDisburseLoan(product.getMultiDisburseLoan()).setCanDefineInstallmentAmount(Boolean.valueOf(product.isCanDefineInstallmentAmount())).setMaxOutstandingLoanBalance(product.getOutstandingLoanBalance()).setProduct(product).setGraceOnArrearsAgeing(product.getGraceOnArrearsAgeing()).setOverdueCharges(product.overdueFeeCharges()).setDaysInMonthType(product.getDaysInMonthType()).setDaysInYearType(product.getDaysInYearType()).setInterestRecalculationEnabled(product.isInterestRecalculationEnabled()).setInterestRecalculationData(product.toLoanInterestRecalculationData()).setIsVariableInstallmentsAllowed(Boolean.valueOf(product.isAllowVariableInstallments())).setMinimumGap(product.getMinimumGap()).setMaximumGap(product.getMaximumGap()).setTopup(product.isCanUseForTopup()).setIsEqualAmortization(Boolean.valueOf(product.isEqualAmortization())).setFixedPrincipalPercentagePerInstallment(product.getFixedPrincipalPercentagePerInstallment()).setDelinquent(CollectionData.template()).setDisallowExpectedDisbursements(product.getDisallowExpectedDisbursements()).setLoanScheduleType(product.getLoanScheduleType()).setLoanScheduleProcessingType(product.getLoanScheduleProcessingType()).setInterestRecognitionOnDisbursementDate(Boolean.valueOf(product.isInterestRecognitionOnDisbursementDate()));
    }

    public static LoanAccountData basicLoanDetails(Long id, String accountNo, LoanStatusEnumData status, ExternalId externalId, Long clientId, String clientAccountNo, String clientName, Long clientOfficeId, ExternalId clientExternalId, GroupGeneralData group, EnumOptionData loanType, Long loanProductId, String loanProductName, String loanProductDescription, boolean isLoanProductLinkedToFloatingRate, Long fundId, String fundName, Long loanPurposeId, String loanPurposeName, Long loanOfficerId, String loanOfficerName, CurrencyData currencyData, BigDecimal proposedPrincipal, BigDecimal principal, BigDecimal approvedPrincipal, BigDecimal netDisbursalAmount, BigDecimal totalOverpaid, BigDecimal inArrearsTolerance, Integer termFrequency, EnumOptionData termPeriodFrequencyType, Integer numberOfRepayments, Integer repaymentEvery, EnumOptionData repaymentFrequencyType, EnumOptionData repaymentFrequencyNthDayType, EnumOptionData repaymentFrequencyDayOfWeekType, String transactionStrategy, String transactionStrategyName, EnumOptionData amortizationType, BigDecimal interestRatePerPeriod, EnumOptionData interestRateFrequencyType, BigDecimal annualInterestRate, EnumOptionData interestType, boolean isFloatingInterestRate, BigDecimal interestRateDifferential, EnumOptionData interestCalculationPeriodType, Boolean allowPartialPeriodInterestCalcualtion, LocalDate expectedFirstRepaymentOnDate, Integer graceOnPrincipalPayment, Integer recurringMoratoriumOnPrincipalPeriods, Integer graceOnInterestPayment, Integer graceOnInterestCharged, LocalDate interestChargedFromDate, LoanApplicationTimelineData timeline, LoanSummaryData loanSummary, BigDecimal feeChargesDueAtDisbursementCharged, Boolean syncDisbursementWithMeeting, Integer loanCounter, Integer loanProductCounter, Boolean multiDisburseLoan, Boolean canDefineInstallmentAmount, BigDecimal fixedEmiAmont, BigDecimal outstandingLoanBalance, Boolean inArrears, Integer graceOnArrearsAgeing, Boolean isNPA, EnumOptionData daysInMonthType, EnumOptionData daysInYearType, boolean isInterestRecalculationEnabled, LoanInterestRecalculationData interestRecalculationData, Boolean createStandingInstructionAtDisbursement, Boolean isVariableInstallmentsAllowed, Integer minimumGap, Integer maximumGap, EnumOptionData subStatus, boolean canUseForTopup, boolean isTopup, Long closureLoanId, String closureLoanAccountNo, BigDecimal topupAmount, boolean isEqualAmortization, BigDecimal fixedPrincipalPercentagePerInstallment, DelinquencyRangeData delinquencyRange, boolean disallowExpectedDisbursements, boolean fraud, LocalDate lastClosedBusinessDate, LocalDate overpaidOnDate, boolean chargedOff, boolean enableDownPayment, BigDecimal disbursedAmountPercentageForDownPayment, boolean enableAutoRepaymentForDownPayment, boolean enableInstallmentLevelDelinquency, EnumOptionData loanScheduleType, EnumOptionData loanScheduleProcessingType, Integer fixedLength, StringEnumOptionData chargeOffBehaviour, boolean isInterestRecognitionOnDisbursementDate) {
        CollectionData delinquent = CollectionData.template();
        return new LoanAccountData().setId(id).setAccountNo(accountNo).setStatus(status).setExternalId(externalId).setClientId(clientId).setClientAccountNo(clientAccountNo).setClientName(clientName).setClientOfficeId(clientOfficeId).setClientExternalId(clientExternalId).setGroup(group).setLoanType(loanType).setLoanProductId(loanProductId).setLoanProductName(loanProductName).setLoanProductDescription(loanProductDescription).setLoanProductLinkedToFloatingRate(isLoanProductLinkedToFloatingRate).setFundId(fundId).setFundName(fundName).setLoanPurposeId(loanPurposeId).setLoanPurposeName(loanPurposeName).setLoanOfficerId(loanOfficerId).setLoanOfficerName(loanOfficerName).setCurrency(currencyData).setProposedPrincipal(proposedPrincipal).setPrincipal(principal).setApprovedPrincipal(approvedPrincipal).setNetDisbursalAmount(netDisbursalAmount).setTotalOverpaid(totalOverpaid).setInArrearsTolerance(inArrearsTolerance).setTermFrequency(termFrequency).setTermPeriodFrequencyType(termPeriodFrequencyType).setNumberOfRepayments(numberOfRepayments).setRepaymentEvery(repaymentEvery).setRepaymentFrequencyType(repaymentFrequencyType).setRepaymentFrequencyNthDayType(repaymentFrequencyNthDayType).setRepaymentFrequencyDayOfWeekType(repaymentFrequencyDayOfWeekType).setTransactionProcessingStrategyCode(transactionStrategy).setTransactionProcessingStrategyName(transactionStrategyName).setAmortizationType(amortizationType).setInterestRatePerPeriod(interestRatePerPeriod).setInterestRateFrequencyType(interestRateFrequencyType).setAnnualInterestRate(annualInterestRate).setInterestType(interestType).setFloatingInterestRate(isFloatingInterestRate).setInterestRateDifferential(interestRateDifferential).setInterestCalculationPeriodType(interestCalculationPeriodType).setAllowPartialPeriodInterestCalculation(allowPartialPeriodInterestCalcualtion).setExpectedFirstRepaymentOnDate(expectedFirstRepaymentOnDate).setGraceOnPrincipalPayment(graceOnPrincipalPayment).setRecurringMoratoriumOnPrincipalPeriods(recurringMoratoriumOnPrincipalPeriods).setGraceOnInterestPayment(graceOnInterestPayment).setGraceOnInterestCharged(graceOnInterestCharged).setInterestChargedFromDate(interestChargedFromDate).setTimeline(timeline).setSummary(loanSummary).setFeeChargesAtDisbursementCharged(feeChargesDueAtDisbursementCharged).setSyncDisbursementWithMeeting(syncDisbursementWithMeeting).setLoanCounter(loanCounter).setLoanProductCounter(loanProductCounter).setMultiDisburseLoan(multiDisburseLoan).setCanDefineInstallmentAmount(canDefineInstallmentAmount).setFixedEmiAmount(fixedEmiAmont).setMaxOutstandingLoanBalance(outstandingLoanBalance).setInArrears(inArrears).setGraceOnArrearsAgeing(graceOnArrearsAgeing).setIsNPA(isNPA).setDaysInMonthType(daysInMonthType).setDaysInYearType(daysInYearType).setInterestRecalculationEnabled(isInterestRecalculationEnabled).setInterestRecalculationData(interestRecalculationData).setCreateStandingInstructionAtDisbursement(createStandingInstructionAtDisbursement).setIsVariableInstallmentsAllowed(isVariableInstallmentsAllowed).setMinimumGap(minimumGap).setMaximumGap(maximumGap).setSubStatus(subStatus).setCanUseForTopup(Boolean.valueOf(canUseForTopup)).setTopup(isTopup).setClosureLoanId(closureLoanId).setClosureLoanAccountNo(closureLoanAccountNo).setTopupAmount(topupAmount).setIsEqualAmortization(Boolean.valueOf(isEqualAmortization)).setFixedPrincipalPercentagePerInstallment(fixedPrincipalPercentagePerInstallment).setDelinquent(delinquent).setDelinquencyRange(delinquencyRange).setDisallowExpectedDisbursements(Boolean.valueOf(disallowExpectedDisbursements)).setFraud(fraud).setLastClosedBusinessDate(lastClosedBusinessDate).setOverpaidOnDate(overpaidOnDate).setChargedOff(Boolean.valueOf(chargedOff)).setEnableDownPayment(Boolean.valueOf(enableDownPayment)).setDisbursedAmountPercentageForDownPayment(disbursedAmountPercentageForDownPayment).setEnableAutoRepaymentForDownPayment(Boolean.valueOf(enableAutoRepaymentForDownPayment)).setEnableInstallmentLevelDelinquency(Boolean.valueOf(enableInstallmentLevelDelinquency)).setLoanScheduleType(loanScheduleType).setLoanScheduleProcessingType(loanScheduleProcessingType).setFixedLength(fixedLength).setChargeOffBehaviour(chargeOffBehaviour).setInterestRecognitionOnDisbursementDate(Boolean.valueOf(isInterestRecognitionOnDisbursementDate));
    }

    public LoanAccountData associationsAndTemplate(LoanScheduleData repaymentSchedule, Collection<LoanTransactionData> transactions, Collection<LoanChargeData> charges, Collection<LoanCollateralManagementData> collateral, Collection<GuarantorData> guarantors, CalendarData calendarData, Collection<LoanProductData> productOptions, Collection<EnumOptionData> termFrequencyTypeOptions, Collection<EnumOptionData> repaymentFrequencyTypeOptions, Collection<EnumOptionData> repaymentFrequencyNthDayTypeOptions, Collection<EnumOptionData> repaymentFrequencyDayOfWeekTypeOptions, Collection<TransactionProcessingStrategyData> transactionProcessingStrategyOptions, Collection<EnumOptionData> interestRateFrequencyTypeOptions, Collection<EnumOptionData> amortizationTypeOptions, Collection<EnumOptionData> interestTypeOptions, Collection<EnumOptionData> interestCalculationPeriodTypeOptions, Collection<FundData> fundOptions, Collection<ChargeData> chargeOptions, ChargeData chargeTemplate, Collection<StaffData> loanOfficerOptions, Collection<CodeValueData> loanPurposeOptions, Collection<CodeValueData> loanCollateralOptions, Collection<CalendarData> calendarOptions, Collection<NoteData> notes, Collection<PortfolioAccountData> accountLinkingOptions, PortfolioAccountData linkedAccount, Collection<DisbursementData> disbursementDetails, Collection<LoanTermVariationsData> emiAmountVariations, Collection<ChargeData> overdueCharges, PaidInAdvanceData paidInAdvance, Collection<InterestRatePeriodData> interestRatesPeriods, Collection<LoanAccountSummaryData> clientActiveLoanOptions, List<RateData> rates, Boolean isRatesEnabled, CollectionData delinquent, List<EnumOptionData> loanScheduleTypeOptions, List<EnumOptionData> loanScheduleProcessingTypeOptions, List<LoanTermVariationsData> loanTermVariations) {
        return this.setRepaymentSchedule(repaymentSchedule).setTransactions(transactions).setCharges(charges).setCollateral(collateral).setGuarantors(guarantors).setProductOptions(productOptions).setTermFrequencyTypeOptions(termFrequencyTypeOptions).setRepaymentFrequencyTypeOptions(repaymentFrequencyTypeOptions).setRepaymentFrequencyNthDayTypeOptions(repaymentFrequencyNthDayTypeOptions).setRepaymentFrequencyDaysOfWeekTypeOptions(repaymentFrequencyDayOfWeekTypeOptions).setTransactionProcessingStrategyOptions(transactionProcessingStrategyOptions).setInterestRateFrequencyTypeOptions(interestRateFrequencyTypeOptions).setAmortizationTypeOptions(amortizationTypeOptions).setInterestTypeOptions(interestTypeOptions).setInterestCalculationPeriodTypeOptions(interestCalculationPeriodTypeOptions).setFundOptions(fundOptions).setChargeOptions(chargeOptions).setLoanOfficerOptions(loanOfficerOptions).setLoanPurposeOptions(loanPurposeOptions).setLoanCollateralOptions(loanCollateralOptions).setCalendarOptions(calendarOptions).setNotes(notes).setAccountLinkingOptions(accountLinkingOptions).setLinkedAccount(linkedAccount).setDisbursementDetails(disbursementDetails).setEmiAmountVariations(emiAmountVariations).setOverdueCharges(overdueCharges).setPaidInAdvance(paidInAdvance).setInterestRatesPeriods(interestRatesPeriods).setClientActiveLoanOptions(clientActiveLoanOptions).setRates(rates).setIsRatesEnabled(isRatesEnabled).setDelinquent(delinquent).setLoanScheduleTypeOptions(loanScheduleTypeOptions).setLoanScheduleProcessingTypeOptions(loanScheduleProcessingTypeOptions).setLoanTermVariations(loanTermVariations);
    }

    public LoanAccountData associationsAndTemplate(Collection<LoanProductData> productOptions, Collection<StaffData> allowedLoanOfficers, Collection<CalendarData> calendarOptions, Collection<PortfolioAccountData> accountLinkingOptions, Boolean isRatesEnabled) {
        return this.setProductOptions(productOptions).setLoanOfficerOptions(allowedLoanOfficers).setCalendarOptions(calendarOptions).setAccountLinkingOptions(accountLinkingOptions).setIsRatesEnabled(isRatesEnabled);
    }

    public LoanAccountData associateMemberVariations(Map<Long, Integer> memberLoanCycle) {
        HashMap<Long, LoanBorrowerCycleData> memberVariations = new HashMap<Long, LoanBorrowerCycleData>();
        for (Map.Entry<Long, Integer> mapEntry : memberLoanCycle.entrySet()) {
            BigDecimal principal = null;
            BigDecimal interestRatePerPeriod = null;
            Integer numberOfRepayments = null;
            Long clientId = mapEntry.getKey();
            Integer loanCycleNumber = mapEntry.getValue();
            if (this.product.isUseBorrowerCycle() && loanCycleNumber != null && loanCycleNumber > 0) {
                Collection principalVariationsForBorrowerCycle = this.product.getPrincipalVariationsForBorrowerCycle();
                Collection interestForVariationsForBorrowerCycle = this.product.getInterestRateVariationsForBorrowerCycle();
                Collection repaymentVariationsForBorrowerCycle = this.product.getNumberOfRepaymentVariationsForBorrowerCycle();
                principal = LoanAccountData.fetchLoanCycleDefaultValue((Collection)principalVariationsForBorrowerCycle, (Integer)loanCycleNumber);
                interestRatePerPeriod = LoanAccountData.fetchLoanCycleDefaultValue((Collection)interestForVariationsForBorrowerCycle, (Integer)loanCycleNumber);
                BigDecimal numberofRepaymentval = LoanAccountData.fetchLoanCycleDefaultValue((Collection)repaymentVariationsForBorrowerCycle, (Integer)loanCycleNumber);
                if (numberofRepaymentval != null) {
                    numberOfRepayments = numberofRepaymentval.intValue();
                }
            }
            if (principal == null) {
                principal = this.product.getPrincipal();
            }
            if (interestRatePerPeriod == null) {
                interestRatePerPeriod = this.product.getInterestRatePerPeriod();
            }
            if (numberOfRepayments == null) {
                numberOfRepayments = this.product.getNumberOfRepayments();
            }
            Integer termFrequency = numberOfRepayments * this.product.getRepaymentEvery();
            LoanBorrowerCycleData borrowerCycleData = new LoanBorrowerCycleData(principal, interestRatePerPeriod, numberOfRepayments, termFrequency);
            memberVariations.put(clientId, borrowerCycleData);
        }
        return this.setMemberVariations(memberVariations);
    }

    public LoanAccountData withInterestRecalculationCalendarData(CalendarData calendarData, CalendarData compoundingCalendarData) {
        if (this.interestRecalculationData == null) {
            this.interestRecalculationData = new LoanInterestRecalculationData();
        }
        LoanInterestRecalculationData newInterestRecalculationData = this.interestRecalculationData.withCalendarData(calendarData, compoundingCalendarData);
        return this.setInterestRecalculationData(newInterestRecalculationData);
    }

    private static BigDecimal fetchLoanCycleDefaultValue(Collection<LoanProductBorrowerCycleVariationData> borrowerCycleVariationData, Integer loanCycleNumber) {
        BigDecimal defaultValue = null;
        Integer cycleNumberSelected = 0;
        for (LoanProductBorrowerCycleVariationData data : borrowerCycleVariationData) {
            if (!LoanAccountData.isLoanCycleValuesWhenConditionEqual((Integer)loanCycleNumber, (LoanProductBorrowerCycleVariationData)data) && !LoanAccountData.isLoanCycleValuesWhenConditionGreterthan((Integer)loanCycleNumber, (Integer)cycleNumberSelected, (LoanProductBorrowerCycleVariationData)data)) continue;
            cycleNumberSelected = data.getBorrowerCycleNumber();
            defaultValue = data.getDefaultValue();
        }
        return defaultValue;
    }

    private static boolean isLoanCycleValuesWhenConditionGreterthan(Integer loanCycleNumber, Integer cycleNumberSelected, LoanProductBorrowerCycleVariationData data) {
        return data.getBorrowerCycleNumber() < loanCycleNumber && data.getLoanProductValueConditionType().equals((Object)LoanProductValueConditionType.GREATERTHAN) && cycleNumberSelected < data.getBorrowerCycleNumber();
    }

    private static boolean isLoanCycleValuesWhenConditionEqual(Integer loanCycleNumber, LoanProductBorrowerCycleVariationData data) {
        return data.getBorrowerCycleNumber().equals(loanCycleNumber) && data.getLoanProductValueConditionType().equals((Object)LoanProductValueConditionType.EQUAL);
    }

    public Long getInterestRecalculationDetailId() {
        if (this.isInterestRecalculationEnabled) {
            return this.interestRecalculationData.getId();
        }
        return null;
    }

    public boolean isActive() {
        return LoanStatus.fromInt((Integer)this.getStatus().getId().intValue()).isActive();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getAccountNo() {
        return this.accountNo;
    }

    @Generated
    public ExternalId getExternalId() {
        return this.externalId;
    }

    @Generated
    public LoanStatusEnumData getStatus() {
        return this.status;
    }

    @Generated
    public EnumOptionData getSubStatus() {
        return this.subStatus;
    }

    @Generated
    public Long getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientAccountNo() {
        return this.clientAccountNo;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public ExternalId getClientExternalId() {
        return this.clientExternalId;
    }

    @Generated
    public Long getClientOfficeId() {
        return this.clientOfficeId;
    }

    @Generated
    public GroupGeneralData getGroup() {
        return this.group;
    }

    @Generated
    public Long getLoanProductId() {
        return this.loanProductId;
    }

    @Generated
    public String getLoanProductName() {
        return this.loanProductName;
    }

    @Generated
    public String getLoanProductDescription() {
        return this.loanProductDescription;
    }

    @Generated
    public boolean isLoanProductLinkedToFloatingRate() {
        return this.isLoanProductLinkedToFloatingRate;
    }

    @Generated
    public Long getFundId() {
        return this.fundId;
    }

    @Generated
    public String getFundName() {
        return this.fundName;
    }

    @Generated
    public Long getLoanPurposeId() {
        return this.loanPurposeId;
    }

    @Generated
    public String getLoanPurposeName() {
        return this.loanPurposeName;
    }

    @Generated
    public Long getLoanOfficerId() {
        return this.loanOfficerId;
    }

    @Generated
    public String getLoanOfficerName() {
        return this.loanOfficerName;
    }

    @Generated
    public EnumOptionData getLoanType() {
        return this.loanType;
    }

    @Generated
    public CurrencyData getCurrency() {
        return this.currency;
    }

    @Generated
    public BigDecimal getPrincipal() {
        return this.principal;
    }

    @Generated
    public BigDecimal getApprovedPrincipal() {
        return this.approvedPrincipal;
    }

    @Generated
    public BigDecimal getProposedPrincipal() {
        return this.proposedPrincipal;
    }

    @Generated
    public BigDecimal getNetDisbursalAmount() {
        return this.netDisbursalAmount;
    }

    @Generated
    public Integer getTermFrequency() {
        return this.termFrequency;
    }

    @Generated
    public EnumOptionData getTermPeriodFrequencyType() {
        return this.termPeriodFrequencyType;
    }

    @Generated
    public Integer getNumberOfRepayments() {
        return this.numberOfRepayments;
    }

    @Generated
    public Integer getRepaymentEvery() {
        return this.repaymentEvery;
    }

    @Generated
    public Integer getFixedLength() {
        return this.fixedLength;
    }

    @Generated
    public EnumOptionData getRepaymentFrequencyType() {
        return this.repaymentFrequencyType;
    }

    @Generated
    public EnumOptionData getRepaymentFrequencyNthDayType() {
        return this.repaymentFrequencyNthDayType;
    }

    @Generated
    public EnumOptionData getRepaymentFrequencyDayOfWeekType() {
        return this.repaymentFrequencyDayOfWeekType;
    }

    @Generated
    public BigDecimal getInterestRatePerPeriod() {
        return this.interestRatePerPeriod;
    }

    @Generated
    public EnumOptionData getInterestRateFrequencyType() {
        return this.interestRateFrequencyType;
    }

    @Generated
    public BigDecimal getAnnualInterestRate() {
        return this.annualInterestRate;
    }

    @Generated
    public boolean isFloatingInterestRate() {
        return this.isFloatingInterestRate;
    }

    @Generated
    public BigDecimal getInterestRateDifferential() {
        return this.interestRateDifferential;
    }

    @Generated
    public EnumOptionData getAmortizationType() {
        return this.amortizationType;
    }

    @Generated
    public EnumOptionData getInterestType() {
        return this.interestType;
    }

    @Generated
    public EnumOptionData getInterestCalculationPeriodType() {
        return this.interestCalculationPeriodType;
    }

    @Generated
    public Boolean getAllowPartialPeriodInterestCalculation() {
        return this.allowPartialPeriodInterestCalculation;
    }

    @Generated
    public BigDecimal getInArrearsTolerance() {
        return this.inArrearsTolerance;
    }

    @Generated
    public String getTransactionProcessingStrategyCode() {
        return this.transactionProcessingStrategyCode;
    }

    @Generated
    public String getTransactionProcessingStrategyName() {
        return this.transactionProcessingStrategyName;
    }

    @Generated
    public Integer getGraceOnPrincipalPayment() {
        return this.graceOnPrincipalPayment;
    }

    @Generated
    public Integer getRecurringMoratoriumOnPrincipalPeriods() {
        return this.recurringMoratoriumOnPrincipalPeriods;
    }

    @Generated
    public Integer getGraceOnInterestPayment() {
        return this.graceOnInterestPayment;
    }

    @Generated
    public Integer getGraceOnInterestCharged() {
        return this.graceOnInterestCharged;
    }

    @Generated
    public Integer getGraceOnArrearsAgeing() {
        return this.graceOnArrearsAgeing;
    }

    @Generated
    public LocalDate getInterestChargedFromDate() {
        return this.interestChargedFromDate;
    }

    @Generated
    public LocalDate getExpectedFirstRepaymentOnDate() {
        return this.expectedFirstRepaymentOnDate;
    }

    @Generated
    public Boolean getSyncDisbursementWithMeeting() {
        return this.syncDisbursementWithMeeting;
    }

    @Generated
    public Boolean getDisallowExpectedDisbursements() {
        return this.disallowExpectedDisbursements;
    }

    @Generated
    public LoanApplicationTimelineData getTimeline() {
        return this.timeline;
    }

    @Generated
    public LoanSummaryData getSummary() {
        return this.summary;
    }

    @Generated
    public LoanScheduleData getRepaymentSchedule() {
        return this.repaymentSchedule;
    }

    @Generated
    public Collection<LoanTransactionData> getTransactions() {
        return this.transactions;
    }

    @Generated
    public Collection<LoanChargeData> getCharges() {
        return this.charges;
    }

    @Generated
    public Collection<LoanCollateralManagementData> getCollateral() {
        return this.collateral;
    }

    @Generated
    public Collection<GuarantorData> getGuarantors() {
        return this.guarantors;
    }

    @Generated
    public CalendarData getMeeting() {
        return this.meeting;
    }

    @Generated
    public Collection<NoteData> getNotes() {
        return this.notes;
    }

    @Generated
    public Collection<DisbursementData> getDisbursementDetails() {
        return this.disbursementDetails;
    }

    @Generated
    public LoanScheduleData getOriginalSchedule() {
        return this.originalSchedule;
    }

    @Generated
    public Collection<LoanProductData> getProductOptions() {
        return this.productOptions;
    }

    @Generated
    public Collection<StaffData> getLoanOfficerOptions() {
        return this.loanOfficerOptions;
    }

    @Generated
    public Collection<CodeValueData> getLoanPurposeOptions() {
        return this.loanPurposeOptions;
    }

    @Generated
    public Collection<FundData> getFundOptions() {
        return this.fundOptions;
    }

    @Generated
    public Collection<EnumOptionData> getTermFrequencyTypeOptions() {
        return this.termFrequencyTypeOptions;
    }

    @Generated
    public Collection<EnumOptionData> getRepaymentFrequencyTypeOptions() {
        return this.repaymentFrequencyTypeOptions;
    }

    @Generated
    public Collection<EnumOptionData> getRepaymentFrequencyNthDayTypeOptions() {
        return this.repaymentFrequencyNthDayTypeOptions;
    }

    @Generated
    public Collection<EnumOptionData> getRepaymentFrequencyDaysOfWeekTypeOptions() {
        return this.repaymentFrequencyDaysOfWeekTypeOptions;
    }

    @Generated
    public Collection<EnumOptionData> getInterestRateFrequencyTypeOptions() {
        return this.interestRateFrequencyTypeOptions;
    }

    @Generated
    public Collection<EnumOptionData> getAmortizationTypeOptions() {
        return this.amortizationTypeOptions;
    }

    @Generated
    public Collection<EnumOptionData> getInterestTypeOptions() {
        return this.interestTypeOptions;
    }

    @Generated
    public Collection<EnumOptionData> getInterestCalculationPeriodTypeOptions() {
        return this.interestCalculationPeriodTypeOptions;
    }

    @Generated
    public Collection<TransactionProcessingStrategyData> getTransactionProcessingStrategyOptions() {
        return this.transactionProcessingStrategyOptions;
    }

    @Generated
    public Collection<ChargeData> getChargeOptions() {
        return this.chargeOptions;
    }

    @Generated
    public Collection<CodeValueData> getLoanCollateralOptions() {
        return this.loanCollateralOptions;
    }

    @Generated
    public Collection<CalendarData> getCalendarOptions() {
        return this.calendarOptions;
    }

    @Generated
    public List<EnumOptionData> getLoanScheduleTypeOptions() {
        return this.loanScheduleTypeOptions;
    }

    @Generated
    public List<EnumOptionData> getLoanScheduleProcessingTypeOptions() {
        return this.loanScheduleProcessingTypeOptions;
    }

    @Generated
    public BigDecimal getFeeChargesAtDisbursementCharged() {
        return this.feeChargesAtDisbursementCharged;
    }

    @Generated
    public BigDecimal getTotalOverpaid() {
        return this.totalOverpaid;
    }

    @Generated
    public Integer getLoanCounter() {
        return this.loanCounter;
    }

    @Generated
    public Integer getLoanProductCounter() {
        return this.loanProductCounter;
    }

    @Generated
    public PortfolioAccountData getLinkedAccount() {
        return this.linkedAccount;
    }

    @Generated
    public Collection<PortfolioAccountData> getAccountLinkingOptions() {
        return this.accountLinkingOptions;
    }

    @Generated
    public Boolean getMultiDisburseLoan() {
        return this.multiDisburseLoan;
    }

    @Generated
    public Boolean getCanDefineInstallmentAmount() {
        return this.canDefineInstallmentAmount;
    }

    @Generated
    public BigDecimal getFixedEmiAmount() {
        return this.fixedEmiAmount;
    }

    @Generated
    public BigDecimal getMaxOutstandingLoanBalance() {
        return this.maxOutstandingLoanBalance;
    }

    @Generated
    public Boolean getCanDisburse() {
        return this.canDisburse;
    }

    @Generated
    public Collection<LoanTermVariationsData> getEmiAmountVariations() {
        return this.emiAmountVariations;
    }

    @Generated
    public Collection<LoanTermVariationsData> getLoanTermVariations() {
        return this.loanTermVariations;
    }

    @Generated
    public Collection<LoanAccountSummaryData> getClientActiveLoanOptions() {
        return this.clientActiveLoanOptions;
    }

    @Generated
    public Boolean getCanUseForTopup() {
        return this.canUseForTopup;
    }

    @Generated
    public boolean isTopup() {
        return this.isTopup;
    }

    @Generated
    public boolean isFraud() {
        return this.fraud;
    }

    @Generated
    public Long getClosureLoanId() {
        return this.closureLoanId;
    }

    @Generated
    public String getClosureLoanAccountNo() {
        return this.closureLoanAccountNo;
    }

    @Generated
    public BigDecimal getTopupAmount() {
        return this.topupAmount;
    }

    @Generated
    public LoanProductData getProduct() {
        return this.product;
    }

    @Generated
    public Map<Long, LoanBorrowerCycleData> getMemberVariations() {
        return this.memberVariations;
    }

    @Generated
    public Boolean getInArrears() {
        return this.inArrears;
    }

    @Generated
    public Boolean getIsNPA() {
        return this.isNPA;
    }

    @Generated
    public Collection<ChargeData> getOverdueCharges() {
        return this.overdueCharges;
    }

    @Generated
    public EnumOptionData getDaysInMonthType() {
        return this.daysInMonthType;
    }

    @Generated
    public EnumOptionData getDaysInYearType() {
        return this.daysInYearType;
    }

    @Generated
    public boolean isInterestRecalculationEnabled() {
        return this.isInterestRecalculationEnabled;
    }

    @Generated
    public LoanInterestRecalculationData getInterestRecalculationData() {
        return this.interestRecalculationData;
    }

    @Generated
    public Boolean getCreateStandingInstructionAtDisbursement() {
        return this.createStandingInstructionAtDisbursement;
    }

    @Generated
    public PaidInAdvanceData getPaidInAdvance() {
        return this.paidInAdvance;
    }

    @Generated
    public Collection<InterestRatePeriodData> getInterestRatesPeriods() {
        return this.interestRatesPeriods;
    }

    @Generated
    public Boolean getIsVariableInstallmentsAllowed() {
        return this.isVariableInstallmentsAllowed;
    }

    @Generated
    public Integer getMinimumGap() {
        return this.minimumGap;
    }

    @Generated
    public Integer getMaximumGap() {
        return this.maximumGap;
    }

    @Generated
    public List<DatatableData> getDatatables() {
        return this.datatables;
    }

    @Generated
    public Boolean getIsEqualAmortization() {
        return this.isEqualAmortization;
    }

    @Generated
    public BigDecimal getFixedPrincipalPercentagePerInstallment() {
        return this.fixedPrincipalPercentagePerInstallment;
    }

    @Generated
    public List<RateData> getRates() {
        return this.rates;
    }

    @Generated
    public Boolean getIsRatesEnabled() {
        return this.isRatesEnabled;
    }

    @Generated
    public String getDateFormat() {
        return this.dateFormat;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public Integer getRowIndex() {
        return this.rowIndex;
    }

    @Generated
    public LocalDate getSubmittedOnDate() {
        return this.submittedOnDate;
    }

    @Generated
    public Long getProductId() {
        return this.productId;
    }

    @Generated
    public Integer getLoanTermFrequency() {
        return this.loanTermFrequency;
    }

    @Generated
    public EnumOptionData getLoanTermFrequencyType() {
        return this.loanTermFrequencyType;
    }

    @Generated
    public LocalDate getRepaymentsStartingFromDate() {
        return this.repaymentsStartingFromDate;
    }

    @Generated
    public String getLinkAccountId() {
        return this.linkAccountId;
    }

    @Generated
    public Long getGroupId() {
        return this.groupId;
    }

    @Generated
    public LocalDate getExpectedDisbursementDate() {
        return this.expectedDisbursementDate;
    }

    @Generated
    public LocalDate getOverpaidOnDate() {
        return this.overpaidOnDate;
    }

    @Generated
    public CollectionData getDelinquent() {
        return this.delinquent;
    }

    @Generated
    public DelinquencyRangeData getDelinquencyRange() {
        return this.delinquencyRange;
    }

    @Generated
    public Boolean getEnableInstallmentLevelDelinquency() {
        return this.enableInstallmentLevelDelinquency;
    }

    @Generated
    public LocalDate getLastClosedBusinessDate() {
        return this.lastClosedBusinessDate;
    }

    @Generated
    public Boolean getChargedOff() {
        return this.chargedOff;
    }

    @Generated
    public Boolean getEnableDownPayment() {
        return this.enableDownPayment;
    }

    @Generated
    public BigDecimal getDisbursedAmountPercentageForDownPayment() {
        return this.disbursedAmountPercentageForDownPayment;
    }

    @Generated
    public Boolean getEnableAutoRepaymentForDownPayment() {
        return this.enableAutoRepaymentForDownPayment;
    }

    @Generated
    public Boolean getInterestRecognitionOnDisbursementDate() {
        return this.interestRecognitionOnDisbursementDate;
    }

    @Generated
    public EnumOptionData getLoanScheduleType() {
        return this.loanScheduleType;
    }

    @Generated
    public EnumOptionData getLoanScheduleProcessingType() {
        return this.loanScheduleProcessingType;
    }

    @Generated
    public StringEnumOptionData getChargeOffBehaviour() {
        return this.chargeOffBehaviour;
    }

    @Generated
    public LoanAccountData setId(Long id) {
        this.id = id;
        return this;
    }

    @Generated
    public LoanAccountData setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    @Generated
    public LoanAccountData setExternalId(ExternalId externalId) {
        this.externalId = externalId;
        return this;
    }

    @Generated
    public LoanAccountData setStatus(LoanStatusEnumData status) {
        this.status = status;
        return this;
    }

    @Generated
    public LoanAccountData setSubStatus(EnumOptionData subStatus) {
        this.subStatus = subStatus;
        return this;
    }

    @Generated
    public LoanAccountData setClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    @Generated
    public LoanAccountData setClientAccountNo(String clientAccountNo) {
        this.clientAccountNo = clientAccountNo;
        return this;
    }

    @Generated
    public LoanAccountData setClientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    @Generated
    public LoanAccountData setClientExternalId(ExternalId clientExternalId) {
        this.clientExternalId = clientExternalId;
        return this;
    }

    @Generated
    public LoanAccountData setClientOfficeId(Long clientOfficeId) {
        this.clientOfficeId = clientOfficeId;
        return this;
    }

    @Generated
    public LoanAccountData setGroup(GroupGeneralData group) {
        this.group = group;
        return this;
    }

    @Generated
    public LoanAccountData setLoanProductId(Long loanProductId) {
        this.loanProductId = loanProductId;
        return this;
    }

    @Generated
    public LoanAccountData setLoanProductName(String loanProductName) {
        this.loanProductName = loanProductName;
        return this;
    }

    @Generated
    public LoanAccountData setLoanProductDescription(String loanProductDescription) {
        this.loanProductDescription = loanProductDescription;
        return this;
    }

    @Generated
    public LoanAccountData setLoanProductLinkedToFloatingRate(boolean isLoanProductLinkedToFloatingRate) {
        this.isLoanProductLinkedToFloatingRate = isLoanProductLinkedToFloatingRate;
        return this;
    }

    @Generated
    public LoanAccountData setFundId(Long fundId) {
        this.fundId = fundId;
        return this;
    }

    @Generated
    public LoanAccountData setFundName(String fundName) {
        this.fundName = fundName;
        return this;
    }

    @Generated
    public LoanAccountData setLoanPurposeId(Long loanPurposeId) {
        this.loanPurposeId = loanPurposeId;
        return this;
    }

    @Generated
    public LoanAccountData setLoanPurposeName(String loanPurposeName) {
        this.loanPurposeName = loanPurposeName;
        return this;
    }

    @Generated
    public LoanAccountData setLoanOfficerId(Long loanOfficerId) {
        this.loanOfficerId = loanOfficerId;
        return this;
    }

    @Generated
    public LoanAccountData setLoanOfficerName(String loanOfficerName) {
        this.loanOfficerName = loanOfficerName;
        return this;
    }

    @Generated
    public LoanAccountData setLoanType(EnumOptionData loanType) {
        this.loanType = loanType;
        return this;
    }

    @Generated
    public LoanAccountData setCurrency(CurrencyData currency) {
        this.currency = currency;
        return this;
    }

    @Generated
    public LoanAccountData setPrincipal(BigDecimal principal) {
        this.principal = principal;
        return this;
    }

    @Generated
    public LoanAccountData setApprovedPrincipal(BigDecimal approvedPrincipal) {
        this.approvedPrincipal = approvedPrincipal;
        return this;
    }

    @Generated
    public LoanAccountData setProposedPrincipal(BigDecimal proposedPrincipal) {
        this.proposedPrincipal = proposedPrincipal;
        return this;
    }

    @Generated
    public LoanAccountData setNetDisbursalAmount(BigDecimal netDisbursalAmount) {
        this.netDisbursalAmount = netDisbursalAmount;
        return this;
    }

    @Generated
    public LoanAccountData setTermFrequency(Integer termFrequency) {
        this.termFrequency = termFrequency;
        return this;
    }

    @Generated
    public LoanAccountData setTermPeriodFrequencyType(EnumOptionData termPeriodFrequencyType) {
        this.termPeriodFrequencyType = termPeriodFrequencyType;
        return this;
    }

    @Generated
    public LoanAccountData setNumberOfRepayments(Integer numberOfRepayments) {
        this.numberOfRepayments = numberOfRepayments;
        return this;
    }

    @Generated
    public LoanAccountData setRepaymentEvery(Integer repaymentEvery) {
        this.repaymentEvery = repaymentEvery;
        return this;
    }

    @Generated
    public LoanAccountData setFixedLength(Integer fixedLength) {
        this.fixedLength = fixedLength;
        return this;
    }

    @Generated
    public LoanAccountData setRepaymentFrequencyType(EnumOptionData repaymentFrequencyType) {
        this.repaymentFrequencyType = repaymentFrequencyType;
        return this;
    }

    @Generated
    public LoanAccountData setRepaymentFrequencyNthDayType(EnumOptionData repaymentFrequencyNthDayType) {
        this.repaymentFrequencyNthDayType = repaymentFrequencyNthDayType;
        return this;
    }

    @Generated
    public LoanAccountData setRepaymentFrequencyDayOfWeekType(EnumOptionData repaymentFrequencyDayOfWeekType) {
        this.repaymentFrequencyDayOfWeekType = repaymentFrequencyDayOfWeekType;
        return this;
    }

    @Generated
    public LoanAccountData setInterestRatePerPeriod(BigDecimal interestRatePerPeriod) {
        this.interestRatePerPeriod = interestRatePerPeriod;
        return this;
    }

    @Generated
    public LoanAccountData setInterestRateFrequencyType(EnumOptionData interestRateFrequencyType) {
        this.interestRateFrequencyType = interestRateFrequencyType;
        return this;
    }

    @Generated
    public LoanAccountData setAnnualInterestRate(BigDecimal annualInterestRate) {
        this.annualInterestRate = annualInterestRate;
        return this;
    }

    @Generated
    public LoanAccountData setFloatingInterestRate(boolean isFloatingInterestRate) {
        this.isFloatingInterestRate = isFloatingInterestRate;
        return this;
    }

    @Generated
    public LoanAccountData setInterestRateDifferential(BigDecimal interestRateDifferential) {
        this.interestRateDifferential = interestRateDifferential;
        return this;
    }

    @Generated
    public LoanAccountData setAmortizationType(EnumOptionData amortizationType) {
        this.amortizationType = amortizationType;
        return this;
    }

    @Generated
    public LoanAccountData setInterestType(EnumOptionData interestType) {
        this.interestType = interestType;
        return this;
    }

    @Generated
    public LoanAccountData setInterestCalculationPeriodType(EnumOptionData interestCalculationPeriodType) {
        this.interestCalculationPeriodType = interestCalculationPeriodType;
        return this;
    }

    @Generated
    public LoanAccountData setAllowPartialPeriodInterestCalculation(Boolean allowPartialPeriodInterestCalculation) {
        this.allowPartialPeriodInterestCalculation = allowPartialPeriodInterestCalculation;
        return this;
    }

    @Generated
    public LoanAccountData setInArrearsTolerance(BigDecimal inArrearsTolerance) {
        this.inArrearsTolerance = inArrearsTolerance;
        return this;
    }

    @Generated
    public LoanAccountData setTransactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
        this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
        return this;
    }

    @Generated
    public LoanAccountData setTransactionProcessingStrategyName(String transactionProcessingStrategyName) {
        this.transactionProcessingStrategyName = transactionProcessingStrategyName;
        return this;
    }

    @Generated
    public LoanAccountData setGraceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
        this.graceOnPrincipalPayment = graceOnPrincipalPayment;
        return this;
    }

    @Generated
    public LoanAccountData setRecurringMoratoriumOnPrincipalPeriods(Integer recurringMoratoriumOnPrincipalPeriods) {
        this.recurringMoratoriumOnPrincipalPeriods = recurringMoratoriumOnPrincipalPeriods;
        return this;
    }

    @Generated
    public LoanAccountData setGraceOnInterestPayment(Integer graceOnInterestPayment) {
        this.graceOnInterestPayment = graceOnInterestPayment;
        return this;
    }

    @Generated
    public LoanAccountData setGraceOnInterestCharged(Integer graceOnInterestCharged) {
        this.graceOnInterestCharged = graceOnInterestCharged;
        return this;
    }

    @Generated
    public LoanAccountData setGraceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
        this.graceOnArrearsAgeing = graceOnArrearsAgeing;
        return this;
    }

    @Generated
    public LoanAccountData setInterestChargedFromDate(LocalDate interestChargedFromDate) {
        this.interestChargedFromDate = interestChargedFromDate;
        return this;
    }

    @Generated
    public LoanAccountData setExpectedFirstRepaymentOnDate(LocalDate expectedFirstRepaymentOnDate) {
        this.expectedFirstRepaymentOnDate = expectedFirstRepaymentOnDate;
        return this;
    }

    @Generated
    public LoanAccountData setSyncDisbursementWithMeeting(Boolean syncDisbursementWithMeeting) {
        this.syncDisbursementWithMeeting = syncDisbursementWithMeeting;
        return this;
    }

    @Generated
    public LoanAccountData setDisallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
        this.disallowExpectedDisbursements = disallowExpectedDisbursements;
        return this;
    }

    @Generated
    public LoanAccountData setTimeline(LoanApplicationTimelineData timeline) {
        this.timeline = timeline;
        return this;
    }

    @Generated
    public LoanAccountData setSummary(LoanSummaryData summary) {
        this.summary = summary;
        return this;
    }

    @Generated
    public LoanAccountData setRepaymentSchedule(LoanScheduleData repaymentSchedule) {
        this.repaymentSchedule = repaymentSchedule;
        return this;
    }

    @Generated
    public LoanAccountData setTransactions(Collection<LoanTransactionData> transactions) {
        this.transactions = transactions;
        return this;
    }

    @Generated
    public LoanAccountData setCharges(Collection<LoanChargeData> charges) {
        this.charges = charges;
        return this;
    }

    @Generated
    public LoanAccountData setCollateral(Collection<LoanCollateralManagementData> collateral) {
        this.collateral = collateral;
        return this;
    }

    @Generated
    public LoanAccountData setGuarantors(Collection<GuarantorData> guarantors) {
        this.guarantors = guarantors;
        return this;
    }

    @Generated
    public LoanAccountData setMeeting(CalendarData meeting) {
        this.meeting = meeting;
        return this;
    }

    @Generated
    public LoanAccountData setNotes(Collection<NoteData> notes) {
        this.notes = notes;
        return this;
    }

    @Generated
    public LoanAccountData setDisbursementDetails(Collection<DisbursementData> disbursementDetails) {
        this.disbursementDetails = disbursementDetails;
        return this;
    }

    @Generated
    public LoanAccountData setOriginalSchedule(LoanScheduleData originalSchedule) {
        this.originalSchedule = originalSchedule;
        return this;
    }

    @Generated
    public LoanAccountData setProductOptions(Collection<LoanProductData> productOptions) {
        this.productOptions = productOptions;
        return this;
    }

    @Generated
    public LoanAccountData setLoanOfficerOptions(Collection<StaffData> loanOfficerOptions) {
        this.loanOfficerOptions = loanOfficerOptions;
        return this;
    }

    @Generated
    public LoanAccountData setLoanPurposeOptions(Collection<CodeValueData> loanPurposeOptions) {
        this.loanPurposeOptions = loanPurposeOptions;
        return this;
    }

    @Generated
    public LoanAccountData setFundOptions(Collection<FundData> fundOptions) {
        this.fundOptions = fundOptions;
        return this;
    }

    @Generated
    public LoanAccountData setTermFrequencyTypeOptions(Collection<EnumOptionData> termFrequencyTypeOptions) {
        this.termFrequencyTypeOptions = termFrequencyTypeOptions;
        return this;
    }

    @Generated
    public LoanAccountData setRepaymentFrequencyTypeOptions(Collection<EnumOptionData> repaymentFrequencyTypeOptions) {
        this.repaymentFrequencyTypeOptions = repaymentFrequencyTypeOptions;
        return this;
    }

    @Generated
    public LoanAccountData setRepaymentFrequencyNthDayTypeOptions(Collection<EnumOptionData> repaymentFrequencyNthDayTypeOptions) {
        this.repaymentFrequencyNthDayTypeOptions = repaymentFrequencyNthDayTypeOptions;
        return this;
    }

    @Generated
    public LoanAccountData setRepaymentFrequencyDaysOfWeekTypeOptions(Collection<EnumOptionData> repaymentFrequencyDaysOfWeekTypeOptions) {
        this.repaymentFrequencyDaysOfWeekTypeOptions = repaymentFrequencyDaysOfWeekTypeOptions;
        return this;
    }

    @Generated
    public LoanAccountData setInterestRateFrequencyTypeOptions(Collection<EnumOptionData> interestRateFrequencyTypeOptions) {
        this.interestRateFrequencyTypeOptions = interestRateFrequencyTypeOptions;
        return this;
    }

    @Generated
    public LoanAccountData setAmortizationTypeOptions(Collection<EnumOptionData> amortizationTypeOptions) {
        this.amortizationTypeOptions = amortizationTypeOptions;
        return this;
    }

    @Generated
    public LoanAccountData setInterestTypeOptions(Collection<EnumOptionData> interestTypeOptions) {
        this.interestTypeOptions = interestTypeOptions;
        return this;
    }

    @Generated
    public LoanAccountData setInterestCalculationPeriodTypeOptions(Collection<EnumOptionData> interestCalculationPeriodTypeOptions) {
        this.interestCalculationPeriodTypeOptions = interestCalculationPeriodTypeOptions;
        return this;
    }

    @Generated
    public LoanAccountData setTransactionProcessingStrategyOptions(Collection<TransactionProcessingStrategyData> transactionProcessingStrategyOptions) {
        this.transactionProcessingStrategyOptions = transactionProcessingStrategyOptions;
        return this;
    }

    @Generated
    public LoanAccountData setChargeOptions(Collection<ChargeData> chargeOptions) {
        this.chargeOptions = chargeOptions;
        return this;
    }

    @Generated
    public LoanAccountData setLoanCollateralOptions(Collection<CodeValueData> loanCollateralOptions) {
        this.loanCollateralOptions = loanCollateralOptions;
        return this;
    }

    @Generated
    public LoanAccountData setCalendarOptions(Collection<CalendarData> calendarOptions) {
        this.calendarOptions = calendarOptions;
        return this;
    }

    @Generated
    public LoanAccountData setLoanScheduleTypeOptions(List<EnumOptionData> loanScheduleTypeOptions) {
        this.loanScheduleTypeOptions = loanScheduleTypeOptions;
        return this;
    }

    @Generated
    public LoanAccountData setLoanScheduleProcessingTypeOptions(List<EnumOptionData> loanScheduleProcessingTypeOptions) {
        this.loanScheduleProcessingTypeOptions = loanScheduleProcessingTypeOptions;
        return this;
    }

    @Generated
    public LoanAccountData setFeeChargesAtDisbursementCharged(BigDecimal feeChargesAtDisbursementCharged) {
        this.feeChargesAtDisbursementCharged = feeChargesAtDisbursementCharged;
        return this;
    }

    @Generated
    public LoanAccountData setTotalOverpaid(BigDecimal totalOverpaid) {
        this.totalOverpaid = totalOverpaid;
        return this;
    }

    @Generated
    public LoanAccountData setLoanCounter(Integer loanCounter) {
        this.loanCounter = loanCounter;
        return this;
    }

    @Generated
    public LoanAccountData setLoanProductCounter(Integer loanProductCounter) {
        this.loanProductCounter = loanProductCounter;
        return this;
    }

    @Generated
    public LoanAccountData setLinkedAccount(PortfolioAccountData linkedAccount) {
        this.linkedAccount = linkedAccount;
        return this;
    }

    @Generated
    public LoanAccountData setAccountLinkingOptions(Collection<PortfolioAccountData> accountLinkingOptions) {
        this.accountLinkingOptions = accountLinkingOptions;
        return this;
    }

    @Generated
    public LoanAccountData setMultiDisburseLoan(Boolean multiDisburseLoan) {
        this.multiDisburseLoan = multiDisburseLoan;
        return this;
    }

    @Generated
    public LoanAccountData setCanDefineInstallmentAmount(Boolean canDefineInstallmentAmount) {
        this.canDefineInstallmentAmount = canDefineInstallmentAmount;
        return this;
    }

    @Generated
    public LoanAccountData setFixedEmiAmount(BigDecimal fixedEmiAmount) {
        this.fixedEmiAmount = fixedEmiAmount;
        return this;
    }

    @Generated
    public LoanAccountData setMaxOutstandingLoanBalance(BigDecimal maxOutstandingLoanBalance) {
        this.maxOutstandingLoanBalance = maxOutstandingLoanBalance;
        return this;
    }

    @Generated
    public LoanAccountData setCanDisburse(Boolean canDisburse) {
        this.canDisburse = canDisburse;
        return this;
    }

    @Generated
    public LoanAccountData setEmiAmountVariations(Collection<LoanTermVariationsData> emiAmountVariations) {
        this.emiAmountVariations = emiAmountVariations;
        return this;
    }

    @Generated
    public LoanAccountData setLoanTermVariations(Collection<LoanTermVariationsData> loanTermVariations) {
        this.loanTermVariations = loanTermVariations;
        return this;
    }

    @Generated
    public LoanAccountData setClientActiveLoanOptions(Collection<LoanAccountSummaryData> clientActiveLoanOptions) {
        this.clientActiveLoanOptions = clientActiveLoanOptions;
        return this;
    }

    @Generated
    public LoanAccountData setCanUseForTopup(Boolean canUseForTopup) {
        this.canUseForTopup = canUseForTopup;
        return this;
    }

    @Generated
    public LoanAccountData setTopup(boolean isTopup) {
        this.isTopup = isTopup;
        return this;
    }

    @Generated
    public LoanAccountData setFraud(boolean fraud) {
        this.fraud = fraud;
        return this;
    }

    @Generated
    public LoanAccountData setClosureLoanId(Long closureLoanId) {
        this.closureLoanId = closureLoanId;
        return this;
    }

    @Generated
    public LoanAccountData setClosureLoanAccountNo(String closureLoanAccountNo) {
        this.closureLoanAccountNo = closureLoanAccountNo;
        return this;
    }

    @Generated
    public LoanAccountData setTopupAmount(BigDecimal topupAmount) {
        this.topupAmount = topupAmount;
        return this;
    }

    @Generated
    public LoanAccountData setProduct(LoanProductData product) {
        this.product = product;
        return this;
    }

    @Generated
    public LoanAccountData setMemberVariations(Map<Long, LoanBorrowerCycleData> memberVariations) {
        this.memberVariations = memberVariations;
        return this;
    }

    @Generated
    public LoanAccountData setInArrears(Boolean inArrears) {
        this.inArrears = inArrears;
        return this;
    }

    @Generated
    public LoanAccountData setIsNPA(Boolean isNPA) {
        this.isNPA = isNPA;
        return this;
    }

    @Generated
    public LoanAccountData setOverdueCharges(Collection<ChargeData> overdueCharges) {
        this.overdueCharges = overdueCharges;
        return this;
    }

    @Generated
    public LoanAccountData setDaysInMonthType(EnumOptionData daysInMonthType) {
        this.daysInMonthType = daysInMonthType;
        return this;
    }

    @Generated
    public LoanAccountData setDaysInYearType(EnumOptionData daysInYearType) {
        this.daysInYearType = daysInYearType;
        return this;
    }

    @Generated
    public LoanAccountData setInterestRecalculationEnabled(boolean isInterestRecalculationEnabled) {
        this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
        return this;
    }

    @Generated
    public LoanAccountData setInterestRecalculationData(LoanInterestRecalculationData interestRecalculationData) {
        this.interestRecalculationData = interestRecalculationData;
        return this;
    }

    @Generated
    public LoanAccountData setCreateStandingInstructionAtDisbursement(Boolean createStandingInstructionAtDisbursement) {
        this.createStandingInstructionAtDisbursement = createStandingInstructionAtDisbursement;
        return this;
    }

    @Generated
    public LoanAccountData setPaidInAdvance(PaidInAdvanceData paidInAdvance) {
        this.paidInAdvance = paidInAdvance;
        return this;
    }

    @Generated
    public LoanAccountData setInterestRatesPeriods(Collection<InterestRatePeriodData> interestRatesPeriods) {
        this.interestRatesPeriods = interestRatesPeriods;
        return this;
    }

    @Generated
    public LoanAccountData setIsVariableInstallmentsAllowed(Boolean isVariableInstallmentsAllowed) {
        this.isVariableInstallmentsAllowed = isVariableInstallmentsAllowed;
        return this;
    }

    @Generated
    public LoanAccountData setMinimumGap(Integer minimumGap) {
        this.minimumGap = minimumGap;
        return this;
    }

    @Generated
    public LoanAccountData setMaximumGap(Integer maximumGap) {
        this.maximumGap = maximumGap;
        return this;
    }

    @Generated
    public LoanAccountData setDatatables(List<DatatableData> datatables) {
        this.datatables = datatables;
        return this;
    }

    @Generated
    public LoanAccountData setIsEqualAmortization(Boolean isEqualAmortization) {
        this.isEqualAmortization = isEqualAmortization;
        return this;
    }

    @Generated
    public LoanAccountData setFixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
        this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
        return this;
    }

    @Generated
    public LoanAccountData setRates(List<RateData> rates) {
        this.rates = rates;
        return this;
    }

    @Generated
    public LoanAccountData setIsRatesEnabled(Boolean isRatesEnabled) {
        this.isRatesEnabled = isRatesEnabled;
        return this;
    }

    @Generated
    public LoanAccountData setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    @Generated
    public LoanAccountData setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    @Generated
    public LoanAccountData setRowIndex(Integer rowIndex) {
        this.rowIndex = rowIndex;
        return this;
    }

    @Generated
    public LoanAccountData setSubmittedOnDate(LocalDate submittedOnDate) {
        this.submittedOnDate = submittedOnDate;
        return this;
    }

    @Generated
    public LoanAccountData setProductId(Long productId) {
        this.productId = productId;
        return this;
    }

    @Generated
    public LoanAccountData setLoanTermFrequency(Integer loanTermFrequency) {
        this.loanTermFrequency = loanTermFrequency;
        return this;
    }

    @Generated
    public LoanAccountData setLoanTermFrequencyType(EnumOptionData loanTermFrequencyType) {
        this.loanTermFrequencyType = loanTermFrequencyType;
        return this;
    }

    @Generated
    public LoanAccountData setRepaymentsStartingFromDate(LocalDate repaymentsStartingFromDate) {
        this.repaymentsStartingFromDate = repaymentsStartingFromDate;
        return this;
    }

    @Generated
    public LoanAccountData setLinkAccountId(String linkAccountId) {
        this.linkAccountId = linkAccountId;
        return this;
    }

    @Generated
    public LoanAccountData setGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    @Generated
    public LoanAccountData setExpectedDisbursementDate(LocalDate expectedDisbursementDate) {
        this.expectedDisbursementDate = expectedDisbursementDate;
        return this;
    }

    @Generated
    public LoanAccountData setOverpaidOnDate(LocalDate overpaidOnDate) {
        this.overpaidOnDate = overpaidOnDate;
        return this;
    }

    @Generated
    public LoanAccountData setDelinquent(CollectionData delinquent) {
        this.delinquent = delinquent;
        return this;
    }

    @Generated
    public LoanAccountData setDelinquencyRange(DelinquencyRangeData delinquencyRange) {
        this.delinquencyRange = delinquencyRange;
        return this;
    }

    @Generated
    public LoanAccountData setEnableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
        this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
        return this;
    }

    @Generated
    public LoanAccountData setLastClosedBusinessDate(LocalDate lastClosedBusinessDate) {
        this.lastClosedBusinessDate = lastClosedBusinessDate;
        return this;
    }

    @Generated
    public LoanAccountData setChargedOff(Boolean chargedOff) {
        this.chargedOff = chargedOff;
        return this;
    }

    @Generated
    public LoanAccountData setEnableDownPayment(Boolean enableDownPayment) {
        this.enableDownPayment = enableDownPayment;
        return this;
    }

    @Generated
    public LoanAccountData setDisbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
        this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
        return this;
    }

    @Generated
    public LoanAccountData setEnableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
        this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
        return this;
    }

    @Generated
    public LoanAccountData setInterestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
        this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
        return this;
    }

    @Generated
    public LoanAccountData setLoanScheduleType(EnumOptionData loanScheduleType) {
        this.loanScheduleType = loanScheduleType;
        return this;
    }

    @Generated
    public LoanAccountData setLoanScheduleProcessingType(EnumOptionData loanScheduleProcessingType) {
        this.loanScheduleProcessingType = loanScheduleProcessingType;
        return this;
    }

    @Generated
    public LoanAccountData setChargeOffBehaviour(StringEnumOptionData chargeOffBehaviour) {
        this.chargeOffBehaviour = chargeOffBehaviour;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Generated
    public boolean equals(Object o) {
        void other$chargeOffBehaviour;
        void this$chargeOffBehaviour;
        void other$loanScheduleProcessingType;
        void this$loanScheduleProcessingType;
        void other$loanScheduleType;
        void this$loanScheduleType;
        void other$disbursedAmountPercentageForDownPayment;
        void this$disbursedAmountPercentageForDownPayment;
        void other$lastClosedBusinessDate;
        void this$lastClosedBusinessDate;
        void other$delinquencyRange;
        void this$delinquencyRange;
        void other$delinquent;
        void this$delinquent;
        void other$overpaidOnDate;
        void this$overpaidOnDate;
        void other$expectedDisbursementDate;
        void this$expectedDisbursementDate;
        void other$linkAccountId;
        void this$linkAccountId;
        void other$repaymentsStartingFromDate;
        void this$repaymentsStartingFromDate;
        void other$loanTermFrequencyType;
        void this$loanTermFrequencyType;
        void other$submittedOnDate;
        void this$submittedOnDate;
        void other$locale;
        void this$locale;
        void other$dateFormat;
        void this$dateFormat;
        void other$rates;
        void this$rates;
        void other$fixedPrincipalPercentagePerInstallment;
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoanAccountData)) {
            return false;
        }
        LoanAccountData other = (LoanAccountData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isLoanProductLinkedToFloatingRate() != other.isLoanProductLinkedToFloatingRate()) {
            return false;
        }
        if (this.isFloatingInterestRate() != other.isFloatingInterestRate()) {
            return false;
        }
        if (this.isTopup() != other.isTopup()) {
            return false;
        }
        if (this.isFraud() != other.isFraud()) {
            return false;
        }
        if (this.isInterestRecalculationEnabled() != other.isInterestRecalculationEnabled()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$clientId = this.getClientId();
        Long other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !((Object)this$clientId).equals(other$clientId)) {
            return false;
        }
        Long this$clientOfficeId = this.getClientOfficeId();
        Long other$clientOfficeId = other.getClientOfficeId();
        if (this$clientOfficeId == null ? other$clientOfficeId != null : !((Object)this$clientOfficeId).equals(other$clientOfficeId)) {
            return false;
        }
        Long this$loanProductId = this.getLoanProductId();
        Long other$loanProductId = other.getLoanProductId();
        if (this$loanProductId == null ? other$loanProductId != null : !((Object)this$loanProductId).equals(other$loanProductId)) {
            return false;
        }
        Long this$fundId = this.getFundId();
        Long other$fundId = other.getFundId();
        if (this$fundId == null ? other$fundId != null : !((Object)this$fundId).equals(other$fundId)) {
            return false;
        }
        Long this$loanPurposeId = this.getLoanPurposeId();
        Long other$loanPurposeId = other.getLoanPurposeId();
        if (this$loanPurposeId == null ? other$loanPurposeId != null : !((Object)this$loanPurposeId).equals(other$loanPurposeId)) {
            return false;
        }
        Long this$loanOfficerId = this.getLoanOfficerId();
        Long other$loanOfficerId = other.getLoanOfficerId();
        if (this$loanOfficerId == null ? other$loanOfficerId != null : !((Object)this$loanOfficerId).equals(other$loanOfficerId)) {
            return false;
        }
        Integer this$termFrequency = this.getTermFrequency();
        Integer other$termFrequency = other.getTermFrequency();
        if (this$termFrequency == null ? other$termFrequency != null : !((Object)this$termFrequency).equals(other$termFrequency)) {
            return false;
        }
        Integer this$numberOfRepayments = this.getNumberOfRepayments();
        Integer other$numberOfRepayments = other.getNumberOfRepayments();
        if (this$numberOfRepayments == null ? other$numberOfRepayments != null : !((Object)this$numberOfRepayments).equals(other$numberOfRepayments)) {
            return false;
        }
        Integer this$repaymentEvery = this.getRepaymentEvery();
        Integer other$repaymentEvery = other.getRepaymentEvery();
        if (this$repaymentEvery == null ? other$repaymentEvery != null : !((Object)this$repaymentEvery).equals(other$repaymentEvery)) {
            return false;
        }
        Integer this$fixedLength = this.getFixedLength();
        Integer other$fixedLength = other.getFixedLength();
        if (this$fixedLength == null ? other$fixedLength != null : !((Object)this$fixedLength).equals(other$fixedLength)) {
            return false;
        }
        Boolean this$allowPartialPeriodInterestCalculation = this.getAllowPartialPeriodInterestCalculation();
        Boolean other$allowPartialPeriodInterestCalculation = other.getAllowPartialPeriodInterestCalculation();
        if (this$allowPartialPeriodInterestCalculation == null ? other$allowPartialPeriodInterestCalculation != null : !((Object)this$allowPartialPeriodInterestCalculation).equals(other$allowPartialPeriodInterestCalculation)) {
            return false;
        }
        Integer this$graceOnPrincipalPayment = this.getGraceOnPrincipalPayment();
        Integer other$graceOnPrincipalPayment = other.getGraceOnPrincipalPayment();
        if (this$graceOnPrincipalPayment == null ? other$graceOnPrincipalPayment != null : !((Object)this$graceOnPrincipalPayment).equals(other$graceOnPrincipalPayment)) {
            return false;
        }
        Integer this$recurringMoratoriumOnPrincipalPeriods = this.getRecurringMoratoriumOnPrincipalPeriods();
        Integer other$recurringMoratoriumOnPrincipalPeriods = other.getRecurringMoratoriumOnPrincipalPeriods();
        if (this$recurringMoratoriumOnPrincipalPeriods == null ? other$recurringMoratoriumOnPrincipalPeriods != null : !((Object)this$recurringMoratoriumOnPrincipalPeriods).equals(other$recurringMoratoriumOnPrincipalPeriods)) {
            return false;
        }
        Integer this$graceOnInterestPayment = this.getGraceOnInterestPayment();
        Integer other$graceOnInterestPayment = other.getGraceOnInterestPayment();
        if (this$graceOnInterestPayment == null ? other$graceOnInterestPayment != null : !((Object)this$graceOnInterestPayment).equals(other$graceOnInterestPayment)) {
            return false;
        }
        Integer this$graceOnInterestCharged = this.getGraceOnInterestCharged();
        Integer other$graceOnInterestCharged = other.getGraceOnInterestCharged();
        if (this$graceOnInterestCharged == null ? other$graceOnInterestCharged != null : !((Object)this$graceOnInterestCharged).equals(other$graceOnInterestCharged)) {
            return false;
        }
        Integer this$graceOnArrearsAgeing = this.getGraceOnArrearsAgeing();
        Integer other$graceOnArrearsAgeing = other.getGraceOnArrearsAgeing();
        if (this$graceOnArrearsAgeing == null ? other$graceOnArrearsAgeing != null : !((Object)this$graceOnArrearsAgeing).equals(other$graceOnArrearsAgeing)) {
            return false;
        }
        Boolean this$syncDisbursementWithMeeting = this.getSyncDisbursementWithMeeting();
        Boolean other$syncDisbursementWithMeeting = other.getSyncDisbursementWithMeeting();
        if (this$syncDisbursementWithMeeting == null ? other$syncDisbursementWithMeeting != null : !((Object)this$syncDisbursementWithMeeting).equals(other$syncDisbursementWithMeeting)) {
            return false;
        }
        Boolean this$disallowExpectedDisbursements = this.getDisallowExpectedDisbursements();
        Boolean other$disallowExpectedDisbursements = other.getDisallowExpectedDisbursements();
        if (this$disallowExpectedDisbursements == null ? other$disallowExpectedDisbursements != null : !((Object)this$disallowExpectedDisbursements).equals(other$disallowExpectedDisbursements)) {
            return false;
        }
        Integer this$loanCounter = this.getLoanCounter();
        Integer other$loanCounter = other.getLoanCounter();
        if (this$loanCounter == null ? other$loanCounter != null : !((Object)this$loanCounter).equals(other$loanCounter)) {
            return false;
        }
        Integer this$loanProductCounter = this.getLoanProductCounter();
        Integer other$loanProductCounter = other.getLoanProductCounter();
        if (this$loanProductCounter == null ? other$loanProductCounter != null : !((Object)this$loanProductCounter).equals(other$loanProductCounter)) {
            return false;
        }
        Boolean this$multiDisburseLoan = this.getMultiDisburseLoan();
        Boolean other$multiDisburseLoan = other.getMultiDisburseLoan();
        if (this$multiDisburseLoan == null ? other$multiDisburseLoan != null : !((Object)this$multiDisburseLoan).equals(other$multiDisburseLoan)) {
            return false;
        }
        Boolean this$canDefineInstallmentAmount = this.getCanDefineInstallmentAmount();
        Boolean other$canDefineInstallmentAmount = other.getCanDefineInstallmentAmount();
        if (this$canDefineInstallmentAmount == null ? other$canDefineInstallmentAmount != null : !((Object)this$canDefineInstallmentAmount).equals(other$canDefineInstallmentAmount)) {
            return false;
        }
        Boolean this$canDisburse = this.getCanDisburse();
        Boolean other$canDisburse = other.getCanDisburse();
        if (this$canDisburse == null ? other$canDisburse != null : !((Object)this$canDisburse).equals(other$canDisburse)) {
            return false;
        }
        Boolean this$canUseForTopup = this.getCanUseForTopup();
        Boolean other$canUseForTopup = other.getCanUseForTopup();
        if (this$canUseForTopup == null ? other$canUseForTopup != null : !((Object)this$canUseForTopup).equals(other$canUseForTopup)) {
            return false;
        }
        Long this$closureLoanId = this.getClosureLoanId();
        Long other$closureLoanId = other.getClosureLoanId();
        if (this$closureLoanId == null ? other$closureLoanId != null : !((Object)this$closureLoanId).equals(other$closureLoanId)) {
            return false;
        }
        Boolean this$inArrears = this.getInArrears();
        Boolean other$inArrears = other.getInArrears();
        if (this$inArrears == null ? other$inArrears != null : !((Object)this$inArrears).equals(other$inArrears)) {
            return false;
        }
        Boolean this$isNPA = this.getIsNPA();
        Boolean other$isNPA = other.getIsNPA();
        if (this$isNPA == null ? other$isNPA != null : !((Object)this$isNPA).equals(other$isNPA)) {
            return false;
        }
        Boolean this$createStandingInstructionAtDisbursement = this.getCreateStandingInstructionAtDisbursement();
        Boolean other$createStandingInstructionAtDisbursement = other.getCreateStandingInstructionAtDisbursement();
        if (this$createStandingInstructionAtDisbursement == null ? other$createStandingInstructionAtDisbursement != null : !((Object)this$createStandingInstructionAtDisbursement).equals(other$createStandingInstructionAtDisbursement)) {
            return false;
        }
        Boolean this$isVariableInstallmentsAllowed = this.getIsVariableInstallmentsAllowed();
        Boolean other$isVariableInstallmentsAllowed = other.getIsVariableInstallmentsAllowed();
        if (this$isVariableInstallmentsAllowed == null ? other$isVariableInstallmentsAllowed != null : !((Object)this$isVariableInstallmentsAllowed).equals(other$isVariableInstallmentsAllowed)) {
            return false;
        }
        Integer this$minimumGap = this.getMinimumGap();
        Integer other$minimumGap = other.getMinimumGap();
        if (this$minimumGap == null ? other$minimumGap != null : !((Object)this$minimumGap).equals(other$minimumGap)) {
            return false;
        }
        Integer this$maximumGap = this.getMaximumGap();
        Integer other$maximumGap = other.getMaximumGap();
        if (this$maximumGap == null ? other$maximumGap != null : !((Object)this$maximumGap).equals(other$maximumGap)) {
            return false;
        }
        Boolean this$isEqualAmortization = this.getIsEqualAmortization();
        Boolean other$isEqualAmortization = other.getIsEqualAmortization();
        if (this$isEqualAmortization == null ? other$isEqualAmortization != null : !((Object)this$isEqualAmortization).equals(other$isEqualAmortization)) {
            return false;
        }
        Boolean this$isRatesEnabled = this.getIsRatesEnabled();
        Boolean other$isRatesEnabled = other.getIsRatesEnabled();
        if (this$isRatesEnabled == null ? other$isRatesEnabled != null : !((Object)this$isRatesEnabled).equals(other$isRatesEnabled)) {
            return false;
        }
        Long this$productId = this.getProductId();
        Long other$productId = other.getProductId();
        if (this$productId == null ? other$productId != null : !((Object)this$productId).equals(other$productId)) {
            return false;
        }
        Integer this$loanTermFrequency = this.getLoanTermFrequency();
        Integer other$loanTermFrequency = other.getLoanTermFrequency();
        if (this$loanTermFrequency == null ? other$loanTermFrequency != null : !((Object)this$loanTermFrequency).equals(other$loanTermFrequency)) {
            return false;
        }
        Long this$groupId = this.getGroupId();
        Long other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !((Object)this$groupId).equals(other$groupId)) {
            return false;
        }
        Boolean this$enableInstallmentLevelDelinquency = this.getEnableInstallmentLevelDelinquency();
        Boolean other$enableInstallmentLevelDelinquency = other.getEnableInstallmentLevelDelinquency();
        if (this$enableInstallmentLevelDelinquency == null ? other$enableInstallmentLevelDelinquency != null : !((Object)this$enableInstallmentLevelDelinquency).equals(other$enableInstallmentLevelDelinquency)) {
            return false;
        }
        Boolean this$chargedOff = this.getChargedOff();
        Boolean other$chargedOff = other.getChargedOff();
        if (this$chargedOff == null ? other$chargedOff != null : !((Object)this$chargedOff).equals(other$chargedOff)) {
            return false;
        }
        Boolean this$enableDownPayment = this.getEnableDownPayment();
        Boolean other$enableDownPayment = other.getEnableDownPayment();
        if (this$enableDownPayment == null ? other$enableDownPayment != null : !((Object)this$enableDownPayment).equals(other$enableDownPayment)) {
            return false;
        }
        Boolean this$enableAutoRepaymentForDownPayment = this.getEnableAutoRepaymentForDownPayment();
        Boolean other$enableAutoRepaymentForDownPayment = other.getEnableAutoRepaymentForDownPayment();
        if (this$enableAutoRepaymentForDownPayment == null ? other$enableAutoRepaymentForDownPayment != null : !((Object)this$enableAutoRepaymentForDownPayment).equals(other$enableAutoRepaymentForDownPayment)) {
            return false;
        }
        Boolean this$interestRecognitionOnDisbursementDate = this.getInterestRecognitionOnDisbursementDate();
        Boolean other$interestRecognitionOnDisbursementDate = other.getInterestRecognitionOnDisbursementDate();
        if (this$interestRecognitionOnDisbursementDate == null ? other$interestRecognitionOnDisbursementDate != null : !((Object)this$interestRecognitionOnDisbursementDate).equals(other$interestRecognitionOnDisbursementDate)) {
            return false;
        }
        String this$accountNo = this.getAccountNo();
        String other$accountNo = other.getAccountNo();
        if (this$accountNo == null ? other$accountNo != null : !this$accountNo.equals(other$accountNo)) {
            return false;
        }
        ExternalId this$externalId = this.getExternalId();
        ExternalId other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        LoanStatusEnumData this$status = this.getStatus();
        LoanStatusEnumData other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        EnumOptionData this$subStatus = this.getSubStatus();
        EnumOptionData other$subStatus = other.getSubStatus();
        if (this$subStatus == null ? other$subStatus != null : !this$subStatus.equals(other$subStatus)) {
            return false;
        }
        String this$clientAccountNo = this.getClientAccountNo();
        String other$clientAccountNo = other.getClientAccountNo();
        if (this$clientAccountNo == null ? other$clientAccountNo != null : !this$clientAccountNo.equals(other$clientAccountNo)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        ExternalId this$clientExternalId = this.getClientExternalId();
        ExternalId other$clientExternalId = other.getClientExternalId();
        if (this$clientExternalId == null ? other$clientExternalId != null : !this$clientExternalId.equals(other$clientExternalId)) {
            return false;
        }
        GroupGeneralData this$group = this.getGroup();
        GroupGeneralData other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$loanProductName = this.getLoanProductName();
        String other$loanProductName = other.getLoanProductName();
        if (this$loanProductName == null ? other$loanProductName != null : !this$loanProductName.equals(other$loanProductName)) {
            return false;
        }
        String this$loanProductDescription = this.getLoanProductDescription();
        String other$loanProductDescription = other.getLoanProductDescription();
        if (this$loanProductDescription == null ? other$loanProductDescription != null : !this$loanProductDescription.equals(other$loanProductDescription)) {
            return false;
        }
        String this$fundName = this.getFundName();
        String other$fundName = other.getFundName();
        if (this$fundName == null ? other$fundName != null : !this$fundName.equals(other$fundName)) {
            return false;
        }
        String this$loanPurposeName = this.getLoanPurposeName();
        String other$loanPurposeName = other.getLoanPurposeName();
        if (this$loanPurposeName == null ? other$loanPurposeName != null : !this$loanPurposeName.equals(other$loanPurposeName)) {
            return false;
        }
        String this$loanOfficerName = this.getLoanOfficerName();
        String other$loanOfficerName = other.getLoanOfficerName();
        if (this$loanOfficerName == null ? other$loanOfficerName != null : !this$loanOfficerName.equals(other$loanOfficerName)) {
            return false;
        }
        EnumOptionData this$loanType = this.getLoanType();
        EnumOptionData other$loanType = other.getLoanType();
        if (this$loanType == null ? other$loanType != null : !this$loanType.equals(other$loanType)) {
            return false;
        }
        CurrencyData this$currency = this.getCurrency();
        CurrencyData other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        BigDecimal this$principal = this.getPrincipal();
        BigDecimal other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !((Object)this$principal).equals(other$principal)) {
            return false;
        }
        BigDecimal this$approvedPrincipal = this.getApprovedPrincipal();
        BigDecimal other$approvedPrincipal = other.getApprovedPrincipal();
        if (this$approvedPrincipal == null ? other$approvedPrincipal != null : !((Object)this$approvedPrincipal).equals(other$approvedPrincipal)) {
            return false;
        }
        BigDecimal this$proposedPrincipal = this.getProposedPrincipal();
        BigDecimal other$proposedPrincipal = other.getProposedPrincipal();
        if (this$proposedPrincipal == null ? other$proposedPrincipal != null : !((Object)this$proposedPrincipal).equals(other$proposedPrincipal)) {
            return false;
        }
        BigDecimal this$netDisbursalAmount = this.getNetDisbursalAmount();
        BigDecimal other$netDisbursalAmount = other.getNetDisbursalAmount();
        if (this$netDisbursalAmount == null ? other$netDisbursalAmount != null : !((Object)this$netDisbursalAmount).equals(other$netDisbursalAmount)) {
            return false;
        }
        EnumOptionData this$termPeriodFrequencyType = this.getTermPeriodFrequencyType();
        EnumOptionData other$termPeriodFrequencyType = other.getTermPeriodFrequencyType();
        if (this$termPeriodFrequencyType == null ? other$termPeriodFrequencyType != null : !this$termPeriodFrequencyType.equals(other$termPeriodFrequencyType)) {
            return false;
        }
        EnumOptionData this$repaymentFrequencyType = this.getRepaymentFrequencyType();
        EnumOptionData other$repaymentFrequencyType = other.getRepaymentFrequencyType();
        if (this$repaymentFrequencyType == null ? other$repaymentFrequencyType != null : !this$repaymentFrequencyType.equals(other$repaymentFrequencyType)) {
            return false;
        }
        EnumOptionData this$repaymentFrequencyNthDayType = this.getRepaymentFrequencyNthDayType();
        EnumOptionData other$repaymentFrequencyNthDayType = other.getRepaymentFrequencyNthDayType();
        if (this$repaymentFrequencyNthDayType == null ? other$repaymentFrequencyNthDayType != null : !this$repaymentFrequencyNthDayType.equals(other$repaymentFrequencyNthDayType)) {
            return false;
        }
        EnumOptionData this$repaymentFrequencyDayOfWeekType = this.getRepaymentFrequencyDayOfWeekType();
        EnumOptionData other$repaymentFrequencyDayOfWeekType = other.getRepaymentFrequencyDayOfWeekType();
        if (this$repaymentFrequencyDayOfWeekType == null ? other$repaymentFrequencyDayOfWeekType != null : !this$repaymentFrequencyDayOfWeekType.equals(other$repaymentFrequencyDayOfWeekType)) {
            return false;
        }
        BigDecimal this$interestRatePerPeriod = this.getInterestRatePerPeriod();
        BigDecimal other$interestRatePerPeriod = other.getInterestRatePerPeriod();
        if (this$interestRatePerPeriod == null ? other$interestRatePerPeriod != null : !((Object)this$interestRatePerPeriod).equals(other$interestRatePerPeriod)) {
            return false;
        }
        EnumOptionData this$interestRateFrequencyType = this.getInterestRateFrequencyType();
        EnumOptionData other$interestRateFrequencyType = other.getInterestRateFrequencyType();
        if (this$interestRateFrequencyType == null ? other$interestRateFrequencyType != null : !this$interestRateFrequencyType.equals(other$interestRateFrequencyType)) {
            return false;
        }
        BigDecimal this$annualInterestRate = this.getAnnualInterestRate();
        BigDecimal other$annualInterestRate = other.getAnnualInterestRate();
        if (this$annualInterestRate == null ? other$annualInterestRate != null : !((Object)this$annualInterestRate).equals(other$annualInterestRate)) {
            return false;
        }
        BigDecimal this$interestRateDifferential = this.getInterestRateDifferential();
        BigDecimal other$interestRateDifferential = other.getInterestRateDifferential();
        if (this$interestRateDifferential == null ? other$interestRateDifferential != null : !((Object)this$interestRateDifferential).equals(other$interestRateDifferential)) {
            return false;
        }
        EnumOptionData this$amortizationType = this.getAmortizationType();
        EnumOptionData other$amortizationType = other.getAmortizationType();
        if (this$amortizationType == null ? other$amortizationType != null : !this$amortizationType.equals(other$amortizationType)) {
            return false;
        }
        EnumOptionData this$interestType = this.getInterestType();
        EnumOptionData other$interestType = other.getInterestType();
        if (this$interestType == null ? other$interestType != null : !this$interestType.equals(other$interestType)) {
            return false;
        }
        EnumOptionData this$interestCalculationPeriodType = this.getInterestCalculationPeriodType();
        EnumOptionData other$interestCalculationPeriodType = other.getInterestCalculationPeriodType();
        if (this$interestCalculationPeriodType == null ? other$interestCalculationPeriodType != null : !this$interestCalculationPeriodType.equals(other$interestCalculationPeriodType)) {
            return false;
        }
        BigDecimal this$inArrearsTolerance = this.getInArrearsTolerance();
        BigDecimal other$inArrearsTolerance = other.getInArrearsTolerance();
        if (this$inArrearsTolerance == null ? other$inArrearsTolerance != null : !((Object)this$inArrearsTolerance).equals(other$inArrearsTolerance)) {
            return false;
        }
        String this$transactionProcessingStrategyCode = this.getTransactionProcessingStrategyCode();
        String other$transactionProcessingStrategyCode = other.getTransactionProcessingStrategyCode();
        if (this$transactionProcessingStrategyCode == null ? other$transactionProcessingStrategyCode != null : !this$transactionProcessingStrategyCode.equals(other$transactionProcessingStrategyCode)) {
            return false;
        }
        String this$transactionProcessingStrategyName = this.getTransactionProcessingStrategyName();
        String other$transactionProcessingStrategyName = other.getTransactionProcessingStrategyName();
        if (this$transactionProcessingStrategyName == null ? other$transactionProcessingStrategyName != null : !this$transactionProcessingStrategyName.equals(other$transactionProcessingStrategyName)) {
            return false;
        }
        LocalDate this$interestChargedFromDate = this.getInterestChargedFromDate();
        LocalDate other$interestChargedFromDate = other.getInterestChargedFromDate();
        if (this$interestChargedFromDate == null ? other$interestChargedFromDate != null : !((Object)this$interestChargedFromDate).equals(other$interestChargedFromDate)) {
            return false;
        }
        LocalDate this$expectedFirstRepaymentOnDate = this.getExpectedFirstRepaymentOnDate();
        LocalDate other$expectedFirstRepaymentOnDate = other.getExpectedFirstRepaymentOnDate();
        if (this$expectedFirstRepaymentOnDate == null ? other$expectedFirstRepaymentOnDate != null : !((Object)this$expectedFirstRepaymentOnDate).equals(other$expectedFirstRepaymentOnDate)) {
            return false;
        }
        LoanApplicationTimelineData this$timeline = this.getTimeline();
        LoanApplicationTimelineData other$timeline = other.getTimeline();
        if (this$timeline == null ? other$timeline != null : !this$timeline.equals(other$timeline)) {
            return false;
        }
        LoanSummaryData this$summary = this.getSummary();
        LoanSummaryData other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        LoanScheduleData this$repaymentSchedule = this.getRepaymentSchedule();
        LoanScheduleData other$repaymentSchedule = other.getRepaymentSchedule();
        if (this$repaymentSchedule == null ? other$repaymentSchedule != null : !this$repaymentSchedule.equals(other$repaymentSchedule)) {
            return false;
        }
        Collection this$transactions = this.getTransactions();
        Collection other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        Collection this$charges = this.getCharges();
        Collection other$charges = other.getCharges();
        if (this$charges == null ? other$charges != null : !((Object)this$charges).equals(other$charges)) {
            return false;
        }
        Collection this$collateral = this.getCollateral();
        Collection other$collateral = other.getCollateral();
        if (this$collateral == null ? other$collateral != null : !((Object)this$collateral).equals(other$collateral)) {
            return false;
        }
        Collection this$guarantors = this.getGuarantors();
        Collection other$guarantors = other.getGuarantors();
        if (this$guarantors == null ? other$guarantors != null : !((Object)this$guarantors).equals(other$guarantors)) {
            return false;
        }
        CalendarData this$meeting = this.getMeeting();
        CalendarData other$meeting = other.getMeeting();
        if (this$meeting == null ? other$meeting != null : !this$meeting.equals(other$meeting)) {
            return false;
        }
        Collection this$notes = this.getNotes();
        Collection other$notes = other.getNotes();
        if (this$notes == null ? other$notes != null : !((Object)this$notes).equals(other$notes)) {
            return false;
        }
        Collection this$disbursementDetails = this.getDisbursementDetails();
        Collection other$disbursementDetails = other.getDisbursementDetails();
        if (this$disbursementDetails == null ? other$disbursementDetails != null : !((Object)this$disbursementDetails).equals(other$disbursementDetails)) {
            return false;
        }
        LoanScheduleData this$originalSchedule = this.getOriginalSchedule();
        LoanScheduleData other$originalSchedule = other.getOriginalSchedule();
        if (this$originalSchedule == null ? other$originalSchedule != null : !this$originalSchedule.equals(other$originalSchedule)) {
            return false;
        }
        Collection this$productOptions = this.getProductOptions();
        Collection other$productOptions = other.getProductOptions();
        if (this$productOptions == null ? other$productOptions != null : !((Object)this$productOptions).equals(other$productOptions)) {
            return false;
        }
        Collection this$loanOfficerOptions = this.getLoanOfficerOptions();
        Collection other$loanOfficerOptions = other.getLoanOfficerOptions();
        if (this$loanOfficerOptions == null ? other$loanOfficerOptions != null : !((Object)this$loanOfficerOptions).equals(other$loanOfficerOptions)) {
            return false;
        }
        Collection this$loanPurposeOptions = this.getLoanPurposeOptions();
        Collection other$loanPurposeOptions = other.getLoanPurposeOptions();
        if (this$loanPurposeOptions == null ? other$loanPurposeOptions != null : !((Object)this$loanPurposeOptions).equals(other$loanPurposeOptions)) {
            return false;
        }
        Collection this$fundOptions = this.getFundOptions();
        Collection other$fundOptions = other.getFundOptions();
        if (this$fundOptions == null ? other$fundOptions != null : !((Object)this$fundOptions).equals(other$fundOptions)) {
            return false;
        }
        Collection this$termFrequencyTypeOptions = this.getTermFrequencyTypeOptions();
        Collection other$termFrequencyTypeOptions = other.getTermFrequencyTypeOptions();
        if (this$termFrequencyTypeOptions == null ? other$termFrequencyTypeOptions != null : !((Object)this$termFrequencyTypeOptions).equals(other$termFrequencyTypeOptions)) {
            return false;
        }
        Collection this$repaymentFrequencyTypeOptions = this.getRepaymentFrequencyTypeOptions();
        Collection other$repaymentFrequencyTypeOptions = other.getRepaymentFrequencyTypeOptions();
        if (this$repaymentFrequencyTypeOptions == null ? other$repaymentFrequencyTypeOptions != null : !((Object)this$repaymentFrequencyTypeOptions).equals(other$repaymentFrequencyTypeOptions)) {
            return false;
        }
        Collection this$repaymentFrequencyNthDayTypeOptions = this.getRepaymentFrequencyNthDayTypeOptions();
        Collection other$repaymentFrequencyNthDayTypeOptions = other.getRepaymentFrequencyNthDayTypeOptions();
        if (this$repaymentFrequencyNthDayTypeOptions == null ? other$repaymentFrequencyNthDayTypeOptions != null : !((Object)this$repaymentFrequencyNthDayTypeOptions).equals(other$repaymentFrequencyNthDayTypeOptions)) {
            return false;
        }
        Collection this$repaymentFrequencyDaysOfWeekTypeOptions = this.getRepaymentFrequencyDaysOfWeekTypeOptions();
        Collection other$repaymentFrequencyDaysOfWeekTypeOptions = other.getRepaymentFrequencyDaysOfWeekTypeOptions();
        if (this$repaymentFrequencyDaysOfWeekTypeOptions == null ? other$repaymentFrequencyDaysOfWeekTypeOptions != null : !((Object)this$repaymentFrequencyDaysOfWeekTypeOptions).equals(other$repaymentFrequencyDaysOfWeekTypeOptions)) {
            return false;
        }
        Collection this$interestRateFrequencyTypeOptions = this.getInterestRateFrequencyTypeOptions();
        Collection other$interestRateFrequencyTypeOptions = other.getInterestRateFrequencyTypeOptions();
        if (this$interestRateFrequencyTypeOptions == null ? other$interestRateFrequencyTypeOptions != null : !((Object)this$interestRateFrequencyTypeOptions).equals(other$interestRateFrequencyTypeOptions)) {
            return false;
        }
        Collection this$amortizationTypeOptions = this.getAmortizationTypeOptions();
        Collection other$amortizationTypeOptions = other.getAmortizationTypeOptions();
        if (this$amortizationTypeOptions == null ? other$amortizationTypeOptions != null : !((Object)this$amortizationTypeOptions).equals(other$amortizationTypeOptions)) {
            return false;
        }
        Collection this$interestTypeOptions = this.getInterestTypeOptions();
        Collection other$interestTypeOptions = other.getInterestTypeOptions();
        if (this$interestTypeOptions == null ? other$interestTypeOptions != null : !((Object)this$interestTypeOptions).equals(other$interestTypeOptions)) {
            return false;
        }
        Collection this$interestCalculationPeriodTypeOptions = this.getInterestCalculationPeriodTypeOptions();
        Collection other$interestCalculationPeriodTypeOptions = other.getInterestCalculationPeriodTypeOptions();
        if (this$interestCalculationPeriodTypeOptions == null ? other$interestCalculationPeriodTypeOptions != null : !((Object)this$interestCalculationPeriodTypeOptions).equals(other$interestCalculationPeriodTypeOptions)) {
            return false;
        }
        Collection this$transactionProcessingStrategyOptions = this.getTransactionProcessingStrategyOptions();
        Collection other$transactionProcessingStrategyOptions = other.getTransactionProcessingStrategyOptions();
        if (this$transactionProcessingStrategyOptions == null ? other$transactionProcessingStrategyOptions != null : !((Object)this$transactionProcessingStrategyOptions).equals(other$transactionProcessingStrategyOptions)) {
            return false;
        }
        Collection this$chargeOptions = this.getChargeOptions();
        Collection other$chargeOptions = other.getChargeOptions();
        if (this$chargeOptions == null ? other$chargeOptions != null : !((Object)this$chargeOptions).equals(other$chargeOptions)) {
            return false;
        }
        Collection this$loanCollateralOptions = this.getLoanCollateralOptions();
        Collection other$loanCollateralOptions = other.getLoanCollateralOptions();
        if (this$loanCollateralOptions == null ? other$loanCollateralOptions != null : !((Object)this$loanCollateralOptions).equals(other$loanCollateralOptions)) {
            return false;
        }
        Collection this$calendarOptions = this.getCalendarOptions();
        Collection other$calendarOptions = other.getCalendarOptions();
        if (this$calendarOptions == null ? other$calendarOptions != null : !((Object)this$calendarOptions).equals(other$calendarOptions)) {
            return false;
        }
        List this$loanScheduleTypeOptions = this.getLoanScheduleTypeOptions();
        List other$loanScheduleTypeOptions = other.getLoanScheduleTypeOptions();
        if (this$loanScheduleTypeOptions == null ? other$loanScheduleTypeOptions != null : !((Object)this$loanScheduleTypeOptions).equals(other$loanScheduleTypeOptions)) {
            return false;
        }
        List this$loanScheduleProcessingTypeOptions = this.getLoanScheduleProcessingTypeOptions();
        List other$loanScheduleProcessingTypeOptions = other.getLoanScheduleProcessingTypeOptions();
        if (this$loanScheduleProcessingTypeOptions == null ? other$loanScheduleProcessingTypeOptions != null : !((Object)this$loanScheduleProcessingTypeOptions).equals(other$loanScheduleProcessingTypeOptions)) {
            return false;
        }
        BigDecimal this$feeChargesAtDisbursementCharged = this.getFeeChargesAtDisbursementCharged();
        BigDecimal other$feeChargesAtDisbursementCharged = other.getFeeChargesAtDisbursementCharged();
        if (this$feeChargesAtDisbursementCharged == null ? other$feeChargesAtDisbursementCharged != null : !((Object)this$feeChargesAtDisbursementCharged).equals(other$feeChargesAtDisbursementCharged)) {
            return false;
        }
        BigDecimal this$totalOverpaid = this.getTotalOverpaid();
        BigDecimal other$totalOverpaid = other.getTotalOverpaid();
        if (this$totalOverpaid == null ? other$totalOverpaid != null : !((Object)this$totalOverpaid).equals(other$totalOverpaid)) {
            return false;
        }
        PortfolioAccountData this$linkedAccount = this.getLinkedAccount();
        PortfolioAccountData other$linkedAccount = other.getLinkedAccount();
        if (this$linkedAccount == null ? other$linkedAccount != null : !this$linkedAccount.equals(other$linkedAccount)) {
            return false;
        }
        Collection this$accountLinkingOptions = this.getAccountLinkingOptions();
        Collection other$accountLinkingOptions = other.getAccountLinkingOptions();
        if (this$accountLinkingOptions == null ? other$accountLinkingOptions != null : !((Object)this$accountLinkingOptions).equals(other$accountLinkingOptions)) {
            return false;
        }
        BigDecimal this$fixedEmiAmount = this.getFixedEmiAmount();
        BigDecimal other$fixedEmiAmount = other.getFixedEmiAmount();
        if (this$fixedEmiAmount == null ? other$fixedEmiAmount != null : !((Object)this$fixedEmiAmount).equals(other$fixedEmiAmount)) {
            return false;
        }
        BigDecimal this$maxOutstandingLoanBalance = this.getMaxOutstandingLoanBalance();
        BigDecimal other$maxOutstandingLoanBalance = other.getMaxOutstandingLoanBalance();
        if (this$maxOutstandingLoanBalance == null ? other$maxOutstandingLoanBalance != null : !((Object)this$maxOutstandingLoanBalance).equals(other$maxOutstandingLoanBalance)) {
            return false;
        }
        Collection this$emiAmountVariations = this.getEmiAmountVariations();
        Collection other$emiAmountVariations = other.getEmiAmountVariations();
        if (this$emiAmountVariations == null ? other$emiAmountVariations != null : !((Object)this$emiAmountVariations).equals(other$emiAmountVariations)) {
            return false;
        }
        Collection this$loanTermVariations = this.getLoanTermVariations();
        Collection other$loanTermVariations = other.getLoanTermVariations();
        if (this$loanTermVariations == null ? other$loanTermVariations != null : !((Object)this$loanTermVariations).equals(other$loanTermVariations)) {
            return false;
        }
        Collection this$clientActiveLoanOptions = this.getClientActiveLoanOptions();
        Collection other$clientActiveLoanOptions = other.getClientActiveLoanOptions();
        if (this$clientActiveLoanOptions == null ? other$clientActiveLoanOptions != null : !((Object)this$clientActiveLoanOptions).equals(other$clientActiveLoanOptions)) {
            return false;
        }
        String this$closureLoanAccountNo = this.getClosureLoanAccountNo();
        String other$closureLoanAccountNo = other.getClosureLoanAccountNo();
        if (this$closureLoanAccountNo == null ? other$closureLoanAccountNo != null : !this$closureLoanAccountNo.equals(other$closureLoanAccountNo)) {
            return false;
        }
        BigDecimal this$topupAmount = this.getTopupAmount();
        BigDecimal other$topupAmount = other.getTopupAmount();
        if (this$topupAmount == null ? other$topupAmount != null : !((Object)this$topupAmount).equals(other$topupAmount)) {
            return false;
        }
        LoanProductData this$product = this.getProduct();
        LoanProductData other$product = other.getProduct();
        if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
            return false;
        }
        Map this$memberVariations = this.getMemberVariations();
        Map other$memberVariations = other.getMemberVariations();
        if (this$memberVariations == null ? other$memberVariations != null : !((Object)this$memberVariations).equals(other$memberVariations)) {
            return false;
        }
        Collection this$overdueCharges = this.getOverdueCharges();
        Collection other$overdueCharges = other.getOverdueCharges();
        if (this$overdueCharges == null ? other$overdueCharges != null : !((Object)this$overdueCharges).equals(other$overdueCharges)) {
            return false;
        }
        EnumOptionData this$daysInMonthType = this.getDaysInMonthType();
        EnumOptionData other$daysInMonthType = other.getDaysInMonthType();
        if (this$daysInMonthType == null ? other$daysInMonthType != null : !this$daysInMonthType.equals(other$daysInMonthType)) {
            return false;
        }
        EnumOptionData this$daysInYearType = this.getDaysInYearType();
        EnumOptionData other$daysInYearType = other.getDaysInYearType();
        if (this$daysInYearType == null ? other$daysInYearType != null : !this$daysInYearType.equals(other$daysInYearType)) {
            return false;
        }
        LoanInterestRecalculationData this$interestRecalculationData = this.getInterestRecalculationData();
        LoanInterestRecalculationData other$interestRecalculationData = other.getInterestRecalculationData();
        if (this$interestRecalculationData == null ? other$interestRecalculationData != null : !this$interestRecalculationData.equals(other$interestRecalculationData)) {
            return false;
        }
        PaidInAdvanceData this$paidInAdvance = this.getPaidInAdvance();
        PaidInAdvanceData other$paidInAdvance = other.getPaidInAdvance();
        if (this$paidInAdvance == null ? other$paidInAdvance != null : !this$paidInAdvance.equals(other$paidInAdvance)) {
            return false;
        }
        Collection this$interestRatesPeriods = this.getInterestRatesPeriods();
        Collection other$interestRatesPeriods = other.getInterestRatesPeriods();
        if (this$interestRatesPeriods == null ? other$interestRatesPeriods != null : !((Object)this$interestRatesPeriods).equals(other$interestRatesPeriods)) {
            return false;
        }
        List this$datatables = this.getDatatables();
        List other$datatables = other.getDatatables();
        if (this$datatables == null ? other$datatables != null : !((Object)this$datatables).equals(other$datatables)) {
            return false;
        }
        BigDecimal this$fixedPrincipalPercentagePerInstallment = this.getFixedPrincipalPercentagePerInstallment();
        BigDecimal bigDecimal = other.getFixedPrincipalPercentagePerInstallment();
        if (this$fixedPrincipalPercentagePerInstallment == null ? other$fixedPrincipalPercentagePerInstallment != null : !((Object)this$fixedPrincipalPercentagePerInstallment).equals(other$fixedPrincipalPercentagePerInstallment)) {
            return false;
        }
        List list = this.getRates();
        List list2 = other.getRates();
        if (this$rates == null ? other$rates != null : !this$rates.equals(other$rates)) {
            return false;
        }
        String string = this.getDateFormat();
        String string2 = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        String string3 = this.getLocale();
        String string4 = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        LocalDate localDate = this.getSubmittedOnDate();
        LocalDate localDate2 = other.getSubmittedOnDate();
        if (this$submittedOnDate == null ? other$submittedOnDate != null : !this$submittedOnDate.equals(other$submittedOnDate)) {
            return false;
        }
        EnumOptionData enumOptionData = this.getLoanTermFrequencyType();
        EnumOptionData enumOptionData2 = other.getLoanTermFrequencyType();
        if (this$loanTermFrequencyType == null ? other$loanTermFrequencyType != null : !this$loanTermFrequencyType.equals(other$loanTermFrequencyType)) {
            return false;
        }
        LocalDate localDate3 = this.getRepaymentsStartingFromDate();
        LocalDate localDate4 = other.getRepaymentsStartingFromDate();
        if (this$repaymentsStartingFromDate == null ? other$repaymentsStartingFromDate != null : !this$repaymentsStartingFromDate.equals(other$repaymentsStartingFromDate)) {
            return false;
        }
        String string5 = this.getLinkAccountId();
        String string6 = other.getLinkAccountId();
        if (this$linkAccountId == null ? other$linkAccountId != null : !this$linkAccountId.equals(other$linkAccountId)) {
            return false;
        }
        LocalDate localDate5 = this.getExpectedDisbursementDate();
        LocalDate localDate6 = other.getExpectedDisbursementDate();
        if (this$expectedDisbursementDate == null ? other$expectedDisbursementDate != null : !this$expectedDisbursementDate.equals(other$expectedDisbursementDate)) {
            return false;
        }
        LocalDate localDate7 = this.getOverpaidOnDate();
        LocalDate localDate8 = other.getOverpaidOnDate();
        if (this$overpaidOnDate == null ? other$overpaidOnDate != null : !this$overpaidOnDate.equals(other$overpaidOnDate)) {
            return false;
        }
        CollectionData collectionData = this.getDelinquent();
        CollectionData collectionData2 = other.getDelinquent();
        if (this$delinquent == null ? other$delinquent != null : !this$delinquent.equals(other$delinquent)) {
            return false;
        }
        DelinquencyRangeData delinquencyRangeData = this.getDelinquencyRange();
        DelinquencyRangeData delinquencyRangeData2 = other.getDelinquencyRange();
        if (this$delinquencyRange == null ? other$delinquencyRange != null : !this$delinquencyRange.equals(other$delinquencyRange)) {
            return false;
        }
        LocalDate localDate9 = this.getLastClosedBusinessDate();
        LocalDate localDate10 = other.getLastClosedBusinessDate();
        if (this$lastClosedBusinessDate == null ? other$lastClosedBusinessDate != null : !this$lastClosedBusinessDate.equals(other$lastClosedBusinessDate)) {
            return false;
        }
        BigDecimal bigDecimal2 = this.getDisbursedAmountPercentageForDownPayment();
        BigDecimal bigDecimal3 = other.getDisbursedAmountPercentageForDownPayment();
        if (this$disbursedAmountPercentageForDownPayment == null ? other$disbursedAmountPercentageForDownPayment != null : !this$disbursedAmountPercentageForDownPayment.equals(other$disbursedAmountPercentageForDownPayment)) {
            return false;
        }
        EnumOptionData enumOptionData3 = this.getLoanScheduleType();
        EnumOptionData enumOptionData4 = other.getLoanScheduleType();
        if (this$loanScheduleType == null ? other$loanScheduleType != null : !this$loanScheduleType.equals(other$loanScheduleType)) {
            return false;
        }
        EnumOptionData enumOptionData5 = this.getLoanScheduleProcessingType();
        EnumOptionData enumOptionData6 = other.getLoanScheduleProcessingType();
        if (this$loanScheduleProcessingType == null ? other$loanScheduleProcessingType != null : !this$loanScheduleProcessingType.equals(other$loanScheduleProcessingType)) {
            return false;
        }
        StringEnumOptionData stringEnumOptionData = this.getChargeOffBehaviour();
        StringEnumOptionData stringEnumOptionData2 = other.getChargeOffBehaviour();
        return !(this$chargeOffBehaviour == null ? other$chargeOffBehaviour != null : !this$chargeOffBehaviour.equals(other$chargeOffBehaviour));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LoanAccountData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLoanProductLinkedToFloatingRate() ? 79 : 97);
        result = result * 59 + (this.isFloatingInterestRate() ? 79 : 97);
        result = result * 59 + (this.isTopup() ? 79 : 97);
        result = result * 59 + (this.isFraud() ? 79 : 97);
        result = result * 59 + (this.isInterestRecalculationEnabled() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : ((Object)$clientId).hashCode());
        Long $clientOfficeId = this.getClientOfficeId();
        result = result * 59 + ($clientOfficeId == null ? 43 : ((Object)$clientOfficeId).hashCode());
        Long $loanProductId = this.getLoanProductId();
        result = result * 59 + ($loanProductId == null ? 43 : ((Object)$loanProductId).hashCode());
        Long $fundId = this.getFundId();
        result = result * 59 + ($fundId == null ? 43 : ((Object)$fundId).hashCode());
        Long $loanPurposeId = this.getLoanPurposeId();
        result = result * 59 + ($loanPurposeId == null ? 43 : ((Object)$loanPurposeId).hashCode());
        Long $loanOfficerId = this.getLoanOfficerId();
        result = result * 59 + ($loanOfficerId == null ? 43 : ((Object)$loanOfficerId).hashCode());
        Integer $termFrequency = this.getTermFrequency();
        result = result * 59 + ($termFrequency == null ? 43 : ((Object)$termFrequency).hashCode());
        Integer $numberOfRepayments = this.getNumberOfRepayments();
        result = result * 59 + ($numberOfRepayments == null ? 43 : ((Object)$numberOfRepayments).hashCode());
        Integer $repaymentEvery = this.getRepaymentEvery();
        result = result * 59 + ($repaymentEvery == null ? 43 : ((Object)$repaymentEvery).hashCode());
        Integer $fixedLength = this.getFixedLength();
        result = result * 59 + ($fixedLength == null ? 43 : ((Object)$fixedLength).hashCode());
        Boolean $allowPartialPeriodInterestCalculation = this.getAllowPartialPeriodInterestCalculation();
        result = result * 59 + ($allowPartialPeriodInterestCalculation == null ? 43 : ((Object)$allowPartialPeriodInterestCalculation).hashCode());
        Integer $graceOnPrincipalPayment = this.getGraceOnPrincipalPayment();
        result = result * 59 + ($graceOnPrincipalPayment == null ? 43 : ((Object)$graceOnPrincipalPayment).hashCode());
        Integer $recurringMoratoriumOnPrincipalPeriods = this.getRecurringMoratoriumOnPrincipalPeriods();
        result = result * 59 + ($recurringMoratoriumOnPrincipalPeriods == null ? 43 : ((Object)$recurringMoratoriumOnPrincipalPeriods).hashCode());
        Integer $graceOnInterestPayment = this.getGraceOnInterestPayment();
        result = result * 59 + ($graceOnInterestPayment == null ? 43 : ((Object)$graceOnInterestPayment).hashCode());
        Integer $graceOnInterestCharged = this.getGraceOnInterestCharged();
        result = result * 59 + ($graceOnInterestCharged == null ? 43 : ((Object)$graceOnInterestCharged).hashCode());
        Integer $graceOnArrearsAgeing = this.getGraceOnArrearsAgeing();
        result = result * 59 + ($graceOnArrearsAgeing == null ? 43 : ((Object)$graceOnArrearsAgeing).hashCode());
        Boolean $syncDisbursementWithMeeting = this.getSyncDisbursementWithMeeting();
        result = result * 59 + ($syncDisbursementWithMeeting == null ? 43 : ((Object)$syncDisbursementWithMeeting).hashCode());
        Boolean $disallowExpectedDisbursements = this.getDisallowExpectedDisbursements();
        result = result * 59 + ($disallowExpectedDisbursements == null ? 43 : ((Object)$disallowExpectedDisbursements).hashCode());
        Integer $loanCounter = this.getLoanCounter();
        result = result * 59 + ($loanCounter == null ? 43 : ((Object)$loanCounter).hashCode());
        Integer $loanProductCounter = this.getLoanProductCounter();
        result = result * 59 + ($loanProductCounter == null ? 43 : ((Object)$loanProductCounter).hashCode());
        Boolean $multiDisburseLoan = this.getMultiDisburseLoan();
        result = result * 59 + ($multiDisburseLoan == null ? 43 : ((Object)$multiDisburseLoan).hashCode());
        Boolean $canDefineInstallmentAmount = this.getCanDefineInstallmentAmount();
        result = result * 59 + ($canDefineInstallmentAmount == null ? 43 : ((Object)$canDefineInstallmentAmount).hashCode());
        Boolean $canDisburse = this.getCanDisburse();
        result = result * 59 + ($canDisburse == null ? 43 : ((Object)$canDisburse).hashCode());
        Boolean $canUseForTopup = this.getCanUseForTopup();
        result = result * 59 + ($canUseForTopup == null ? 43 : ((Object)$canUseForTopup).hashCode());
        Long $closureLoanId = this.getClosureLoanId();
        result = result * 59 + ($closureLoanId == null ? 43 : ((Object)$closureLoanId).hashCode());
        Boolean $inArrears = this.getInArrears();
        result = result * 59 + ($inArrears == null ? 43 : ((Object)$inArrears).hashCode());
        Boolean $isNPA = this.getIsNPA();
        result = result * 59 + ($isNPA == null ? 43 : ((Object)$isNPA).hashCode());
        Boolean $createStandingInstructionAtDisbursement = this.getCreateStandingInstructionAtDisbursement();
        result = result * 59 + ($createStandingInstructionAtDisbursement == null ? 43 : ((Object)$createStandingInstructionAtDisbursement).hashCode());
        Boolean $isVariableInstallmentsAllowed = this.getIsVariableInstallmentsAllowed();
        result = result * 59 + ($isVariableInstallmentsAllowed == null ? 43 : ((Object)$isVariableInstallmentsAllowed).hashCode());
        Integer $minimumGap = this.getMinimumGap();
        result = result * 59 + ($minimumGap == null ? 43 : ((Object)$minimumGap).hashCode());
        Integer $maximumGap = this.getMaximumGap();
        result = result * 59 + ($maximumGap == null ? 43 : ((Object)$maximumGap).hashCode());
        Boolean $isEqualAmortization = this.getIsEqualAmortization();
        result = result * 59 + ($isEqualAmortization == null ? 43 : ((Object)$isEqualAmortization).hashCode());
        Boolean $isRatesEnabled = this.getIsRatesEnabled();
        result = result * 59 + ($isRatesEnabled == null ? 43 : ((Object)$isRatesEnabled).hashCode());
        Long $productId = this.getProductId();
        result = result * 59 + ($productId == null ? 43 : ((Object)$productId).hashCode());
        Integer $loanTermFrequency = this.getLoanTermFrequency();
        result = result * 59 + ($loanTermFrequency == null ? 43 : ((Object)$loanTermFrequency).hashCode());
        Long $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : ((Object)$groupId).hashCode());
        Boolean $enableInstallmentLevelDelinquency = this.getEnableInstallmentLevelDelinquency();
        result = result * 59 + ($enableInstallmentLevelDelinquency == null ? 43 : ((Object)$enableInstallmentLevelDelinquency).hashCode());
        Boolean $chargedOff = this.getChargedOff();
        result = result * 59 + ($chargedOff == null ? 43 : ((Object)$chargedOff).hashCode());
        Boolean $enableDownPayment = this.getEnableDownPayment();
        result = result * 59 + ($enableDownPayment == null ? 43 : ((Object)$enableDownPayment).hashCode());
        Boolean $enableAutoRepaymentForDownPayment = this.getEnableAutoRepaymentForDownPayment();
        result = result * 59 + ($enableAutoRepaymentForDownPayment == null ? 43 : ((Object)$enableAutoRepaymentForDownPayment).hashCode());
        Boolean $interestRecognitionOnDisbursementDate = this.getInterestRecognitionOnDisbursementDate();
        result = result * 59 + ($interestRecognitionOnDisbursementDate == null ? 43 : ((Object)$interestRecognitionOnDisbursementDate).hashCode());
        String $accountNo = this.getAccountNo();
        result = result * 59 + ($accountNo == null ? 43 : $accountNo.hashCode());
        ExternalId $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        LoanStatusEnumData $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        EnumOptionData $subStatus = this.getSubStatus();
        result = result * 59 + ($subStatus == null ? 43 : $subStatus.hashCode());
        String $clientAccountNo = this.getClientAccountNo();
        result = result * 59 + ($clientAccountNo == null ? 43 : $clientAccountNo.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        ExternalId $clientExternalId = this.getClientExternalId();
        result = result * 59 + ($clientExternalId == null ? 43 : $clientExternalId.hashCode());
        GroupGeneralData $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $loanProductName = this.getLoanProductName();
        result = result * 59 + ($loanProductName == null ? 43 : $loanProductName.hashCode());
        String $loanProductDescription = this.getLoanProductDescription();
        result = result * 59 + ($loanProductDescription == null ? 43 : $loanProductDescription.hashCode());
        String $fundName = this.getFundName();
        result = result * 59 + ($fundName == null ? 43 : $fundName.hashCode());
        String $loanPurposeName = this.getLoanPurposeName();
        result = result * 59 + ($loanPurposeName == null ? 43 : $loanPurposeName.hashCode());
        String $loanOfficerName = this.getLoanOfficerName();
        result = result * 59 + ($loanOfficerName == null ? 43 : $loanOfficerName.hashCode());
        EnumOptionData $loanType = this.getLoanType();
        result = result * 59 + ($loanType == null ? 43 : $loanType.hashCode());
        CurrencyData $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        BigDecimal $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : ((Object)$principal).hashCode());
        BigDecimal $approvedPrincipal = this.getApprovedPrincipal();
        result = result * 59 + ($approvedPrincipal == null ? 43 : ((Object)$approvedPrincipal).hashCode());
        BigDecimal $proposedPrincipal = this.getProposedPrincipal();
        result = result * 59 + ($proposedPrincipal == null ? 43 : ((Object)$proposedPrincipal).hashCode());
        BigDecimal $netDisbursalAmount = this.getNetDisbursalAmount();
        result = result * 59 + ($netDisbursalAmount == null ? 43 : ((Object)$netDisbursalAmount).hashCode());
        EnumOptionData $termPeriodFrequencyType = this.getTermPeriodFrequencyType();
        result = result * 59 + ($termPeriodFrequencyType == null ? 43 : $termPeriodFrequencyType.hashCode());
        EnumOptionData $repaymentFrequencyType = this.getRepaymentFrequencyType();
        result = result * 59 + ($repaymentFrequencyType == null ? 43 : $repaymentFrequencyType.hashCode());
        EnumOptionData $repaymentFrequencyNthDayType = this.getRepaymentFrequencyNthDayType();
        result = result * 59 + ($repaymentFrequencyNthDayType == null ? 43 : $repaymentFrequencyNthDayType.hashCode());
        EnumOptionData $repaymentFrequencyDayOfWeekType = this.getRepaymentFrequencyDayOfWeekType();
        result = result * 59 + ($repaymentFrequencyDayOfWeekType == null ? 43 : $repaymentFrequencyDayOfWeekType.hashCode());
        BigDecimal $interestRatePerPeriod = this.getInterestRatePerPeriod();
        result = result * 59 + ($interestRatePerPeriod == null ? 43 : ((Object)$interestRatePerPeriod).hashCode());
        EnumOptionData $interestRateFrequencyType = this.getInterestRateFrequencyType();
        result = result * 59 + ($interestRateFrequencyType == null ? 43 : $interestRateFrequencyType.hashCode());
        BigDecimal $annualInterestRate = this.getAnnualInterestRate();
        result = result * 59 + ($annualInterestRate == null ? 43 : ((Object)$annualInterestRate).hashCode());
        BigDecimal $interestRateDifferential = this.getInterestRateDifferential();
        result = result * 59 + ($interestRateDifferential == null ? 43 : ((Object)$interestRateDifferential).hashCode());
        EnumOptionData $amortizationType = this.getAmortizationType();
        result = result * 59 + ($amortizationType == null ? 43 : $amortizationType.hashCode());
        EnumOptionData $interestType = this.getInterestType();
        result = result * 59 + ($interestType == null ? 43 : $interestType.hashCode());
        EnumOptionData $interestCalculationPeriodType = this.getInterestCalculationPeriodType();
        result = result * 59 + ($interestCalculationPeriodType == null ? 43 : $interestCalculationPeriodType.hashCode());
        BigDecimal $inArrearsTolerance = this.getInArrearsTolerance();
        result = result * 59 + ($inArrearsTolerance == null ? 43 : ((Object)$inArrearsTolerance).hashCode());
        String $transactionProcessingStrategyCode = this.getTransactionProcessingStrategyCode();
        result = result * 59 + ($transactionProcessingStrategyCode == null ? 43 : $transactionProcessingStrategyCode.hashCode());
        String $transactionProcessingStrategyName = this.getTransactionProcessingStrategyName();
        result = result * 59 + ($transactionProcessingStrategyName == null ? 43 : $transactionProcessingStrategyName.hashCode());
        LocalDate $interestChargedFromDate = this.getInterestChargedFromDate();
        result = result * 59 + ($interestChargedFromDate == null ? 43 : ((Object)$interestChargedFromDate).hashCode());
        LocalDate $expectedFirstRepaymentOnDate = this.getExpectedFirstRepaymentOnDate();
        result = result * 59 + ($expectedFirstRepaymentOnDate == null ? 43 : ((Object)$expectedFirstRepaymentOnDate).hashCode());
        LoanApplicationTimelineData $timeline = this.getTimeline();
        result = result * 59 + ($timeline == null ? 43 : $timeline.hashCode());
        LoanSummaryData $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        LoanScheduleData $repaymentSchedule = this.getRepaymentSchedule();
        result = result * 59 + ($repaymentSchedule == null ? 43 : $repaymentSchedule.hashCode());
        Collection $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        Collection $charges = this.getCharges();
        result = result * 59 + ($charges == null ? 43 : ((Object)$charges).hashCode());
        Collection $collateral = this.getCollateral();
        result = result * 59 + ($collateral == null ? 43 : ((Object)$collateral).hashCode());
        Collection $guarantors = this.getGuarantors();
        result = result * 59 + ($guarantors == null ? 43 : ((Object)$guarantors).hashCode());
        CalendarData $meeting = this.getMeeting();
        result = result * 59 + ($meeting == null ? 43 : $meeting.hashCode());
        Collection $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : ((Object)$notes).hashCode());
        Collection $disbursementDetails = this.getDisbursementDetails();
        result = result * 59 + ($disbursementDetails == null ? 43 : ((Object)$disbursementDetails).hashCode());
        LoanScheduleData $originalSchedule = this.getOriginalSchedule();
        result = result * 59 + ($originalSchedule == null ? 43 : $originalSchedule.hashCode());
        Collection $productOptions = this.getProductOptions();
        result = result * 59 + ($productOptions == null ? 43 : ((Object)$productOptions).hashCode());
        Collection $loanOfficerOptions = this.getLoanOfficerOptions();
        result = result * 59 + ($loanOfficerOptions == null ? 43 : ((Object)$loanOfficerOptions).hashCode());
        Collection $loanPurposeOptions = this.getLoanPurposeOptions();
        result = result * 59 + ($loanPurposeOptions == null ? 43 : ((Object)$loanPurposeOptions).hashCode());
        Collection $fundOptions = this.getFundOptions();
        result = result * 59 + ($fundOptions == null ? 43 : ((Object)$fundOptions).hashCode());
        Collection $termFrequencyTypeOptions = this.getTermFrequencyTypeOptions();
        result = result * 59 + ($termFrequencyTypeOptions == null ? 43 : ((Object)$termFrequencyTypeOptions).hashCode());
        Collection $repaymentFrequencyTypeOptions = this.getRepaymentFrequencyTypeOptions();
        result = result * 59 + ($repaymentFrequencyTypeOptions == null ? 43 : ((Object)$repaymentFrequencyTypeOptions).hashCode());
        Collection $repaymentFrequencyNthDayTypeOptions = this.getRepaymentFrequencyNthDayTypeOptions();
        result = result * 59 + ($repaymentFrequencyNthDayTypeOptions == null ? 43 : ((Object)$repaymentFrequencyNthDayTypeOptions).hashCode());
        Collection $repaymentFrequencyDaysOfWeekTypeOptions = this.getRepaymentFrequencyDaysOfWeekTypeOptions();
        result = result * 59 + ($repaymentFrequencyDaysOfWeekTypeOptions == null ? 43 : ((Object)$repaymentFrequencyDaysOfWeekTypeOptions).hashCode());
        Collection $interestRateFrequencyTypeOptions = this.getInterestRateFrequencyTypeOptions();
        result = result * 59 + ($interestRateFrequencyTypeOptions == null ? 43 : ((Object)$interestRateFrequencyTypeOptions).hashCode());
        Collection $amortizationTypeOptions = this.getAmortizationTypeOptions();
        result = result * 59 + ($amortizationTypeOptions == null ? 43 : ((Object)$amortizationTypeOptions).hashCode());
        Collection $interestTypeOptions = this.getInterestTypeOptions();
        result = result * 59 + ($interestTypeOptions == null ? 43 : ((Object)$interestTypeOptions).hashCode());
        Collection $interestCalculationPeriodTypeOptions = this.getInterestCalculationPeriodTypeOptions();
        result = result * 59 + ($interestCalculationPeriodTypeOptions == null ? 43 : ((Object)$interestCalculationPeriodTypeOptions).hashCode());
        Collection $transactionProcessingStrategyOptions = this.getTransactionProcessingStrategyOptions();
        result = result * 59 + ($transactionProcessingStrategyOptions == null ? 43 : ((Object)$transactionProcessingStrategyOptions).hashCode());
        Collection $chargeOptions = this.getChargeOptions();
        result = result * 59 + ($chargeOptions == null ? 43 : ((Object)$chargeOptions).hashCode());
        Collection $loanCollateralOptions = this.getLoanCollateralOptions();
        result = result * 59 + ($loanCollateralOptions == null ? 43 : ((Object)$loanCollateralOptions).hashCode());
        Collection $calendarOptions = this.getCalendarOptions();
        result = result * 59 + ($calendarOptions == null ? 43 : ((Object)$calendarOptions).hashCode());
        List $loanScheduleTypeOptions = this.getLoanScheduleTypeOptions();
        result = result * 59 + ($loanScheduleTypeOptions == null ? 43 : ((Object)$loanScheduleTypeOptions).hashCode());
        List $loanScheduleProcessingTypeOptions = this.getLoanScheduleProcessingTypeOptions();
        result = result * 59 + ($loanScheduleProcessingTypeOptions == null ? 43 : ((Object)$loanScheduleProcessingTypeOptions).hashCode());
        BigDecimal $feeChargesAtDisbursementCharged = this.getFeeChargesAtDisbursementCharged();
        result = result * 59 + ($feeChargesAtDisbursementCharged == null ? 43 : ((Object)$feeChargesAtDisbursementCharged).hashCode());
        BigDecimal $totalOverpaid = this.getTotalOverpaid();
        result = result * 59 + ($totalOverpaid == null ? 43 : ((Object)$totalOverpaid).hashCode());
        PortfolioAccountData $linkedAccount = this.getLinkedAccount();
        result = result * 59 + ($linkedAccount == null ? 43 : $linkedAccount.hashCode());
        Collection $accountLinkingOptions = this.getAccountLinkingOptions();
        result = result * 59 + ($accountLinkingOptions == null ? 43 : ((Object)$accountLinkingOptions).hashCode());
        BigDecimal $fixedEmiAmount = this.getFixedEmiAmount();
        result = result * 59 + ($fixedEmiAmount == null ? 43 : ((Object)$fixedEmiAmount).hashCode());
        BigDecimal $maxOutstandingLoanBalance = this.getMaxOutstandingLoanBalance();
        result = result * 59 + ($maxOutstandingLoanBalance == null ? 43 : ((Object)$maxOutstandingLoanBalance).hashCode());
        Collection $emiAmountVariations = this.getEmiAmountVariations();
        result = result * 59 + ($emiAmountVariations == null ? 43 : ((Object)$emiAmountVariations).hashCode());
        Collection $loanTermVariations = this.getLoanTermVariations();
        result = result * 59 + ($loanTermVariations == null ? 43 : ((Object)$loanTermVariations).hashCode());
        Collection $clientActiveLoanOptions = this.getClientActiveLoanOptions();
        result = result * 59 + ($clientActiveLoanOptions == null ? 43 : ((Object)$clientActiveLoanOptions).hashCode());
        String $closureLoanAccountNo = this.getClosureLoanAccountNo();
        result = result * 59 + ($closureLoanAccountNo == null ? 43 : $closureLoanAccountNo.hashCode());
        BigDecimal $topupAmount = this.getTopupAmount();
        result = result * 59 + ($topupAmount == null ? 43 : ((Object)$topupAmount).hashCode());
        LoanProductData $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : $product.hashCode());
        Map $memberVariations = this.getMemberVariations();
        result = result * 59 + ($memberVariations == null ? 43 : ((Object)$memberVariations).hashCode());
        Collection $overdueCharges = this.getOverdueCharges();
        result = result * 59 + ($overdueCharges == null ? 43 : ((Object)$overdueCharges).hashCode());
        EnumOptionData $daysInMonthType = this.getDaysInMonthType();
        result = result * 59 + ($daysInMonthType == null ? 43 : $daysInMonthType.hashCode());
        EnumOptionData $daysInYearType = this.getDaysInYearType();
        result = result * 59 + ($daysInYearType == null ? 43 : $daysInYearType.hashCode());
        LoanInterestRecalculationData $interestRecalculationData = this.getInterestRecalculationData();
        result = result * 59 + ($interestRecalculationData == null ? 43 : $interestRecalculationData.hashCode());
        PaidInAdvanceData $paidInAdvance = this.getPaidInAdvance();
        result = result * 59 + ($paidInAdvance == null ? 43 : $paidInAdvance.hashCode());
        Collection $interestRatesPeriods = this.getInterestRatesPeriods();
        result = result * 59 + ($interestRatesPeriods == null ? 43 : ((Object)$interestRatesPeriods).hashCode());
        List $datatables = this.getDatatables();
        result = result * 59 + ($datatables == null ? 43 : ((Object)$datatables).hashCode());
        BigDecimal $fixedPrincipalPercentagePerInstallment = this.getFixedPrincipalPercentagePerInstallment();
        result = result * 59 + ($fixedPrincipalPercentagePerInstallment == null ? 43 : ((Object)$fixedPrincipalPercentagePerInstallment).hashCode());
        List $rates = this.getRates();
        result = result * 59 + ($rates == null ? 43 : ((Object)$rates).hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        LocalDate $submittedOnDate = this.getSubmittedOnDate();
        result = result * 59 + ($submittedOnDate == null ? 43 : ((Object)$submittedOnDate).hashCode());
        EnumOptionData $loanTermFrequencyType = this.getLoanTermFrequencyType();
        result = result * 59 + ($loanTermFrequencyType == null ? 43 : $loanTermFrequencyType.hashCode());
        LocalDate $repaymentsStartingFromDate = this.getRepaymentsStartingFromDate();
        result = result * 59 + ($repaymentsStartingFromDate == null ? 43 : ((Object)$repaymentsStartingFromDate).hashCode());
        String $linkAccountId = this.getLinkAccountId();
        result = result * 59 + ($linkAccountId == null ? 43 : $linkAccountId.hashCode());
        LocalDate $expectedDisbursementDate = this.getExpectedDisbursementDate();
        result = result * 59 + ($expectedDisbursementDate == null ? 43 : ((Object)$expectedDisbursementDate).hashCode());
        LocalDate $overpaidOnDate = this.getOverpaidOnDate();
        result = result * 59 + ($overpaidOnDate == null ? 43 : ((Object)$overpaidOnDate).hashCode());
        CollectionData $delinquent = this.getDelinquent();
        result = result * 59 + ($delinquent == null ? 43 : $delinquent.hashCode());
        DelinquencyRangeData $delinquencyRange = this.getDelinquencyRange();
        result = result * 59 + ($delinquencyRange == null ? 43 : $delinquencyRange.hashCode());
        LocalDate $lastClosedBusinessDate = this.getLastClosedBusinessDate();
        result = result * 59 + ($lastClosedBusinessDate == null ? 43 : ((Object)$lastClosedBusinessDate).hashCode());
        BigDecimal $disbursedAmountPercentageForDownPayment = this.getDisbursedAmountPercentageForDownPayment();
        result = result * 59 + ($disbursedAmountPercentageForDownPayment == null ? 43 : ((Object)$disbursedAmountPercentageForDownPayment).hashCode());
        EnumOptionData $loanScheduleType = this.getLoanScheduleType();
        result = result * 59 + ($loanScheduleType == null ? 43 : $loanScheduleType.hashCode());
        EnumOptionData $loanScheduleProcessingType = this.getLoanScheduleProcessingType();
        result = result * 59 + ($loanScheduleProcessingType == null ? 43 : $loanScheduleProcessingType.hashCode());
        StringEnumOptionData $chargeOffBehaviour = this.getChargeOffBehaviour();
        result = result * 59 + ($chargeOffBehaviour == null ? 43 : $chargeOffBehaviour.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LoanAccountData(id=" + this.getId() + ", accountNo=" + this.getAccountNo() + ", externalId=" + String.valueOf(this.getExternalId()) + ", status=" + String.valueOf(this.getStatus()) + ", subStatus=" + String.valueOf(this.getSubStatus()) + ", clientId=" + this.getClientId() + ", clientAccountNo=" + this.getClientAccountNo() + ", clientName=" + this.getClientName() + ", clientExternalId=" + String.valueOf(this.getClientExternalId()) + ", clientOfficeId=" + this.getClientOfficeId() + ", group=" + String.valueOf(this.getGroup()) + ", loanProductId=" + this.getLoanProductId() + ", loanProductName=" + this.getLoanProductName() + ", loanProductDescription=" + this.getLoanProductDescription() + ", isLoanProductLinkedToFloatingRate=" + this.isLoanProductLinkedToFloatingRate() + ", fundId=" + this.getFundId() + ", fundName=" + this.getFundName() + ", loanPurposeId=" + this.getLoanPurposeId() + ", loanPurposeName=" + this.getLoanPurposeName() + ", loanOfficerId=" + this.getLoanOfficerId() + ", loanOfficerName=" + this.getLoanOfficerName() + ", loanType=" + String.valueOf(this.getLoanType()) + ", currency=" + String.valueOf(this.getCurrency()) + ", principal=" + String.valueOf(this.getPrincipal()) + ", approvedPrincipal=" + String.valueOf(this.getApprovedPrincipal()) + ", proposedPrincipal=" + String.valueOf(this.getProposedPrincipal()) + ", netDisbursalAmount=" + String.valueOf(this.getNetDisbursalAmount()) + ", termFrequency=" + this.getTermFrequency() + ", termPeriodFrequencyType=" + String.valueOf(this.getTermPeriodFrequencyType()) + ", numberOfRepayments=" + this.getNumberOfRepayments() + ", repaymentEvery=" + this.getRepaymentEvery() + ", fixedLength=" + this.getFixedLength() + ", repaymentFrequencyType=" + String.valueOf(this.getRepaymentFrequencyType()) + ", repaymentFrequencyNthDayType=" + String.valueOf(this.getRepaymentFrequencyNthDayType()) + ", repaymentFrequencyDayOfWeekType=" + String.valueOf(this.getRepaymentFrequencyDayOfWeekType()) + ", interestRatePerPeriod=" + String.valueOf(this.getInterestRatePerPeriod()) + ", interestRateFrequencyType=" + String.valueOf(this.getInterestRateFrequencyType()) + ", annualInterestRate=" + String.valueOf(this.getAnnualInterestRate()) + ", isFloatingInterestRate=" + this.isFloatingInterestRate() + ", interestRateDifferential=" + String.valueOf(this.getInterestRateDifferential()) + ", amortizationType=" + String.valueOf(this.getAmortizationType()) + ", interestType=" + String.valueOf(this.getInterestType()) + ", interestCalculationPeriodType=" + String.valueOf(this.getInterestCalculationPeriodType()) + ", allowPartialPeriodInterestCalculation=" + this.getAllowPartialPeriodInterestCalculation() + ", inArrearsTolerance=" + String.valueOf(this.getInArrearsTolerance()) + ", transactionProcessingStrategyCode=" + this.getTransactionProcessingStrategyCode() + ", transactionProcessingStrategyName=" + this.getTransactionProcessingStrategyName() + ", graceOnPrincipalPayment=" + this.getGraceOnPrincipalPayment() + ", recurringMoratoriumOnPrincipalPeriods=" + this.getRecurringMoratoriumOnPrincipalPeriods() + ", graceOnInterestPayment=" + this.getGraceOnInterestPayment() + ", graceOnInterestCharged=" + this.getGraceOnInterestCharged() + ", graceOnArrearsAgeing=" + this.getGraceOnArrearsAgeing() + ", interestChargedFromDate=" + String.valueOf(this.getInterestChargedFromDate()) + ", expectedFirstRepaymentOnDate=" + String.valueOf(this.getExpectedFirstRepaymentOnDate()) + ", syncDisbursementWithMeeting=" + this.getSyncDisbursementWithMeeting() + ", disallowExpectedDisbursements=" + this.getDisallowExpectedDisbursements() + ", timeline=" + String.valueOf(this.getTimeline()) + ", summary=" + String.valueOf(this.getSummary()) + ", repaymentSchedule=" + String.valueOf(this.getRepaymentSchedule()) + ", transactions=" + String.valueOf(this.getTransactions()) + ", charges=" + String.valueOf(this.getCharges()) + ", collateral=" + String.valueOf(this.getCollateral()) + ", guarantors=" + String.valueOf(this.getGuarantors()) + ", meeting=" + String.valueOf(this.getMeeting()) + ", notes=" + String.valueOf(this.getNotes()) + ", disbursementDetails=" + String.valueOf(this.getDisbursementDetails()) + ", originalSchedule=" + String.valueOf(this.getOriginalSchedule()) + ", productOptions=" + String.valueOf(this.getProductOptions()) + ", loanOfficerOptions=" + String.valueOf(this.getLoanOfficerOptions()) + ", loanPurposeOptions=" + String.valueOf(this.getLoanPurposeOptions()) + ", fundOptions=" + String.valueOf(this.getFundOptions()) + ", termFrequencyTypeOptions=" + String.valueOf(this.getTermFrequencyTypeOptions()) + ", repaymentFrequencyTypeOptions=" + String.valueOf(this.getRepaymentFrequencyTypeOptions()) + ", repaymentFrequencyNthDayTypeOptions=" + String.valueOf(this.getRepaymentFrequencyNthDayTypeOptions()) + ", repaymentFrequencyDaysOfWeekTypeOptions=" + String.valueOf(this.getRepaymentFrequencyDaysOfWeekTypeOptions()) + ", interestRateFrequencyTypeOptions=" + String.valueOf(this.getInterestRateFrequencyTypeOptions()) + ", amortizationTypeOptions=" + String.valueOf(this.getAmortizationTypeOptions()) + ", interestTypeOptions=" + String.valueOf(this.getInterestTypeOptions()) + ", interestCalculationPeriodTypeOptions=" + String.valueOf(this.getInterestCalculationPeriodTypeOptions()) + ", transactionProcessingStrategyOptions=" + String.valueOf(this.getTransactionProcessingStrategyOptions()) + ", chargeOptions=" + String.valueOf(this.getChargeOptions()) + ", loanCollateralOptions=" + String.valueOf(this.getLoanCollateralOptions()) + ", calendarOptions=" + String.valueOf(this.getCalendarOptions()) + ", loanScheduleTypeOptions=" + String.valueOf(this.getLoanScheduleTypeOptions()) + ", loanScheduleProcessingTypeOptions=" + String.valueOf(this.getLoanScheduleProcessingTypeOptions()) + ", feeChargesAtDisbursementCharged=" + String.valueOf(this.getFeeChargesAtDisbursementCharged()) + ", totalOverpaid=" + String.valueOf(this.getTotalOverpaid()) + ", loanCounter=" + this.getLoanCounter() + ", loanProductCounter=" + this.getLoanProductCounter() + ", linkedAccount=" + String.valueOf(this.getLinkedAccount()) + ", accountLinkingOptions=" + String.valueOf(this.getAccountLinkingOptions()) + ", multiDisburseLoan=" + this.getMultiDisburseLoan() + ", canDefineInstallmentAmount=" + this.getCanDefineInstallmentAmount() + ", fixedEmiAmount=" + String.valueOf(this.getFixedEmiAmount()) + ", maxOutstandingLoanBalance=" + String.valueOf(this.getMaxOutstandingLoanBalance()) + ", canDisburse=" + this.getCanDisburse() + ", emiAmountVariations=" + String.valueOf(this.getEmiAmountVariations()) + ", loanTermVariations=" + String.valueOf(this.getLoanTermVariations()) + ", clientActiveLoanOptions=" + String.valueOf(this.getClientActiveLoanOptions()) + ", canUseForTopup=" + (this.getCanUseForTopup() + ", isTopup=" + this.isTopup() + ", fraud=" + this.isFraud() + ", closureLoanId=" + this.getClosureLoanId() + ", closureLoanAccountNo=" + this.getClosureLoanAccountNo() + ", topupAmount=" + String.valueOf(this.getTopupAmount()) + ", product=" + String.valueOf(this.getProduct()) + ", memberVariations=" + String.valueOf(this.getMemberVariations()) + ", inArrears=" + this.getInArrears() + ", isNPA=" + this.getIsNPA() + ", overdueCharges=" + String.valueOf(this.getOverdueCharges()) + ", daysInMonthType=" + String.valueOf(this.getDaysInMonthType()) + ", daysInYearType=" + String.valueOf(this.getDaysInYearType()) + ", isInterestRecalculationEnabled=" + this.isInterestRecalculationEnabled() + ", interestRecalculationData=" + String.valueOf(this.getInterestRecalculationData()) + ", createStandingInstructionAtDisbursement=" + this.getCreateStandingInstructionAtDisbursement() + ", paidInAdvance=" + String.valueOf(this.getPaidInAdvance()) + ", interestRatesPeriods=" + String.valueOf(this.getInterestRatesPeriods()) + ", isVariableInstallmentsAllowed=" + this.getIsVariableInstallmentsAllowed() + ", minimumGap=" + this.getMinimumGap() + ", maximumGap=" + this.getMaximumGap() + ", datatables=" + String.valueOf(this.getDatatables()) + ", isEqualAmortization=" + this.getIsEqualAmortization() + ", fixedPrincipalPercentagePerInstallment=" + String.valueOf(this.getFixedPrincipalPercentagePerInstallment()) + ", rates=" + String.valueOf(this.getRates()) + ", isRatesEnabled=" + this.getIsRatesEnabled() + ", dateFormat=" + this.getDateFormat() + ", locale=" + this.getLocale() + ", rowIndex=" + this.getRowIndex() + ", submittedOnDate=" + String.valueOf(this.getSubmittedOnDate()) + ", productId=" + this.getProductId() + ", loanTermFrequency=" + this.getLoanTermFrequency() + ", loanTermFrequencyType=" + String.valueOf(this.getLoanTermFrequencyType()) + ", repaymentsStartingFromDate=" + String.valueOf(this.getRepaymentsStartingFromDate()) + ", linkAccountId=" + this.getLinkAccountId() + ", groupId=" + this.getGroupId() + ", expectedDisbursementDate=" + String.valueOf(this.getExpectedDisbursementDate()) + ", overpaidOnDate=" + String.valueOf(this.getOverpaidOnDate()) + ", delinquent=" + String.valueOf(this.getDelinquent()) + ", delinquencyRange=" + String.valueOf(this.getDelinquencyRange()) + ", enableInstallmentLevelDelinquency=" + this.getEnableInstallmentLevelDelinquency() + ", lastClosedBusinessDate=" + String.valueOf(this.getLastClosedBusinessDate()) + ", chargedOff=" + this.getChargedOff() + ", enableDownPayment=" + this.getEnableDownPayment() + ", disbursedAmountPercentageForDownPayment=" + String.valueOf(this.getDisbursedAmountPercentageForDownPayment()) + ", enableAutoRepaymentForDownPayment=" + this.getEnableAutoRepaymentForDownPayment() + ", interestRecognitionOnDisbursementDate=" + this.getInterestRecognitionOnDisbursementDate() + ", loanScheduleType=" + String.valueOf(this.getLoanScheduleType()) + ", loanScheduleProcessingType=" + String.valueOf(this.getLoanScheduleProcessingType()) + ", chargeOffBehaviour=" + String.valueOf(this.getChargeOffBehaviour()) + ")");
    }

    @Generated
    public LoanAccountData() {
    }
}

