/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.loanschedule.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.data.OutstandingAmountsDTO;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanDisbursementDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanLifecycleStateMachine;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleTransactionProcessorFactory;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.LoanRepaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanSchedulePeriodData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanApplicationTerms;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleModel;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleAssembler;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleCalculationPlatformService;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanApplicationValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanScheduleValidator;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LoanScheduleCalculationPlatformServiceImpl
implements LoanScheduleCalculationPlatformService {
    private final LoanScheduleValidator fromApiJsonDeserializer;
    private final LoanScheduleAssembler loanScheduleAssembler;
    private final LoanApplicationValidator loanApiJsonDeserializer;
    private final LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory;
    private final CurrencyReadPlatformService currencyReadPlatformService;
    private final LoanUtilService loanUtilService;
    private final LoanRepositoryWrapper loanRepository;
    private final LoanLifecycleStateMachine defaultLoanLifecycleStateMachine;

    public LoanScheduleModel calculateLoanSchedule(JsonQuery query, Boolean validateParams) {
        if (validateParams.booleanValue()) {
            this.loanApiJsonDeserializer.validateForCreate(query);
        }
        this.fromApiJsonDeserializer.validate(query.json());
        return this.loanScheduleAssembler.assembleLoanScheduleFrom(query.parsedJson());
    }

    public void updateFutureSchedule(LoanScheduleData loanScheduleData, Long loanId) {
        Loan loan = this.fetchLoan(loanId);
        LocalDate today = DateUtils.getBusinessLocalDate();
        LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor = this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(loan.transactionProcessingStrategy());
        if (!loan.isInterestBearingAndInterestRecalculationEnabled() || loan.isNpa() || loan.isChargedOff() || !loan.getStatus().isActive() || !loanRepaymentScheduleTransactionProcessor.isInterestFirstRepaymentScheduleTransactionProcessor()) {
            return;
        }
        if (loan.loanProduct().isMultiDisburseLoan()) {
            BigDecimal disbursedAmount = loan.getDisbursedAmount();
            BigDecimal principalRepaid = loan.getSummary().getTotalPrincipalRepaid();
            BigDecimal principalWrittenOff = loan.getSummary().getTotalPrincipalWrittenOff();
            if (disbursedAmount.subtract(principalWrittenOff).subtract(principalRepaid).compareTo(BigDecimal.ZERO) <= 0) {
                return;
            }
        }
        MonetaryCurrency currency = loan.getCurrency();
        Money totalPrincipal = Money.zero((MonetaryCurrency)currency);
        ArrayList<LoanSchedulePeriodData> futureInstallments = new ArrayList<LoanSchedulePeriodData>();
        List installments = loan.getRepaymentScheduleInstallments();
        for (LoanRepaymentScheduleInstallment currentInstallment : installments) {
            if (!currentInstallment.isNotFullyPaidOff() || DateUtils.isAfter((LocalDate)currentInstallment.getDueDate(), (LocalDate)today)) continue;
            totalPrincipal = totalPrincipal.plus(currentInstallment.getPrincipalOutstanding(currency));
        }
        LoanApplicationTerms loanApplicationTerms = this.constructLoanApplicationTerms(loan);
        OutstandingAmountsDTO outstandingAmountsDTO = this.loanScheduleAssembler.calculatePrepaymentAmount(currency, today, loanApplicationTerms, loan, loan.getOfficeId(), loanRepaymentScheduleTransactionProcessor);
        LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment = new LoanRepaymentScheduleInstallment(null, Integer.valueOf(0), today, today, outstandingAmountsDTO.principal().getAmount(), outstandingAmountsDTO.interest().getAmount(), outstandingAmountsDTO.feeCharges().getAmount(), outstandingAmountsDTO.penaltyCharges().getAmount(), false, null);
        Money interestDue = loanRepaymentScheduleInstallment.getInterestOutstanding(currency);
        boolean isNewPaymentRequired = loanRepaymentScheduleInstallment.isInterestDue(currency) || totalPrincipal.isGreaterThanZero();
        LoanScheduleModel model = this.loanScheduleAssembler.assembleForInterestRecalculation(loanApplicationTerms, loan.getOfficeId(), loan, loanRepaymentScheduleTransactionProcessor, loan.fetchInterestRecalculateFromDate());
        LoanScheduleData scheduleDate = model.toData();
        Collection periodDatas = scheduleDate.getPeriods();
        for (LoanSchedulePeriodData periodData : periodDatas) {
            if (isNewPaymentRequired && !DateUtils.isBefore((LocalDate)periodData.getDueDate(), (LocalDate)today)) {
                LoanSchedulePeriodData loanSchedulePeriodData = LoanSchedulePeriodData.repaymentOnlyPeriod((Integer)periodData.getPeriod(), (LocalDate)periodData.getFromDate(), (LocalDate)periodData.getDueDate(), (BigDecimal)totalPrincipal.getAmount(), (BigDecimal)periodData.getPrincipalLoanBalanceOutstanding(), (BigDecimal)interestDue.getAmount(), (BigDecimal)loanRepaymentScheduleInstallment.getFeeChargesCharged(currency).getAmount(), (BigDecimal)loanRepaymentScheduleInstallment.getPenaltyChargesCharged(currency).getAmount());
                futureInstallments.add(loanSchedulePeriodData);
                isNewPaymentRequired = false;
                continue;
            }
            if (!DateUtils.isAfter((LocalDate)periodData.getDueDate(), (LocalDate)today)) continue;
            futureInstallments.add(periodData);
        }
        loanScheduleData.updateFuturePeriods(futureInstallments);
    }

    @Transactional(readOnly=true)
    public LoanScheduleData generateLoanScheduleForVariableInstallmentRequest(Long loanId, String json) {
        Loan loan = this.fetchLoan(loanId);
        this.loanScheduleAssembler.assempleVariableScheduleFrom(loan, json);
        return this.constructLoanScheduleData(loan);
    }

    private LoanScheduleData constructLoanScheduleData(Loan loan) {
        List installments = loan.getRepaymentScheduleInstallments();
        ArrayList<LoanSchedulePeriodData> installmentData = new ArrayList<LoanSchedulePeriodData>();
        MonetaryCurrency currency = loan.getCurrency();
        Money outstanding = loan.getPrincipal();
        List disbursementDetails = new ArrayList();
        if (loan.isMultiDisburmentLoan()) {
            disbursementDetails = loan.getDisbursementDetails();
            outstanding = outstanding.zero();
        }
        Money principal = outstanding;
        Iterator disbursementItr = disbursementDetails.iterator();
        Object loanDisbursementDetails = null;
        if (disbursementItr.hasNext()) {
            loanDisbursementDetails = (LoanDisbursementDetails)disbursementItr.next();
        }
        Money totalInterest = principal.zero();
        Money totalCharge = principal.zero();
        Money totalPenalty = principal.zero();
        for (LoanRepaymentScheduleInstallment installment : installments) {
            if (loanDisbursementDetails != null && !DateUtils.isAfter((LocalDate)loanDisbursementDetails.expectedDisbursementDateAsLocalDate(), (LocalDate)installment.getDueDate())) {
                outstanding = outstanding.plus(loanDisbursementDetails.principal());
                principal = principal.plus(loanDisbursementDetails.principal());
                loanDisbursementDetails = disbursementItr.hasNext() ? (LoanDisbursementDetails)disbursementItr.next() : null;
            }
            outstanding = outstanding.minus(installment.getPrincipal(currency));
            LoanSchedulePeriodData loanSchedulePeriodData = LoanSchedulePeriodData.repaymentOnlyPeriod((Integer)installment.getInstallmentNumber(), (LocalDate)installment.getFromDate(), (LocalDate)installment.getDueDate(), (BigDecimal)installment.getPrincipal(currency).getAmount(), (BigDecimal)outstanding.getAmount(), (BigDecimal)installment.getInterestCharged(currency).getAmount(), (BigDecimal)installment.getFeeChargesCharged(currency).getAmount(), (BigDecimal)installment.getPenaltyChargesCharged(currency).getAmount());
            installmentData.add(loanSchedulePeriodData);
            totalInterest = totalInterest.plus(installment.getInterestCharged(currency));
            totalCharge = totalCharge.plus(installment.getFeeChargesCharged(currency));
            totalPenalty = totalPenalty.plus(installment.getPenaltyChargesCharged(currency));
        }
        CurrencyData currencyData = this.currencyReadPlatformService.retrieveCurrency(currency.getCode());
        return new LoanScheduleData(currencyData, installmentData, loan.getLoanRepaymentScheduleDetail().getNumberOfRepayments(), principal.getAmount(), principal.getAmount(), totalInterest.getAmount(), totalCharge.getAmount(), totalPenalty.getAmount(), principal.plus(totalCharge).plus(totalInterest).plus(totalPenalty).getAmount());
    }

    private LoanApplicationTerms constructLoanApplicationTerms(Loan loan) {
        LocalDate recalculateFrom = null;
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
        return loan.constructLoanApplicationTerms(scheduleGeneratorDTO);
    }

    private Loan fetchLoan(Long accountId) {
        Loan loanAccount = this.loanRepository.findOneWithNotFoundDetection(accountId, true);
        loanAccount.setHelpers(this.defaultLoanLifecycleStateMachine, this.loanRepaymentScheduleTransactionProcessorFactory);
        return loanAccount;
    }

    @Generated
    public LoanScheduleCalculationPlatformServiceImpl(LoanScheduleValidator fromApiJsonDeserializer, LoanScheduleAssembler loanScheduleAssembler, LoanApplicationValidator loanApiJsonDeserializer, LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory, CurrencyReadPlatformService currencyReadPlatformService, LoanUtilService loanUtilService, LoanRepositoryWrapper loanRepository, LoanLifecycleStateMachine defaultLoanLifecycleStateMachine) {
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.loanScheduleAssembler = loanScheduleAssembler;
        this.loanApiJsonDeserializer = loanApiJsonDeserializer;
        this.loanRepaymentScheduleTransactionProcessorFactory = loanRepaymentScheduleTransactionProcessorFactory;
        this.currencyReadPlatformService = currencyReadPlatformService;
        this.loanUtilService = loanUtilService;
        this.loanRepository = loanRepository;
        this.defaultLoanLifecycleStateMachine = defaultLoanLifecycleStateMachine;
    }
}

