/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.serialization;

import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidLoanStateTransitionException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanDisbursalException;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanApplicationValidator;
import org.springframework.stereotype.Component;

@Component
public final class LoanDisbursementValidator {
    private final LoanApplicationValidator loanApplicationValidator;

    public void compareDisbursedToApprovedOrProposedPrincipal(Loan loan, BigDecimal disbursedAmount, BigDecimal totalDisbursed) {
        if (loan.loanProduct().isDisallowExpectedDisbursements() && loan.loanProduct().isAllowApprovedDisbursedAmountsOverApplied()) {
            BigDecimal maxDisbursedAmount = this.loanApplicationValidator.getOverAppliedMax(loan);
            if (totalDisbursed.compareTo(maxDisbursedAmount) > 0) {
                String errorMessage = String.format("Loan disbursal amount can't be greater than maximum applied loan amount calculation. Total disbursed amount: %s  Maximum disbursal amount: %s", totalDisbursed.stripTrailingZeros().toPlainString(), maxDisbursedAmount.stripTrailingZeros().toPlainString());
                throw new InvalidLoanStateTransitionException("disbursal", "amount.can't.be.greater.than.maximum.applied.loan.amount.calculation", errorMessage, new Object[]{disbursedAmount, maxDisbursedAmount});
            }
        } else if (totalDisbursed.compareTo(loan.getApprovedPrincipal()) > 0) {
            String errorMsg = "Loan can't be disbursed,disburse amount is exceeding approved principal ";
            throw new LoanDisbursalException("Loan can't be disbursed,disburse amount is exceeding approved principal ", "disburse.amount.must.be.less.than.approved.principal", new Object[]{totalDisbursed, loan.getApprovedPrincipal()});
        }
    }

    public void validateDisburseAmountNotExceedingApprovedAmount(Loan loan, BigDecimal diff, BigDecimal principalDisbursed) {
        if (!loan.loanProduct().isMultiDisburseLoan() && diff.compareTo(BigDecimal.ZERO) < 0) {
            String errorMsg = "Loan can't be disbursed,disburse amount is exceeding approved amount ";
            throw new LoanDisbursalException("Loan can't be disbursed,disburse amount is exceeding approved amount ", "disburse.amount.must.be.less.than.approved.amount", new Object[]{principalDisbursed, loan.getLoanRepaymentScheduleDetail().getPrincipal().getAmount()});
        }
    }

    public void validateDisburseDate(Loan loan, LocalDate disbursedOn, LocalDate expectedDate) {
        if (expectedDate != null && (DateUtils.isAfter((LocalDate)disbursedOn, (LocalDate)loan.fetchRepaymentScheduleInstallment(Integer.valueOf(1)).getDueDate()) || DateUtils.isAfter((LocalDate)disbursedOn, (LocalDate)expectedDate)) && DateUtils.isEqual((LocalDate)disbursedOn, (LocalDate)loan.getActualDisbursementDate())) {
            String errorMessage = "submittedOnDate cannot be after the loans  expectedFirstRepaymentOnDate: " + String.valueOf(expectedDate);
            throw new InvalidLoanStateTransitionException("disbursal", "cannot.be.after.expected.first.repayment.date", errorMessage, new Object[]{disbursedOn, expectedDate});
        }
        if (DateUtils.isDateInTheFuture((LocalDate)disbursedOn)) {
            String errorMessage = "The date on which a loan with identifier : " + loan.getAccountNumber() + " is disbursed cannot be in the future.";
            throw new InvalidLoanStateTransitionException("disbursal", "cannot.be.a.future.date", errorMessage, new Object[]{disbursedOn});
        }
    }

    @Generated
    public LoanDisbursementValidator(LoanApplicationValidator loanApplicationValidator) {
        this.loanApplicationValidator = loanApplicationValidator;
    }
}

