/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanAdjustTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionAccrualActivityPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionAccrualActivityPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelation;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelationTypeEnum;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualActivityProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanTransactionAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LoanAccrualActivityProcessingServiceImpl
implements LoanAccrualActivityProcessingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanAccrualActivityProcessingServiceImpl.class);
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final ExternalIdFactory externalIdFactory;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanTransactionAssembler loanTransactionAssembler;
    private final LoanAccountService loanAccountService;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void makeAccrualActivityTransaction(@NotNull Long loanId, @NotNull LocalDate currentDate) {
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        this.makeAccrualActivityTransaction(loan, currentDate);
    }

    public void makeAccrualActivityTransaction(@NotNull Loan loan, @NotNull LocalDate currentDate) {
        if (!loan.getLoanProductRelatedDetail().isEnableAccrualActivityPosting() || loan.isClosed() || loan.getStatus().isOverpaid()) {
            return;
        }
        List installments = loan.getRepaymentScheduleInstallments(i -> !i.isDownPayment() && !DateUtils.isBefore((LocalDate)currentDate, (LocalDate)i.getDueDate()));
        for (LoanRepaymentScheduleInstallment installment : installments) {
            LocalDate dueDate = installment.getDueDate();
            ArrayList<LoanTransaction> existingActivities = new ArrayList<LoanTransaction>(loan.getLoanTransactions(t -> t.isNotReversed() && t.isAccrualActivity() && t.getTransactionDate().isEqual(dueDate)));
            boolean hasExisting = !existingActivities.isEmpty();
            LoanTransaction existingActivity = hasExisting ? (LoanTransaction)existingActivities.get(0) : null;
            this.makeOrReplayActivity(loan, installment, existingActivity);
            if (!hasExisting) continue;
            existingActivities.remove(existingActivity);
            existingActivities.forEach(arg_0 -> this.reverseAccrualActivityTransaction(arg_0));
        }
    }

    @Transactional
    public void processAccrualActivityForLoanClosure(@NotNull Loan loan) {
        if (!loan.getLoanProductRelatedDetail().isEnableAccrualActivityPosting()) {
            return;
        }
        LocalDate closureDate = loan.isOverPaid() ? loan.getOverpaidOnDate() : loan.getClosedOnDate();
        loan.getLoanTransactions(t -> t.isAccrualActivity() && !t.isReversed() && t.getDateOf().isAfter(closureDate)).forEach(arg_0 -> this.reverseAccrualActivityTransaction(arg_0));
        BigDecimal feeChargesPortion = BigDecimal.ZERO;
        BigDecimal penaltyChargesPortion = BigDecimal.ZERO;
        BigDecimal interestPortion = BigDecimal.ZERO;
        for (Object installment : loan.getRepaymentScheduleInstallments()) {
            if (installment.isDownPayment()) continue;
            feeChargesPortion = MathUtil.add((BigDecimal)feeChargesPortion, (BigDecimal)installment.getFeeChargesCharged());
            penaltyChargesPortion = MathUtil.add((BigDecimal)penaltyChargesPortion, (BigDecimal)installment.getPenaltyCharges());
            interestPortion = MathUtil.add((BigDecimal)interestPortion, (BigDecimal)installment.getInterestCharged());
        }
        List accrualActivities = loan.getLoanTransactions(t -> t.isAccrualActivity() && !t.isReversed());
        for (LoanRepaymentScheduleInstallment installment : loan.getRepaymentScheduleInstallments()) {
            if (installment.isDownPayment() || installment.isAdditional() || !installment.getDueDate().isBefore(closureDate)) continue;
            List<LoanTransaction> installmentAccruals = accrualActivities.stream().filter(t -> t.getDateOf().isEqual(installment.getDueDate())).toList();
            if (installmentAccruals.isEmpty()) {
                this.makeAccrualActivityTransaction(loan, installment, installment.getDueDate());
                continue;
            }
            if (installmentAccruals.size() > 1) {
                installmentAccruals.forEach(arg_0 -> this.reverseAccrualActivityTransaction(arg_0));
                this.makeAccrualActivityTransaction(loan, installment, installment.getDueDate());
                continue;
            }
            if (this.validateActivityTransaction(installment, installmentAccruals.get(0))) continue;
            this.reverseReplayAccrualActivityTransaction(loan, installmentAccruals.get(0), installment, installment.getDueDate());
        }
        accrualActivities = loan.getLoanTransactions(t -> t.isAccrualActivity() && !t.isReversed());
        for (LoanTransaction accrualActivity : accrualActivities) {
            feeChargesPortion = MathUtil.subtract((BigDecimal)feeChargesPortion, (BigDecimal[])new BigDecimal[]{accrualActivity.getFeeChargesPortion()});
            penaltyChargesPortion = MathUtil.subtract((BigDecimal)penaltyChargesPortion, (BigDecimal[])new BigDecimal[]{accrualActivity.getPenaltyChargesPortion()});
            interestPortion = MathUtil.subtract((BigDecimal)interestPortion, (BigDecimal[])new BigDecimal[]{accrualActivity.getInterestPortion()});
        }
        if (MathUtil.isGreaterThanZero((BigDecimal)feeChargesPortion) || MathUtil.isGreaterThanZero((BigDecimal)penaltyChargesPortion) || MathUtil.isGreaterThanZero((BigDecimal)interestPortion)) {
            BigDecimal transactionAmount = MathUtil.add((BigDecimal[])new BigDecimal[]{feeChargesPortion, penaltyChargesPortion, interestPortion});
            LoanTransaction newActivity = new LoanTransaction(loan, loan.getOffice(), LoanTransactionType.ACCRUAL_ACTIVITY.getValue(), closureDate, transactionAmount, null, interestPortion, feeChargesPortion, penaltyChargesPortion, null, false, null, this.externalIdFactory.create());
            this.makeAccrualActivityTransaction(loan, newActivity);
        }
    }

    @Transactional
    public void processAccrualActivityForLoanReopen(@NotNull Loan loan) {
        if (!loan.getLoanProductRelatedDetail().isEnableAccrualActivityPosting()) {
            return;
        }
        LoanTransaction lastAccrualActivityMarkedToReverse = loan.getLoanTransactions().stream().filter(loanTransaction -> loanTransaction.isNotReversed() && loanTransaction.isAccrualActivity()).sorted(Comparator.comparing(LoanTransaction::getDateOf)).reduce((first, second) -> second).orElse(null);
        LocalDate lastAccrualActivityTransactionDate = lastAccrualActivityMarkedToReverse == null ? null : lastAccrualActivityMarkedToReverse.getDateOf();
        LocalDate today = DateUtils.getBusinessLocalDate();
        List<LoanRepaymentScheduleInstallment> installmentsBetweenBusinessDateAndLastAccrualActivityTransactionDate = loan.getRepaymentScheduleInstallments().stream().filter(installment -> installment.getDueDate().isBefore(today) && (DateUtils.isAfter((LocalDate)installment.getDueDate(), (LocalDate)lastAccrualActivityTransactionDate) || installment.getDueDate().isEqual(lastAccrualActivityTransactionDate))).sorted(Comparator.comparing(LoanRepaymentScheduleInstallment::getDueDate)).toList();
        for (LoanRepaymentScheduleInstallment installment2 : installmentsBetweenBusinessDateAndLastAccrualActivityTransactionDate) {
            this.makeOrReplayActivity(loan, installment2, lastAccrualActivityMarkedToReverse);
            lastAccrualActivityMarkedToReverse = null;
        }
        if (lastAccrualActivityMarkedToReverse != null) {
            this.reverseAccrualActivityTransaction(lastAccrualActivityMarkedToReverse);
        }
    }

    private void makeOrReplayActivity(@NotNull Loan loan, @NotNull LoanRepaymentScheduleInstallment installment, LoanTransaction existingActivity) {
        LocalDate dueDate = installment.getDueDate();
        if (existingActivity == null) {
            this.makeAccrualActivityTransaction(loan, installment, dueDate);
        } else {
            this.reverseReplayAccrualActivityTransaction(loan, existingActivity, installment, dueDate);
        }
    }

    private LoanTransaction reverseReplayAccrualActivityTransaction(@NotNull Loan loan, @NotNull LoanTransaction loanTransaction, @NotNull LoanRepaymentScheduleInstallment installment, @NotNull LocalDate transactionDate) {
        if (this.validateActivityTransaction(installment, loanTransaction)) {
            return loanTransaction;
        }
        LoanTransaction newLoanTransaction = this.loanTransactionAssembler.assembleAccrualActivityTransaction(loan, installment, transactionDate);
        if (newLoanTransaction != null) {
            newLoanTransaction.copyLoanTransactionRelations(loanTransaction.getLoanTransactionRelations());
            newLoanTransaction.getLoanTransactionRelations().add(LoanTransactionRelation.linkToTransaction((LoanTransaction)newLoanTransaction, (LoanTransaction)loanTransaction, (LoanTransactionRelationTypeEnum)LoanTransactionRelationTypeEnum.REPLAYED));
            this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(newLoanTransaction);
            loan.addLoanTransaction(newLoanTransaction);
            LoanAdjustTransactionBusinessEvent.Data data = new LoanAdjustTransactionBusinessEvent.Data(loanTransaction);
            data.setNewTransactionDetail(newLoanTransaction);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAdjustTransactionBusinessEvent(data));
        }
        this.reverseAccrualActivityTransaction(loanTransaction);
        return newLoanTransaction;
    }

    private boolean validateActivityTransaction(@NotNull LoanRepaymentScheduleInstallment installment, @NotNull LoanTransaction transaction) {
        return DateUtils.isEqual((LocalDate)installment.getDueDate(), (LocalDate)transaction.getDateOf()) && MathUtil.isEqualTo((BigDecimal)transaction.getInterestPortion(), (BigDecimal)installment.getInterestCharged()) && MathUtil.isEqualTo((BigDecimal)transaction.getFeeChargesPortion(), (BigDecimal)installment.getFeeChargesCharged()) && MathUtil.isEqualTo((BigDecimal)transaction.getPenaltyChargesPortion(), (BigDecimal)installment.getPenaltyCharges());
    }

    private void reverseAccrualActivityTransaction(LoanTransaction loanTransaction) {
        loanTransaction.reverse();
        LoanAdjustTransactionBusinessEvent.Data data = new LoanAdjustTransactionBusinessEvent.Data(loanTransaction);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAdjustTransactionBusinessEvent(data));
    }

    private LoanTransaction makeAccrualActivityTransaction(@NotNull Loan loan, @NotNull LoanRepaymentScheduleInstallment installment, @NotNull LocalDate transactionDate) {
        LoanTransaction newAccrualActivityTransaction = this.loanTransactionAssembler.assembleAccrualActivityTransaction(loan, installment, transactionDate);
        return newAccrualActivityTransaction == null ? null : this.makeAccrualActivityTransaction(loan, newAccrualActivityTransaction);
    }

    private LoanTransaction makeAccrualActivityTransaction(@NotNull Loan loan, @NotNull LoanTransaction newAccrualActivityTransaction) {
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanTransactionAccrualActivityPreBusinessEvent(loan));
        newAccrualActivityTransaction = this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(newAccrualActivityTransaction);
        loan.addLoanTransaction(newAccrualActivityTransaction);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanTransactionAccrualActivityPostBusinessEvent(newAccrualActivityTransaction));
        return newAccrualActivityTransaction;
    }

    @Generated
    public LoanAccrualActivityProcessingServiceImpl(LoanRepositoryWrapper loanRepositoryWrapper, ExternalIdFactory externalIdFactory, BusinessEventNotifierService businessEventNotifierService, LoanTransactionAssembler loanTransactionAssembler, LoanAccountService loanAccountService) {
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.externalIdFactory = externalIdFactory;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanTransactionAssembler = loanTransactionAssembler;
        this.loanAccountService = loanAccountService;
    }
}

