/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.persistence.PersistenceException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksWritePlatformService;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanApprovedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanCreatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanRejectedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanUndoApprovalBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.account.domain.AccountAssociationType;
import org.apache.fineract.portfolio.account.domain.AccountAssociations;
import org.apache.fineract.portfolio.account.domain.AccountAssociationsRepository;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarFrequencyType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarType;
import org.apache.fineract.portfolio.calendar.exception.CalendarNotFoundException;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformService;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagement;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.group.exception.GroupMemberNotFoundInGSIMException;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.GLIMAccountInfoRepository;
import org.apache.fineract.portfolio.loanaccount.domain.GroupLoanIndividualMonitoringAccount;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCollateralManagement;
import org.apache.fineract.portfolio.loanaccount.domain.LoanEvent;
import org.apache.fineract.portfolio.loanaccount.domain.LoanLifecycleStateMachine;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleTransactionProcessorFactory;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.exception.LoanApplicationNotInSubmittedAndPendingApprovalStateCannotBeDeleted;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanApplicationTerms;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleAssembler;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanApplicationTransitionValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanApplicationValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanDownPaymentTransactionValidator;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanApplicationWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanApplicationWritePlatformServiceJpaRepositoryImpl;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanproduct.domain.RecalculationFrequencyType;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.savings.data.GroupSavingsIndividualMonitoringAccountData;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.service.GSIMReadPlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class LoanApplicationWritePlatformServiceJpaRepositoryImpl
implements LoanApplicationWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanApplicationWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final LoanApplicationTransitionValidator loanApplicationTransitionValidator;
    private final LoanApplicationValidator loanApplicationValidator;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final NoteRepository noteRepository;
    private final LoanAssembler loanAssembler;
    private final LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory;
    private final CalendarRepository calendarRepository;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final SavingsAccountRepositoryWrapper savingsAccountRepository;
    private final AccountAssociationsRepository accountAssociationsRepository;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanScheduleAssembler loanScheduleAssembler;
    private final LoanUtilService loanUtilService;
    private final CalendarReadPlatformService calendarReadPlatformService;
    private final EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService;
    private final GLIMAccountInfoRepository glimRepository;
    private final LoanRepository loanRepository;
    private final GSIMReadPlatformService gsimReadPlatformService;
    private final LoanLifecycleStateMachine defaultLoanLifecycleStateMachine;
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;
    private final LoanDownPaymentTransactionValidator loanDownPaymentTransactionValidator;
    private final LoanScheduleService loanScheduleService;

    @Transactional
    public CommandProcessingResult submitApplication(JsonCommand command) {
        try {
            this.loanApplicationValidator.validateForCreate(command);
            Loan loan = this.loanAssembler.assembleFrom(command);
            this.loanApplicationValidator.validateForCreate(loan);
            this.loanRepositoryWrapper.saveAndFlush(loan);
            this.loanAssembler.accountNumberGeneration(command, loan);
            if (loan.getLoanProduct().isInterestRecalculationEnabled()) {
                this.createAndPersistCalendarInstanceForInterestRecalculation(loan);
            }
            String submittedOnNote = command.stringValueOfParameterNamed("submittedOnNote");
            this.createNote(submittedOnNote, loan);
            this.createCalendar(command, loan);
            Long savingsAccountId = command.longValueOfParameterNamed("linkAccountId");
            this.createSavingsAccountAssociation(savingsAccountId, loan);
            if (command.parameterExists("datatables")) {
                this.entityDatatableChecksWritePlatformService.saveDatatables(StatusEnum.CREATE.getValue(), EntityTables.LOAN.getName(), (Long)loan.getId(), loan.productId(), command.arrayOfParameterNamed("datatables"));
            }
            this.loanRepositoryWrapper.flush();
            this.entityDatatableChecksWritePlatformService.runTheCheckForProduct((Long)loan.getId(), EntityTables.LOAN.getName(), StatusEnum.CREATE.getValue(), EntityTables.LOAN.getForeignKeyColumnNameOnDatatable(), loan.productId().longValue());
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanCreatedBusinessEvent(loan));
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)loan.getId()).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId((Long)loan.getId()).withGlimId(loan.getGlimId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private void createAndPersistCalendarInstanceForInterestRecalculation(Loan loan) {
        LocalDate calendarStartDate = loan.getExpectedDisbursedOnLocalDate();
        Integer repeatsOnDay = null;
        RecalculationFrequencyType recalculationFrequencyType = loan.loanInterestRecalculationDetails().getRestFrequencyType();
        Integer recalculationFrequencyNthDay = loan.loanInterestRecalculationDetails().getRestFrequencyOnDay();
        if (recalculationFrequencyNthDay == null) {
            recalculationFrequencyNthDay = loan.loanInterestRecalculationDetails().getRestFrequencyNthDay();
            repeatsOnDay = loan.loanInterestRecalculationDetails().getRestFrequencyWeekday();
        }
        Integer frequency = loan.loanInterestRecalculationDetails().getRestInterval();
        CalendarEntityType calendarEntityType = CalendarEntityType.LOAN_RECALCULATION_REST_DETAIL;
        String title = "loan_recalculation_detail_" + String.valueOf(loan.loanInterestRecalculationDetails().getId());
        this.createCalendar(loan, calendarStartDate, recalculationFrequencyNthDay, repeatsOnDay, recalculationFrequencyType, frequency, calendarEntityType, title);
        if (loan.loanInterestRecalculationDetails().getInterestRecalculationCompoundingMethod().isCompoundingEnabled()) {
            LocalDate compoundingStartDate = loan.getExpectedDisbursedOnLocalDate();
            Integer compoundingRepeatsOnDay = null;
            RecalculationFrequencyType recalculationCompoundingFrequencyType = loan.loanInterestRecalculationDetails().getCompoundingFrequencyType();
            Integer recalculationCompoundingFrequencyNthDay = loan.loanInterestRecalculationDetails().getCompoundingFrequencyOnDay();
            if (recalculationCompoundingFrequencyNthDay == null) {
                recalculationCompoundingFrequencyNthDay = loan.loanInterestRecalculationDetails().getCompoundingFrequencyNthDay();
                compoundingRepeatsOnDay = loan.loanInterestRecalculationDetails().getCompoundingFrequencyWeekday();
            }
            Integer compoundingFrequency = loan.loanInterestRecalculationDetails().getCompoundingInterval();
            CalendarEntityType compoundingCalendarEntityType = CalendarEntityType.LOAN_RECALCULATION_COMPOUNDING_DETAIL;
            String compoundingCalendarTitle = "loan_recalculation_detail_compounding_frequency" + String.valueOf(loan.loanInterestRecalculationDetails().getId());
            this.createCalendar(loan, compoundingStartDate, recalculationCompoundingFrequencyNthDay, compoundingRepeatsOnDay, recalculationCompoundingFrequencyType, compoundingFrequency, compoundingCalendarEntityType, compoundingCalendarTitle);
        }
    }

    private void createCalendar(Loan loan, LocalDate calendarStartDate, Integer recalculationFrequencyNthDay, Integer repeatsOnDay, RecalculationFrequencyType recalculationFrequencyType, Integer frequency, CalendarEntityType calendarEntityType, String title) {
        CalendarFrequencyType calendarFrequencyType;
        Integer updatedRepeatsOnDay = repeatsOnDay;
        switch (1.$SwitchMap$org$apache$fineract$portfolio$loanproduct$domain$RecalculationFrequencyType[recalculationFrequencyType.ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: {
                CalendarFrequencyType calendarFrequencyType2 = CalendarFrequencyType.DAILY;
                break;
            }
            case 2: {
                CalendarFrequencyType calendarFrequencyType2 = CalendarFrequencyType.WEEKLY;
                break;
            }
            case 3: {
                CalendarFrequencyType calendarFrequencyType2 = CalendarFrequencyType.MONTHLY;
                break;
            }
            case 4: {
                CalendarFrequencyType calendarFrequencyType2 = CalendarFrequencyType.from((PeriodFrequencyType)loan.repaymentScheduleDetail().getRepaymentPeriodFrequencyType());
                break;
            }
            case 5: {
                CalendarFrequencyType calendarFrequencyType2 = calendarFrequencyType = CalendarFrequencyType.INVALID;
            }
        }
        if (recalculationFrequencyType == RecalculationFrequencyType.SAME_AS_REPAYMENT_PERIOD) {
            frequency = loan.repaymentScheduleDetail().getRepayEvery();
            calendarStartDate = loan.getExpectedDisbursedOnLocalDate();
            if (updatedRepeatsOnDay == null) {
                updatedRepeatsOnDay = calendarStartDate.get(ChronoField.DAY_OF_WEEK);
            }
        }
        Calendar calendar = Calendar.createRepeatingCalendar((String)title, (LocalDate)calendarStartDate, (Integer)CalendarType.COLLECTION.getValue(), (CalendarFrequencyType)calendarFrequencyType, (Integer)frequency, (Integer)updatedRepeatsOnDay, (Integer)recalculationFrequencyNthDay);
        CalendarInstance calendarInstance = CalendarInstance.from((Calendar)calendar, (Long)((Long)loan.loanInterestRecalculationDetails().getId()), (Integer)calendarEntityType.getValue());
        this.calendarInstanceRepository.save((Object)calendarInstance);
    }

    @Transactional
    public CommandProcessingResult modifyApplication(Long loanId, JsonCommand command) {
        try {
            Loan loan = this.retrieveLoanBy(loanId);
            this.loanApplicationValidator.validateForModify(command, loan);
            Map changes = this.loanAssembler.updateFrom(command, loan);
            this.loanApplicationValidator.validateForModify(loan);
            loan = (Loan)this.loanRepository.saveAndFlush((Object)loan);
            String submittedOnNote = command.stringValueOfParameterNamed("submittedOnNote");
            this.createNote(submittedOnNote, loan);
            Long calendarId = command.longValueOfParameterNamed("calendarId");
            this.modifyCalendar(loanId, calendarId, loan, changes);
            this.modifyLinkedAccount(command, changes, loan);
            this.loanRepositoryWrapper.saveAndFlush(loan);
            if (loan.isInterestBearingAndInterestRecalculationEnabled() && changes.containsKey("isInterestRecalculationEnabled")) {
                this.createAndPersistCalendarInstanceForInterestRecalculation(loan);
            }
            return new CommandProcessingResultBuilder().withEntityId(loanId).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId((Long)loan.getId()).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private void modifyLinkedAccount(JsonCommand command, Map<String, Object> changes, Loan loan) {
        Long savingsAccountId = command.longValueOfParameterNamed("linkAccountId");
        boolean linkedAccountWasProvided = command.parameterExists("linkAccountId");
        if (linkedAccountWasProvided) {
            AccountAssociations accountAssociations = this.accountAssociationsRepository.findByLoanIdAndType((Long)loan.getId(), AccountAssociationType.LINKED_ACCOUNT_ASSOCIATION.getValue());
            if (savingsAccountId == null) {
                this.removeLinkedAccountAssociation(accountAssociations, changes);
            } else {
                SavingsAccount savingsAccount = this.savingsAccountRepository.findOneWithNotFoundDetection(savingsAccountId);
                if (accountAssociations == null) {
                    this.createLinkedAccountAssociation(loan, savingsAccount, changes);
                } else if (!((Long)accountAssociations.linkedSavingsAccount().getId()).equals(savingsAccountId)) {
                    this.updateLinkedAccountAssociation(accountAssociations, savingsAccount, changes);
                }
            }
        }
    }

    private void updateLinkedAccountAssociation(AccountAssociations accountAssociations, SavingsAccount savingsAccount, Map<String, Object> changes) {
        accountAssociations.updateLinkedSavingsAccount(savingsAccount);
        this.accountAssociationsRepository.save((Object)accountAssociations);
        changes.put("linkAccountId", savingsAccount.getId());
    }

    private void removeLinkedAccountAssociation(AccountAssociations accountAssociations, Map<String, Object> changes) {
        if (accountAssociations != null) {
            this.accountAssociationsRepository.delete((Object)accountAssociations);
            changes.put("linkAccountId", null);
        }
    }

    private void createLinkedAccountAssociation(Loan loan, SavingsAccount savingsAccount, Map<String, Object> changes) {
        boolean isActive = true;
        this.accountAssociationsRepository.save((Object)AccountAssociations.associateSavingsAccount((Loan)loan, (SavingsAccount)savingsAccount, (Integer)AccountAssociationType.LINKED_ACCOUNT_ASSOCIATION.getValue(), (boolean)isActive));
        changes.put("linkAccountId", savingsAccount.getId());
    }

    private void modifyCalendar(Long loanId, Long calendarId, Loan loan, Map<String, Object> changes) {
        Calendar calendar = null;
        if (calendarId != null && calendarId != 0L) {
            calendar = (Calendar)this.calendarRepository.findById((Object)calendarId).orElseThrow(() -> new CalendarNotFoundException(calendarId));
        }
        List ciList = (List)this.calendarInstanceRepository.findByEntityIdAndEntityTypeId(loanId, CalendarEntityType.LOANS.getValue());
        if (calendar != null) {
            if (ciList != null && !ciList.isEmpty()) {
                CalendarInstance calendarInstance = (CalendarInstance)ciList.get(0);
                boolean isCalendarAssociatedWithEntity = this.calendarReadPlatformService.isCalendarAssociatedWithEntity(calendarInstance.getEntityId(), (Long)calendarInstance.getCalendar().getId(), Long.valueOf(CalendarEntityType.LOANS.getValue().longValue()));
                if (isCalendarAssociatedWithEntity && calendarId == null) {
                    this.calendarRepository.delete((Object)calendarInstance.getCalendar());
                }
                if (!((Long)calendarInstance.getCalendar().getId()).equals(calendar.getId())) {
                    calendarInstance.updateCalendar(calendar);
                    this.calendarInstanceRepository.saveAndFlush((Object)calendarInstance);
                }
            } else {
                CalendarInstance calendarInstance = new CalendarInstance(calendar, (Long)loan.getId(), CalendarEntityType.LOANS.getValue());
                this.calendarInstanceRepository.save((Object)calendarInstance);
            }
        } else {
            CalendarInstance existingCalendarInstance;
            boolean isCalendarAssociatedWithEntity;
            if (ciList != null && !ciList.isEmpty() && (isCalendarAssociatedWithEntity = this.calendarReadPlatformService.isCalendarAssociatedWithEntity((existingCalendarInstance = (CalendarInstance)ciList.get(0)).getEntityId(), (Long)existingCalendarInstance.getCalendar().getId(), Long.valueOf(CalendarEntityType.GROUPS.getValue().longValue())).booleanValue())) {
                this.calendarInstanceRepository.delete((Object)existingCalendarInstance);
            }
            if (changes.containsKey("repaymentFrequencyNthDayType") || changes.containsKey("repaymentFrequencyDayOfWeekType")) {
                if (changes.get("repaymentFrequencyNthDayType") == null) {
                    CalendarInstance calendarInstance;
                    if (ciList != null && !ciList.isEmpty() && (isCalendarAssociatedWithEntity = this.calendarReadPlatformService.isCalendarAssociatedWithEntity((calendarInstance = (CalendarInstance)ciList.get(0)).getEntityId(), (Long)calendarInstance.getCalendar().getId(), Long.valueOf(CalendarEntityType.LOANS.getValue().longValue())).booleanValue())) {
                        this.calendarInstanceRepository.delete((Object)calendarInstance);
                        this.calendarRepository.delete((Object)calendarInstance.getCalendar());
                    }
                } else {
                    PeriodFrequencyType repaymentFrequencyType = loan.repaymentScheduleDetail().getRepaymentPeriodFrequencyType();
                    if (repaymentFrequencyType == PeriodFrequencyType.MONTHS) {
                        String title = "loan_schedule_" + String.valueOf(loan.getId());
                        Integer typeId = CalendarType.COLLECTION.getValue();
                        CalendarFrequencyType calendarFrequencyType = CalendarFrequencyType.MONTHLY;
                        Integer interval = loan.repaymentScheduleDetail().getRepayEvery();
                        LocalDate startDate = loan.getExpectedFirstRepaymentOnDate();
                        if (startDate == null) {
                            startDate = loan.getExpectedDisbursedOnLocalDate();
                        }
                        Calendar newCalendar = Calendar.createRepeatingCalendar((String)title, (LocalDate)startDate, (Integer)typeId, (CalendarFrequencyType)calendarFrequencyType, (Integer)interval, (Integer)((Integer)changes.get("repaymentFrequencyDayOfWeekType")), (Integer)((Integer)changes.get("repaymentFrequencyNthDayType")));
                        if (ciList != null && !ciList.isEmpty()) {
                            String existingRecurrence;
                            Calendar existingCalendar;
                            CalendarInstance calendarInstance = (CalendarInstance)ciList.get(0);
                            boolean isCalendarAssociatedWithEntity2 = this.calendarReadPlatformService.isCalendarAssociatedWithEntity(calendarInstance.getEntityId(), (Long)calendarInstance.getCalendar().getId(), Long.valueOf(CalendarEntityType.LOANS.getValue().longValue()));
                            if (isCalendarAssociatedWithEntity2 && (existingCalendar = calendarInstance.getCalendar()) != null && !(existingRecurrence = existingCalendar.getRecurrence()).equals(newCalendar.getRecurrence())) {
                                existingCalendar.setRecurrence(newCalendar.getRecurrence());
                                this.calendarRepository.save((Object)existingCalendar);
                            }
                        } else {
                            this.calendarRepository.save((Object)newCalendar);
                            Integer calendarEntityType = CalendarEntityType.LOANS.getValue();
                            CalendarInstance calendarInstance = new CalendarInstance(newCalendar, (Long)loan.getId(), calendarEntityType);
                            this.calendarInstanceRepository.save((Object)calendarInstance);
                        }
                    }
                }
            }
        }
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("loan_account_no_UNIQUE") || realCause.getCause() != null && realCause.getCause().getMessage().contains("loan_account_no_UNIQUE")) {
            String accountNo = command.stringValueOfParameterNamed("accountNo");
            throw new PlatformDataIntegrityException("error.msg.loan.duplicate.accountNo", "Loan with accountNo `" + accountNo + "` already exists", "accountNo", new Object[]{accountNo});
        }
        if (realCause.getMessage().contains("loan_externalid_UNIQUE") || realCause.getCause() != null && realCause.getCause().getMessage().contains("loan_externalid_UNIQUE") || realCause.getMessage().toLowerCase().contains("external_id_unique")) {
            String externalId = command.stringValueOfParameterNamed("externalId");
            throw new PlatformDataIntegrityException("error.msg.loan.duplicate.externalId", "Loan with externalId `" + externalId + "` already exists", "externalId", new Object[]{externalId});
        }
        log.error("Error occurred.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    @Transactional
    public CommandProcessingResult deleteApplication(Long loanId) {
        Loan loan = this.retrieveLoanBy(loanId);
        this.loanApplicationTransitionValidator.checkClientOrGroupActive(loan);
        if (loan.isNotSubmittedAndPendingApproval()) {
            throw new LoanApplicationNotInSubmittedAndPendingApprovalStateCannotBeDeleted(loanId);
        }
        List relatedNotes = this.noteRepository.findByLoanId((Long)loan.getId());
        this.noteRepository.deleteAllInBatch((Iterable)relatedNotes);
        AccountAssociations accountAssociations = this.accountAssociationsRepository.findByLoanIdAndType(loanId, AccountAssociationType.LINKED_ACCOUNT_ASSOCIATION.getValue());
        if (accountAssociations != null) {
            this.accountAssociationsRepository.delete((Object)accountAssociations);
        }
        Set loanCollateralManagements = loan.getLoanCollateralManagements();
        for (LoanCollateralManagement loanCollateralManagement : loanCollateralManagements) {
            BigDecimal quantity = loanCollateralManagement.getQuantity();
            ClientCollateralManagement clientCollateralManagement = loanCollateralManagement.getClientCollateralManagement();
            clientCollateralManagement.updateQuantityAfterLoanClosed(quantity);
            loanCollateralManagement.setIsReleased(true);
            loanCollateralManagement.setClientCollateralManagement(clientCollateralManagement);
        }
        this.loanRepositoryWrapper.delete(loanId);
        return new CommandProcessingResultBuilder().withEntityId(loanId).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId((Long)loan.getId()).build();
    }

    @Transactional
    public CommandProcessingResult approveGLIMLoanAppication(Long loanId, JsonCommand command) {
        Long parentLoanId = loanId;
        GroupLoanIndividualMonitoringAccount parentLoan = (GroupLoanIndividualMonitoringAccount)this.glimRepository.findById((Object)parentLoanId).orElseThrow();
        JsonArray approvalFormData = command.arrayOfParameterNamed("approvalFormData");
        JsonObject jsonObject = null;
        JsonCommand childCommand = null;
        Long[] childLoanId = new Long[approvalFormData.size()];
        BigDecimal parentPrincipalAmount = command.bigDecimalValueOfParameterNamed("glimPrincipal");
        for (int i = 0; i < approvalFormData.size(); ++i) {
            jsonObject = approvalFormData.get(i).getAsJsonObject();
            childLoanId[i] = jsonObject.get("loanId").getAsLong();
        }
        CommandProcessingResult result = null;
        int count = 0;
        int j = 0;
        for (JsonElement approvals : approvalFormData) {
            childCommand = JsonCommand.fromExistingCommand((JsonCommand)command, (JsonElement)approvals);
            if ((result = this.approveApplication(childLoanId[j++], childCommand)).getLoanId() == null || (long)(++count) != parentLoan.getChildAccountsCount()) continue;
            parentLoan.setPrincipalAmount(parentPrincipalAmount);
            parentLoan.setLoanStatus(LoanStatus.APPROVED.getValue());
            this.glimRepository.save((Object)parentLoan);
        }
        return result;
    }

    @Transactional
    public CommandProcessingResult approveApplication(Long loanId, JsonCommand command) {
        AppUser currentUser = this.getAppUserIfPresent();
        this.loanApplicationValidator.validateApproval(command, loanId);
        Pair loanAndChanges = this.loanScheduleAssembler.assembleLoanApproval(currentUser, command, loanId);
        Loan loan = (Loan)loanAndChanges.getLeft();
        Map changes = (Map)loanAndChanges.getRight();
        if (!changes.isEmpty()) {
            String noteText = command.stringValueOfParameterNamed("note");
            this.createNote(noteText, loan).ifPresent(note -> changes.put("note", noteText));
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanApprovedBusinessEvent(loan));
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)loan.getId()).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult undoGLIMLoanApplicationApproval(Long loanId, JsonCommand command) {
        Long parentLoanId = loanId;
        GroupLoanIndividualMonitoringAccount parentLoan = (GroupLoanIndividualMonitoringAccount)this.glimRepository.findById((Object)parentLoanId).orElseThrow();
        List childLoans = this.loanRepository.findByGlimId(loanId);
        CommandProcessingResult result = null;
        int count = 0;
        for (Loan loan : childLoans) {
            result = this.undoApplicationApproval((Long)loan.getId(), command);
            if (result.getLoanId() == null || (long)(++count) != parentLoan.getChildAccountsCount()) continue;
            parentLoan.setLoanStatus(LoanStatus.SUBMITTED_AND_PENDING_APPROVAL.getValue());
            this.glimRepository.save((Object)parentLoan);
        }
        return result;
    }

    @Transactional
    public CommandProcessingResult undoApplicationApproval(Long loanId, JsonCommand command) {
        this.loanApplicationValidator.validateForUndo(command.json());
        Loan loan = this.retrieveLoanBy(loanId);
        this.loanApplicationTransitionValidator.checkClientOrGroupActive(loan);
        this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.LOAN_APPROVAL_UNDO);
        Map changes = loan.undoApproval(this.defaultLoanLifecycleStateMachine);
        if (!changes.isEmpty()) {
            if (changes.containsKey("approvedLoanAmount") || changes.containsKey("principal")) {
                LocalDate recalculateFrom = null;
                ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
                this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
                this.loanAccrualsProcessingService.reprocessExistingAccruals(loan);
            }
            loan.adjustNetDisbursalAmount(loan.getProposedPrincipal());
            loan = (Loan)this.loanRepository.saveAndFlush((Object)loan);
            String noteText = command.stringValueOfParameterNamed("note");
            this.createNote(noteText, loan);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUndoApprovalBusinessEvent(loan));
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)loan.getId()).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult rejectGLIMApplicationApproval(Long glimId, JsonCommand command) {
        Long parentLoanId = glimId;
        GroupLoanIndividualMonitoringAccount parentLoan = (GroupLoanIndividualMonitoringAccount)this.glimRepository.findById((Object)parentLoanId).orElseThrow();
        List childLoans = this.loanRepository.findByGlimId(glimId);
        CommandProcessingResult result = null;
        int count = 0;
        for (Loan loan : childLoans) {
            result = this.rejectApplication((Long)loan.getId(), command);
            if (result.getLoanId() == null || (long)(++count) != parentLoan.getChildAccountsCount()) continue;
            parentLoan.setLoanStatus(LoanStatus.REJECTED.getValue());
            this.glimRepository.save((Object)parentLoan);
        }
        return result;
    }

    @Transactional
    public CommandProcessingResult rejectApplication(Long loanId, JsonCommand command) {
        Loan loan = this.retrieveLoanBy(loanId);
        this.loanApplicationTransitionValidator.validateRejection(command, loan);
        this.entityDatatableChecksWritePlatformService.runTheCheckForProduct(loanId, EntityTables.LOAN.getName(), StatusEnum.REJECTED.getValue(), EntityTables.LOAN.getForeignKeyColumnNameOnDatatable(), loan.productId().longValue());
        AppUser currentUser = this.getAppUserIfPresent();
        this.defaultLoanLifecycleStateMachine.transition(LoanEvent.LOAN_REJECTED, loan);
        Map changes = this.loanAssembler.updateLoanApplicationAttributesForRejection(loan, command, currentUser);
        if (!changes.isEmpty()) {
            this.loanRepositoryWrapper.saveAndFlush(loan);
            String noteText = command.stringValueOfParameterNamed("note");
            this.createNote(noteText, loan);
        }
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanRejectedBusinessEvent(loan));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)loan.getId()).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult applicantWithdrawsFromApplication(Long loanId, JsonCommand command) {
        Loan loan = this.retrieveLoanBy(loanId);
        this.loanApplicationTransitionValidator.validateApplicantWithdrawal(command, loan);
        this.entityDatatableChecksWritePlatformService.runTheCheckForProduct(loanId, EntityTables.LOAN.getName(), StatusEnum.WITHDRAWN.getValue(), EntityTables.LOAN.getForeignKeyColumnNameOnDatatable(), loan.productId().longValue());
        AppUser currentUser = this.getAppUserIfPresent();
        this.defaultLoanLifecycleStateMachine.transition(LoanEvent.LOAN_WITHDRAWN, loan);
        Map changes = this.loanAssembler.updateLoanApplicationAttributesForWithdrawal(loan, command, currentUser);
        if (loan.getLoanType().isIndividualAccount()) {
            this.releaseAttachedCollaterals(loan);
        }
        if (!changes.isEmpty()) {
            this.loanRepositoryWrapper.saveAndFlush(loan);
            String noteText = command.stringValueOfParameterNamed("note");
            this.createNote(noteText, loan);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)loan.getId()).withEntityExternalId(loan.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    private Loan retrieveLoanBy(Long loanId) {
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        loan.setHelpers(this.defaultLoanLifecycleStateMachine, this.loanRepaymentScheduleTransactionProcessorFactory);
        return loan;
    }

    private AppUser getAppUserIfPresent() {
        AppUser user = null;
        if (this.context != null) {
            user = this.context.getAuthenticatedUserIfPresent();
        }
        return user;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createSavingsAccountAssociation(Long savingsAccountId, Loan loan) {
        SavingsAccount savingsAccount;
        if (savingsAccountId == null) return;
        if (loan.getLoanType().isGLIMAccount()) {
            List childSavings = (List)this.gsimReadPlatformService.findGSIMAccountsByGSIMId(savingsAccountId);
            ArrayList<BigDecimal> gsimClientMembers = new ArrayList<BigDecimal>();
            HashMap<BigDecimal, BigDecimal> clientAccountMappings = new HashMap<BigDecimal, BigDecimal>();
            for (GroupSavingsIndividualMonitoringAccountData childSaving : childSavings) {
                gsimClientMembers.add(childSaving.getClientId());
                clientAccountMappings.put(childSaving.getClientId(), childSaving.getChildAccountId());
            }
            if (!gsimClientMembers.contains(BigDecimal.valueOf(loan.getClientId()))) throw new GroupMemberNotFoundInGSIMException(loan.getClientId());
            savingsAccount = this.savingsAccountRepository.findOneWithNotFoundDetection(Long.valueOf(((BigDecimal)clientAccountMappings.get(BigDecimal.valueOf(loan.getClientId()))).longValue()));
        } else {
            savingsAccount = this.savingsAccountRepository.findOneWithNotFoundDetection(savingsAccountId);
        }
        boolean isActive = true;
        AccountAssociations accountAssociations = AccountAssociations.associateSavingsAccount((Loan)loan, (SavingsAccount)savingsAccount, (Integer)AccountAssociationType.LINKED_ACCOUNT_ASSOCIATION.getValue(), (boolean)isActive);
        this.accountAssociationsRepository.save((Object)accountAssociations);
    }

    private void createCalendar(JsonCommand command, Loan loan) {
        Long calendarId = command.longValueOfParameterNamed("calendarId");
        if (calendarId != null && calendarId != 0L) {
            Calendar calendar = (Calendar)this.calendarRepository.findById((Object)calendarId).orElseThrow(() -> new CalendarNotFoundException(calendarId));
            CalendarInstance calendarInstance = new CalendarInstance(calendar, (Long)loan.getId(), CalendarEntityType.LOANS.getValue());
            this.calendarInstanceRepository.save((Object)calendarInstance);
        } else {
            LoanApplicationTerms loanApplicationTerms = this.loanScheduleAssembler.assembleLoanTerms(command.parsedJson());
            if (loanApplicationTerms.getRepaymentPeriodFrequencyType() == PeriodFrequencyType.MONTHS && loanApplicationTerms.getNthDay() != null) {
                String title = "loan_schedule_" + String.valueOf(loan.getId());
                LocalDate calendarStartDate = loanApplicationTerms.getRepaymentsStartingFromLocalDate();
                if (calendarStartDate == null) {
                    calendarStartDate = loanApplicationTerms.getExpectedDisbursementDate();
                }
                CalendarFrequencyType calendarFrequencyType = CalendarFrequencyType.MONTHLY;
                Integer frequency = loanApplicationTerms.getRepaymentEvery();
                Integer repeatsOnDay = loanApplicationTerms.getWeekDayType().getValue();
                Integer repeatsOnNthDayOfMonth = loanApplicationTerms.getNthDay();
                Integer calendarEntityType = CalendarEntityType.LOANS.getValue();
                Calendar loanCalendar = Calendar.createRepeatingCalendar((String)title, (LocalDate)calendarStartDate, (Integer)CalendarType.COLLECTION.getValue(), (CalendarFrequencyType)calendarFrequencyType, (Integer)frequency, (Integer)repeatsOnDay, (Integer)repeatsOnNthDayOfMonth);
                this.calendarRepository.save((Object)loanCalendar);
                CalendarInstance calendarInstance = CalendarInstance.from((Calendar)loanCalendar, (Long)((Long)loan.getId()), (Integer)calendarEntityType);
                this.calendarInstanceRepository.save((Object)calendarInstance);
            }
        }
    }

    private Optional<Note> createNote(String submittedOnNote, Loan newLoanApplication) {
        if (StringUtils.isNotBlank((CharSequence)submittedOnNote)) {
            Note note = Note.loanNote((Loan)newLoanApplication, (String)submittedOnNote);
            this.noteRepository.save((Object)note);
            return Optional.of(note);
        }
        return Optional.empty();
    }

    private void releaseAttachedCollaterals(Loan loan) {
        Set loanCollateralManagements = loan.getLoanCollateralManagements();
        for (LoanCollateralManagement loanCollateralManagement : loanCollateralManagements) {
            ClientCollateralManagement clientCollateralManagement = loanCollateralManagement.getClientCollateralManagement();
            clientCollateralManagement.updateQuantity(clientCollateralManagement.getQuantity().add(loanCollateralManagement.getQuantity()));
            loanCollateralManagement.setClientCollateralManagement(clientCollateralManagement);
            loanCollateralManagement.setIsReleased(true);
        }
        loan.updateLoanCollateral(loanCollateralManagements);
    }

    @Generated
    public LoanApplicationWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, LoanApplicationTransitionValidator loanApplicationTransitionValidator, LoanApplicationValidator loanApplicationValidator, LoanRepositoryWrapper loanRepositoryWrapper, NoteRepository noteRepository, LoanAssembler loanAssembler, LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory, CalendarRepository calendarRepository, CalendarInstanceRepository calendarInstanceRepository, SavingsAccountRepositoryWrapper savingsAccountRepository, AccountAssociationsRepository accountAssociationsRepository, BusinessEventNotifierService businessEventNotifierService, LoanScheduleAssembler loanScheduleAssembler, LoanUtilService loanUtilService, CalendarReadPlatformService calendarReadPlatformService, EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService, GLIMAccountInfoRepository glimRepository, LoanRepository loanRepository, GSIMReadPlatformService gsimReadPlatformService, LoanLifecycleStateMachine defaultLoanLifecycleStateMachine, LoanAccrualsProcessingService loanAccrualsProcessingService, LoanDownPaymentTransactionValidator loanDownPaymentTransactionValidator, LoanScheduleService loanScheduleService) {
        this.context = context;
        this.loanApplicationTransitionValidator = loanApplicationTransitionValidator;
        this.loanApplicationValidator = loanApplicationValidator;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.noteRepository = noteRepository;
        this.loanAssembler = loanAssembler;
        this.loanRepaymentScheduleTransactionProcessorFactory = loanRepaymentScheduleTransactionProcessorFactory;
        this.calendarRepository = calendarRepository;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.savingsAccountRepository = savingsAccountRepository;
        this.accountAssociationsRepository = accountAssociationsRepository;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanScheduleAssembler = loanScheduleAssembler;
        this.loanUtilService = loanUtilService;
        this.calendarReadPlatformService = calendarReadPlatformService;
        this.entityDatatableChecksWritePlatformService = entityDatatableChecksWritePlatformService;
        this.glimRepository = glimRepository;
        this.loanRepository = loanRepository;
        this.gsimReadPlatformService = gsimReadPlatformService;
        this.defaultLoanLifecycleStateMachine = defaultLoanLifecycleStateMachine;
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
        this.loanDownPaymentTransactionValidator = loanDownPaymentTransactionValidator;
        this.loanScheduleService = loanScheduleService;
    }
}

