/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import com.google.common.base.Splitter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.service.TemporaryConfigurationServiceContainer;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.serialization.JsonParserHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargePaidBy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanDisbursementDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTrancheCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTrancheDisbursementCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanChargeValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanDisbursementValidator;
import org.apache.fineract.portfolio.loanaccount.service.ReprocessLoanTransactionsService;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;

public class LoanDisbursementService {
    private final LoanChargeValidator loanChargeValidator;
    private final LoanDisbursementValidator loanDisbursementValidator;
    private final ReprocessLoanTransactionsService reprocessLoanTransactionsService;

    public void updateDisbursementDetails(Loan loan, JsonCommand jsonCommand, Map<String, Object> actualChanges) {
        JsonArray disbursementDataArray;
        boolean removeAllCharges;
        List disbursementList = loan.fetchDisbursementIds();
        List loanChargeIds = loan.fetchLoanTrancheChargeIds();
        int chargeIdLength = loanChargeIds.size();
        boolean bl = removeAllCharges = jsonCommand.parameterExists("charges") && jsonCommand.arrayOfParameterNamed("charges").isEmpty();
        if (jsonCommand.parameterExists("disbursementData") && (disbursementDataArray = jsonCommand.arrayOfParameterNamed("disbursementData")) != null && !disbursementDataArray.isEmpty()) {
            Locale locale = null;
            Map dateAndLocale = loan.getDateFormatAndLocale(jsonCommand);
            String dateFormat = (String)dateAndLocale.get("dateFormat");
            if (dateAndLocale.containsKey("locale")) {
                locale = JsonParserHelper.localeFromString((String)((String)dateAndLocale.get("locale")));
            }
            for (JsonElement jsonElement : disbursementDataArray) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                Map parsedDisbursementData = loan.parseDisbursementDetails(jsonObject, dateFormat, locale);
                LocalDate expectedDisbursementDate = (LocalDate)parsedDisbursementData.get("expectedDisbursementDate");
                BigDecimal principal = (BigDecimal)parsedDisbursementData.get("principal");
                Long disbursementID = (Long)parsedDisbursementData.get("id");
                String chargeIds = (String)parsedDisbursementData.get("loanChargeId");
                if (chargeIds != null) {
                    if (chargeIds.contains(",")) {
                        Iterable chargeId = Splitter.on((char)',').split((CharSequence)chargeIds);
                        for (String loanChargeId : chargeId) {
                            loanChargeIds.remove(Long.parseLong(loanChargeId));
                        }
                    } else {
                        loanChargeIds.remove(Long.parseLong(chargeIds));
                    }
                }
                this.createOrUpdateDisbursementDetails(loan, disbursementID, actualChanges, expectedDisbursementDate, principal, disbursementList);
            }
            this.removeDisbursementAndAssociatedCharges(loan, actualChanges, disbursementList, loanChargeIds, chargeIdLength, removeAllCharges);
        }
    }

    public Money adjustDisburseAmount(Loan loan, @NotNull JsonCommand command, @NotNull LocalDate actualDisbursementDate) {
        Money disburseAmount = loan.getLoanRepaymentScheduleDetail().getPrincipal().zero();
        BigDecimal principalDisbursed = command.bigDecimalValueOfParameterNamed("transactionAmount");
        if (loan.getActualDisbursementDate() == null || DateUtils.isBefore((LocalDate)actualDisbursementDate, (LocalDate)loan.getActualDisbursementDate())) {
            loan.setActualDisbursementDate(actualDisbursementDate);
        }
        BigDecimal diff = BigDecimal.ZERO;
        Collection details = loan.fetchUndisbursedDetail();
        if (principalDisbursed == null) {
            disburseAmount = loan.getLoanRepaymentScheduleDetail().getPrincipal();
            if (!details.isEmpty()) {
                disburseAmount = disburseAmount.zero();
                for (LoanDisbursementDetails disbursementDetails : details) {
                    disbursementDetails.updateActualDisbursementDate(actualDisbursementDate);
                    disburseAmount = disburseAmount.plus(disbursementDetails.principal());
                }
            }
        } else {
            disburseAmount = loan.getLoanProduct().isMultiDisburseLoan() ? Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)principalDisbursed) : disburseAmount.plus(principalDisbursed);
            if (details.isEmpty()) {
                diff = loan.getLoanRepaymentScheduleDetail().getPrincipal().minus(principalDisbursed).getAmount();
            } else {
                for (LoanDisbursementDetails disbursementDetails : details) {
                    disbursementDetails.updateActualDisbursementDate(actualDisbursementDate);
                    disbursementDetails.updatePrincipal(principalDisbursed);
                }
            }
            if (loan.loanProduct().isMultiDisburseLoan()) {
                List loanDisburseDetails = loan.getDisbursementDetails();
                BigDecimal setPrincipalAmount = BigDecimal.ZERO;
                BigDecimal totalAmount = BigDecimal.ZERO;
                for (LoanDisbursementDetails disbursementDetails : loanDisburseDetails) {
                    if (disbursementDetails.actualDisbursementDate() != null) {
                        setPrincipalAmount = setPrincipalAmount.add(disbursementDetails.principal());
                    }
                    totalAmount = totalAmount.add(disbursementDetails.principal());
                }
                loan.getLoanRepaymentScheduleDetail().setPrincipal(setPrincipalAmount);
                this.loanDisbursementValidator.compareDisbursedToApprovedOrProposedPrincipal(loan, disburseAmount.getAmount(), totalAmount);
            } else {
                loan.getLoanRepaymentScheduleDetail().setPrincipal(loan.getLoanRepaymentScheduleDetail().getPrincipal().minus(diff).getAmount());
            }
            this.loanDisbursementValidator.validateDisburseAmountNotExceedingApprovedAmount(loan, diff, principalDisbursed);
        }
        return disburseAmount;
    }

    public void handleDisbursementTransaction(Loan loan, LocalDate disbursedOn, PaymentDetail paymentDetail) {
        Money totalFeeChargesDueAtDisbursement = loan.getSummary().getTotalFeeChargesDueAtDisbursement(loan.getCurrency());
        Money disbursentMoney = Money.zero((MonetaryCurrency)loan.getCurrency());
        LoanTransaction chargesPayment = LoanTransaction.repaymentAtDisbursement((Office)loan.getOffice(), (Money)disbursentMoney, (PaymentDetail)paymentDetail, (LocalDate)disbursedOn, null);
        Integer installmentNumber = null;
        for (LoanCharge charge : loan.getActiveCharges()) {
            LocalDate actualDisbursementDate = loan.getActualDisbursementDate(charge);
            if (charge.getCharge().getChargeTimeType().equals(ChargeTimeType.DISBURSEMENT.getValue()) && disbursedOn.equals(actualDisbursementDate) && !charge.isWaived() && !charge.isFullyPaid() || charge.getCharge().getChargeTimeType().equals(ChargeTimeType.TRANCHE_DISBURSEMENT.getValue()) && disbursedOn.equals(actualDisbursementDate) && !charge.isWaived() && !charge.isFullyPaid()) {
                if (!totalFeeChargesDueAtDisbursement.isGreaterThanZero() || charge.getChargePaymentMode().isPaymentModeAccountTransfer()) continue;
                charge.markAsFullyPaid();
                LoanChargePaidBy loanChargePaidBy = new LoanChargePaidBy(chargesPayment, charge, charge.amount(), installmentNumber);
                chargesPayment.getLoanChargesPaid().add(loanChargePaidBy);
                disbursentMoney = disbursentMoney.plus(charge.amount());
                continue;
            }
            if (!disbursedOn.equals(loan.getActualDisbursementDate()) || !loan.isNoneOrCashOrUpfrontAccrualAccountingEnabledOnLoanProduct().booleanValue()) continue;
            loan.handleChargeAppliedTransaction(charge, disbursedOn);
        }
        if (disbursentMoney.isGreaterThanZero()) {
            Money zero = Money.zero((MonetaryCurrency)loan.getCurrency());
            chargesPayment.updateComponentsAndTotal(zero, zero, disbursentMoney, zero);
            chargesPayment.updateLoan(loan);
            loan.addLoanTransaction(chargesPayment);
            loan.updateLoanOutstandingBalances();
        }
        LocalDate expectedDate = loan.getExpectedFirstRepaymentOnDate();
        this.loanDisbursementValidator.validateDisburseDate(loan, disbursedOn, expectedDate);
    }

    private void createOrUpdateDisbursementDetails(Loan loan, Long disbursementID, Map<String, Object> actualChanges, LocalDate expectedDisbursementDate, BigDecimal principal, List<Long> existingDisbursementList) {
        if (disbursementID != null) {
            LoanDisbursementDetails loanDisbursementDetail = loan.fetchLoanDisbursementsById(disbursementID);
            existingDisbursementList.remove(disbursementID);
            if (loanDisbursementDetail.actualDisbursementDate() == null) {
                LocalDate actualDisbursementDate = null;
                LoanDisbursementDetails disbursementDetails = new LoanDisbursementDetails(expectedDisbursementDate, actualDisbursementDate, principal, loan.getNetDisbursalAmount(), false);
                disbursementDetails.updateLoan(loan);
                if (!loanDisbursementDetail.equals((Object)disbursementDetails)) {
                    loanDisbursementDetail.copy(disbursementDetails);
                    actualChanges.put("disbursementDetailId", disbursementID);
                    actualChanges.put("recalculateLoanSchedule", true);
                }
            }
        } else {
            LoanDisbursementDetails disbursementDetails = loan.addLoanDisbursementDetails(expectedDisbursementDate, principal);
            for (LoanTrancheCharge trancheCharge : loan.getTrancheCharges()) {
                Charge chargeDefinition = trancheCharge.getCharge();
                ExternalId externalId = ExternalId.empty();
                if (TemporaryConfigurationServiceContainer.isExternalIdAutoGenerationEnabled()) {
                    externalId = ExternalId.generate();
                }
                LoanCharge loanCharge = new LoanCharge(loan, chargeDefinition, principal, null, null, null, expectedDisbursementDate, null, null, BigDecimal.ZERO, externalId);
                LoanTrancheDisbursementCharge loanTrancheDisbursementCharge = new LoanTrancheDisbursementCharge(loanCharge, disbursementDetails);
                loanCharge.updateLoanTrancheDisbursementCharge(loanTrancheDisbursementCharge);
                this.loanChargeValidator.validateChargeAdditionForDisbursedLoan(loan, loanCharge);
                this.loanChargeValidator.validateChargeHasValidSpecifiedDateIfApplicable(loan, loanCharge, loan.getDisbursementDate());
                loan.addLoanCharge(loanCharge);
            }
            actualChanges.put("disbursementData", String.valueOf(expectedDisbursementDate) + "-" + String.valueOf(principal));
            actualChanges.put("recalculateLoanSchedule", true);
        }
    }

    private void removeDisbursementAndAssociatedCharges(Loan loan, Map<String, Object> actualChanges, List<Long> disbursementList, List<Long> loanChargeIds, int chargeIdLength, boolean removeAllCharges) {
        if (removeAllCharges) {
            LoanCharge[] tempCharges = new LoanCharge[loan.getCharges().size()];
            loan.getCharges().toArray(tempCharges);
            for (LoanCharge loanCharge : tempCharges) {
                this.loanChargeValidator.validateLoanIsNotClosed(loan, loanCharge);
                this.loanChargeValidator.validateLoanChargeIsNotWaived(loan, loanCharge);
                this.reprocessLoanTransactionsService.removeLoanCharge(loan, loanCharge);
            }
            loan.getTrancheCharges().clear();
        } else if (!loanChargeIds.isEmpty() && loanChargeIds.size() != chargeIdLength) {
            for (Long chargeId : loanChargeIds) {
                LoanCharge deleteCharge = loan.fetchLoanChargesById(chargeId);
                if (!loan.getCharges().contains(deleteCharge)) continue;
                this.loanChargeValidator.validateLoanIsNotClosed(loan, deleteCharge);
                this.loanChargeValidator.validateLoanChargeIsNotWaived(loan, deleteCharge);
                this.reprocessLoanTransactionsService.removeLoanCharge(loan, deleteCharge);
            }
        }
        for (Long id : disbursementList) {
            this.removeChargesByDisbursementID(loan, id);
            loan.removeDisbursementDetails(id.longValue());
            actualChanges.put("recalculateLoanSchedule", true);
        }
    }

    private void removeChargesByDisbursementID(Loan loan, Long id) {
        loan.getCharges().stream().filter(charge -> {
            LoanTrancheDisbursementCharge transCharge = charge.getTrancheDisbursementCharge();
            if (transCharge == null || !Objects.equals(id, transCharge.getloanDisbursementDetails().getId())) {
                return false;
            }
            this.loanChargeValidator.validateLoanIsNotClosed(loan, charge);
            this.loanChargeValidator.validateLoanChargeIsNotWaived(loan, charge);
            return true;
        }).forEach(loanCharge -> this.reprocessLoanTransactionsService.removeLoanCharge(loan, loanCharge));
    }

    @Generated
    public LoanDisbursementService(LoanChargeValidator loanChargeValidator, LoanDisbursementValidator loanDisbursementValidator, ReprocessLoanTransactionsService reprocessLoanTransactionsService) {
        this.loanChargeValidator = loanChargeValidator;
        this.loanDisbursementValidator = loanDisbursementValidator;
        this.reprocessLoanTransactionsService = reprocessLoanTransactionsService;
    }
}

