/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.floatingrates.data.InterestRatePeriodData;
import org.apache.fineract.portfolio.loanaccount.data.DisbursementData;
import org.apache.fineract.portfolio.loanaccount.data.LoanAccountData;
import org.apache.fineract.portfolio.loanaccount.data.LoanApprovalData;
import org.apache.fineract.portfolio.loanaccount.data.LoanRepaymentScheduleInstallmentData;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionData;
import org.apache.fineract.portfolio.loanaccount.data.PaidInAdvanceData;
import org.apache.fineract.portfolio.loanaccount.data.RepaymentScheduleRelatedLoanData;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.OverdueLoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;

public interface LoanReadPlatformService {
    public LoanAccountData retrieveOne(Long var1);

    public LoanAccountData fetchRepaymentScheduleData(LoanAccountData var1);

    public LoanScheduleData retrieveRepaymentSchedule(Long var1, RepaymentScheduleRelatedLoanData var2, Collection<DisbursementData> var3, boolean var4, LoanScheduleType var5);

    public Collection<LoanTransactionData> retrieveLoanTransactions(Long var1);

    public LoanAccountData retrieveTemplateWithClientAndProductDetails(Long var1, Long var2);

    public LoanAccountData retrieveTemplateWithGroupAndProductDetails(Long var1, Long var2);

    public LoanTransactionData retrieveLoanTransactionTemplate(Long var1);

    public LoanTransactionData retrieveWaiveInterestDetails(Long var1);

    public LoanTransactionData retrieveLoanTransaction(Long var1, Long var2);

    public LoanTransactionData retrieveNewClosureDetails();

    public LoanTransactionData retrieveDisbursalTemplate(Long var1, boolean var2);

    public LoanApprovalData retrieveApprovalTemplate(Long var1);

    public LoanAccountData retrieveTemplateWithCompleteGroupAndProductDetails(Long var1, Long var2);

    public LoanAccountData retrieveLoanProductDetailsTemplate(Long var1, Long var2, Long var3);

    public Collection<CalendarData> retrieveCalendars(Long var1);

    public Page<LoanAccountData> retrieveAll(SearchParameters var1);

    public Collection<StaffData> retrieveAllowedLoanOfficers(Long var1, boolean var2);

    public Collection<OverdueLoanScheduleData> retrieveAllLoansWithOverdueInstallments(Long var1, Boolean var2);

    public Collection<OverdueLoanScheduleData> retrieveAllOverdueInstallmentsForLoan(Loan var1);

    public Integer retriveLoanCounter(Long var1, Integer var2, Long var3);

    public Integer retriveLoanCounter(Long var1, Long var2);

    public Collection<DisbursementData> retrieveLoanDisbursementDetails(Long var1);

    public DisbursementData retrieveLoanDisbursementDetail(Long var1, Long var2);

    public LoanTransactionData retrieveRecoveryPaymentTemplate(Long var1);

    public LoanTransactionData retrieveLoanWriteoffTemplate(Long var1);

    public LoanTransactionData retrieveLoanChargeOffTemplate(Long var1);

    public Collection<Long> fetchLoansForInterestRecalculation();

    public List<Long> fetchLoansForInterestRecalculation(Integer var1, Long var2, String var3);

    public LoanTransactionData retrieveLoanPrePaymentTemplate(LoanTransactionType var1, Long var2, LocalDate var3);

    public boolean isGuaranteeRequired(Long var1);

    public LocalDate retrieveMinimumDateOfRepaymentTransaction(Long var1);

    public PaidInAdvanceData retrieveTotalPaidInAdvance(Long var1);

    public LoanTransactionData retrieveRefundByCashTemplate(Long var1);

    public LoanTransactionData retrieveCreditBalanceRefundTemplate(Long var1);

    public Collection<InterestRatePeriodData> retrieveLoanInterestRatePeriodData(LoanAccountData var1);

    public Collection<Long> retrieveLoanIdsWithPendingIncomePostingTransactions();

    public LoanTransactionData retrieveLoanForeclosureTemplate(Long var1, LocalDate var2);

    public LoanAccountData retrieveLoanByLoanAccount(String var1);

    public Long retrieveLoanIdByAccountNumber(String var1);

    public String retrieveAccountNumberByAccountId(Long var1);

    public Integer retrieveNumberOfActiveLoans();

    public Integer retrieveNumberOfRepayments(Long var1);

    public List<LoanAccountData> retrieveGLIMChildLoansByGLIMParentAccount(String var1);

    public List<LoanRepaymentScheduleInstallmentData> getRepaymentDataResponse(Long var1);

    public Long retrieveLoanTransactionIdByExternalId(ExternalId var1);

    public Long retrieveLoanIdByExternalId(ExternalId var1);

    public List<Long> retrieveLoanIdsByExternalIds(List<ExternalId> var1);
}

